/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ServerMethod;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import java.util.ArrayList;

class DownloadMessagesAndListAttachmentsServerMethod
extends ServerMethod {
    private static final String SERVER_METHOD_PATH = "/downloadMessagesAndListAttachments";
    private final String server;
    private final Identity ownedIdentity;
    private final byte[] token;
    private final UID deviceUid;
    private final long listStartTimestamp;
    private MessageAndAttachmentLengths[] messageAndAttachmentLengthsArray;
    private long downloadTimestamp;

    public MessageAndAttachmentLengths[] getMessageAndAttachmentLengthsArray() {
        return this.messageAndAttachmentLengthsArray;
    }

    public long getDownloadTimestamp() {
        return this.downloadTimestamp;
    }

    DownloadMessagesAndListAttachmentsServerMethod(Identity ownedIdentity, byte[] token, UID deviceUid, long listStartTimestamp) {
        this.server = ownedIdentity.getServer();
        this.ownedIdentity = ownedIdentity;
        this.token = token;
        this.deviceUid = deviceUid;
        this.listStartTimestamp = listStartTimestamp;
    }

    @Override
    protected String getServer() {
        return this.server;
    }

    @Override
    protected String getServerMethod() {
        return SERVER_METHOD_PATH;
    }

    @Override
    protected byte[] getDataToSend() {
        return Encoded.of(new Encoded[]{Encoded.of(this.ownedIdentity), Encoded.of(this.token), Encoded.of(this.deviceUid), Encoded.of(this.listStartTimestamp)}).getBytes();
    }

    @Override
    protected void parseReceivedData(Encoded[] receivedData) {
        if (this.returnStatus == 0 || this.returnStatus == 23) {
            try {
                this.downloadTimestamp = receivedData[0].decodeLong();
                ArrayList<MessageAndAttachmentLengths> list = new ArrayList<MessageAndAttachmentLengths>();
                for (int i = 0; i < receivedData.length - 1; ++i) {
                    Encoded[] parts = receivedData[i + 1].decodeList();
                    int attachmentCount = parts.length - 5;
                    MessageAndAttachmentLengths messageAndAttachmentLengths = new MessageAndAttachmentLengths(parts[0].decodeUid(), parts[1].decodeLong(), parts[2].decodeEncryptedData(), parts[3].decodeEncryptedData(), parts[4].decodeBoolean(), attachmentCount);
                    for (int j = 0; j < attachmentCount; ++j) {
                        Encoded[] attachmentParts = parts[5 + j].decodeList();
                        int attachmentNumber = (int)attachmentParts[0].decodeLong();
                        long attachmentLength = attachmentParts[1].decodeLong();
                        int chunkLength = (int)attachmentParts[2].decodeLong();
                        String[] privateUrls = attachmentParts[3].decodeStringArray();
                        messageAndAttachmentLengths.attachmentLengths[attachmentNumber] = attachmentLength;
                        messageAndAttachmentLengths.chunkLengths[attachmentNumber] = chunkLength;
                        if (chunkLength == 0) continue;
                        messageAndAttachmentLengths.chunkDownloadPrivateUrls[attachmentNumber] = privateUrls.length == (int)((attachmentLength - 1L) / (long)chunkLength) + 1 ? privateUrls : null;
                    }
                    list.add(messageAndAttachmentLengths);
                }
                this.messageAndAttachmentLengthsArray = list.toArray(new MessageAndAttachmentLengths[0]);
            }
            catch (DecodingException e) {
                Logger.x(e);
                this.returnStatus = (byte)-1;
            }
        }
    }

    @Override
    protected boolean isActiveIdentityRequired() {
        return true;
    }

    static class MessageAndAttachmentLengths {
        final UID messageUid;
        final long serverTimestamp;
        final EncryptedBytes wrappedKey;
        final EncryptedBytes messageContent;
        final boolean hasExtendedContent;
        final long[] attachmentLengths;
        final int[] chunkLengths;
        final String[][] chunkDownloadPrivateUrls;

        MessageAndAttachmentLengths(UID messageUid, long serverTimestamp, EncryptedBytes wrappedKey, EncryptedBytes messageContent, boolean hasExtendedContent, int attachmentCount) {
            this.messageUid = messageUid;
            this.serverTimestamp = serverTimestamp;
            this.wrappedKey = wrappedKey;
            this.messageContent = messageContent;
            this.hasExtendedContent = hasExtendedContent;
            this.attachmentLengths = new long[attachmentCount];
            this.chunkLengths = new int[attachmentCount];
            this.chunkDownloadPrivateUrls = new String[attachmentCount][];
        }
    }
}

