/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.AuthEnc;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.Chunk;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.EtaEstimator;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.PriorityOperation;
import io.olvid.engine.datatypes.ServerMethodForS3;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.networkfetch.coordinators.DownloadAttachmentCoordinator;
import io.olvid.engine.networkfetch.databases.InboxAttachment;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSessionFactory;
import io.olvid.engine.networkfetch.operations.DownloadAttachmentServerMethodForS3;
import java.lang.ref.WeakReference;
import java.sql.SQLException;
import java.util.HashMap;
import javax.net.ssl.SSLSocketFactory;

public class DownloadAttachmentOperation
extends PriorityOperation {
    public static final int RFC_NETWORK_ERROR = 1;
    public static final int RFC_INVALID_SIGNED_URL = 2;
    public static final int RFC_ATTACHMENT_CANNOT_BE_FOUND = 3;
    public static final int RFC_DECRYPTION_ERROR = 5;
    public static final int RFC_ATTACHMENT_CANNOT_BE_FETCHED = 6;
    public static final int RFC_NOT_YET_AVAILABLE_ON_SERVER = 7;
    public static final int RFC_DOES_NOT_HAVE_THE_HIGHEST_PRIORITY = 8;
    public static final int RFC_MARKED_FOR_DELETION = 9;
    public static final int RFC_FETCH_NOT_REQUESTED = 10;
    public static final int RFC_INVALID_CHUNK = 11;
    public static final int RFC_UNABLE_TO_WRITE_CHUNK_TO_FILE = 12;
    public static final int RFC_DOWNLOAD_PAUSED = 13;
    public static final int RFC_UPLOAD_CANCELLED_BY_SENDER = 14;
    public static final int RFC_IDENTITY_IS_INACTIVE = 15;
    private final FetchManagerSessionFactory fetchManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final String userAgentOverride;
    private final Identity ownedIdentity;
    private final UID messageUid;
    private final int attachmentNumber;
    private final int priorityCategory;
    private final WeakReference<DownloadAttachmentCoordinator> coordinatorWeakReference;
    private long priority;
    InboxAttachment attachment;

    public DownloadAttachmentOperation(FetchManagerSessionFactory fetchManagerSessionFactory, SSLSocketFactory sslSocketFactory, String userAgentOverride, Identity ownedIdentity, UID messageUid, int attachmentNumber, int priorityCategory, long initialPriority, DownloadAttachmentCoordinator coordinator, Operation.OnFinishCallback onFinishCallback, Operation.OnCancelCallback onCancelCallback) {
        super(InboxAttachment.computeUniqueUid(ownedIdentity, messageUid, attachmentNumber), onFinishCallback, onCancelCallback);
        this.fetchManagerSessionFactory = fetchManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.userAgentOverride = userAgentOverride;
        this.ownedIdentity = ownedIdentity;
        this.messageUid = messageUid;
        this.attachmentNumber = attachmentNumber;
        this.priorityCategory = priorityCategory;
        this.priority = initialPriority;
        this.coordinatorWeakReference = new WeakReference<DownloadAttachmentCoordinator>(coordinator);
    }

    @Override
    public void doCancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doExecute() {
        boolean finished = false;
        this.attachment = null;
        try (final FetchManagerSession fetchManagerSession = this.fetchManagerSessionFactory.getSession();){
            try {
                this.attachment = InboxAttachment.get(fetchManagerSession, this.ownedIdentity, this.messageUid, this.attachmentNumber);
                if (this.attachment == null) {
                    this.cancel(3);
                    return;
                }
                if (this.attachment.isMarkedForDeletion()) {
                    this.cancel(9);
                    return;
                }
                if (this.attachment.cannotBeFetched()) {
                    this.cancel(6);
                    return;
                }
                if (!this.attachment.isDownloadRequested()) {
                    this.cancel(10);
                    return;
                }
                final EtaEstimator etaEstimator = new EtaEstimator(this.attachment.getReceivedLength(), this.attachment.getExpectedLength());
                while (this.attachment.getReceivedLength() != this.attachment.getExpectedLength()) {
                    if (this.cancelWasRequested()) {
                        return;
                    }
                    if (this.attachment.isMarkedForDeletion()) {
                        this.cancel(9);
                        return;
                    }
                    if (!this.attachment.isDownloadRequested()) {
                        this.cancel(13);
                        return;
                    }
                    if (this.attachment.getChunkDownloadPrivateUrls().length == 0) {
                        this.cancel(2);
                        return;
                    }
                    if (this.attachment.getChunkDownloadPrivateUrls()[this.attachment.getReceivedChunkCount()].isEmpty()) {
                        this.cancel(14);
                        return;
                    }
                    DownloadAttachmentServerMethodForS3 serverMethod = new DownloadAttachmentServerMethodForS3(this.attachment.getChunkDownloadPrivateUrls()[this.attachment.getReceivedChunkCount()]);
                    serverMethod.setSslSocketFactory(this.sslSocketFactory, this.userAgentOverride);
                    serverMethod.setProgressListener(150L, new ServerMethodForS3.ServerMethodForS3ProgressListener(){
                        final HashMap<String, Object> userInfo = new HashMap();
                        {
                            this.userInfo.put("owned_identity", DownloadAttachmentOperation.this.ownedIdentity);
                            this.userInfo.put("messageUid", DownloadAttachmentOperation.this.messageUid);
                            this.userInfo.put("attachmentNumber", DownloadAttachmentOperation.this.attachmentNumber);
                        }

                        @Override
                        public void onProgress(long byteCount) {
                            float progress = (float)(DownloadAttachmentOperation.this.attachment.getReceivedLength() + byteCount) / (float)DownloadAttachmentOperation.this.attachment.getExpectedLength();
                            this.userInfo.put("progress", Float.valueOf(progress));
                            etaEstimator.update(DownloadAttachmentOperation.this.attachment.getReceivedLength() + byteCount);
                            EtaEstimator.SpeedAndEta speedAndEta = etaEstimator.getSpeedAndEta();
                            this.userInfo.put("speed", Float.valueOf(speedAndEta.speedBps));
                            this.userInfo.put("eta", speedAndEta.etaSeconds);
                            fetchManagerSession.notificationPostingDelegate.postNotification("network_fetch_notification_attachment_download_progress", this.userInfo);
                        }
                    });
                    byte returnStatus = serverMethod.execute(fetchManagerSession.identityDelegate.isActiveOwnedIdentity(fetchManagerSession.session, this.ownedIdentity));
                    fetchManagerSession.session.startTransaction();
                    switch (returnStatus) {
                        case 0: {
                            Chunk attachmentChunk;
                            EncryptedBytes encryptedChunk = serverMethod.getEncryptedChunk();
                            if (encryptedChunk.length != this.attachment.getChunkLength() && this.attachment.getReceivedLength() + (long)encryptedChunk.length != this.attachment.getExpectedLength()) {
                                this.cancel(11);
                                return;
                            }
                            try {
                                AuthEncKey key = this.attachment.getKey();
                                AuthEnc authEnc = Suite.getAuthEnc(key);
                                Encoded encodedChunk = new Encoded(authEnc.decrypt(key, encryptedChunk));
                                attachmentChunk = Chunk.of(encodedChunk);
                            }
                            catch (Exception e) {
                                this.cancel(5);
                                if (finished) {
                                    fetchManagerSession.session.commit();
                                    this.setFinished();
                                } else {
                                    fetchManagerSession.session.rollback();
                                    if (this.hasNoReasonForCancel()) {
                                        this.cancel(null);
                                    }
                                    this.processCancel();
                                }
                                if (fetchManagerSession == null) return;
                                fetchManagerSession.close();
                                return;
                            }
                            if (attachmentChunk.getChunkNumber() != this.attachment.getReceivedChunkCount()) {
                                this.cancel(11);
                                return;
                            }
                            boolean success = this.attachment.writeToAttachmentFile(attachmentChunk.getData(), encryptedChunk.length);
                            if (!success) {
                                this.cancel(12);
                                return;
                            }
                            fetchManagerSession.session.commit();
                            DownloadAttachmentCoordinator coordinator = (DownloadAttachmentCoordinator)this.coordinatorWeakReference.get();
                            if (coordinator == null) break;
                            coordinator.resetFailedAttemptCount(this.ownedIdentity, this.messageUid, this.attachmentNumber);
                            break;
                        }
                        case 2: {
                            this.cancel(2);
                            return;
                        }
                        case 1: {
                            this.cancel(7);
                            return;
                        }
                        case -114: {
                            this.cancel(15);
                            return;
                        }
                        default: {
                            this.cancel(1);
                            return;
                        }
                    }
                    this.attachment = InboxAttachment.get(fetchManagerSession, this.ownedIdentity, this.messageUid, this.attachmentNumber);
                    this.priority = this.attachment.getPriority();
                }
                finished = true;
                return;
            }
            catch (Exception e) {
                Logger.x(e);
                fetchManagerSession.session.rollback();
                return;
            }
            finally {
                if (finished) {
                    fetchManagerSession.session.commit();
                    this.setFinished();
                } else {
                    fetchManagerSession.session.rollback();
                    if (this.hasNoReasonForCancel()) {
                        this.cancel(null);
                    }
                    this.processCancel();
                }
            }
        }
        catch (SQLException e) {
            Logger.x(e);
            this.cancel(null);
            this.processCancel();
        }
    }

    @Override
    public long getPriority() {
        return this.priority;
    }

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public UID getMessageUid() {
        return this.messageUid;
    }

    public int getAttachmentNumber() {
        return this.attachmentNumber;
    }

    public int getPriorityCategory() {
        return this.priorityCategory;
    }
}

