/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.containers.ServerQuery;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.networkfetch.operations.ServerQueryServerMethod;

class DeviceManagementServerMethod
extends ServerQueryServerMethod {
    private static final String SERVER_METHOD_PATH = "/deviceManagement";
    private final String server;
    private final Identity identity;
    private final byte[] token;
    private final ServerQuery.Type queryType;
    private Encoded serverResponse;

    public DeviceManagementServerMethod(Identity identity, byte[] token, ServerQuery.Type queryType) {
        this.server = identity.getServer();
        this.identity = identity;
        this.token = token;
        this.queryType = queryType;
    }

    @Override
    protected String getServer() {
        return this.server;
    }

    @Override
    protected String getServerMethod() {
        return SERVER_METHOD_PATH;
    }

    @Override
    protected byte[] getDataToSend() {
        if (this.queryType instanceof ServerQuery.DeviceManagementSetNicknameQuery) {
            return Encoded.of(new Encoded[]{Encoded.of(this.identity), Encoded.of(this.token), Encoded.of(new byte[]{0}), Encoded.of(((ServerQuery.DeviceManagementSetNicknameQuery)this.queryType).deviceUid), Encoded.of(((ServerQuery.DeviceManagementSetNicknameQuery)this.queryType).encryptedDeviceName)}).getBytes();
        }
        if (this.queryType instanceof ServerQuery.DeviceManagementDeactivateDeviceQuery) {
            return Encoded.of(new Encoded[]{Encoded.of(this.identity), Encoded.of(this.token), Encoded.of(new byte[]{1}), Encoded.of(((ServerQuery.DeviceManagementDeactivateDeviceQuery)this.queryType).deviceUid)}).getBytes();
        }
        if (this.queryType instanceof ServerQuery.DeviceManagementSetUnexpiringDeviceQuery) {
            return Encoded.of(new Encoded[]{Encoded.of(this.identity), Encoded.of(this.token), Encoded.of(new byte[]{2}), Encoded.of(((ServerQuery.DeviceManagementSetUnexpiringDeviceQuery)this.queryType).deviceUid)}).getBytes();
        }
        return new byte[0];
    }

    @Override
    protected void parseReceivedData(Encoded[] receivedData) {
        super.parseReceivedData(receivedData);
        if (this.returnStatus == 0) {
            if (receivedData.length == 0) {
                this.serverResponse = null;
            } else {
                this.returnStatus = (byte)-1;
            }
        }
    }

    @Override
    public Encoded getServerResponse() {
        return this.serverResponse;
    }
}

