/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.networkfetch.operations.ServerQueryServerMethod;

class DeviceDiscoveryServerMethod
extends ServerQueryServerMethod {
    private static final String SERVER_METHOD_PATH = "/deviceDiscovery";
    private final String server;
    private final Identity identity;
    private Encoded serverResponse;

    public DeviceDiscoveryServerMethod(Identity identity) {
        this.server = identity.getServer();
        this.identity = identity;
    }

    @Override
    protected String getServer() {
        return this.server;
    }

    @Override
    protected String getServerMethod() {
        return SERVER_METHOD_PATH;
    }

    @Override
    protected byte[] getDataToSend() {
        return Encoded.of(new Encoded[]{Encoded.of(this.identity)}).getBytes();
    }

    @Override
    protected void parseReceivedData(Encoded[] receivedData) {
        super.parseReceivedData(receivedData);
        if (this.returnStatus == 0) {
            try {
                receivedData[0].decodeDictionary();
                this.serverResponse = receivedData[0];
            }
            catch (DecodingException e) {
                Logger.x(e);
                this.returnStatus = (byte)-1;
            }
        }
    }

    @Override
    public Encoded getServerResponse() {
        return this.serverResponse;
    }
}

