/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ServerMethod;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.UidAndBoolean;
import io.olvid.engine.encoder.Encoded;

class DeleteMessageAndAttachmentServerMethod
extends ServerMethod {
    private static final String SERVER_METHOD_PATH = "/deleteMessageAndAttachments";
    private final String server;
    private final Identity identity;
    private final byte[] token;
    private final UID currentDeviceUid;
    private final UidAndBoolean[] messageUidsAndMarkAsListed;

    DeleteMessageAndAttachmentServerMethod(Identity identity, byte[] token, UID currentDeviceUid, UidAndBoolean[] messageUidsAndMarkAsListed) {
        this.server = identity.getServer();
        this.identity = identity;
        this.token = token;
        this.currentDeviceUid = currentDeviceUid;
        this.messageUidsAndMarkAsListed = messageUidsAndMarkAsListed;
    }

    @Override
    protected String getServer() {
        return this.server;
    }

    @Override
    protected String getServerMethod() {
        return SERVER_METHOD_PATH;
    }

    @Override
    protected byte[] getDataToSend() {
        Encoded[] encodedMessageUidsAndMarkAsListed = new Encoded[2 * this.messageUidsAndMarkAsListed.length];
        for (int i = 0; i < this.messageUidsAndMarkAsListed.length; ++i) {
            encodedMessageUidsAndMarkAsListed[2 * i] = Encoded.of(this.messageUidsAndMarkAsListed[i].uid);
            encodedMessageUidsAndMarkAsListed[2 * i + 1] = Encoded.of(this.messageUidsAndMarkAsListed[i].bool);
        }
        return Encoded.of(new Encoded[]{Encoded.of(this.identity), Encoded.of(this.token), Encoded.of(this.currentDeviceUid), Encoded.of(encodedMessageUidsAndMarkAsListed)}).getBytes();
    }

    @Override
    protected void parseReceivedData(Encoded[] receivedData) {
    }

    @Override
    protected boolean isActiveIdentityRequired() {
        return false;
    }
}

