/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.datatypes.UID;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.networkfetch.operations.ServerQueryServerMethod;

class DeleteGroupBlobServerMethod
extends ServerQueryServerMethod {
    private static final String SERVER_METHOD_PATH = "/groupBlobDelete";
    private final String server;
    private final UID groupUid;
    private final byte[] signature;
    private Encoded serverResponse;

    public DeleteGroupBlobServerMethod(String server, UID groupUid, byte[] signature) {
        this.server = server;
        this.groupUid = groupUid;
        this.signature = signature;
    }

    @Override
    protected boolean isActiveIdentityRequired() {
        return false;
    }

    @Override
    protected String getServer() {
        return this.server;
    }

    @Override
    protected String getServerMethod() {
        return SERVER_METHOD_PATH;
    }

    @Override
    protected byte[] getDataToSend() {
        return Encoded.of(new Encoded[]{Encoded.of(this.groupUid), Encoded.of(this.signature)}).getBytes();
    }

    @Override
    protected void parseReceivedData(Encoded[] receivedData) {
        super.parseReceivedData(receivedData);
        this.serverResponse = Encoded.of(this.returnStatus == 0);
        if (this.returnStatus == 20) {
            this.returnStatus = 0;
        }
    }

    @Override
    public Encoded getServerResponse() {
        return this.serverResponse;
    }
}

