/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.OperationQueue;
import io.olvid.engine.metamanager.SolveChallengeDelegate;
import io.olvid.engine.networkfetch.databases.ServerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSessionFactory;
import io.olvid.engine.networkfetch.operations.GetTokenOperation;
import io.olvid.engine.networkfetch.operations.RequestChallengeOperation;
import io.olvid.engine.networkfetch.operations.SolveChallengeOperation;
import java.util.List;
import javax.net.ssl.SSLSocketFactory;

public class CreateServerSessionCompositeOperation
extends Operation
implements Operation.OnFinishCallback {
    public static final int RFC_NETWORK_ERROR = 1;
    public static final int RFC_SESSION_CANNOT_BE_FOUND = 2;
    public static final int RFC_SESSION_DOES_NOT_CONTAIN_A_CHALLENGE = 3;
    public static final int RFC_SESSION_DOES_NOT_CONTAIN_A_RESPONSE = 4;
    public static final int RFC_SESSION_DOES_NOT_CONTAIN_A_NONCE = 5;
    public static final int RFC_IDENTITY_NOT_FOUND = 6;
    public static final int RFC_INVALID_SESSION = 7;
    private final Identity ownedIdentity;
    private final Operation[] suboperations;
    private ServerSession.ApiKeyStatus apiKeyStatus;
    private List<ServerSession.Permission> permissions;
    private long apiKeyExpirationTimestamp;

    public CreateServerSessionCompositeOperation(FetchManagerSessionFactory fetchManagerSessionFactory, SSLSocketFactory sslSocketFactory, String userAgentOverride, Identity ownedIdentity, SolveChallengeDelegate solveChallengeDelegate, Operation.OnFinishCallback onFinishCallback, Operation.OnCancelCallback onCancelCallback) {
        super(ownedIdentity.computeUniqueUid(), onFinishCallback, onCancelCallback);
        this.ownedIdentity = ownedIdentity;
        this.suboperations = new Operation[3];
        this.suboperations[0] = new RequestChallengeOperation(fetchManagerSessionFactory, sslSocketFactory, userAgentOverride, ownedIdentity);
        this.suboperations[1] = new SolveChallengeOperation(fetchManagerSessionFactory, ownedIdentity, solveChallengeDelegate);
        this.suboperations[2] = new GetTokenOperation(fetchManagerSessionFactory, sslSocketFactory, userAgentOverride, ownedIdentity, this);
        for (int i = 0; i < this.suboperations.length - 1; ++i) {
            this.suboperations[i + 1].addDependency(this.suboperations[i]);
        }
    }

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public ServerSession.ApiKeyStatus getApiKeyStatus() {
        return this.apiKeyStatus;
    }

    public List<ServerSession.Permission> getPermissions() {
        return this.permissions;
    }

    public long getApiKeyExpirationTimestamp() {
        return this.apiKeyExpirationTimestamp;
    }

    @Override
    public void doCancel() {
        for (Operation op : this.suboperations) {
            op.cancel(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute() {
        boolean finished = false;
        try {
            OperationQueue queue = new OperationQueue();
            for (Operation op : this.suboperations) {
                queue.queue(op);
            }
            queue.execute(1, "Engine-CreateServerSessionCompositeOperation");
            queue.join();
            if (this.cancelWasRequested()) {
                return;
            }
            for (Operation op : this.suboperations) {
                if (!op.isCancelled()) continue;
                this.cancel(op.getReasonForCancel());
                return;
            }
            finished = true;
        }
        catch (Exception e) {
            Logger.x(e);
        }
        finally {
            if (finished) {
                this.setFinished();
            } else {
                this.cancel(null);
                this.processCancel();
            }
        }
    }

    @Override
    public void onFinishCallback(Operation operation) {
        if (operation instanceof GetTokenOperation) {
            GetTokenOperation op = (GetTokenOperation)operation;
            this.apiKeyStatus = op.getApiKeyStatus();
            this.permissions = op.getPermissions();
            this.apiKeyExpirationTimestamp = op.getApiKeyExpirationTimestamp();
        }
    }
}

