/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.networkfetch.operations.ServerQueryServerMethod;

class CreateGroupBlobServerMethod
extends ServerQueryServerMethod {
    private static final String SERVER_METHOD_PATH = "/groupBlobCreate";
    private final Identity ownedIdentity;
    private final byte[] token;
    private final String server;
    private final UID groupUid;
    private final Encoded encodedGroupAdminPublicKey;
    private final EncryptedBytes encryptedBlob;
    private Encoded serverResponse;

    public CreateGroupBlobServerMethod(Identity ownedIdentity, byte[] token, String server, UID groupUid, Encoded encodedGroupAdminPublicKey, EncryptedBytes encryptedBlob) {
        this.ownedIdentity = ownedIdentity;
        this.token = token;
        this.server = server;
        this.groupUid = groupUid;
        this.encodedGroupAdminPublicKey = encodedGroupAdminPublicKey;
        this.encryptedBlob = encryptedBlob;
    }

    @Override
    protected String getServer() {
        return this.server;
    }

    @Override
    protected String getServerMethod() {
        return SERVER_METHOD_PATH;
    }

    @Override
    protected byte[] getDataToSend() {
        return Encoded.of(new Encoded[]{Encoded.of(this.ownedIdentity), Encoded.of(this.token), Encoded.of(this.groupUid), this.encodedGroupAdminPublicKey, Encoded.of(this.encryptedBlob)}).getBytes();
    }

    @Override
    protected void parseReceivedData(Encoded[] receivedData) {
        super.parseReceivedData(receivedData);
        if (this.returnStatus == 0) {
            this.serverResponse = Encoded.of(0L);
        } else if (this.returnStatus == 18) {
            this.returnStatus = 0;
            this.serverResponse = Encoded.of(2L);
        }
    }

    @Override
    public Encoded getServerResponse() {
        return this.serverResponse;
    }
}

