/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.networkfetch.operations.ServerQueryServerMethod;
import java.nio.charset.StandardCharsets;

class CheckKeycloakRevocationServerMethod
extends ServerQueryServerMethod {
    private static final String SERVER_METHOD_PATH = "olvid-rest/verify";
    private final String server;
    private final String path;
    private final String signedContactDetails;
    private Encoded serverResponse;

    public CheckKeycloakRevocationServerMethod(String keycloakServerUrl, String signedContactDetails) {
        this.signedContactDetails = signedContactDetails;
        String url = keycloakServerUrl + SERVER_METHOD_PATH;
        int pos = url.indexOf(47, 8);
        this.server = url.substring(0, pos);
        this.path = url.substring(pos);
    }

    @Override
    protected String getServer() {
        return this.server;
    }

    @Override
    protected String getServerMethod() {
        return this.path;
    }

    @Override
    protected byte[] getDataToSend() {
        String jsonString = "{\"signature\": \"" + this.signedContactDetails + "\"}";
        return jsonString.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    protected void parseReceivedData(Encoded[] receivedData) {
        super.parseReceivedData(receivedData);
        if (this.returnStatus == 0) {
            try {
                boolean verificationSuccessful = receivedData[0].decodeBoolean();
                Logger.w("Server responded to verify server query: " + verificationSuccessful);
                this.serverResponse = Encoded.of(verificationSuccessful);
            }
            catch (DecodingException e) {
                Logger.x(e);
                this.returnStatus = (byte)-1;
            }
        }
    }

    @Override
    public Encoded getServerResponse() {
        return this.serverResponse;
    }
}

