/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.datatypes.UID;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.networkfetch.operations.ServerQueryServerMethod;

class BackupsV2ListBackupsServerMethod
extends ServerQueryServerMethod {
    private static final String SERVER_METHOD_PATH = "/backupList";
    private final String server;
    private final UID backupUid;
    private Encoded serverResponse;

    public BackupsV2ListBackupsServerMethod(String server, UID backupUid) {
        this.server = server;
        this.backupUid = backupUid;
    }

    @Override
    protected String getServer() {
        return this.server;
    }

    @Override
    protected String getServerMethod() {
        return SERVER_METHOD_PATH;
    }

    @Override
    protected byte[] getDataToSend() {
        return Encoded.of(new Encoded[]{Encoded.of(this.backupUid)}).getBytes();
    }

    @Override
    protected void parseReceivedData(Encoded[] receivedData) {
        super.parseReceivedData(receivedData);
        if (this.returnStatus == 0) {
            if (receivedData.length == 1) {
                this.serverResponse = receivedData[0];
            } else {
                this.returnStatus = (byte)-126;
            }
        }
    }

    @Override
    public Encoded getServerResponse() {
        return this.serverResponse;
    }
}

