/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.AuthEnc;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.networkfetch.operations.GetUserDataServerMethod;

class BackupsV2DownloadProfilePictureServerMethod
extends GetUserDataServerMethod {
    private final AuthEncKey photoKey;

    public BackupsV2DownloadProfilePictureServerMethod(Identity identity, UID photoLabel, AuthEncKey photoKey) {
        super(identity, photoLabel, null);
        this.photoKey = photoKey;
    }

    @Override
    protected void parseReceivedData(Encoded[] receivedData) {
        if (this.returnStatus == 0) {
            try {
                EncryptedBytes encryptedData = receivedData[0].decodeEncryptedData();
                AuthEnc authEnc = Suite.getAuthEnc(this.photoKey);
                this.serverResponse = Encoded.of(authEnc.decrypt(this.photoKey, encryptedData));
            }
            catch (Exception e) {
                Logger.x(e);
                this.returnStatus = (byte)-1;
            }
        }
    }
}

