/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ServerSession
implements ObvDatabase {
    static final String TABLE_NAME = "server_session";
    private final FetchManagerSession fetchManagerSession;
    private Identity ownedIdentity;
    static final String OWNED_IDENTITY = "identity";
    private byte[] nonce;
    static final String NONCE = "nonce";
    private byte[] challenge;
    static final String CHALLENGE = "challenge";
    private byte[] response;
    static final String RESPONSE = "response";
    private byte[] token;
    static final String TOKEN = "token";
    private int apiKeyStatus;
    static final String API_KEY_STATUS = "api_key_status";
    private long permissions;
    static final String PERMISSIONS = "permissions";
    private long apiKeyExpirationTimestamp;
    static final String API_KEY_EXPIRATION_TIMESTAMP = "api_key_expiration_timestamp";

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public byte[] getChallenge() {
        return this.challenge;
    }

    public byte[] getResponse() {
        return this.response;
    }

    public byte[] getToken() {
        return this.token;
    }

    public ApiKeyStatus getApiKeyStatus() {
        return ServerSession.deserializeApiKeyStatus(this.apiKeyStatus);
    }

    public static ApiKeyStatus deserializeApiKeyStatus(int apiKeyStatus) {
        switch (apiKeyStatus) {
            case 0: {
                return ApiKeyStatus.VALID;
            }
            case 3: {
                return ApiKeyStatus.EXPIRED;
            }
            case 2: {
                return ApiKeyStatus.LICENSES_EXHAUSTED;
            }
            case 4: {
                return ApiKeyStatus.OPEN_BETA_KEY;
            }
            case 5: {
                return ApiKeyStatus.FREE_TRIAL_KEY;
            }
            case 6: {
                return ApiKeyStatus.AWAITING_PAYMENT_GRACE_PERIOD;
            }
            case 7: {
                return ApiKeyStatus.AWAITING_PAYMENT_ON_HOLD;
            }
            case 8: {
                return ApiKeyStatus.FREE_TRIAL_KEY_EXPIRED;
            }
        }
        return ApiKeyStatus.UNKNOWN;
    }

    public List<Permission> getPermissions() {
        return ServerSession.deserializePermissions(this.permissions);
    }

    public static List<Permission> deserializePermissions(long permissions) {
        ArrayList<Permission> out = new ArrayList<Permission>();
        if ((permissions & 1L) != 0L) {
            out.add(Permission.CALL);
        }
        if ((permissions & 2L) != 0L) {
            out.add(Permission.WEB_CLIENT);
        }
        if ((permissions & 4L) != 0L) {
            out.add(Permission.MULTI_DEVICE);
        }
        return out;
    }

    public long getApiKeyExpirationTimestamp() {
        return this.apiKeyExpirationTimestamp;
    }

    public void setChallengeAndNonce(byte[] challenge, byte[] nonce) {
        try (PreparedStatement statement = this.fetchManagerSession.session.prepareStatement("ServerSession.setChallengeAndNonce", "UPDATE server_session SET challenge = ?, nonce = ? WHERE identity = ?;");){
            statement.setBytes(1, challenge);
            statement.setBytes(2, nonce);
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.challenge = challenge;
            this.nonce = nonce;
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    public void setResponseForChallenge(byte[] challenge, byte[] response) {
        if (response == null || challenge == null) {
            return;
        }
        try (PreparedStatement statement = this.fetchManagerSession.session.prepareStatement("ServerSession.setResponseForChallenge", "UPDATE server_session SET response = ?  WHERE identity = ?  AND challenge = ?;");){
            statement.setBytes(1, response);
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.setBytes(3, challenge);
            statement.executeUpdate();
            if (Arrays.equals(this.challenge, challenge)) {
                this.response = response;
            }
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    public void setTokenAndPermissions(byte[] token, int apiKeyStatus, long permissions, long apiKeyExpirationTimestamp) {
        if (token == null) {
            return;
        }
        try (PreparedStatement statement = this.fetchManagerSession.session.prepareStatement("ServerSession.setTokenAndPermissions", "UPDATE server_session SET token = ?, api_key_status = ?, permissions = ?, api_key_expiration_timestamp = ?  WHERE identity = ?;");){
            statement.setBytes(1, token);
            statement.setInt(2, apiKeyStatus);
            statement.setLong(3, permissions);
            statement.setLong(4, apiKeyExpirationTimestamp);
            statement.setBytes(5, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.token = token;
            this.apiKeyStatus = apiKeyStatus;
            this.permissions = permissions;
            this.apiKeyExpirationTimestamp = apiKeyExpirationTimestamp;
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    public static void deleteCurrentTokenIfEqualTo(FetchManagerSession fetchManagerSession, byte[] token, Identity ownedIdentity) {
        if (ownedIdentity == null) {
            return;
        }
        try (PreparedStatement statement = fetchManagerSession.session.prepareStatement("ServerSession.deleteCurrentTokenIfEqualTo", "DELETE FROM server_session WHERE identity = ? AND token = ?;");){
            statement.setBytes(1, ownedIdentity.getBytes());
            statement.setBytes(2, token);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    public static void deleteForIdentity(FetchManagerSession fetchManagerSession, Identity ownedIdentity) {
        if (ownedIdentity == null) {
            return;
        }
        try (PreparedStatement statement = fetchManagerSession.session.prepareStatement("ServerSession.deleteForIdentity", "DELETE FROM server_session WHERE identity = ?;");){
            statement.setBytes(1, ownedIdentity.getBytes());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    public static ServerSession create(FetchManagerSession fetchManagerSession, Identity ownedIdentity) {
        if (ownedIdentity == null) {
            return null;
        }
        try {
            ServerSession serverSession = new ServerSession(fetchManagerSession, ownedIdentity);
            serverSession.insert();
            return serverSession;
        }
        catch (SQLException e) {
            Logger.w("SQLException during ServerSession insert.");
            return null;
        }
    }

    private ServerSession(FetchManagerSession fetchManagerSession, Identity ownedIdentity) {
        this.fetchManagerSession = fetchManagerSession;
        this.ownedIdentity = ownedIdentity;
        this.nonce = null;
        this.challenge = null;
        this.response = null;
        this.token = null;
        this.apiKeyStatus = -1;
        this.permissions = 0L;
        this.apiKeyExpirationTimestamp = 0L;
    }

    private ServerSession(FetchManagerSession fetchManagerSession, ResultSet res) throws SQLException {
        this.fetchManagerSession = fetchManagerSession;
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
        }
        catch (DecodingException e) {
            Logger.x(e);
        }
        this.nonce = res.getBytes(NONCE);
        this.challenge = res.getBytes(CHALLENGE);
        this.response = res.getBytes(RESPONSE);
        this.token = res.getBytes(TOKEN);
        this.apiKeyStatus = res.getInt(API_KEY_STATUS);
        this.permissions = res.getLong(PERMISSIONS);
        this.apiKeyExpirationTimestamp = res.getLong(API_KEY_EXPIRATION_TIMESTAMP);
    }

    public static byte[] getToken(FetchManagerSession fetchManagerSession, Identity ownedIdentity) {
        ServerSession serverSession = ServerSession.get(fetchManagerSession, ownedIdentity);
        return serverSession == null ? null : serverSession.token;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ServerSession get(FetchManagerSession fetchManagerSession, Identity ownedIdentity) {
        if (ownedIdentity == null) {
            return null;
        }
        try (PreparedStatement statement = fetchManagerSession.session.prepareStatement("ServerSession.get", "SELECT * FROM server_session WHERE identity = ?;");){
            ServerSession serverSession;
            block19: {
                ResultSet res;
                block17: {
                    ServerSession serverSession2;
                    block18: {
                        statement.setBytes(1, ownedIdentity.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block17;
                            serverSession2 = new ServerSession(fetchManagerSession, res);
                            if (res == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return serverSession2;
                }
                serverSession = null;
                if (res == null) break block19;
                res.close();
            }
            return serverSession;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    public static ServerSession[] getAll(FetchManagerSession fetchManagerSession) throws SQLException {
        try (Statement statement = fetchManagerSession.session.createStatement("ServerSession.getAll");){
            ServerSession[] serverSessionArray;
            block13: {
                ResultSet res = statement.executeQuery("SELECT * FROM server_session");
                try {
                    ArrayList<ServerSession> list = new ArrayList<ServerSession>();
                    while (res.next()) {
                        list.add(new ServerSession(fetchManagerSession, res));
                    }
                    serverSessionArray = list.toArray(new ServerSession[0]);
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return serverSessionArray;
        }
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS server_session (identity BLOB PRIMARY KEY, nonce BLOB, challenge BLOB, response BLOB, token BLOB, api_key_status INT NOT NULL, permissions BIGINT NOT NULL, api_key_expiration_timestamp BIGINT NOT NULL);");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        if (oldVersion < 18 && newVersion >= 18) {
            Logger.d("MIGRATING `server_session` DATABASE FROM VERSION " + oldVersion + " TO 18");
            try (Statement statement = session.createStatement();){
                statement.execute("DROP TABLE server_session");
                statement.execute("CREATE TABLE server_session (identity BLOB PRIMARY KEY, nonce BLOB, challenge BLOB, response BLOB, token BLOB, api_key_status INT NOT NULL, permissions BIGINT NOT NULL, api_key_expiration_timestamp BIGINT NOT NULL);");
            }
            oldVersion = 18;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.fetchManagerSession.session.prepareStatement("ServerSession.insert", "INSERT INTO server_session VALUES(?,?,?,?,?, ?,?,?);");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.nonce);
            statement.setBytes(3, this.challenge);
            statement.setBytes(4, this.response);
            statement.setBytes(5, this.token);
            statement.setInt(6, this.apiKeyStatus);
            statement.setLong(7, this.permissions);
            statement.setLong(8, this.apiKeyExpirationTimestamp);
            statement.executeUpdate();
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.fetchManagerSession.session.prepareStatement("ServerSession.delete", "DELETE FROM server_session WHERE identity = ?;");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    @Override
    public void wasCommitted() {
    }

    public static enum ApiKeyStatus {
        VALID,
        UNKNOWN,
        LICENSES_EXHAUSTED,
        EXPIRED,
        OPEN_BETA_KEY,
        FREE_TRIAL_KEY,
        AWAITING_PAYMENT_GRACE_PERIOD,
        AWAITING_PAYMENT_ON_HOLD,
        FREE_TRIAL_KEY_EXPIRED;

    }

    public static enum Permission {
        CALL,
        WEB_CLIENT,
        MULTI_DEVICE;

    }
}

