/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.PushNotificationTypeAndParameters;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class PushNotificationConfiguration
implements ObvDatabase {
    static final String TABLE_NAME = "push_notification_configuration";
    private final FetchManagerSession fetchManagerSession;
    private Identity ownedIdentity;
    static final String OWNED_IDENTITY = "identity";
    private UID deviceUid;
    static final String DEVICE_UID = "device_uid";
    private byte pushNotificationType;
    static final String PUSH_NOTIFICATION_TYPE = "push_notification_type";
    private byte[] token;
    static final String TOKEN = "token";
    private UID identityMaskingUid;
    static final String IDENTITY_MASKING_UID = "identity_masking_uid";
    private int multiDeviceConfiguration;
    static final String MULTI_DEVICE_CONFIGURATION = "multi_device_configuration";
    private UID deviceUidToReplace;
    static final String DEVICE_UID_TO_REPLACE = "device_uid_to_replace";
    private static final int CONFIGURATION_REACTIVATE_CURRENT_DEVICE_AT_NEXT_REGISTRATION_BIT = 1;
    private long commitHookBits = 0L;
    private static final long HOOK_BIT_INSERT = 1L;

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public UID getDeviceUid() {
        return this.deviceUid;
    }

    public byte getPushNotificationType() {
        return this.pushNotificationType;
    }

    public byte[] getToken() {
        return this.token;
    }

    public UID getIdentityMaskingUid() {
        return this.identityMaskingUid;
    }

    public boolean shouldReactivateCurrentDevice() {
        return (this.multiDeviceConfiguration & 1) != 0;
    }

    public UID getDeviceUidToReplace() {
        return this.deviceUidToReplace;
    }

    public PushNotificationTypeAndParameters getPushNotificationTypeAndParameters() {
        boolean reactivateCurrentDevice = (this.multiDeviceConfiguration & 1) != 0;
        return new PushNotificationTypeAndParameters(this.pushNotificationType, this.token, this.identityMaskingUid, reactivateCurrentDevice, this.deviceUidToReplace);
    }

    public static PushNotificationConfiguration create(FetchManagerSession fetchManagerSession, Identity ownedIdentity, UID deviceUid, PushNotificationTypeAndParameters pushNotificationTypeAndParameters) {
        if (ownedIdentity == null || deviceUid == null || pushNotificationTypeAndParameters == null) {
            return null;
        }
        int multiDeviceConfiguration = 0;
        if (pushNotificationTypeAndParameters.reactivateCurrentDevice) {
            multiDeviceConfiguration |= 1;
        }
        try {
            PushNotificationConfiguration pushNotificationConfiguration = new PushNotificationConfiguration(fetchManagerSession, ownedIdentity, deviceUid, pushNotificationTypeAndParameters.pushNotificationType, pushNotificationTypeAndParameters.token, pushNotificationTypeAndParameters.identityMaskingUid, multiDeviceConfiguration, pushNotificationTypeAndParameters.deviceUidToReplace);
            pushNotificationConfiguration.insert();
            return pushNotificationConfiguration;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    private PushNotificationConfiguration(FetchManagerSession fetchManagerSession, Identity ownedIdentity, UID deviceUid, byte pushNotificationType, byte[] token, UID identityMaskingUid, int multiDeviceConfiguration, UID deviceUidToReplace) {
        this.fetchManagerSession = fetchManagerSession;
        this.ownedIdentity = ownedIdentity;
        this.deviceUid = deviceUid;
        this.pushNotificationType = pushNotificationType;
        this.token = token;
        this.identityMaskingUid = identityMaskingUid;
        this.multiDeviceConfiguration = multiDeviceConfiguration;
        this.deviceUidToReplace = deviceUidToReplace;
    }

    private PushNotificationConfiguration(FetchManagerSession fetchManagerSession, ResultSet res) throws SQLException {
        this.fetchManagerSession = fetchManagerSession;
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
        }
        catch (DecodingException e) {
            Logger.x(e);
        }
        this.deviceUid = new UID(res.getBytes(DEVICE_UID));
        this.pushNotificationType = res.getByte(PUSH_NOTIFICATION_TYPE);
        this.token = res.getBytes(TOKEN);
        byte[] identityMaskingBytes = res.getBytes(IDENTITY_MASKING_UID);
        this.identityMaskingUid = identityMaskingBytes == null ? null : new UID(identityMaskingBytes);
        this.multiDeviceConfiguration = res.getInt(MULTI_DEVICE_CONFIGURATION);
        byte[] bytesDeviceUidToReplace = res.getBytes(DEVICE_UID_TO_REPLACE);
        this.deviceUidToReplace = bytesDeviceUidToReplace == null ? null : new UID(bytesDeviceUidToReplace);
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS push_notification_configuration (identity BLOB PRIMARY KEY, device_uid BLOB NOT NULL, push_notification_type INT NOT NULL, token BLOB, identity_masking_uid BLOB, multi_device_configuration INT NOT NULL,device_uid_to_replace BLOB );");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        Statement statement;
        if (oldVersion < 15 && newVersion >= 15) {
            Logger.d("DELETING old `registered_push_notification` table. It is replaced by the new and better `push_notification_configuration`.");
            statement = session.createStatement();
            try {
                statement.execute("DROP TABLE IF EXISTS registered_push_notification");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 15;
        }
        if (oldVersion < 35 && newVersion >= 35) {
            statement = session.createStatement();
            try {
                Logger.d("MIGRATING `push_notification_configuration` TABLE FROM VERSION " + oldVersion + " TO 35");
                statement.execute("ALTER TABLE push_notification_configuration ADD COLUMN device_uid_to_replace BLOB DEFAULT NULL");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 35;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.fetchManagerSession.session.prepareStatement("PushNotificationConfiguration.insert", "INSERT INTO push_notification_configuration VALUES(?,?,?,?,?, ?,?);");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.deviceUid.getBytes());
            statement.setByte(3, this.pushNotificationType);
            statement.setBytes(4, this.token);
            statement.setBytes(5, this.identityMaskingUid == null ? null : this.identityMaskingUid.getBytes());
            statement.setInt(6, this.multiDeviceConfiguration);
            statement.setBytes(7, this.deviceUidToReplace == null ? null : this.deviceUidToReplace.getBytes());
            statement.executeUpdate();
            this.commitHookBits |= 1L;
            this.fetchManagerSession.session.addSessionCommitListener(this);
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.fetchManagerSession.session.prepareStatement("PushNotificationConfiguration.delete", "DELETE FROM push_notification_configuration WHERE identity = ?;");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static PushNotificationConfiguration get(FetchManagerSession fetchManagerSession, Identity ownedIdentity) {
        if (ownedIdentity == null) {
            return null;
        }
        try (PreparedStatement statement = fetchManagerSession.session.prepareStatement("PushNotificationConfiguration.get", "SELECT * FROM push_notification_configuration WHERE identity = ?;");){
            PushNotificationConfiguration pushNotificationConfiguration;
            block19: {
                ResultSet res;
                block17: {
                    PushNotificationConfiguration pushNotificationConfiguration2;
                    block18: {
                        statement.setBytes(1, ownedIdentity.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block17;
                            pushNotificationConfiguration2 = new PushNotificationConfiguration(fetchManagerSession, res);
                            if (res == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return pushNotificationConfiguration2;
                }
                pushNotificationConfiguration = null;
                if (res == null) break block19;
                res.close();
            }
            return pushNotificationConfiguration;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static PushNotificationConfiguration[] getAll(FetchManagerSession fetchManagerSession) {
        try (PreparedStatement statement = fetchManagerSession.session.prepareStatement("PushNotificationConfiguration.getAll", "SELECT * FROM push_notification_configuration;");){
            PushNotificationConfiguration[] pushNotificationConfigurationArray;
            block15: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<PushNotificationConfiguration> list = new ArrayList<PushNotificationConfiguration>();
                    while (res.next()) {
                        list.add(new PushNotificationConfiguration(fetchManagerSession, res));
                    }
                    pushNotificationConfigurationArray = list.toArray(new PushNotificationConfiguration[0]);
                    if (res == null) break block15;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return pushNotificationConfigurationArray;
        }
        catch (SQLException e) {
            return new PushNotificationConfiguration[0];
        }
    }

    public void clearKickOtherDevices() {
        try (PreparedStatement statement = this.fetchManagerSession.session.prepareStatement("PushNotificationConfiguration.clearKickOtherDevices", "UPDATE push_notification_configuration SET multi_device_configuration = ?, device_uid_to_replace = NULL  WHERE identity = ?;");){
            int newMultiDeviceConfiguration = this.multiDeviceConfiguration & 0xFFFFFFFE;
            statement.setInt(1, newMultiDeviceConfiguration);
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.multiDeviceConfiguration = newMultiDeviceConfiguration;
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    public static void deleteForOwnedIdentity(FetchManagerSession fetchManagerSession, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = fetchManagerSession.session.prepareStatement("PushNotificationConfiguration.deleteForOwnedIdentity", "DELETE FROM push_notification_configuration WHERE identity = ?;");){
            statement.setBytes(1, ownedIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    @Override
    public void wasCommitted() {
        if ((this.commitHookBits & 1L) != 0L && this.fetchManagerSession.newPushNotificationConfigurationListener != null) {
            this.fetchManagerSession.newPushNotificationConfigurationListener.newPushNotificationConfiguration(this.ownedIdentity, this.deviceUid, this.getPushNotificationTypeAndParameters());
        }
    }

    public static interface NewPushNotificationConfigurationListener {
        public void newPushNotificationConfiguration(Identity var1, UID var2, PushNotificationTypeAndParameters var3);
    }
}

