/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.Hash;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.DecryptedApplicationMessage;
import io.olvid.engine.datatypes.containers.IdentityAndUid;
import io.olvid.engine.datatypes.containers.NetworkReceivedMessage;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.networkfetch.databases.InboxAttachment;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InboxMessage
implements ObvDatabase {
    static final String TABLE_NAME = "inbox_message";
    private final FetchManagerSession fetchManagerSession;
    private static final long DELETED_MESSAGE_RETENTION_TIME_MILLIS = 600000L;
    private static long lastExpungeTimestamp = System.currentTimeMillis();
    private static final HashMap<IdentityAndUid, Long> deletedMessageUids = new HashMap();
    private Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private final UID uid;
    static final String UID_ = "uid";
    private final EncryptedBytes wrappedKey;
    static final String WRAPPED_KEY = "wrapped_key";
    private final EncryptedBytes encryptedContent;
    static final String ENCRYPTED_CONTENT = "encrypted_content";
    private boolean markedForDeletion;
    static final String MARKED_FOR_DELETION = "marked_for_deletion";
    private final long serverTimestamp;
    static final String SERVER_TIMESTAMP = "server_timestamp";
    private byte[] payload;
    static final String PAYLOAD = "payload";
    private Identity fromIdentity;
    static final String FROM_IDENTITY = "from_identity";
    private final long downloadTimestamp;
    static final String DOWNLOAD_TIMESTAMP = "download_timestamp";
    private final long localDownloadTimestamp;
    static final String LOCAL_DOWNLOAD_TIMESTAMP = "local_download_timestamp";
    private final boolean hasExtendedPayload;
    static final String HAS_EXTENDED_PAYLOAD = "has_extended_payload";
    private AuthEncKey extendedPayloadKey;
    static final String EXTENDED_PAYLOAD_KEY = "extended_payload_key";
    private byte[] extendedPayload;
    static final String EXTENDED_PAYLOAD = "extended_payload";
    private UID fromDeviceUid;
    static final String FROM_DEVICE_UID = "from_device_uid";
    private boolean onHold;
    static final String ON_HOLD = "on_hold";
    private long commitHookBits = 0L;
    private InboxAttachment[] attachmentsToNotify;
    private static final long HOOK_BIT_INSERT = 1L;
    private static final long HOOK_BIT_PAYLOAD_AND_FROM_IDENTITY_SET = 2L;
    private static final long HOOK_BIT_EXTENDED_PAYLOAD_SET = 4L;

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public UID getUid() {
        return this.uid;
    }

    public EncryptedBytes getWrappedKey() {
        return this.wrappedKey;
    }

    public EncryptedBytes getEncryptedContent() {
        return this.encryptedContent;
    }

    public long getServerTimestamp() {
        return this.serverTimestamp;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public AuthEncKey getExtendedPayloadKey() {
        return this.extendedPayloadKey;
    }

    public byte[] getExtendedPayload() {
        return this.extendedPayload;
    }

    public InboxAttachment[] getAttachments() {
        return InboxAttachment.getAll(this.fetchManagerSession, this.ownedIdentity, this.uid);
    }

    public NetworkReceivedMessage getNetworkReceivedMessage() {
        if (this.encryptedContent == null || this.wrappedKey == null) {
            return null;
        }
        NetworkReceivedMessage.Header header = new NetworkReceivedMessage.Header(this.ownedIdentity, this.wrappedKey);
        return new NetworkReceivedMessage(this.uid, this.serverTimestamp, this.encryptedContent, header, this.hasExtendedPayload);
    }

    public DecryptedApplicationMessage getDecryptedApplicationMessage() {
        if (this.payload == null || this.fromIdentity == null) {
            return null;
        }
        return new DecryptedApplicationMessage(this.uid, this.payload, this.fromIdentity, this.fromDeviceUid, this.ownedIdentity, this.serverTimestamp, this.downloadTimestamp, this.localDownloadTimestamp);
    }

    public static UID computeUniqueUid(Identity ownedIdentity, UID messageUid, boolean markAsListed) {
        Hash sha256 = Suite.getHash("sha-256");
        byte[] input = new byte[ownedIdentity.getBytes().length + 32 + 1];
        System.arraycopy(ownedIdentity.getBytes(), 0, input, 0, ownedIdentity.getBytes().length);
        System.arraycopy(messageUid.getBytes(), 0, input, ownedIdentity.getBytes().length, 32);
        input[ownedIdentity.getBytes().length + 32] = markAsListed ? (byte)1 : 0;
        return new UID(sha256.digest(input));
    }

    public boolean canBeDeleted() {
        if (!this.markedForDeletion) {
            return false;
        }
        for (InboxAttachment inboxAttachment : this.getAttachments()) {
            if (inboxAttachment.isMarkedForDeletion()) continue;
            return false;
        }
        return true;
    }

    public void markForDeletion() {
        try (PreparedStatement statement = this.fetchManagerSession.session.prepareStatement("InboxMessage.markForDeletion", "UPDATE inbox_message SET marked_for_deletion = 1  WHERE owned_identity = ?  AND uid = ?;");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.uid.getBytes());
            statement.executeUpdate();
            this.markedForDeletion = true;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void markAsOnHold() throws SQLException {
        try (PreparedStatement statement = this.fetchManagerSession.session.prepareStatement("InboxMessage.markAsOnHold", "UPDATE inbox_message SET on_hold = 1  WHERE owned_identity = ?  AND uid = ?;");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.uid.getBytes());
            statement.executeUpdate();
            this.onHold = true;
        }
    }

    public void setPayloadAndFromIdentity(byte[] payload, Identity fromIdentity, UID fromDeviceUid, AuthEncKey extendedPayloadKey, InboxAttachment[] attachments) {
        try (PreparedStatement statement = this.fetchManagerSession.session.prepareStatement("InboxMessage.setPayloadAndFromIdentity", "UPDATE inbox_message SET payload = ?, from_identity = ?, from_device_uid = ?, extended_payload_key = ? WHERE owned_identity = ?  AND uid = ?;");){
            statement.setBytes(1, payload);
            statement.setBytes(2, fromIdentity.getBytes());
            statement.setBytes(3, fromDeviceUid == null ? null : fromDeviceUid.getBytes());
            statement.setBytes(4, extendedPayloadKey == null ? null : Encoded.of(extendedPayloadKey).getBytes());
            statement.setBytes(5, this.ownedIdentity.getBytes());
            statement.setBytes(6, this.uid.getBytes());
            statement.executeUpdate();
            this.payload = payload;
            this.fromIdentity = fromIdentity;
            this.fromDeviceUid = fromDeviceUid;
            this.extendedPayloadKey = extendedPayloadKey;
            this.attachmentsToNotify = attachments;
            this.commitHookBits |= 2L;
            this.fetchManagerSession.session.addSessionCommitListener(this);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void setFromIdentityForMissingPreKeyContact(Identity fromIdentity) {
        try (PreparedStatement statement = this.fetchManagerSession.session.prepareStatement("InboxMessage.setFromIdentityForMissingPreKeyContact", "UPDATE inbox_message SET from_identity = ? WHERE owned_identity = ?  AND uid = ?;");){
            statement.setBytes(1, fromIdentity.getBytes());
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.setBytes(3, this.uid.getBytes());
            statement.executeUpdate();
            this.fromIdentity = fromIdentity;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void setExtendedPayload(byte[] extendedPayload) throws SQLException {
        try (PreparedStatement statement = this.fetchManagerSession.session.prepareStatement("InboxMessage.setExtendedPayload", "UPDATE inbox_message SET extended_payload = ?  WHERE owned_identity = ?  AND uid = ?;");){
            statement.setBytes(1, extendedPayload);
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.setBytes(3, this.uid.getBytes());
            statement.executeUpdate();
            this.extendedPayload = extendedPayload;
            this.commitHookBits |= 4L;
            this.fetchManagerSession.session.addSessionCommitListener(this);
        }
    }

    public static void clearExtendedPayload(FetchManagerSession fetchManagerSession, Identity ownedIdentity, UID messageUid) {
        try (PreparedStatement statement = fetchManagerSession.session.prepareStatement("InboxMessage.clearExtendedPayload", "UPDATE inbox_message SET has_extended_payload = 0, extended_payload_key = NULL, extended_payload = NULL WHERE owned_identity = ?  AND uid = ?;");){
            statement.setBytes(1, ownedIdentity.getBytes());
            statement.setBytes(2, messageUid.getBytes());
            statement.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static InboxMessage create(FetchManagerSession fetchManagerSession, Identity ownedIdentity, UID messageUid, EncryptedBytes encryptedContent, EncryptedBytes wrappedKey, long serverTimestamp, long downloadTimestamp, long localDownloadTimestamp, boolean hasExtendedContent) {
        if (messageUid == null || ownedIdentity == null || encryptedContent == null || wrappedKey == null) {
            return null;
        }
        if (deletedMessageUids.containsKey(new IdentityAndUid(ownedIdentity, messageUid))) {
            fetchManagerSession.markAsListedAndDeleteOnServerListener.messageCanBeDeletedFromServer(ownedIdentity, messageUid);
            return null;
        }
        try {
            InboxMessage inboxMessage = new InboxMessage(fetchManagerSession, ownedIdentity, messageUid, encryptedContent, wrappedKey, serverTimestamp, downloadTimestamp, localDownloadTimestamp, hasExtendedContent);
            inboxMessage.insert();
            return inboxMessage;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    private InboxMessage(FetchManagerSession fetchManagerSession, Identity ownedIdentity, UID messageUid, EncryptedBytes encryptedContent, EncryptedBytes wrappedKey, long serverTimestamp, long downloadTimestamp, long localDownloadTimestamp, boolean hasExtendedContent) {
        this.fetchManagerSession = fetchManagerSession;
        this.uid = messageUid;
        this.ownedIdentity = ownedIdentity;
        this.encryptedContent = encryptedContent;
        this.wrappedKey = wrappedKey;
        this.markedForDeletion = false;
        this.serverTimestamp = serverTimestamp;
        this.payload = null;
        this.fromIdentity = null;
        this.fromDeviceUid = null;
        this.downloadTimestamp = downloadTimestamp;
        this.localDownloadTimestamp = localDownloadTimestamp;
        this.hasExtendedPayload = hasExtendedContent;
        this.extendedPayloadKey = null;
        this.extendedPayload = null;
        this.onHold = false;
    }

    private InboxMessage(FetchManagerSession fetchManagerSession, ResultSet res) throws SQLException {
        this.fetchManagerSession = fetchManagerSession;
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
        }
        catch (DecodingException e) {
            Logger.x(e);
        }
        this.uid = new UID(res.getBytes(UID_));
        byte[] bytes = res.getBytes(WRAPPED_KEY);
        this.wrappedKey = bytes == null ? null : new EncryptedBytes(bytes);
        bytes = res.getBytes(ENCRYPTED_CONTENT);
        this.encryptedContent = bytes == null ? null : new EncryptedBytes(bytes);
        this.markedForDeletion = res.getBoolean(MARKED_FOR_DELETION);
        this.serverTimestamp = res.getLong(SERVER_TIMESTAMP);
        this.payload = res.getBytes(PAYLOAD);
        byte[] fromIdentityBytes = res.getBytes(FROM_IDENTITY);
        if (fromIdentityBytes == null) {
            this.fromIdentity = null;
        } else {
            try {
                this.fromIdentity = Identity.of(fromIdentityBytes);
            }
            catch (DecodingException e) {
                Logger.x(e);
            }
        }
        byte[] fromDeviceUidBytes = res.getBytes(FROM_DEVICE_UID);
        this.fromDeviceUid = fromDeviceUidBytes == null || fromDeviceUidBytes.length != 32 ? null : new UID(fromDeviceUidBytes);
        this.downloadTimestamp = res.getLong(DOWNLOAD_TIMESTAMP);
        this.localDownloadTimestamp = res.getLong(LOCAL_DOWNLOAD_TIMESTAMP);
        this.hasExtendedPayload = res.getBoolean(HAS_EXTENDED_PAYLOAD);
        try {
            this.extendedPayloadKey = (AuthEncKey)new Encoded(res.getBytes(EXTENDED_PAYLOAD_KEY)).decodeSymmetricKey();
        }
        catch (Exception e) {
            this.extendedPayloadKey = null;
        }
        this.extendedPayload = res.getBytes(EXTENDED_PAYLOAD);
        this.onHold = res.getBoolean(ON_HOLD);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static InboxMessage get(FetchManagerSession fetchManagerSession, Identity ownedIdentity, UID uid) {
        if (uid == null) {
            return null;
        }
        try (PreparedStatement statement = fetchManagerSession.session.prepareStatement("InboxMessage.get", "SELECT * FROM inbox_message WHERE owned_identity = ?  AND uid = ?;");){
            InboxMessage inboxMessage;
            block19: {
                ResultSet res;
                block17: {
                    InboxMessage inboxMessage2;
                    block18: {
                        statement.setBytes(1, ownedIdentity.getBytes());
                        statement.setBytes(2, uid.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block17;
                            inboxMessage2 = new InboxMessage(fetchManagerSession, res);
                            if (res == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return inboxMessage2;
                }
                inboxMessage = null;
                if (res == null) break block19;
                res.close();
            }
            return inboxMessage;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean exists(FetchManagerSession fetchManagerSession, Identity ownedIdentity, UID uid) {
        if (uid == null) {
            return false;
        }
        try (PreparedStatement statement = fetchManagerSession.session.prepareStatement("InboxMessage.exists", "SELECT * FROM inbox_message WHERE owned_identity = ?  AND uid = ?;");){
            boolean bl;
            block15: {
                statement.setBytes(1, ownedIdentity.getBytes());
                statement.setBytes(2, uid.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    bl = res.next();
                    if (res == null) break block15;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return bl;
        }
        catch (SQLException e) {
            Logger.x(e);
            return false;
        }
    }

    public static InboxMessage[] getAllForOwnedIdentity(FetchManagerSession fetchManagerSession, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = fetchManagerSession.session.prepareStatement("InboxMessage.getAllForOwnedIdentity", "SELECT * FROM inbox_message WHERE owned_identity = ?;");){
            InboxMessage[] inboxMessageArray;
            block13: {
                statement.setBytes(1, ownedIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<InboxMessage> list = new ArrayList<InboxMessage>();
                    while (res.next()) {
                        list.add(new InboxMessage(fetchManagerSession, res));
                    }
                    inboxMessageArray = list.toArray(new InboxMessage[0]);
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return inboxMessageArray;
        }
    }

    public static InboxMessage[] getUnprocessedMessagesForOwnedIdentity(FetchManagerSession fetchManagerSession, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = fetchManagerSession.session.prepareStatement("InboxMessage.getUnprocessedMessagesForOwnedIdentity", "SELECT * FROM inbox_message WHERE owned_identity = ? AND payload IS NULL  AND from_identity IS NULL  AND marked_for_deletion = 0 ORDER BY server_timestamp ASC;");){
            InboxMessage[] inboxMessageArray;
            block13: {
                statement.setBytes(1, ownedIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<InboxMessage> list = new ArrayList<InboxMessage>();
                    while (res.next()) {
                        list.add(new InboxMessage(fetchManagerSession, res));
                    }
                    inboxMessageArray = list.toArray(new InboxMessage[0]);
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return inboxMessageArray;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static InboxMessage[] getUnprocessedMessages(FetchManagerSession fetchManagerSession) {
        try (PreparedStatement statement = fetchManagerSession.session.prepareStatement("InboxMessage.getUnprocessedMessages", "SELECT * FROM inbox_message WHERE payload IS NULL  AND marked_for_deletion = 0 ORDER BY server_timestamp ASC;");){
            InboxMessage[] inboxMessageArray;
            block15: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<InboxMessage> list = new ArrayList<InboxMessage>();
                    while (res.next()) {
                        list.add(new InboxMessage(fetchManagerSession, res));
                    }
                    inboxMessageArray = list.toArray(new InboxMessage[0]);
                    if (res == null) break block15;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return inboxMessageArray;
        }
        catch (SQLException e) {
            return new InboxMessage[0];
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<InboxMessage> getPendingPreKeyMessages(FetchManagerSession fetchManagerSession, Identity ownedIdentity, Identity contactIdentity) {
        try (PreparedStatement statement = fetchManagerSession.session.prepareStatement("InboxMessage.getPendingPreKeyMessages", "SELECT * FROM inbox_message WHERE payload IS NULL  AND owned_identity = ?  AND from_identity = ?  AND marked_for_deletion = 0  ORDER BY server_timestamp ASC;");){
            ArrayList<InboxMessage> arrayList;
            block15: {
                statement.setBytes(1, ownedIdentity.getBytes());
                statement.setBytes(2, contactIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<InboxMessage> list = new ArrayList<InboxMessage>();
                    while (res.next()) {
                        list.add(new InboxMessage(fetchManagerSession, res));
                    }
                    arrayList = list;
                    if (res == null) break block15;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<InboxMessage> getExpiredPendingPreKeyMessages(FetchManagerSession fetchManagerSession, long timestamp) {
        try (PreparedStatement statement = fetchManagerSession.session.prepareStatement("InboxMessage.getExpiredPendingPreKeyMessages", "SELECT * FROM inbox_message WHERE payload IS NULL  AND from_identity IS NOT NULL  AND local_download_timestamp < ?;");){
            ArrayList<InboxMessage> arrayList;
            block15: {
                statement.setLong(1, timestamp);
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<InboxMessage> list = new ArrayList<InboxMessage>();
                    while (res.next()) {
                        list.add(new InboxMessage(fetchManagerSession, res));
                    }
                    arrayList = list;
                    if (res == null) break block15;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static InboxMessage[] getDecryptedMessages(FetchManagerSession fetchManagerSession) {
        try (PreparedStatement statement = fetchManagerSession.session.prepareStatement("InboxMessage.getDecryptedMessages", "SELECT * FROM inbox_message WHERE payload NOT NULL  AND marked_for_deletion = 0 AND on_hold = 0 ORDER BY server_timestamp ASC;");){
            InboxMessage[] inboxMessageArray;
            block15: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<InboxMessage> list = new ArrayList<InboxMessage>();
                    while (res.next()) {
                        list.add(new InboxMessage(fetchManagerSession, res));
                    }
                    inboxMessageArray = list.toArray(new InboxMessage[0]);
                    if (res == null) break block15;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return inboxMessageArray;
        }
        catch (SQLException e) {
            return new InboxMessage[0];
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static InboxMessage[] getMarkedForDeletionMessages(FetchManagerSession fetchManagerSession) {
        try (PreparedStatement statement = fetchManagerSession.session.prepareStatement("InboxMessage.getMarkedForDeletionMessages", "SELECT * FROM inbox_message WHERE marked_for_deletion = 1;");){
            InboxMessage[] inboxMessageArray;
            block15: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<InboxMessage> list = new ArrayList<InboxMessage>();
                    while (res.next()) {
                        list.add(new InboxMessage(fetchManagerSession, res));
                    }
                    inboxMessageArray = list.toArray(new InboxMessage[0]);
                    if (res == null) break block15;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return inboxMessageArray;
        }
        catch (SQLException e) {
            return new InboxMessage[0];
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static InboxMessage[] getExtendedPayloadMessages(FetchManagerSession fetchManagerSession) {
        try (PreparedStatement statement = fetchManagerSession.session.prepareStatement("InboxMessage.getExtendedPayloadMessages", "SELECT * FROM inbox_message WHERE extended_payload IS NOT NULL;");){
            InboxMessage[] inboxMessageArray;
            block15: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<InboxMessage> list = new ArrayList<InboxMessage>();
                    while (res.next()) {
                        list.add(new InboxMessage(fetchManagerSession, res));
                    }
                    inboxMessageArray = list.toArray(new InboxMessage[0]);
                    if (res == null) break block15;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return inboxMessageArray;
        }
        catch (SQLException e) {
            return new InboxMessage[0];
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static InboxMessage[] getMissingExtendedPayloadMessages(FetchManagerSession fetchManagerSession) {
        try (PreparedStatement statement = fetchManagerSession.session.prepareStatement("InboxMessage.getMissingExtendedPayloadMessages", "SELECT * FROM inbox_message WHERE extended_payload_key IS NOT NULL AND extended_payload IS NULL;");){
            InboxMessage[] inboxMessageArray;
            block15: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<InboxMessage> list = new ArrayList<InboxMessage>();
                    while (res.next()) {
                        list.add(new InboxMessage(fetchManagerSession, res));
                    }
                    inboxMessageArray = list.toArray(new InboxMessage[0]);
                    if (res == null) break block15;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return inboxMessageArray;
        }
        catch (SQLException e) {
            return new InboxMessage[0];
        }
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS inbox_message (owned_identity BLOB NOT NULL, uid BLOB NOT NULL, wrapped_key BLOB NOT NULL, encrypted_content BLOB NOT NULL, marked_for_deletion BIT NOT NULL, server_timestamp BIGINT NOT NULL, payload BLOB, from_identity BLOB, download_timestamp BIGINT NOT NULL, local_download_timestamp BIGINT NOT NULL, has_extended_payload BIT NOT NULL, extended_payload_key BLOB, extended_payload BLOB, from_device_uid BLOB, on_hold BIT NOT NULL,  CONSTRAINT PK_inbox_message PRIMARY KEY(owned_identity, uid));");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        Statement statement;
        if (oldVersion < 2 && newVersion >= 2) {
            Logger.d("MIGRATING `inbox_message` DATABASE FROM VERSION " + oldVersion + " TO 2");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE `inbox_message` ADD COLUMN `server_timestamp` BIGINT NOT NULL DEFAULT 0");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 2;
        }
        if (oldVersion < 4 && newVersion >= 4) {
            Logger.d("MIGRATING `inbox_message` DATABASE FROM VERSION " + oldVersion + " TO 4\n!!!! THIS MIGRATION IS DESTRUCTIVE !!!!");
            statement = session.createStatement();
            try {
                statement.execute("DROP TABLE IF EXISTS `inbox_message`;");
                statement.execute("CREATE TABLE IF NOT EXISTS inbox_message (uid BLOB PRIMARY KEY, to_identity BLOB NOT NULL, wrapped_key BLOB NOT NULL, encrypted_content BLOB NOT NULL, marked_for_deletion BIT NOT NULL, server_timestamp BIGINT NOT NULL, payload BLOB, from_identity BLOB);");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 4;
        }
        if (oldVersion < 15 && newVersion >= 15) {
            Logger.d("MIGRATING `inbox_message` DATABASE FROM VERSION " + oldVersion + " TO 15");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE inbox_message RENAME TO old_inbox_message");
                statement.execute("CREATE TABLE IF NOT EXISTS inbox_message ( owned_identity BLOB NOT NULL,  uid BLOB NOT NULL,  wrapped_key BLOB NOT NULL,  encrypted_content BLOB NOT NULL,  marked_for_deletion BIT NOT NULL,  server_timestamp BIGINT NOT NULL,  payload BLOB,  from_identity BLOB,  CONSTRAINT PK_inbox_message PRIMARY KEY(owned_identity, uid));");
                statement.execute("INSERT INTO inbox_message SELECT to_identity, uid, wrapped_key, encrypted_content, marked_for_deletion, server_timestamp, payload, from_identity FROM old_inbox_message");
                statement.execute("DROP TABLE old_inbox_message");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 15;
        }
        if (oldVersion < 17 && newVersion >= 17) {
            Logger.d("MIGRATING `inbox_message` DATABASE FROM VERSION " + oldVersion + " TO 17");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE inbox_message RENAME TO old_inbox_message");
                statement.execute("CREATE TABLE IF NOT EXISTS inbox_message ( owned_identity BLOB NOT NULL,  uid BLOB NOT NULL,  wrapped_key BLOB NOT NULL,  encrypted_content BLOB NOT NULL,  marked_for_deletion BIT NOT NULL,  server_timestamp BIGINT NOT NULL,  payload BLOB,  from_identity BLOB,  download_timestamp BIGINT NOT NULL,  CONSTRAINT PK_inbox_message PRIMARY KEY(owned_identity, uid));");
                statement.execute("INSERT INTO inbox_message SELECT owned_identity, uid, wrapped_key, encrypted_content, marked_for_deletion, server_timestamp, payload, from_identity, server_timestamp FROM old_inbox_message");
                statement.execute("DROP TABLE old_inbox_message");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 17;
        }
        if (oldVersion < 19 && newVersion >= 19) {
            Logger.d("MIGRATING `inbox_message` DATABASE FROM VERSION " + oldVersion + " TO 19");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE inbox_message ADD COLUMN `local_download_timestamp` BIGINT NOT NULL DEFAULT 0");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 19;
        }
        if (oldVersion < 22 && newVersion >= 22) {
            Logger.d("MIGRATING `inbox_message` DATABASE FROM VERSION " + oldVersion + " TO 22");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE inbox_message ADD COLUMN `has_extended_payload` BIT NOT NULL DEFAULT 0");
                statement.execute("ALTER TABLE inbox_message ADD COLUMN `extended_payload_key` BLOB DEFAULT NULL");
                statement.execute("ALTER TABLE inbox_message ADD COLUMN `extended_payload` BLOB DEFAULT NULL");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 22;
        }
        if (oldVersion < 38 && newVersion >= 38) {
            Logger.d("MIGRATING `inbox_message` DATABASE FROM VERSION " + oldVersion + " TO 38");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE inbox_message ADD COLUMN `marked_as_listed_on_server` BIT NOT NULL DEFAULT 0");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 38;
        }
        if (oldVersion < 40 && newVersion >= 40) {
            Logger.d("MIGRATING `inbox_message` DATABASE FROM VERSION " + oldVersion + " TO 40");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE inbox_message DROP COLUMN `marked_as_listed_on_server`");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 40;
        }
        if (oldVersion < 43 && newVersion >= 43) {
            Logger.d("MIGRATING `inbox_message` DATABASE FROM VERSION " + oldVersion + " TO 43");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE inbox_message ADD COLUMN `from_device_uid` BLOB DEFAULT NULL");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 43;
        }
        if (oldVersion < 45 && newVersion >= 45) {
            Logger.d("MIGRATING `inbox_message` DATABASE FROM VERSION " + oldVersion + " TO 45");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE inbox_message ADD COLUMN `on_hold` BIT NOT NULL DEFAULT 0");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 45;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.fetchManagerSession.session.prepareStatement("InboxMessage.insert", "INSERT INTO inbox_message VALUES(?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?);");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.uid.getBytes());
            statement.setBytes(3, this.wrappedKey.getBytes());
            statement.setBytes(4, this.encryptedContent.getBytes());
            statement.setBoolean(5, this.markedForDeletion);
            statement.setLong(6, this.serverTimestamp);
            statement.setBytes(7, this.payload);
            statement.setBytes(8, this.fromIdentity == null ? null : this.fromIdentity.getBytes());
            statement.setLong(9, this.downloadTimestamp);
            statement.setLong(10, this.localDownloadTimestamp);
            statement.setBoolean(11, this.hasExtendedPayload);
            statement.setBytes(12, this.extendedPayloadKey == null ? null : Encoded.of(this.extendedPayloadKey).getBytes());
            statement.setBytes(13, this.extendedPayload);
            statement.setBytes(14, this.fromDeviceUid == null ? null : this.fromDeviceUid.getBytes());
            statement.setBoolean(15, this.onHold);
            statement.executeUpdate();
            this.commitHookBits |= 1L;
            this.fetchManagerSession.session.addSessionCommitListener(this);
        }
    }

    @Override
    public void delete() throws SQLException {
        if (System.currentTimeMillis() > lastExpungeTimestamp + 600000L) {
            lastExpungeTimestamp = System.currentTimeMillis();
            try {
                long timestamp = System.currentTimeMillis() - 600000L;
                ArrayList<IdentityAndUid> toDelete = new ArrayList<IdentityAndUid>();
                for (Map.Entry<IdentityAndUid, Long> entry : deletedMessageUids.entrySet()) {
                    if (entry.getValue() >= timestamp) continue;
                    toDelete.add(entry.getKey());
                }
                Logger.d("Expunging " + toDelete.size() + " deletedMessageUids");
                for (IdentityAndUid key : toDelete) {
                    deletedMessageUids.remove(key);
                }
            }
            catch (Exception timestamp) {
                // empty catch block
            }
        }
        deletedMessageUids.put(new IdentityAndUid(this.ownedIdentity, this.uid), System.currentTimeMillis());
        for (InboxAttachment inboxAttachment : this.getAttachments()) {
            try {
                inboxAttachment.deleteAttachmentFile();
            }
            catch (IOException e) {
                throw new SQLException("Error deleting attachment file.");
            }
            inboxAttachment.delete();
        }
        try (PreparedStatement statement = this.fetchManagerSession.session.prepareStatement("InboxMessage.delete", "DELETE FROM inbox_message WHERE owned_identity = ?  AND uid = ?;");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.uid.getBytes());
            statement.executeUpdate();
        }
    }

    @Override
    public void wasCommitted() {
        if ((this.commitHookBits & 1L) != 0L && this.fetchManagerSession.inboxMessageListener != null) {
            this.fetchManagerSession.inboxMessageListener.messageWasDownloaded(this.getNetworkReceivedMessage());
        }
        if ((this.commitHookBits & 2L) != 0L) {
            if (this.fetchManagerSession.inboxMessageListener != null) {
                this.fetchManagerSession.inboxMessageListener.messageDecrypted(this, this.attachmentsToNotify);
                if (this.extendedPayloadKey != null && this.fetchManagerSession.extendedPayloadListener != null) {
                    this.fetchManagerSession.extendedPayloadListener.messageHasExtendedPayloadToDownload(this.ownedIdentity, this.uid);
                }
            }
            if (this.fetchManagerSession.markAsListedAndDeleteOnServerListener != null) {
                this.fetchManagerSession.markAsListedAndDeleteOnServerListener.messageCanBeMarkedAsListedOnServer(this.ownedIdentity, this.uid);
            }
        }
        if ((this.commitHookBits & 4L) != 0L && this.fetchManagerSession.extendedPayloadListener != null) {
            this.fetchManagerSession.extendedPayloadListener.messageExtendedPayloadDownloaded(this.ownedIdentity, this.uid, this.extendedPayload);
        }
        this.commitHookBits = 0L;
    }

    public static interface MarkAsListedAndDeleteOnServerListener {
        public void messageCanBeMarkedAsListedOnServer(Identity var1, UID var2);

        public void messageCanBeDeletedFromServer(Identity var1, UID var2);
    }

    public static interface InboxMessageListener {
        public void messageWasDownloaded(NetworkReceivedMessage var1);

        public void messageDecrypted(InboxMessage var1, InboxAttachment[] var2);
    }

    public static interface ExtendedPayloadListener {
        public void messageHasExtendedPayloadToDownload(Identity var1, UID var2);

        public void messageExtendedPayloadDownloaded(Identity var1, UID var2, byte[] var3);
    }
}

