/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.coordinators;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoDuplicateOperationQueue;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.engine.types.JsonOsmStyle;
import io.olvid.engine.metamanager.NotificationPostingDelegate;
import io.olvid.engine.networkfetch.databases.CachedWellKnown;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSessionFactory;
import io.olvid.engine.networkfetch.datatypes.WellKnownCacheDelegate;
import io.olvid.engine.networkfetch.operations.WellKnownDownloadOperation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.ssl.SSLSocketFactory;

public class WellKnownCoordinator
implements Operation.OnFinishCallback,
Operation.OnCancelCallback,
WellKnownCacheDelegate {
    private final FetchManagerSessionFactory fetchManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final String userAgentOverride;
    private NotificationPostingDelegate notificationPostingDelegate;
    private final ObjectMapper jsonObjectMapper;
    private boolean cacheInitialized;
    private final HashMap<String, JsonWellKnown> wellKnownCache;
    private final NoDuplicateOperationQueue wellKnownDownloadOperationQueue;
    private final Timer wellKnownDownloadTimer;

    public WellKnownCoordinator(FetchManagerSessionFactory fetchManagerSessionFactory, SSLSocketFactory sslSocketFactory, String userAgentOverride, ObjectMapper jsonObjectMapper) {
        this.fetchManagerSessionFactory = fetchManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.userAgentOverride = userAgentOverride;
        this.jsonObjectMapper = jsonObjectMapper;
        this.cacheInitialized = false;
        this.wellKnownCache = new HashMap();
        this.wellKnownDownloadOperationQueue = new NoDuplicateOperationQueue();
        this.wellKnownDownloadTimer = new Timer("Engine-WellKnownDownloadTimer");
    }

    public void startProcessing() {
        this.wellKnownDownloadOperationQueue.execute(1, "Engine-WellKnownDownloadCoordinator");
    }

    public void setNotificationPostingDelegate(NotificationPostingDelegate notificationPostingDelegate) {
        this.notificationPostingDelegate = notificationPostingDelegate;
    }

    public void initialQueueing() {
        try (FetchManagerSession fetchManagerSession = this.fetchManagerSessionFactory.getSession();){
            List<CachedWellKnown> cachedWellKnowns = CachedWellKnown.getAll(fetchManagerSession);
            Identity[] ownedIdentities = fetchManagerSession.identityDelegate.getOwnedIdentities(fetchManagerSession.session);
            HashSet<String> servers = new HashSet<String>();
            for (Identity ownedIdentity : ownedIdentities) {
                servers.add(ownedIdentity.getServer());
            }
            for (String server : servers) {
                this.queueNewWellKnownDownloadOperation(server);
            }
            for (CachedWellKnown cachedWellKnown : cachedWellKnowns) {
                if (servers.contains(cachedWellKnown.getServer())) {
                    try {
                        this.wellKnownCache.put(cachedWellKnown.getServer(), (JsonWellKnown)this.jsonObjectMapper.readValue(cachedWellKnown.getSerializedWellKnown(), JsonWellKnown.class));
                    }
                    catch (Exception exception) {}
                    continue;
                }
                cachedWellKnown.delete();
            }
            this.cacheInitialized = true;
            this.notificationPostingDelegate.postNotification("network_fetch_notification_well_known_cache_initialized", new HashMap<String, Object>());
            this.wellKnownDownloadTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try (FetchManagerSession fetchManagerSession = WellKnownCoordinator.this.fetchManagerSessionFactory.getSession();){
                        Identity[] ownedIdentities = fetchManagerSession.identityDelegate.getOwnedIdentities(fetchManagerSession.session);
                        HashSet<String> servers = new HashSet<String>();
                        for (Identity ownedIdentity : ownedIdentities) {
                            servers.add(ownedIdentity.getServer());
                        }
                        for (String server : servers) {
                            WellKnownCoordinator.this.queueNewWellKnownDownloadOperation(server);
                        }
                    }
                    catch (Exception e) {
                        Logger.x(e);
                    }
                }
            }, 21600000L, 21600000L);
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    public void queueNewWellKnownDownloadOperation(String server) {
        Logger.d("Requesting .well-known fetch for " + server);
        this.wellKnownDownloadOperationQueue.queue(new WellKnownDownloadOperation(this.fetchManagerSessionFactory, this.sslSocketFactory, this.userAgentOverride, server, this.jsonObjectMapper, this, this));
    }

    @Override
    public void onFinishCallback(Operation operation) {
        if (!(operation instanceof WellKnownDownloadOperation)) {
            return;
        }
        WellKnownDownloadOperation wellKnownDownloadOperation = (WellKnownDownloadOperation)operation;
        String server = wellKnownDownloadOperation.getServer();
        JsonWellKnown jsonWellKnown = wellKnownDownloadOperation.getDownloadedWellKnown();
        boolean updated = wellKnownDownloadOperation.isUpdated();
        this.wellKnownCache.put(server, jsonWellKnown);
        if (updated) {
            HashMap<String, Object> userInfo = new HashMap<String, Object>();
            userInfo.put("server", server);
            userInfo.put("server_config", jsonWellKnown.serverConfig);
            userInfo.put("app_info", jsonWellKnown.appInfo);
            this.notificationPostingDelegate.postNotification("network_fetch_notification_well_known_updated", userInfo);
        } else {
            HashMap<String, Object> userInfo = new HashMap<String, Object>();
            userInfo.put("server", wellKnownDownloadOperation.getServer());
            userInfo.put("app_info", jsonWellKnown.appInfo);
            this.notificationPostingDelegate.postNotification("network_fetch_notification_well_known_download_success", userInfo);
        }
    }

    @Override
    public void onCancelCallback(Operation operation) {
        if (!(operation instanceof WellKnownDownloadOperation)) {
            return;
        }
        WellKnownDownloadOperation wellKnownDownloadOperation = (WellKnownDownloadOperation)operation;
        HashMap<String, Object> userInfo = new HashMap<String, Object>();
        userInfo.put("server", wellKnownDownloadOperation.getServer());
        this.notificationPostingDelegate.postNotification("network_fetch_notification_well_known_download_failed", userInfo);
    }

    @Override
    public String getWsUrl(String server) throws NotCachedException {
        if (!this.cacheInitialized) {
            throw new NotCachedException();
        }
        JsonWellKnown jsonWellKnown = this.wellKnownCache.get(server);
        if (jsonWellKnown == null) {
            this.queueNewWellKnownDownloadOperation(server);
            throw new NotCachedException();
        }
        if (jsonWellKnown.serverConfig == null) {
            return null;
        }
        return jsonWellKnown.serverConfig.webSocketUrl;
    }

    @Override
    public List<String> getTurnUrls(String server) throws NotCachedException {
        if (!this.cacheInitialized) {
            throw new NotCachedException();
        }
        JsonWellKnown jsonWellKnown = this.wellKnownCache.get(server);
        if (jsonWellKnown == null) {
            this.queueNewWellKnownDownloadOperation(server);
            throw new NotCachedException();
        }
        if (jsonWellKnown.serverConfig == null) {
            return null;
        }
        return jsonWellKnown.serverConfig.turnServerUrls;
    }

    @Override
    public List<JsonOsmStyle> getOsmStyles(String server) throws NotCachedException {
        if (!this.cacheInitialized) {
            throw new NotCachedException();
        }
        JsonWellKnown jsonWellKnown = this.wellKnownCache.get(server);
        if (jsonWellKnown == null) {
            this.queueNewWellKnownDownloadOperation(server);
            throw new NotCachedException();
        }
        if (jsonWellKnown.serverConfig == null) {
            return null;
        }
        return jsonWellKnown.serverConfig.osmStyles;
    }

    @Override
    public String getAddressUrl(String server) throws NotCachedException {
        if (!this.cacheInitialized) {
            throw new NotCachedException();
        }
        JsonWellKnown jsonWellKnown = this.wellKnownCache.get(server);
        if (jsonWellKnown == null) {
            this.queueNewWellKnownDownloadOperation(server);
            throw new NotCachedException();
        }
        if (jsonWellKnown.serverConfig == null) {
            return null;
        }
        return jsonWellKnown.serverConfig.addressServerUrl;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JsonWellKnown {
        @JsonProperty(value="server")
        public JsonWellKnownServerConfig serverConfig;
        @JsonProperty(value="app")
        public Map<String, Integer> appInfo;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JsonWellKnownServerConfig {
        @JsonProperty(value="ws_server")
        public String webSocketUrl;
        @JsonProperty(value="turn_servers")
        public List<String> turnServerUrls;
        @JsonProperty(value="address_server")
        public String addressServerUrl;
        @JsonProperty(value="osm_styles")
        public List<JsonOsmStyle> osmStyles;
    }

    public static class NotCachedException
    extends Exception {
    }
}

