/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.coordinators;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.ExponentialBackoffRepeatingScheduler;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoDuplicateOperationQueue;
import io.olvid.engine.datatypes.NotificationListener;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.OwnedIdentitySynchronizationStatus;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.engine.types.HttpHelper;
import io.olvid.engine.metamanager.NotificationListeningDelegate;
import io.olvid.engine.metamanager.NotificationPostingDelegate;
import io.olvid.engine.networkfetch.coordinators.WellKnownCoordinator;
import io.olvid.engine.networkfetch.databases.ServerSession;
import io.olvid.engine.networkfetch.datatypes.CreateServerSessionDelegate;
import io.olvid.engine.networkfetch.datatypes.DownloadMessagesAndListAttachmentsDelegate;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSessionFactory;
import io.olvid.engine.networkfetch.datatypes.WellKnownCacheDelegate;
import io.olvid.engine.protocol.datatypes.ProtocolStarterDelegate;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.security.KeyStore;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import net.iharder.Base64;
import okhttp3.Authenticator;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

public class WebsocketCoordinator
implements Operation.OnCancelCallback {
    private final FetchManagerSessionFactory fetchManagerSessionFactory;
    private final CreateServerSessionDelegate createServerSessionDelegate;
    private final DownloadMessagesAndListAttachmentsDelegate downloadMessagesAndListAttachmentsDelegate;
    private final WellKnownCacheDelegate wellKnownCacheDelegate;
    private final ObjectMapper jsonObjectMapper;
    private final Map<String, List<IdentityAndUid>> ownedIdentityAndUidsByServer;
    private final HashSet<Identity> ownedIdentityFirstRegisterSuccessful;
    private final Map<Identity, UID> ownedIdentityCurrentDeviceUids;
    private final Map<Identity, byte[]> ownedIdentityServerSessionTokens;
    private final Object ownedIdentityAndUidsLock = new Object();
    private final Map<String, WebSocketClient> existingWebsockets;
    private final ExponentialBackoffRepeatingScheduler<String> scheduler;
    private final NoDuplicateOperationQueue websocketCreationOperationQueue;
    private final NoDuplicateOperationQueue identityRegistrationOperationQueue;
    private final HashSet<Identity> awaitingServerSessionIdentities;
    private final Object awaitingServerSessionIdentitiesLock;
    private final ServerSessionCreatedNotificationListener serverSessionCreatedNotificationListener;
    private final OwnedIdentityListUpdatedNotificationListener ownedIdentityListUpdatedNotificationListener;
    private final WellKnownCacheNotificationListener wellKnownCacheNotificationListener;
    private NotificationListeningDelegate notificationListeningDelegate;
    private NotificationPostingDelegate notificationPostingDelegate;
    private ProtocolStarterDelegate protocolStarterDelegate;
    private final OkHttpClient okHttpClient;
    private boolean doConnect = false;
    private boolean relyOnWebsocketForNetworkDetection = false;
    private String os;
    private String osVersion;
    private int appBuild;
    private String appVersion;
    long lastSleepDetectorTaskTimestamp = 0L;
    Runnable sleepDetectorTask = () -> {
        long timestamp = System.currentTimeMillis();
        if (this.lastSleepDetectorTaskTimestamp != 0L && timestamp - this.lastSleepDetectorTaskTimestamp > 10000L) {
            Logger.w("\ud83d\udca4 Sleep detected: " + (timestamp - this.lastSleepDetectorTaskTimestamp) + " -> reconnecting WebSockets.");
            this.resetWebsockets();
        }
        this.lastSleepDetectorTaskTimestamp = timestamp;
    };

    public WebsocketCoordinator(FetchManagerSessionFactory fetchManagerSessionFactory, SSLSocketFactory sslSocketFactory, String userAgentOverride, CreateServerSessionDelegate createServerSessionDelegate, DownloadMessagesAndListAttachmentsDelegate downloadMessagesAndListAttachmentsDelegate, WellKnownCacheDelegate wellKnownCacheDelegate, ObjectMapper jsonObjectMapper) {
        this.fetchManagerSessionFactory = fetchManagerSessionFactory;
        this.createServerSessionDelegate = createServerSessionDelegate;
        this.downloadMessagesAndListAttachmentsDelegate = downloadMessagesAndListAttachmentsDelegate;
        this.wellKnownCacheDelegate = wellKnownCacheDelegate;
        this.jsonObjectMapper = jsonObjectMapper;
        this.websocketCreationOperationQueue = new NoDuplicateOperationQueue();
        this.identityRegistrationOperationQueue = new NoDuplicateOperationQueue();
        this.scheduler = new ExponentialBackoffRepeatingScheduler<String>(){

            @Override
            protected long computeReschedulingDelay(int failedAttemptCount) {
                if (WebsocketCoordinator.this.relyOnWebsocketForNetworkDetection) {
                    return Math.min(super.computeReschedulingDelay(failedAttemptCount), 20000L);
                }
                return super.computeReschedulingDelay(failedAttemptCount);
            }
        };
        this.awaitingServerSessionIdentities = new HashSet();
        this.awaitingServerSessionIdentitiesLock = new Object();
        this.serverSessionCreatedNotificationListener = new ServerSessionCreatedNotificationListener();
        this.ownedIdentityListUpdatedNotificationListener = new OwnedIdentityListUpdatedNotificationListener();
        this.wellKnownCacheNotificationListener = new WellKnownCacheNotificationListener();
        this.ownedIdentityAndUidsByServer = new HashMap<String, List<IdentityAndUid>>();
        this.ownedIdentityFirstRegisterSuccessful = new HashSet();
        this.ownedIdentityCurrentDeviceUids = new HashMap<Identity, UID>();
        this.ownedIdentityServerSessionTokens = new HashMap<Identity, byte[]>();
        this.existingWebsockets = new HashMap<String, WebSocketClient>();
        this.okHttpClient = WebsocketCoordinator.initializeOkHttpClientForWebSocket(sslSocketFactory, userAgentOverride);
    }

    public void startProcessing() {
        this.websocketCreationOperationQueue.execute(1, "Engine-WebsocketCoordinator-create");
        this.identityRegistrationOperationQueue.execute(1, "Engine-WebsocketCoordinator-register");
        this.scheduler.schedulePeriodically("\ud83d\udca4 sleep detection", this.sleepDetectorTask, "timer task", 5000L);
    }

    public static OkHttpClient initializeOkHttpClientForWebSocket(SSLSocketFactory sslSocketFactory, String userAgentOverride) {
        String userAgentProperty;
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (sslSocketFactory != null) {
            try {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init((KeyStore)null);
                Object[] trustManagers = trustManagerFactory.getTrustManagers();
                if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                    throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
                }
                X509TrustManager trustManager = (X509TrustManager)trustManagers[0];
                builder.sslSocketFactory(sslSocketFactory, trustManager);
            }
            catch (Exception e) {
                Logger.e("Error initializing websocket okHttpClient trustManager");
                Logger.x(e);
            }
        }
        String string = userAgentProperty = userAgentOverride != null ? userAgentOverride : System.getProperty("http.agent");
        if (userAgentProperty != null) {
            builder.addInterceptor(chain -> chain.proceed(chain.request().newBuilder().header("User-Agent", userAgentProperty).build()));
            builder.proxyAuthenticator((route, response) -> {
                Request request = Authenticator.JAVA_NET_AUTHENTICATOR.authenticate(route, response);
                if (request == null) {
                    if (route == null) {
                        return null;
                    }
                    return new Request.Builder().url(route.address().url()).method("CONNECT", null).header("Host", HttpHelper.toHostHeader(route.address().url())).header("Proxy-Connection", "Keep-Alive").header("User-Agent", userAgentProperty).build();
                }
                return request.newBuilder().header("User-Agent", userAgentProperty).build();
            });
        }
        builder.pingInterval(20000L, TimeUnit.MILLISECONDS);
        return builder.build();
    }

    public void setNotificationListeningDelegate(NotificationListeningDelegate notificationListeningDelegate) {
        this.notificationListeningDelegate = notificationListeningDelegate;
        this.notificationListeningDelegate.addListener("network_fetch_notification_server_session_created", this.serverSessionCreatedNotificationListener);
        this.notificationListeningDelegate.addListener("identity_manager_notification_owned_identity_list_updated", this.ownedIdentityListUpdatedNotificationListener);
        this.notificationListeningDelegate.addListener("identity_manager_notification_owned_identity_changed_active_status", this.ownedIdentityListUpdatedNotificationListener);
        this.notificationListeningDelegate.addListener("network_fetch_notification_well_known_cache_initialized", this.wellKnownCacheNotificationListener);
        this.notificationListeningDelegate.addListener("network_fetch_notification_well_known_updated", this.wellKnownCacheNotificationListener);
    }

    public void setNotificationPostingDelegate(NotificationPostingDelegate notificationPostingDelegate) {
        this.notificationPostingDelegate = notificationPostingDelegate;
    }

    public void setProtocolStarterDelegate(ProtocolStarterDelegate protocolStarterDelegate) {
        this.protocolStarterDelegate = protocolStarterDelegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialQueueing() {
        Object object = this.ownedIdentityAndUidsLock;
        synchronized (object) {
            try (FetchManagerSession fetchManagerSession = this.fetchManagerSessionFactory.getSession();){
                Identity[] ownedIdentities;
                this.ownedIdentityAndUidsByServer.clear();
                this.ownedIdentityCurrentDeviceUids.clear();
                for (Identity ownedIdentity : ownedIdentities = fetchManagerSession.identityDelegate.getOwnedIdentities(fetchManagerSession.session)) {
                    if (!fetchManagerSession.identityDelegate.isActiveOwnedIdentity(fetchManagerSession.session, ownedIdentity)) continue;
                    UID deviceUid = fetchManagerSession.identityDelegate.getCurrentDeviceUidOfOwnedIdentity(fetchManagerSession.session, ownedIdentity);
                    this.ownedIdentityCurrentDeviceUids.put(ownedIdentity, deviceUid);
                    String server = ownedIdentity.getServer();
                    List<IdentityAndUid> identityAndUids = this.ownedIdentityAndUidsByServer.get(server);
                    if (identityAndUids == null) {
                        identityAndUids = new ArrayList<IdentityAndUid>();
                        this.ownedIdentityAndUidsByServer.put(server, identityAndUids);
                    }
                    identityAndUids.add(new IdentityAndUid(ownedIdentity, deviceUid));
                }
            }
            catch (Exception e) {
                Logger.x(e);
            }
        }
        this.resetWebsockets();
    }

    public void connectWebsockets(boolean relyOnWebsocketForNetworkDetection, String os, String osVersion, int appBuild, String appVersion) {
        this.doConnect = true;
        this.relyOnWebsocketForNetworkDetection = relyOnWebsocketForNetworkDetection;
        this.os = os;
        this.osVersion = osVersion;
        this.appBuild = appBuild;
        this.appVersion = appVersion;
        this.internalConnectWebsockets();
    }

    public void disconnectWebsockets() {
        this.doConnect = false;
        this.relyOnWebsocketForNetworkDetection = false;
        this.internalDisconnectWebsockets();
    }

    public void pingWebsocket(Identity ownedIdentity) {
        String server = ownedIdentity.getServer();
        WebSocketClient webSocketClient = this.existingWebsockets.get(server);
        if (webSocketClient != null && webSocketClient.websocketConnected) {
            webSocketClient.sendPing();
        }
    }

    private void resetWebsockets() {
        this.internalDisconnectWebsockets();
        this.internalConnectWebsockets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalDisconnectWebsockets() {
        ArrayList<WebSocketClient> webSocketClients;
        Map<String, WebSocketClient> map = this.existingWebsockets;
        synchronized (map) {
            webSocketClients = new ArrayList<WebSocketClient>(this.existingWebsockets.values());
        }
        for (WebSocketClient webSocketClient : webSocketClients) {
            webSocketClient.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalConnectWebsockets() {
        if (!this.doConnect) {
            return;
        }
        Object object = this.ownedIdentityAndUidsLock;
        synchronized (object) {
            for (String server : this.ownedIdentityAndUidsByServer.keySet()) {
                this.queueWebsocketCreationOperation(server);
            }
        }
    }

    private void queueWebsocketCreationOperation(String server) {
        this.websocketCreationOperationQueue.queue(new WebsocketCreationOperation(server, (Operation.OnCancelCallback)this));
    }

    private void queueIdentityRegistrationOperation(Identity identity, UID deviceUid) {
        this.identityRegistrationOperationQueue.queue(new IdentityRegistrationOperation(identity, deviceUid, this));
    }

    private void scheduleNewWebsocketCreationQueueing(String server) {
        this.scheduler.schedule(server, () -> this.queueWebsocketCreationOperation(server), "Websocket Connection");
    }

    public void retryScheduledNetworkTasks() {
        this.scheduler.retryScheduledRunnables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCancelCallback(Operation operation) {
        if (operation instanceof WebsocketCreationOperation) {
            String server = ((WebsocketCreationOperation)operation).getServer();
            Integer rfc = operation.getReasonForCancel();
            Logger.i("WebsocketCreationOperation cancelled for reason " + rfc);
            if (rfc == null) {
                rfc = -1;
            }
            switch (rfc) {
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    this.scheduleNewWebsocketCreationQueueing(server);
                    break;
                }
            }
        } else if (operation instanceof IdentityRegistrationOperation) {
            Identity identity = ((IdentityRegistrationOperation)operation).getIdentity();
            Integer rfc = operation.getReasonForCancel();
            Logger.i("IdentityRegistrationOperation cancelled for reason " + rfc);
            if (rfc == null) {
                rfc = -1;
            }
            switch (rfc) {
                case 1: {
                    this.resetWebsockets();
                    break;
                }
                case 3: {
                    Object object = this.awaitingServerSessionIdentitiesLock;
                    synchronized (object) {
                        this.awaitingServerSessionIdentities.add(identity);
                    }
                    this.createServerSessionDelegate.createServerSession(identity);
                    break;
                }
            }
        }
    }

    public void deleteReturnReceipt(Identity ownedIdentity, byte[] serverUid) {
        String server = ownedIdentity.getServer();
        WebSocketClient webSocketClient = this.existingWebsockets.get(server);
        if (webSocketClient != null) {
            try {
                HashMap<String, String> messageMap = new HashMap<String, String>();
                messageMap.put("action", "delete_return_receipt");
                messageMap.put("serverUid", Base64.encodeBytes((byte[])serverUid));
                webSocketClient.send(this.jsonObjectMapper.writeValueAsString(messageMap));
            }
            catch (Exception e) {
                Logger.x(e);
            }
        }
    }

    private class ServerSessionCreatedNotificationListener
    implements NotificationListener {
        private ServerSessionCreatedNotificationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callback(String notificationName, Map<String, Object> userInfo) {
            if (!notificationName.equals("network_fetch_notification_server_session_created")) {
                return;
            }
            Object identityObject = userInfo.get("identity");
            if (!(identityObject instanceof Identity)) {
                return;
            }
            Identity identity = (Identity)identityObject;
            Object object = WebsocketCoordinator.this.awaitingServerSessionIdentitiesLock;
            synchronized (object) {
                if (WebsocketCoordinator.this.awaitingServerSessionIdentities.contains(identity)) {
                    UID deviceUid = WebsocketCoordinator.this.ownedIdentityCurrentDeviceUids.get(identity);
                    if (deviceUid != null) {
                        WebsocketCoordinator.this.queueIdentityRegistrationOperation(identity, deviceUid);
                    }
                    WebsocketCoordinator.this.awaitingServerSessionIdentities.remove(identity);
                }
            }
        }
    }

    private class OwnedIdentityListUpdatedNotificationListener
    implements NotificationListener {
        private OwnedIdentityListUpdatedNotificationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callback(String notificationName, Map<String, Object> userInfo) {
            Object object = WebsocketCoordinator.this.ownedIdentityAndUidsLock;
            synchronized (object) {
                try (FetchManagerSession fetchManagerSession = WebsocketCoordinator.this.fetchManagerSessionFactory.getSession();){
                    Identity[] ownedIdentities;
                    WebsocketCoordinator.this.ownedIdentityAndUidsByServer.clear();
                    WebsocketCoordinator.this.ownedIdentityCurrentDeviceUids.clear();
                    for (Identity ownedIdentity : ownedIdentities = fetchManagerSession.identityDelegate.getOwnedIdentities(fetchManagerSession.session)) {
                        if (!fetchManagerSession.identityDelegate.isActiveOwnedIdentity(fetchManagerSession.session, ownedIdentity)) continue;
                        UID deviceUid = fetchManagerSession.identityDelegate.getCurrentDeviceUidOfOwnedIdentity(fetchManagerSession.session, ownedIdentity);
                        WebsocketCoordinator.this.ownedIdentityCurrentDeviceUids.put(ownedIdentity, deviceUid);
                        String server = ownedIdentity.getServer();
                        List<IdentityAndUid> identityAndUids = WebsocketCoordinator.this.ownedIdentityAndUidsByServer.get(server);
                        if (identityAndUids == null) {
                            identityAndUids = new ArrayList<IdentityAndUid>();
                            WebsocketCoordinator.this.ownedIdentityAndUidsByServer.put(server, identityAndUids);
                        }
                        identityAndUids.add(new IdentityAndUid(ownedIdentity, deviceUid));
                    }
                }
                catch (Exception e) {
                    Logger.x(e);
                }
            }
            WebsocketCoordinator.this.resetWebsockets();
        }
    }

    private class WellKnownCacheNotificationListener
    implements NotificationListener {
        private WellKnownCacheNotificationListener() {
        }

        @Override
        public void callback(String notificationName, Map<String, Object> userInfo) {
            switch (notificationName) {
                case "network_fetch_notification_well_known_cache_initialized": 
                case "network_fetch_notification_well_known_updated": {
                    WebsocketCoordinator.this.resetWebsockets();
                }
            }
        }
    }

    private static class IdentityAndUid {
        public final Identity identity;
        public final UID deviceUid;

        IdentityAndUid(Identity identity, UID deviceUid) {
            this.identity = identity;
            this.deviceUid = deviceUid;
        }
    }

    private class WebSocketClient
    extends WebSocketListener {
        private final String wsUrl;
        private final String server;
        private final WebSocket webSocket;
        private boolean websocketConnected = false;
        private boolean remotelyInitiatedClosing = false;
        private boolean reconnectAlreadyTakenCareOf = false;
        private final AtomicLong pingCounter = new AtomicLong(0L);
        private long lastPingCounter = -1L;
        private long lastPingTimestamp = -1L;
        private static final int INTERNAL_CLOSING_CODE = 4547;
        private int currentConnectionState;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        WebSocketClient(String server, String wsUrl) {
            this.wsUrl = wsUrl;
            this.server = server;
            this.currentConnectionState = 0;
            Map<String, WebSocketClient> map = WebsocketCoordinator.this.existingWebsockets;
            synchronized (map) {
                WebsocketCoordinator.this.existingWebsockets.put(server, this);
            }
            this.webSocket = WebsocketCoordinator.this.okHttpClient.newWebSocket(new Request.Builder().url(wsUrl).build(), (WebSocketListener)this);
        }

        public void send(String message) {
            this.webSocket.send(message);
        }

        public void onOpen(WebSocket webSocket, Response response) {
            List<IdentityAndUid> identityAndUids;
            this.websocketConnected = true;
            Logger.d("Websocket connected to " + this.wsUrl);
            if (WebsocketCoordinator.this.notificationPostingDelegate != null) {
                if (this.currentConnectionState != 1) {
                    this.currentConnectionState = 1;
                    HashMap<String, Object> userInfo = new HashMap<String, Object>();
                    userInfo.put("state", 1);
                    WebsocketCoordinator.this.notificationPostingDelegate.postNotification("network_fetch_notification_websocket_connection_state_changed", userInfo);
                }
                if (WebsocketCoordinator.this.relyOnWebsocketForNetworkDetection) {
                    WebsocketCoordinator.this.notificationPostingDelegate.postNotification("network_fetch_notification_websocket_detected_some_network", Collections.emptyMap());
                }
            }
            if ((identityAndUids = WebsocketCoordinator.this.ownedIdentityAndUidsByServer.get(this.server)) != null) {
                for (IdentityAndUid identityAndUid : identityAndUids) {
                    WebsocketCoordinator.this.queueIdentityRegistrationOperation(identityAndUid.identity, identityAndUid.deviceUid);
                }
            }
            this.sendPing();
            WebsocketCoordinator.this.scheduler.schedule(this.server, new ReconnectTask(new WeakReference<WebSocketClient>(this), this.server), "WebSocket automatic reconnection", 6000000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(WebSocket webSocket, String message) {
            block65: {
                String action;
                Map receivedMessage;
                WebsocketCoordinator.this.scheduler.clearFailedCount(this.server);
                if (WebsocketCoordinator.this.notificationPostingDelegate != null && this.currentConnectionState != 2) {
                    this.currentConnectionState = 2;
                    HashMap<String, Object> userInfo = new HashMap<String, Object>();
                    userInfo.put("state", 2);
                    WebsocketCoordinator.this.notificationPostingDelegate.postNotification("network_fetch_notification_websocket_connection_state_changed", userInfo);
                }
                try {
                    receivedMessage = (Map)WebsocketCoordinator.this.jsonObjectMapper.readValue(message, (TypeReference)new TypeReference<Map<String, Object>>(){});
                    action = (String)receivedMessage.get("action");
                }
                catch (Exception e) {
                    Logger.i("Unable to parse websocket JSON message " + message);
                    return;
                }
                if (action == null) break block65;
                block28 : switch (action) {
                    case "register": {
                        Object identityObject = receivedMessage.get("identity");
                        if (!(identityObject instanceof String)) break;
                        try {
                            Identity identity = Identity.of(Base64.decode((String)((String)identityObject)));
                            if (!WebsocketCoordinator.this.ownedIdentityCurrentDeviceUids.containsKey(identity)) break;
                            if (!receivedMessage.containsKey("err")) {
                                Logger.d("Successfully registered identity on websocket");
                                HashSet<Identity> hashSet = WebsocketCoordinator.this.ownedIdentityFirstRegisterSuccessful;
                                synchronized (hashSet) {
                                    WebsocketCoordinator.this.ownedIdentityFirstRegisterSuccessful.add(identity);
                                    break;
                                }
                            }
                            Object errObject = receivedMessage.get("err");
                            int err = 255;
                            if (errObject instanceof Integer) {
                                err = (Integer)errObject;
                            }
                            switch ((byte)err) {
                                case 4: {
                                    if (WebsocketCoordinator.this.ownedIdentityServerSessionTokens.get(identity) != null) {
                                        try (FetchManagerSession fetchManagerSession = WebsocketCoordinator.this.fetchManagerSessionFactory.getSession();){
                                            ServerSession.deleteCurrentTokenIfEqualTo(fetchManagerSession, WebsocketCoordinator.this.ownedIdentityServerSessionTokens.get(identity), identity);
                                            fetchManagerSession.session.commit();
                                        }
                                        catch (SQLException e) {
                                            Logger.x(e);
                                        }
                                    }
                                    Object e = WebsocketCoordinator.this.awaitingServerSessionIdentitiesLock;
                                    synchronized (e) {
                                        WebsocketCoordinator.this.awaitingServerSessionIdentities.add(identity);
                                    }
                                    WebsocketCoordinator.this.createServerSessionDelegate.createServerSession(identity);
                                    break block28;
                                }
                            }
                        }
                        catch (DecodingException | IOException e) {
                            Logger.d("Error decoding identity");
                            Logger.x(e);
                        }
                        break;
                    }
                    case "message": {
                        Object identityObject = receivedMessage.get("identity");
                        if (!(identityObject instanceof String)) break;
                        try {
                            Identity identity = Identity.of(Base64.decode((String)((String)identityObject)));
                            UID deviceUid = WebsocketCoordinator.this.ownedIdentityCurrentDeviceUids.get(identity);
                            if (deviceUid == null) break;
                            Object messageObject = receivedMessage.get("message");
                            if (messageObject instanceof String) {
                                try {
                                    byte[] messagePayload = Base64.decode((String)((String)messageObject));
                                    WebsocketCoordinator.this.downloadMessagesAndListAttachmentsDelegate.processWebsocketDownloadedMessage(identity, deviceUid, messagePayload);
                                    break;
                                }
                                catch (Exception messagePayload) {
                                    // empty catch block
                                }
                            }
                            HashSet<Identity> messagePayload = WebsocketCoordinator.this.ownedIdentityFirstRegisterSuccessful;
                            synchronized (messagePayload) {
                                if (WebsocketCoordinator.this.ownedIdentityFirstRegisterSuccessful.contains(identity)) {
                                    WebsocketCoordinator.this.fetchManagerSessionFactory.markOwnedIdentityAsNotUpToDate(identity, OwnedIdentitySynchronizationStatus.OTHER_SYNC_IN_PROGRESS);
                                } else {
                                    WebsocketCoordinator.this.fetchManagerSessionFactory.markOwnedIdentityAsNotUpToDate(identity, OwnedIdentitySynchronizationStatus.INITIAL_SYNC_IN_PROGRESS);
                                }
                            }
                            WebsocketCoordinator.this.downloadMessagesAndListAttachmentsDelegate.downloadMessagesAndListAttachments(identity, deviceUid);
                        }
                        catch (DecodingException | IOException e) {
                            Logger.d("Error decoding identity");
                            Logger.x(e);
                        }
                        break;
                    }
                    case "return_receipt": {
                        Object identityObject = receivedMessage.get("identity");
                        Object serverUidObject = receivedMessage.get("serverUid");
                        Object nonceObject = receivedMessage.get("nonce");
                        Object encryptedPayloadObject = receivedMessage.get("encryptedPayload");
                        Object timestampObject = receivedMessage.get("timestamp");
                        if (identityObject == null || serverUidObject == null || nonceObject == null || encryptedPayloadObject == null || timestampObject == null) break;
                        try {
                            Identity identity = Identity.of(Base64.decode((String)((String)identityObject)));
                            byte[] serverUid = Base64.decode((String)((String)serverUidObject));
                            byte[] nonce = Base64.decode((String)((String)nonceObject));
                            byte[] encryptedPayload = Base64.decode((String)((String)encryptedPayloadObject));
                            long timestamp = (Long)timestampObject;
                            if (WebsocketCoordinator.this.notificationPostingDelegate == null) break;
                            HashMap<String, Object> userInfo = new HashMap<String, Object>();
                            userInfo.put("bytes_owned_identity", identity);
                            userInfo.put("server_uid", serverUid);
                            userInfo.put("nonce", nonce);
                            userInfo.put("encrypted_payload", encryptedPayload);
                            userInfo.put("timestamp", timestamp);
                            WebsocketCoordinator.this.notificationPostingDelegate.postNotification("network_fetch_notification_return_receipt_received", userInfo);
                        }
                        catch (Exception e) {
                            Logger.d("Error parsing return receipt");
                            Logger.x(e);
                        }
                        break;
                    }
                    case "push_topic": {
                        Object pushTopicObject = receivedMessage.get("topic");
                        if (pushTopicObject == null) break;
                        try {
                            String pushTopic = (String)pushTopicObject;
                            if (WebsocketCoordinator.this.notificationPostingDelegate == null) break;
                            HashMap<String, Object> userInfo = new HashMap<String, Object>();
                            userInfo.put("topic", pushTopic);
                            WebsocketCoordinator.this.notificationPostingDelegate.postNotification("network_fetch_notification_push_topic_notified", userInfo);
                        }
                        catch (Exception e) {
                            Logger.d("Error parsing push topic");
                            Logger.x(e);
                        }
                        break;
                    }
                    case "pong": {
                        Object counterObj = receivedMessage.get("cnt");
                        Object timestampObj = receivedMessage.get("timestamp");
                        if (counterObj == null || timestampObj == null) break;
                        long counter = -1L;
                        long timestamp = -1L;
                        try {
                            counter = counterObj instanceof Integer ? (long)((Integer)counterObj).intValue() : (Long)counterObj;
                            timestamp = timestampObj instanceof Integer ? (long)((Integer)timestampObj).intValue() : (Long)timestampObj;
                        }
                        catch (Exception e) {
                            Logger.x(e);
                        }
                        if (WebsocketCoordinator.this.notificationPostingDelegate == null || counter != this.lastPingCounter || timestamp == -1L) break;
                        this.lastPingCounter = -1L;
                        long delay = System.currentTimeMillis() - timestamp;
                        HashMap<String, Object> userInfo = new HashMap<String, Object>();
                        userInfo.put("delay", delay);
                        WebsocketCoordinator.this.notificationPostingDelegate.postNotification("network_fetch_notification_ping_received", userInfo);
                        break;
                    }
                    case "keycloak": {
                        Object identityObject = receivedMessage.get("identity");
                        if (!(identityObject instanceof String)) break;
                        try {
                            Identity identity = Identity.of(Base64.decode((String)((String)identityObject)));
                            HashMap<String, Object> userInfo = new HashMap<String, Object>();
                            userInfo.put("identity", identity);
                            WebsocketCoordinator.this.notificationPostingDelegate.postNotification("network_fetch_notification_keycloak_update_required", userInfo);
                        }
                        catch (DecodingException | IOException e) {
                            Logger.d("Error decoding identity in keycloak websocket notification");
                            Logger.x(e);
                        }
                        break;
                    }
                    case "ownedDevices": {
                        Object identityObject = receivedMessage.get("identity");
                        if (!(identityObject instanceof String)) break;
                        try {
                            Identity identity = Identity.of(Base64.decode((String)((String)identityObject)));
                            if (WebsocketCoordinator.this.protocolStarterDelegate == null) break;
                            try {
                                WebsocketCoordinator.this.protocolStarterDelegate.startOwnedDeviceDiscoveryProtocol(identity);
                            }
                            catch (Exception e) {
                                Logger.x(e);
                            }
                        }
                        catch (DecodingException | IOException e) {
                            Logger.d("Error decoding identity in ownedDevices websocket notification");
                            Logger.x(e);
                        }
                        break;
                    }
                }
            }
        }

        public void onMessage(WebSocket webSocket, ByteString bytes) {
            Logger.e("Received a binary message on websocket!");
        }

        public void sendPing() {
            long counter = this.pingCounter.incrementAndGet();
            long timestamp = System.currentTimeMillis();
            if (this.lastPingCounter != -1L && timestamp - this.lastPingTimestamp > 5000L && WebsocketCoordinator.this.notificationPostingDelegate != null) {
                WebsocketCoordinator.this.notificationPostingDelegate.postNotification("network_fetch_notification_ping_lost", new HashMap<String, Object>());
            }
            this.lastPingCounter = counter;
            this.lastPingTimestamp = timestamp;
            try {
                HashMap<String, Object> messageMap = new HashMap<String, Object>();
                messageMap.put("action", "ping");
                messageMap.put("cnt", counter);
                messageMap.put("timestamp", timestamp);
                this.webSocket.send(WebsocketCoordinator.this.jsonObjectMapper.writeValueAsString(messageMap));
            }
            catch (Exception e) {
                Logger.x(e);
            }
        }

        public void onClosed(WebSocket webSocket, int code, String reason) {
            if (this.websocketConnected) {
                if (this.remotelyInitiatedClosing) {
                    Logger.d("Websocket remotely disconnected from " + this.wsUrl);
                } else {
                    Logger.d("Websocket locally disconnected from " + this.wsUrl);
                }
            }
            if (WebsocketCoordinator.this.doConnect && !this.reconnectAlreadyTakenCareOf) {
                WebsocketCoordinator.this.scheduleNewWebsocketCreationQueueing(this.server);
            }
            this.close(false);
        }

        public void onClosing(WebSocket webSocket, int code, String reason) {
            this.remotelyInitiatedClosing = 4547 != code;
        }

        public void onFailure(WebSocket webSocket, Throwable t, Response response) {
            if (this.websocketConnected) {
                Logger.w("Websocket exception");
                Logger.x(t);
            }
            this.close(false);
            if (WebsocketCoordinator.this.doConnect) {
                WebsocketCoordinator.this.scheduleNewWebsocketCreationQueueing(this.server);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close(boolean reconnectAlreadyTakenCareOf) {
            if (WebsocketCoordinator.this.notificationPostingDelegate != null && this.currentConnectionState != 0) {
                this.currentConnectionState = 0;
                HashMap<String, Object> userInfo = new HashMap<String, Object>();
                userInfo.put("state", 0);
                WebsocketCoordinator.this.notificationPostingDelegate.postNotification("network_fetch_notification_websocket_connection_state_changed", userInfo);
            }
            this.reconnectAlreadyTakenCareOf = reconnectAlreadyTakenCareOf;
            Map<String, WebSocketClient> map = WebsocketCoordinator.this.existingWebsockets;
            synchronized (map) {
                if (WebsocketCoordinator.this.existingWebsockets.get(this.server) == this) {
                    WebsocketCoordinator.this.existingWebsockets.remove(this.server);
                }
            }
            if (this.webSocket != null && this.webSocket.close(4547, null)) {
                WebsocketCoordinator.this.scheduler.schedule(this.server, () -> ((WebSocket)this.webSocket).cancel(), "Websocket cancel()", 500L);
            }
        }
    }

    private class WebsocketCreationOperation
    extends Operation {
        static final int RFC_WEBSOCKET_ALREADY_EXISTS = 1;
        static final int RFC_NO_KNOWN_WS_SERVER_FOR_SERVER = 2;
        static final int RFC_SSL_HOSTNAME_VERIFICATION_ERROR = 3;
        static final int RFC_WELL_KNOWN_NOT_CACHED_YET = 4;
        private final String server;

        private WebsocketCreationOperation(String server, Operation.OnCancelCallback onCancelCallback) {
            super(new UID(Suite.getHash("sha-256").digest(server.getBytes())), null, onCancelCallback);
            this.server = server;
        }

        public String getServer() {
            return this.server;
        }

        @Override
        public void doCancel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doExecute() {
            boolean finished = false;
            try {
                String wsUrl;
                if (!WebsocketCoordinator.this.doConnect) {
                    finished = true;
                    return;
                }
                if (WebsocketCoordinator.this.existingWebsockets.containsKey(this.server)) {
                    this.cancel(1);
                    return;
                }
                try {
                    wsUrl = WebsocketCoordinator.this.wellKnownCacheDelegate.getWsUrl(this.server);
                }
                catch (WellKnownCoordinator.NotCachedException e) {
                    this.cancel(4);
                    if (finished) {
                        this.setFinished();
                    } else {
                        if (this.hasNoReasonForCancel()) {
                            this.cancel(null);
                        }
                        this.processCancel();
                    }
                    return;
                }
                if (wsUrl == null) {
                    this.cancel(2);
                    return;
                }
                new WebSocketClient(this.server, wsUrl);
                finished = true;
            }
            catch (Exception e) {
                Logger.x(e);
            }
            finally {
                if (finished) {
                    this.setFinished();
                } else {
                    if (this.hasNoReasonForCancel()) {
                        this.cancel(null);
                    }
                    this.processCancel();
                }
            }
        }
    }

    private class IdentityRegistrationOperation
    extends Operation {
        static final int RFC_WEBSOCKET_NOT_FOUND = 1;
        static final int RFC_WEBSOCKET_NOT_CONNECTED = 2;
        static final int RFC_NO_VALID_SERVER_SESSION = 3;
        private final Identity identity;
        private final UID deviceUid;

        private IdentityRegistrationOperation(Identity identity, UID deviceUid, Operation.OnCancelCallback onCancelCallback) {
            super(identity.computeUniqueUid(), null, onCancelCallback);
            this.identity = identity;
            this.deviceUid = deviceUid;
        }

        public Identity getIdentity() {
            return this.identity;
        }

        public UID getDeviceUid() {
            return this.deviceUid;
        }

        @Override
        public void doCancel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void doExecute() {
            boolean finished = false;
            try (FetchManagerSession fetchManagerSession = WebsocketCoordinator.this.fetchManagerSessionFactory.getSession();){
                try {
                    WebSocketClient webSocketClient = WebsocketCoordinator.this.existingWebsockets.get(this.identity.getServer());
                    if (webSocketClient == null) {
                        this.cancel(1);
                        return;
                    }
                    if (!webSocketClient.websocketConnected) {
                        this.cancel(2);
                        return;
                    }
                    byte[] serverSessionToken = ServerSession.getToken(fetchManagerSession, this.identity);
                    if (serverSessionToken == null) {
                        this.cancel(3);
                        return;
                    }
                    WebsocketCoordinator.this.ownedIdentityServerSessionTokens.put(this.identity, serverSessionToken);
                    HashMap<String, Object> messageMap = new HashMap<String, Object>();
                    messageMap.put("action", "register");
                    messageMap.put("identity", Base64.encodeBytes((byte[])this.identity.getBytes()));
                    messageMap.put("deviceUid", Base64.encodeBytes((byte[])this.deviceUid.getBytes()));
                    messageMap.put("token", Base64.encodeBytes((byte[])serverSessionToken));
                    if (WebsocketCoordinator.this.os != null && WebsocketCoordinator.this.osVersion != null && WebsocketCoordinator.this.appBuild != 0 && WebsocketCoordinator.this.appVersion != null) {
                        messageMap.put("os", WebsocketCoordinator.this.os);
                        messageMap.put("osVersion", WebsocketCoordinator.this.osVersion);
                        messageMap.put("appBuild", WebsocketCoordinator.this.appBuild);
                        messageMap.put("appVersion", WebsocketCoordinator.this.appVersion);
                    }
                    webSocketClient.send(WebsocketCoordinator.this.jsonObjectMapper.writeValueAsString(messageMap));
                    finished = true;
                    return;
                }
                catch (Exception e) {
                    Logger.x(e);
                    return;
                }
                finally {
                    if (finished) {
                        this.setFinished();
                    } else {
                        if (this.hasNoReasonForCancel()) {
                            this.cancel(null);
                        }
                        this.processCancel();
                    }
                }
            }
            catch (SQLException e) {
                Logger.x(e);
                this.cancel(null);
                this.processCancel();
            }
        }
    }

    class ReconnectTask
    implements Runnable {
        private final WeakReference<WebSocketClient> webSocketClientWeakReference;
        private final String server;

        ReconnectTask(WeakReference<WebSocketClient> webSocketClientWeakReference, String server) {
            this.webSocketClientWeakReference = webSocketClientWeakReference;
            this.server = server;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            WebSocketClient webSocketClient = (WebSocketClient)((Object)this.webSocketClientWeakReference.get());
            if (webSocketClient != null) {
                boolean doReconnect = false;
                Map<String, WebSocketClient> map = WebsocketCoordinator.this.existingWebsockets;
                synchronized (map) {
                    if (WebsocketCoordinator.this.existingWebsockets.get(this.server) == webSocketClient) {
                        doReconnect = WebsocketCoordinator.this.doConnect;
                    }
                }
                if (doReconnect) {
                    webSocketClient.close(true);
                    WebsocketCoordinator.this.queueWebsocketCreationOperation(this.server);
                }
            }
        }
    }
}

