/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.coordinators;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.NoExceptionSingleThreadExecutor;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelServerResponseMessageToSend;
import io.olvid.engine.datatypes.containers.ServerQuery;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.metamanager.ChannelDelegate;
import io.olvid.engine.networkfetch.coordinators.WebsocketCoordinator;
import io.olvid.engine.networkfetch.databases.PendingServerQuery;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSessionFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerQueryCoordinatorWebSocketModule {
    private static final int ERROR_CODE_GENERAL_ERROR = -1;
    private static final int ERROR_CODE_UNKNOWN_SESSION_NUMBER = 1;
    private static final int ERROR_CODE_OTHER_DISCONNECTED = 2;
    private static final int ERROR_CODE_PAYLOAD_TOO_LARGE = 3;
    private final FetchManagerSessionFactory fetchManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final String userAgentOverride;
    private final ObjectMapper jsonObjectMapper;
    private final PRNGService prng;
    private final HashMap<UID, WebSocketClientAndServerQuery> webSocketsMap;
    private final NoExceptionSingleThreadExecutor executor;
    private ChannelDelegate channelDelegate;

    public ServerQueryCoordinatorWebSocketModule(FetchManagerSessionFactory fetchManagerSessionFactory, SSLSocketFactory sslSocketFactory, String userAgentOverride, ObjectMapper jsonObjectMapper, PRNGService prng) {
        this.fetchManagerSessionFactory = fetchManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.userAgentOverride = userAgentOverride;
        this.jsonObjectMapper = jsonObjectMapper;
        this.prng = prng;
        this.webSocketsMap = new HashMap();
        this.executor = new NoExceptionSingleThreadExecutor("ServerQueryCoordinatorWebSocketModule executor");
    }

    public void setChannelDelegate(ChannelDelegate channelDelegate) {
        this.channelDelegate = channelDelegate;
    }

    public void handleServerQuery(PendingServerQuery pendingServerQuery, boolean calledFromOnOpen) {
        this.executor.execute(() -> {
            UID protocolInstanceUid;
            ServerQuery serverQuery;
            try {
                serverQuery = ServerQuery.of(pendingServerQuery.getEncodedQuery());
            }
            catch (DecodingException e) {
                Logger.x(e);
                return;
            }
            try {
                Encoded[] listOfEncoded = serverQuery.getEncodedElements().decodeList();
                protocolInstanceUid = listOfEncoded[1].decodeUid();
            }
            catch (DecodingException | ArrayIndexOutOfBoundsException e) {
                Logger.e("ServerQueryCoordinatorWebSocketModule.handlePendingServerQuery() failed to decode received serverQuery");
                return;
            }
            try {
                WebSocketClientAndServerQuery webSocketClientAndQuery = this.webSocketsMap.get(protocolInstanceUid);
                if (webSocketClientAndQuery == null) {
                    if (serverQuery.getType().getId() != ServerQuery.TypeId.TRANSFER_SOURCE_QUERY_ID && serverQuery.getType().getId() != ServerQuery.TypeId.TRANSFER_TARGET_QUERY_ID) {
                        this.sendFailedServerQueryResponse(pendingServerQuery);
                        return;
                    }
                    WebSocketClient webSocketClient = new WebSocketClient(protocolInstanceUid);
                    webSocketClientAndQuery = new WebSocketClientAndServerQuery(webSocketClient, pendingServerQuery);
                    this.webSocketsMap.put(protocolInstanceUid, webSocketClientAndQuery);
                    webSocketClientAndQuery.webSocketClient.connect();
                    return;
                }
                if (!calledFromOnOpen) {
                    block33: {
                        if (webSocketClientAndQuery.pendingServerQuery != null) {
                            try {
                                ServerQuery previousServerQuery = ServerQuery.of(webSocketClientAndQuery.pendingServerQuery.getEncodedQuery());
                                if (previousServerQuery.getType().getId() == ServerQuery.TypeId.TRANSFER_RELAY_QUERY_ID && ((ServerQuery.TransferRelayQuery)previousServerQuery.getType()).noResponseExpected) {
                                    try (FetchManagerSession fetchManagerSession = this.fetchManagerSessionFactory.getSession();){
                                        PendingServerQuery rePendingServerQuery = PendingServerQuery.get(fetchManagerSession, webSocketClientAndQuery.pendingServerQuery.getUid());
                                        if (rePendingServerQuery != null) {
                                            rePendingServerQuery.delete();
                                            fetchManagerSession.session.commit();
                                        }
                                        break block33;
                                    }
                                }
                                this.failProtocol(protocolInstanceUid);
                                return;
                            }
                            catch (Exception previousServerQuery) {
                                // empty catch block
                            }
                        }
                    }
                    webSocketClientAndQuery.pendingServerQuery = pendingServerQuery;
                }
                if (webSocketClientAndQuery.webSocketClient.connectionStatus != WebSocketClient.ConnectionStatus.CONNECTED) {
                    this.failProtocol(protocolInstanceUid);
                    return;
                }
                switch (serverQuery.getType().getId()) {
                    case TRANSFER_SOURCE_QUERY_ID: {
                        JsonRequestSource request = new JsonRequestSource();
                        request.action = "source";
                        webSocketClientAndQuery.webSocketClient.send(this.jsonObjectMapper.writeValueAsString((Object)request));
                        break;
                    }
                    case TRANSFER_TARGET_QUERY_ID: {
                        ServerQuery.TransferTargetQuery transferTargetQuery = (ServerQuery.TransferTargetQuery)serverQuery.getType();
                        Object request = new JsonRequestTarget();
                        ((JsonRequestTarget)request).action = "target";
                        ((JsonRequestTarget)request).sessionNumber = transferTargetQuery.sessionNumber;
                        ((JsonRequestTarget)request).payload = transferTargetQuery.payload;
                        webSocketClientAndQuery.webSocketClient.send(this.jsonObjectMapper.writeValueAsString(request));
                        break;
                    }
                    case TRANSFER_RELAY_QUERY_ID: {
                        ServerQuery.TransferRelayQuery transferRelayQuery = (ServerQuery.TransferRelayQuery)serverQuery.getType();
                        Object request = new JsonRequestRelay();
                        ((JsonRequestRelay)request).action = "relay";
                        ((JsonRequestRelay)request).relayConnectionId = transferRelayQuery.connectionIdentifier;
                        ((JsonRequestRelay)request).payload = transferRelayQuery.payload;
                        if (((JsonRequestRelay)request).payload.length > 10000) {
                            int totalFragments = (transferRelayQuery.payload.length - 1) / 10000 + 1;
                            ((JsonRequestRelay)request).totalFragments = totalFragments;
                            for (int i = 0; i < totalFragments; ++i) {
                                ((JsonRequestRelay)request).fragmentNumber = i;
                                ((JsonRequestRelay)request).payload = Arrays.copyOfRange(transferRelayQuery.payload, i * 10000, Math.min((i + 1) * 10000, transferRelayQuery.payload.length));
                                webSocketClientAndQuery.webSocketClient.send(this.jsonObjectMapper.writeValueAsString(request));
                            }
                            break;
                        }
                        webSocketClientAndQuery.webSocketClient.send(this.jsonObjectMapper.writeValueAsString(request));
                        break;
                    }
                    case TRANSFER_WAIT_QUERY_ID: {
                        String pendingMessage = webSocketClientAndQuery.webSocketClient.messageWaitingForWait;
                        if (pendingMessage != null) {
                            webSocketClientAndQuery.webSocketClient.messageWaitingForWait = null;
                            webSocketClientAndQuery.webSocketClient.onMessage(pendingMessage);
                        }
                        break;
                    }
                    case TRANSFER_CLOSE_QUERY_ID: {
                        ServerQuery.TransferCloseQuery transferCloseQuery = (ServerQuery.TransferCloseQuery)serverQuery.getType();
                        if (transferCloseQuery.abort) {
                            webSocketClientAndQuery.webSocketClient.webSocket.cancel();
                        } else {
                            webSocketClientAndQuery.webSocketClient.webSocket.close(1000, "");
                        }
                        this.webSocketsMap.remove(protocolInstanceUid);
                        break;
                    }
                    default: {
                        Logger.e("ServerQueryCoordinatorWebSocketModule.handlePendingServerQuery() received serverQuery with type " + String.valueOf((Object)serverQuery.getType().getId()));
                        this.failProtocol(protocolInstanceUid);
                    }
                }
            }
            catch (Exception e) {
                Logger.x(e);
                this.failProtocol(protocolInstanceUid);
            }
        });
    }

    private void failProtocol(UID protocolInstanceUid) {
        Logger.i("ServerQueryCoordinatorWebSocketModule.failProtocol called");
        WebSocketClientAndServerQuery clientAndQuery = this.webSocketsMap.get(protocolInstanceUid);
        if (clientAndQuery != null) {
            this.webSocketsMap.remove(protocolInstanceUid);
            if (clientAndQuery.webSocketClient.connectionStatus != WebSocketClient.ConnectionStatus.DISCONNECTED && clientAndQuery.webSocketClient.webSocket != null) {
                clientAndQuery.webSocketClient.webSocket.cancel();
            }
            if (clientAndQuery.pendingServerQuery != null) {
                this.sendFailedServerQueryResponse(clientAndQuery.pendingServerQuery);
            }
        }
    }

    private void sendFailedServerQueryResponse(PendingServerQuery pendingServerQuery) {
        this.sendServerQueryResponse(pendingServerQuery, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendServerQueryResponse(PendingServerQuery pendingServerQuery, String response) {
        try (FetchManagerSession fetchManagerSession = this.fetchManagerSessionFactory.getSession();){
            boolean success = false;
            try {
                PendingServerQuery rePendingServerQuery;
                ServerQuery serverQuery = ServerQuery.of(pendingServerQuery.getEncodedQuery());
                fetchManagerSession.session.startTransaction();
                if (serverQuery.getType().getId() != ServerQuery.TypeId.TRANSFER_CLOSE_QUERY_ID) {
                    ChannelServerResponseMessageToSend channelServerResponseMessageToSend = new ChannelServerResponseMessageToSend(serverQuery.getOwnedIdentity(), response == null ? null : Encoded.of(response), serverQuery.getEncodedElements());
                    this.channelDelegate.post(fetchManagerSession.session, channelServerResponseMessageToSend, this.prng);
                }
                if ((rePendingServerQuery = PendingServerQuery.get(fetchManagerSession, pendingServerQuery.getUid())) != null) {
                    rePendingServerQuery.delete();
                }
                success = true;
            }
            catch (Exception e) {
                Logger.x(e);
            }
            finally {
                if (success) {
                    fetchManagerSession.session.commit();
                } else {
                    fetchManagerSession.session.rollback();
                }
            }
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    public static final class WebSocketClientAndServerQuery {
        public final WebSocketClient webSocketClient;
        public PendingServerQuery pendingServerQuery;
        public HashMap<Integer, JsonResponse> fragmentedResponse;

        public WebSocketClientAndServerQuery(WebSocketClient webSocketClient, PendingServerQuery pendingServerQuery) {
            this.webSocketClient = webSocketClient;
            this.pendingServerQuery = pendingServerQuery;
            this.fragmentedResponse = null;
        }
    }

    public class WebSocketClient
    extends WebSocketListener {
        OkHttpClient okHttpClient;
        private WebSocket webSocket;
        private ConnectionStatus connectionStatus;
        private final UID protocolInstanceUid;
        private String messageWaitingForWait;

        WebSocketClient(UID protocolInstanceUid) {
            this.okHttpClient = WebsocketCoordinator.initializeOkHttpClientForWebSocket(ServerQueryCoordinatorWebSocketModule.this.sslSocketFactory, ServerQueryCoordinatorWebSocketModule.this.userAgentOverride);
            this.protocolInstanceUid = protocolInstanceUid;
            this.connectionStatus = ConnectionStatus.INITIALIZING;
            this.webSocket = null;
        }

        public void connect() {
            this.webSocket = this.okHttpClient.newWebSocket(new Request.Builder().url("wss://transfer.olvid.io").build(), (WebSocketListener)this);
        }

        public void send(String message) {
            this.webSocket.send(message);
        }

        public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
            ServerQueryCoordinatorWebSocketModule.this.executor.execute(() -> {
                this.connectionStatus = ConnectionStatus.CONNECTED;
                WebSocketClientAndServerQuery clientAndQuery = ServerQueryCoordinatorWebSocketModule.this.webSocketsMap.get(this.protocolInstanceUid);
                if (clientAndQuery != null && clientAndQuery.pendingServerQuery != null) {
                    try {
                        ServerQueryCoordinatorWebSocketModule.this.handleServerQuery(clientAndQuery.pendingServerQuery, true);
                    }
                    catch (Exception e) {
                        Logger.x(e);
                    }
                }
            });
        }

        public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
            if (code != 1000) {
                ServerQueryCoordinatorWebSocketModule.this.executor.execute(this::closeAndAbort);
            }
        }

        public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
            Logger.x(t);
            ServerQueryCoordinatorWebSocketModule.this.executor.execute(this::closeAndAbort);
        }

        public void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
            this.onMessage(text);
        }

        private void onMessage(String text) {
            if (text == null || text.trim().isEmpty()) {
                return;
            }
            ServerQueryCoordinatorWebSocketModule.this.executor.execute(() -> {
                try {
                    JsonResponseFail fail = (JsonResponseFail)ServerQueryCoordinatorWebSocketModule.this.jsonObjectMapper.readValue(text, JsonResponseFail.class);
                    switch (fail.errorCode) {
                        case -1: 
                        case 1: 
                        case 2: 
                        case 3: {
                            ServerQueryCoordinatorWebSocketModule.this.failProtocol(this.protocolInstanceUid);
                            return;
                        }
                    }
                }
                catch (Exception fail) {
                    // empty catch block
                }
                WebSocketClientAndServerQuery clientAndQuery = ServerQueryCoordinatorWebSocketModule.this.webSocketsMap.get(this.protocolInstanceUid);
                if (clientAndQuery == null) {
                    return;
                }
                PendingServerQuery pendingServerQuery = clientAndQuery.pendingServerQuery;
                if (pendingServerQuery == null) {
                    this.messageWaitingForWait = text;
                    return;
                }
                try {
                    JsonResponse fragmentedResponse = (JsonResponse)ServerQueryCoordinatorWebSocketModule.this.jsonObjectMapper.readValue(text, JsonResponse.class);
                    if (fragmentedResponse.totalFragments != null && fragmentedResponse.fragmentNumber != null && fragmentedResponse.fragmentNumber >= 0 && fragmentedResponse.fragmentNumber < fragmentedResponse.totalFragments) {
                        if (clientAndQuery.fragmentedResponse == null) {
                            clientAndQuery.fragmentedResponse = new HashMap();
                        }
                        clientAndQuery.fragmentedResponse.put(fragmentedResponse.fragmentNumber, fragmentedResponse);
                        if (clientAndQuery.fragmentedResponse.size() == fragmentedResponse.totalFragments.intValue()) {
                            JsonResponse reconstructedResponse = new JsonResponse();
                            int payloadSize = 0;
                            for (int i = 0; i < fragmentedResponse.totalFragments; ++i) {
                                payloadSize += clientAndQuery.fragmentedResponse.get((Object)Integer.valueOf((int)i)).payload.length;
                            }
                            reconstructedResponse.otherConnectionId = clientAndQuery.fragmentedResponse.get((Object)Integer.valueOf((int)0)).otherConnectionId;
                            reconstructedResponse.payload = new byte[payloadSize];
                            int offset = 0;
                            for (int i = 0; i < fragmentedResponse.totalFragments; ++i) {
                                JsonResponse fragment = clientAndQuery.fragmentedResponse.get(i);
                                if (!Objects.equals(reconstructedResponse.otherConnectionId, fragment.otherConnectionId)) {
                                    throw new Exception("otherConnectionId mismatch");
                                }
                                System.arraycopy(fragment.payload, 0, reconstructedResponse.payload, offset, fragment.payload.length);
                                offset += fragment.payload.length;
                            }
                            clientAndQuery.fragmentedResponse = null;
                            clientAndQuery.pendingServerQuery = null;
                            ServerQueryCoordinatorWebSocketModule.this.sendServerQueryResponse(pendingServerQuery, ServerQueryCoordinatorWebSocketModule.this.jsonObjectMapper.writeValueAsString((Object)reconstructedResponse));
                        }
                        return;
                    }
                }
                catch (Exception e) {
                    Logger.x(e);
                }
                clientAndQuery.pendingServerQuery = null;
                ServerQueryCoordinatorWebSocketModule.this.sendServerQueryResponse(pendingServerQuery, text);
            });
        }

        private void closeAndAbort() {
            this.connectionStatus = ConnectionStatus.DISCONNECTED;
            ServerQueryCoordinatorWebSocketModule.this.failProtocol(this.protocolInstanceUid);
        }

        public static enum ConnectionStatus {
            INITIALIZING,
            CONNECTED,
            DISCONNECTED;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JsonRequestSource {
        public String action;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JsonRequestTarget {
        public String action;
        public long sessionNumber;
        public byte[] payload;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JsonRequestRelay {
        public String action;
        public String relayConnectionId;
        public byte[] payload;
        public Integer fragmentNumber;
        public Integer totalFragments;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JsonResponse {
        public String otherConnectionId;
        public byte[] payload;
        public Integer fragmentNumber;
        public Integer totalFragments;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JsonResponseFail {
        public int errorCode;
    }
}

