/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.coordinators;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.ExponentialBackoffRepeatingScheduler;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoDuplicateOperationQueue;
import io.olvid.engine.datatypes.NotificationListener;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.PushNotificationTypeAndParameters;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.IdentityAndUid;
import io.olvid.engine.datatypes.containers.OwnedIdentitySynchronizationStatus;
import io.olvid.engine.metamanager.NotificationListeningDelegate;
import io.olvid.engine.metamanager.NotificationPostingDelegate;
import io.olvid.engine.networkfetch.databases.PushNotificationConfiguration;
import io.olvid.engine.networkfetch.datatypes.CreateServerSessionDelegate;
import io.olvid.engine.networkfetch.datatypes.DownloadMessagesAndListAttachmentsDelegate;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSessionFactory;
import io.olvid.engine.networkfetch.datatypes.RegisterServerPushNotificationDelegate;
import io.olvid.engine.networkfetch.operations.RegisterPushNotificationOperation;
import io.olvid.engine.protocol.datatypes.ProtocolStarterDelegate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;

public class RegisterServerPushNotificationsCoordinator
implements RegisterServerPushNotificationDelegate,
PushNotificationConfiguration.NewPushNotificationConfigurationListener,
Operation.OnCancelCallback,
Operation.OnFinishCallback {
    private final FetchManagerSessionFactory fetchManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final String userAgentOverride;
    private final CreateServerSessionDelegate createServerSessionDelegate;
    private final DownloadMessagesAndListAttachmentsDelegate downloadMessagesAndListAttachmentsDelegate;
    private final ExponentialBackoffRepeatingScheduler<Identity> scheduler;
    private final NoDuplicateOperationQueue registerPushNotificationOperationQueue;
    private final ServerSessionCreatedNotificationListener serverSessionCreatedNotificationListener;
    private final HashMap<UID, IdentityAndUid> androidIdentityMaskingUids;
    private final HashSet<Identity> ownedIdentitiesThatNeedAnOwnedDeviceDiscovery;
    private NotificationListeningDelegate notificationListeningDelegate;
    private NotificationPostingDelegate notificationPostingDelegate;
    private ProtocolStarterDelegate protocolStarterDelegate;

    public RegisterServerPushNotificationsCoordinator(FetchManagerSessionFactory fetchManagerSessionFactory, SSLSocketFactory sslSocketFactory, String userAgentOverride, CreateServerSessionDelegate createServerSessionDelegate, DownloadMessagesAndListAttachmentsDelegate downloadMessagesAndListAttachmentsDelegate) {
        this.fetchManagerSessionFactory = fetchManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.userAgentOverride = userAgentOverride;
        this.createServerSessionDelegate = createServerSessionDelegate;
        this.downloadMessagesAndListAttachmentsDelegate = downloadMessagesAndListAttachmentsDelegate;
        this.registerPushNotificationOperationQueue = new NoDuplicateOperationQueue();
        this.scheduler = new ExponentialBackoffRepeatingScheduler();
        this.androidIdentityMaskingUids = new HashMap();
        this.ownedIdentitiesThatNeedAnOwnedDeviceDiscovery = new HashSet();
        this.serverSessionCreatedNotificationListener = new ServerSessionCreatedNotificationListener();
    }

    public void startProcessing() {
        this.registerPushNotificationOperationQueue.execute(1, "Engine-RegisterServerPushNotificationsCoordinator");
    }

    public void setNotificationListeningDelegate(NotificationListeningDelegate notificationListeningDelegate) {
        this.notificationListeningDelegate = notificationListeningDelegate;
        this.notificationListeningDelegate.addListener("network_fetch_notification_server_session_created", this.serverSessionCreatedNotificationListener);
    }

    public void setNotificationPostingDelegate(NotificationPostingDelegate notificationPostingDelegate) {
        this.notificationPostingDelegate = notificationPostingDelegate;
    }

    public void setProtocolStarterDelegate(ProtocolStarterDelegate protocolStarterDelegate) {
        this.protocolStarterDelegate = protocolStarterDelegate;
    }

    public void initialQueueing() {
        try (FetchManagerSession fetchManagerSession = this.fetchManagerSessionFactory.getSession();){
            PushNotificationConfiguration[] pushNotificationConfigurations;
            block11: for (PushNotificationConfiguration pushNotificationConfiguration : pushNotificationConfigurations = PushNotificationConfiguration.getAll(fetchManagerSession)) {
                if (!fetchManagerSession.identityDelegate.isOwnedIdentity(fetchManagerSession.session, pushNotificationConfiguration.getOwnedIdentity())) {
                    PushNotificationConfiguration.deleteForOwnedIdentity(fetchManagerSession, pushNotificationConfiguration.getOwnedIdentity());
                    fetchManagerSession.session.commit();
                    continue;
                }
                switch (pushNotificationConfiguration.getPushNotificationType()) {
                    case 1: {
                        this.storeAndroidIdentityMaskingUid(pushNotificationConfiguration.getOwnedIdentity(), pushNotificationConfiguration.getDeviceUid(), pushNotificationConfiguration.getIdentityMaskingUid());
                        this.registerServerPushNotification(pushNotificationConfiguration.getOwnedIdentity(), false);
                        continue block11;
                    }
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: {
                        this.registerServerPushNotification(pushNotificationConfiguration.getOwnedIdentity(), false);
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    private void queueNewRegisterPushNotificationOperation(Identity ownedIdentity) {
        RegisterPushNotificationOperation op = new RegisterPushNotificationOperation(this.fetchManagerSessionFactory, this.sslSocketFactory, this.userAgentOverride, ownedIdentity, this, this);
        this.registerPushNotificationOperationQueue.queue(op);
    }

    private void scheduleNewRegisterPushNotificationOperationQueueing(Identity identity) {
        this.scheduler.schedule(identity, () -> this.queueNewRegisterPushNotificationOperation(identity), "RegisterPushNotificationOperation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFinishCallback(Operation operation) {
        Identity ownedIdentity = ((RegisterPushNotificationOperation)operation).getOwnedIdentity();
        UID deviceUid = ((RegisterPushNotificationOperation)operation).getDeviceUid();
        this.scheduler.clearFailedCount(ownedIdentity);
        if (this.notificationPostingDelegate != null) {
            HashMap<String, Object> userInfo = new HashMap<String, Object>();
            userInfo.put("owned_identity", ownedIdentity);
            this.notificationPostingDelegate.postNotification("network_fetch_notification_push_notification_registered", userInfo);
        } else {
            Logger.e("NotificationPostingDelegate not set in RegisterServerPushNotificationsCoordinator");
        }
        HashSet<Identity> hashSet = this.ownedIdentitiesThatNeedAnOwnedDeviceDiscovery;
        synchronized (hashSet) {
            if (this.protocolStarterDelegate != null && this.ownedIdentitiesThatNeedAnOwnedDeviceDiscovery.remove(ownedIdentity)) {
                try {
                    this.protocolStarterDelegate.startOwnedDeviceDiscoveryProtocol(ownedIdentity);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void onCancelCallback(Operation operation) {
        Identity ownedIdentity = ((RegisterPushNotificationOperation)operation).getOwnedIdentity();
        Integer rfc = operation.getReasonForCancel();
        Logger.i("RegisterPushNotificationOperation cancelled for reason " + rfc);
        if (rfc == null) {
            rfc = -1;
        }
        switch (rfc) {
            case 2: {
                this.createServerSessionDelegate.createServerSession(ownedIdentity);
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                HashMap<String, Object> userInfo = new HashMap<String, Object>();
                userInfo.put("owned_identity", ownedIdentity);
                this.notificationPostingDelegate.postNotification("network_fetch_notification_push_register_failed_bad_device_uid_to_replace", userInfo);
                break;
            }
            default: {
                this.scheduleNewRegisterPushNotificationOperationQueueing(ownedIdentity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerServerPushNotification(Identity identity, boolean triggerAnOwnedDeviceDiscoveryWhenFinished) {
        if (triggerAnOwnedDeviceDiscoveryWhenFinished) {
            HashSet<Identity> hashSet = this.ownedIdentitiesThatNeedAnOwnedDeviceDiscovery;
            synchronized (hashSet) {
                this.ownedIdentitiesThatNeedAnOwnedDeviceDiscovery.add(identity);
            }
        }
        this.queueNewRegisterPushNotificationOperation(identity);
    }

    @Override
    public void newPushNotificationConfiguration(Identity identity, UID deviceUid, PushNotificationTypeAndParameters pushNotificationTypeAndParameters) {
        switch (pushNotificationTypeAndParameters.pushNotificationType) {
            case 1: {
                this.storeAndroidIdentityMaskingUid(identity, deviceUid, pushNotificationTypeAndParameters.identityMaskingUid);
                this.registerServerPushNotification(identity, false);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                this.registerServerPushNotification(identity, false);
            }
        }
    }

    public void processAndroidPushNotification(String androidMaskingUidString) {
        if (androidMaskingUidString == null) {
            return;
        }
        try {
            UID androidIdentityMaskingUid = new UID(androidMaskingUidString);
            IdentityAndUid identityAndUid = this.androidIdentityMaskingUids.get(androidIdentityMaskingUid);
            if (identityAndUid != null) {
                this.fetchManagerSessionFactory.markOwnedIdentityAsNotUpToDate(identityAndUid.identity, OwnedIdentitySynchronizationStatus.OTHER_SYNC_IN_PROGRESS);
                this.downloadMessagesAndListAttachmentsDelegate.downloadMessagesAndListAttachments(identityAndUid.identity, identityAndUid.uid);
            }
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    public Identity getOwnedIdentityFromMaskingUid(String androidMaskingUidString) {
        if (androidMaskingUidString != null) {
            try {
                UID androidIdentityMaskingUid = new UID(androidMaskingUidString);
                IdentityAndUid identityAndUid = this.androidIdentityMaskingUids.get(androidIdentityMaskingUid);
                if (identityAndUid != null) {
                    return identityAndUid.identity;
                }
            }
            catch (Exception e) {
                Logger.x(e);
            }
        }
        return null;
    }

    private void storeAndroidIdentityMaskingUid(Identity identity, UID deviceUid, UID identityMaskingUid) {
        this.androidIdentityMaskingUids.put(identityMaskingUid, new IdentityAndUid(identity, deviceUid));
    }

    public void retryScheduledNetworkTasks() {
        this.scheduler.retryScheduledRunnables();
    }

    class ServerSessionCreatedNotificationListener
    implements NotificationListener {
        ServerSessionCreatedNotificationListener() {
        }

        @Override
        public void callback(String notificationName, Map<String, Object> userInfo) {
            if (!notificationName.equals("network_fetch_notification_server_session_created")) {
                return;
            }
            Object identityObject = userInfo.get("identity");
            if (!(identityObject instanceof Identity)) {
                return;
            }
            RegisterServerPushNotificationsCoordinator.this.queueNewRegisterPushNotificationOperation((Identity)identityObject);
        }
    }
}

