/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.coordinators;

import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.OperationQueue;
import io.olvid.engine.datatypes.notifications.DownloadNotifications;
import io.olvid.engine.metamanager.NotificationPostingDelegate;
import io.olvid.engine.networkfetch.datatypes.CreateServerSessionDelegate;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSessionFactory;
import io.olvid.engine.networkfetch.datatypes.WellKnownCacheDelegate;
import io.olvid.engine.networkfetch.operations.GetTurnCredentialsOperation;
import java.util.HashMap;
import java.util.UUID;
import javax.net.ssl.SSLSocketFactory;

public class GetTurnCredentialsCoordinator
implements Operation.OnFinishCallback,
Operation.OnCancelCallback {
    private final FetchManagerSessionFactory fetchManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final String userAgentOverride;
    private final WellKnownCacheDelegate wellKnownCacheDelegate;
    private final CreateServerSessionDelegate createServerSessionDelegate;
    private final OperationQueue getTurnCredentialsOperationQueue;
    private NotificationPostingDelegate notificationPostingDelegate;

    public GetTurnCredentialsCoordinator(FetchManagerSessionFactory fetchManagerSessionFactory, SSLSocketFactory sslSocketFactory, String userAgentOverride, CreateServerSessionDelegate createServerSessionDelegate, WellKnownCacheDelegate wellKnownCacheDelegate) {
        this.fetchManagerSessionFactory = fetchManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.userAgentOverride = userAgentOverride;
        this.createServerSessionDelegate = createServerSessionDelegate;
        this.wellKnownCacheDelegate = wellKnownCacheDelegate;
        this.getTurnCredentialsOperationQueue = new OperationQueue(true);
    }

    public void startProcessing() {
        this.getTurnCredentialsOperationQueue.execute(1, "Engine-GetTurnCredentialsCoordinator");
    }

    public void setNotificationPostingDelegate(NotificationPostingDelegate notificationPostingDelegate) {
        this.notificationPostingDelegate = notificationPostingDelegate;
    }

    private void queueNewGetTurnCredentialsOperation(Identity ownedIdentity, UUID callUuid, String username1, String username2) {
        GetTurnCredentialsOperation op = new GetTurnCredentialsOperation(this.fetchManagerSessionFactory, this.sslSocketFactory, this.userAgentOverride, this.wellKnownCacheDelegate, ownedIdentity, callUuid, username1, username2, this, this);
        this.getTurnCredentialsOperationQueue.queue(op);
    }

    public void getTurnCredentials(Identity ownedIdentity, UUID callUuid, String username1, String username2) {
        this.queueNewGetTurnCredentialsOperation(ownedIdentity, callUuid, username1, username2);
    }

    @Override
    public void onFinishCallback(Operation operation) {
        if (!(operation instanceof GetTurnCredentialsOperation)) {
            return;
        }
        GetTurnCredentialsOperation getTurnCredentialsOperation = (GetTurnCredentialsOperation)operation;
        HashMap<String, Object> userInfo = new HashMap<String, Object>();
        userInfo.put("owned_identity", getTurnCredentialsOperation.getOwnedIdentity());
        userInfo.put("call_uuid", getTurnCredentialsOperation.getCallUuid());
        userInfo.put("username1", getTurnCredentialsOperation.getExpiringUsername1());
        userInfo.put("username2", getTurnCredentialsOperation.getPassword1());
        userInfo.put("password1", getTurnCredentialsOperation.getExpiringUsername2());
        userInfo.put("password2", getTurnCredentialsOperation.getPassword2());
        userInfo.put("servers", getTurnCredentialsOperation.getTurnServers());
        if (this.notificationPostingDelegate != null) {
            this.notificationPostingDelegate.postNotification("network_fetch_notification_turn_credentials_recieved", userInfo);
        }
    }

    @Override
    public void onCancelCallback(Operation operation) {
        if (!(operation instanceof GetTurnCredentialsOperation)) {
            return;
        }
        GetTurnCredentialsOperation getTurnCredentialsOperation = (GetTurnCredentialsOperation)operation;
        Integer rfc = getTurnCredentialsOperation.getReasonForCancel();
        if (rfc == null) {
            rfc = -1;
        }
        DownloadNotifications.TurnCredentialsFailedReason failedReason = switch (rfc) {
            case 1 -> {
                this.createServerSessionDelegate.createServerSession(getTurnCredentialsOperation.getOwnedIdentity());
                yield DownloadNotifications.TurnCredentialsFailedReason.BAD_SERVER_SESSION;
            }
            case 3 -> DownloadNotifications.TurnCredentialsFailedReason.PERMISSION_DENIED;
            case 4 -> DownloadNotifications.TurnCredentialsFailedReason.CALLS_NOT_SUPPORTED_ON_SERVER;
            default -> DownloadNotifications.TurnCredentialsFailedReason.UNABLE_TO_CONTACT_SERVER;
        };
        HashMap<String, Object> userInfo = new HashMap<String, Object>();
        userInfo.put("owned_identity", getTurnCredentialsOperation.getOwnedIdentity());
        userInfo.put("call_uuid", getTurnCredentialsOperation.getCallUuid());
        userInfo.put("reason", (Object)failedReason);
        this.notificationPostingDelegate.postNotification("network_fetch_notification_turn_credentials_failed", userInfo);
    }
}

