/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.coordinators;

import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.OperationQueue;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSessionFactory;
import io.olvid.engine.networkfetch.operations.FreeTrialOperation;
import javax.net.ssl.SSLSocketFactory;

public class FreeTrialCoordinator {
    private final FetchManagerSessionFactory fetchManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final String userAgentOverride;
    private final OperationQueue freeTrialOperationQueue;

    public FreeTrialCoordinator(FetchManagerSessionFactory fetchManagerSessionFactory, SSLSocketFactory sslSocketFactory, String userAgentOverride) {
        this.fetchManagerSessionFactory = fetchManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.userAgentOverride = userAgentOverride;
        this.freeTrialOperationQueue = new OperationQueue(true);
    }

    public void startProcessing() {
        this.freeTrialOperationQueue.execute(1, "Engine-FreeTrialCoordinator");
    }

    private void queueNewFreeTrialOperation(Identity ownedIdentity, boolean retrieveApiKey) {
        FreeTrialOperation op = new FreeTrialOperation(this.fetchManagerSessionFactory, this.sslSocketFactory, this.userAgentOverride, ownedIdentity, retrieveApiKey);
        this.freeTrialOperationQueue.queue(op);
    }

    public void queryFreeTrial(Identity ownedIdentity) {
        this.queueNewFreeTrialOperation(ownedIdentity, false);
    }

    public void startFreeTrial(Identity ownedIdentity) {
        this.queueNewFreeTrialOperation(ownedIdentity, true);
    }
}

