/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.coordinators;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.ExponentialBackoffRepeatingScheduler;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoDuplicateOperationQueue;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.OperationQueue;
import io.olvid.engine.metamanager.NotificationPostingDelegate;
import io.olvid.engine.metamanager.SolveChallengeDelegate;
import io.olvid.engine.networkfetch.databases.ServerSession;
import io.olvid.engine.networkfetch.datatypes.CreateServerSessionDelegate;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSessionFactory;
import io.olvid.engine.networkfetch.operations.CreateServerSessionCompositeOperation;
import io.olvid.engine.networkfetch.operations.QueryApiKeyStatusOperation;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.net.ssl.SSLSocketFactory;

public class CreateServerSessionCoordinator
implements Operation.OnFinishCallback,
Operation.OnCancelCallback,
CreateServerSessionDelegate {
    private final ExponentialBackoffRepeatingScheduler<Identity> scheduler;
    private final NoDuplicateOperationQueue createServerSessionOperationQueue;
    private final OperationQueue queryApiKeyStatusOperationQueue;
    private final FetchManagerSessionFactory fetchManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final String userAgentOverride;
    private SolveChallengeDelegate solveChallengeDelegate;
    private NotificationPostingDelegate notificationPostingDelegate;

    public CreateServerSessionCoordinator(FetchManagerSessionFactory fetchManagerSessionFactory, SSLSocketFactory sslSocketFactory, String userAgentOverride) {
        this.fetchManagerSessionFactory = fetchManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.userAgentOverride = userAgentOverride;
        this.solveChallengeDelegate = null;
        this.scheduler = new ExponentialBackoffRepeatingScheduler();
        this.createServerSessionOperationQueue = new NoDuplicateOperationQueue();
        this.queryApiKeyStatusOperationQueue = new OperationQueue(true);
    }

    public void startProcessing() {
        this.createServerSessionOperationQueue.execute(1, "Engine-CreateServerSessionCoordinator");
        this.queryApiKeyStatusOperationQueue.execute(1, "Engine-CreateServerSessionCoordinator-QueryApiKeyStatus");
    }

    public void setNotificationPostingDelegate(NotificationPostingDelegate notificationPostingDelegate) {
        this.notificationPostingDelegate = notificationPostingDelegate;
    }

    public void setSolveChallengeDelegate(SolveChallengeDelegate solveChallengeDelegate) {
        this.solveChallengeDelegate = solveChallengeDelegate;
    }

    public void initialQueueing() {
        try (FetchManagerSession fetchManagerSession = this.fetchManagerSessionFactory.getSession();){
            for (ServerSession serverSession : ServerSession.getAll(fetchManagerSession)) {
                if (!fetchManagerSession.identityDelegate.isOwnedIdentity(fetchManagerSession.session, serverSession.getOwnedIdentity())) {
                    serverSession.delete();
                    continue;
                }
                HashMap<String, Object> userInfo = new HashMap<String, Object>();
                userInfo.put("identity", serverSession.getOwnedIdentity());
                userInfo.put("api_key_status", (Object)serverSession.getApiKeyStatus());
                userInfo.put("permissions", serverSession.getPermissions());
                userInfo.put("api_key_expiration_timestamp", serverSession.getApiKeyExpirationTimestamp());
                this.notificationPostingDelegate.postNotification("network_fetch_notification_server_session_exists", userInfo);
            }
            fetchManagerSession.session.commit();
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    public void queueNewQueryApiKeyStatusOperation(Identity ownedIdentity, UUID apiKey) {
        QueryApiKeyStatusOperation op = new QueryApiKeyStatusOperation(this.sslSocketFactory, this.userAgentOverride, ownedIdentity, apiKey, operation -> {
            if (this.notificationPostingDelegate == null) {
                Logger.e("NotificationPostingDelegate not set onFinishCallback of QueryApiKeyStatusOperation.");
                return;
            }
            ServerSession.ApiKeyStatus apiKeyStatus = ((QueryApiKeyStatusOperation)operation).getApiKeyStatus();
            List<ServerSession.Permission> permissions = ((QueryApiKeyStatusOperation)operation).getPermissions();
            long apiKeyExpirationTimestamp = ((QueryApiKeyStatusOperation)operation).getApiKeyExpirationTimestamp();
            HashMap<String, Object> userInfo = new HashMap<String, Object>();
            userInfo.put("owned_identity", ownedIdentity);
            userInfo.put("api_key", apiKey);
            userInfo.put("api_key_status", (Object)apiKeyStatus);
            userInfo.put("permissions", permissions);
            userInfo.put("api_key_expiration_timestamp", apiKeyExpirationTimestamp);
            this.notificationPostingDelegate.postNotification("network_fetch_notification_api_key_status_query_success", userInfo);
        }, operation -> {
            if (this.notificationPostingDelegate == null) {
                Logger.e("NotificationPostingDelegate not set onCancelCallback of QueryApiKeyStatusOperation.");
                return;
            }
            HashMap<String, Object> userInfo = new HashMap<String, Object>();
            userInfo.put("owned_identity", ownedIdentity);
            userInfo.put("api_key", apiKey);
            this.notificationPostingDelegate.postNotification("network_fetch_notification_api_key_status_query_failed", userInfo);
        });
        this.queryApiKeyStatusOperationQueue.queue(op);
    }

    private void queueNewCreateServerSessionCompositeOperation(Identity ownedIdentity) {
        if (this.solveChallengeDelegate == null) {
            Logger.e("The SolveChallengeDelegate is not set in the CreateServerSessionCoordinator. Unable to queue a new CreateServerSessionCompositeOperation.");
            return;
        }
        CreateServerSessionCompositeOperation op = new CreateServerSessionCompositeOperation(this.fetchManagerSessionFactory, this.sslSocketFactory, this.userAgentOverride, ownedIdentity, this.solveChallengeDelegate, this, this);
        this.createServerSessionOperationQueue.queue(op);
    }

    private void scheduleNewCreateServerSessionCompositeOperationQueueing(Identity ownedIdentity) {
        this.scheduler.schedule(ownedIdentity, () -> this.queueNewCreateServerSessionCompositeOperation(ownedIdentity), "CreateServerSessionCompositeOperation");
    }

    public void retryScheduledNetworkTasks() {
        this.scheduler.retryScheduledRunnables();
    }

    @Override
    public void onFinishCallback(Operation operation) {
        Identity ownedIdentity = ((CreateServerSessionCompositeOperation)operation).getOwnedIdentity();
        ServerSession.ApiKeyStatus apiKeyStatus = ((CreateServerSessionCompositeOperation)operation).getApiKeyStatus();
        List<ServerSession.Permission> permissions = ((CreateServerSessionCompositeOperation)operation).getPermissions();
        long apiKeyExpirationTimestamp = ((CreateServerSessionCompositeOperation)operation).getApiKeyExpirationTimestamp();
        this.scheduler.clearFailedCount(ownedIdentity);
        HashMap<String, Object> userInfo = new HashMap<String, Object>();
        userInfo.put("identity", ownedIdentity);
        userInfo.put("api_key_status", (Object)apiKeyStatus);
        userInfo.put("permissions", permissions);
        userInfo.put("api_key_expiration_timestamp", apiKeyExpirationTimestamp);
        this.notificationPostingDelegate.postNotification("network_fetch_notification_server_session_created", userInfo);
    }

    @Override
    public void onCancelCallback(Operation operation) {
        Identity ownedIdentity = ((CreateServerSessionCompositeOperation)operation).getOwnedIdentity();
        Integer rfc = operation.getReasonForCancel();
        Logger.i("CreateServerSessionCompositeOperation cancelled for reason " + rfc);
        if (rfc == null) {
            rfc = -1;
        }
        switch (rfc) {
            case 2: {
                this.queueNewCreateServerSessionCompositeOperation(ownedIdentity);
                break;
            }
            case 6: {
                break;
            }
            default: {
                this.scheduleNewCreateServerSessionCompositeOperationQueueing(ownedIdentity);
            }
        }
    }

    @Override
    public void createServerSession(Identity ownedIdentity) {
        this.queueNewCreateServerSessionCompositeOperation(ownedIdentity);
    }
}

