/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.PushNotificationTypeAndParameters;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.AttachmentKeyAndMetadata;
import io.olvid.engine.datatypes.containers.DecryptedApplicationMessage;
import io.olvid.engine.datatypes.containers.OwnedIdentitySynchronizationStatus;
import io.olvid.engine.datatypes.containers.ReceivedAttachment;
import io.olvid.engine.datatypes.containers.ServerQuery;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.engine.types.JsonOsmStyle;
import io.olvid.engine.engine.types.ObvMessage;
import io.olvid.engine.metamanager.ChannelDelegate;
import io.olvid.engine.metamanager.CreateSessionDelegate;
import io.olvid.engine.metamanager.IdentityDelegate;
import io.olvid.engine.metamanager.MetaManager;
import io.olvid.engine.metamanager.NetworkFetchDelegate;
import io.olvid.engine.metamanager.NotificationListeningDelegate;
import io.olvid.engine.metamanager.NotificationPostingDelegate;
import io.olvid.engine.metamanager.ObvManager;
import io.olvid.engine.metamanager.ProcessDownloadedMessageDelegate;
import io.olvid.engine.metamanager.PushNotificationDelegate;
import io.olvid.engine.metamanager.SolveChallengeDelegate;
import io.olvid.engine.networkfetch.coordinators.CreateServerSessionCoordinator;
import io.olvid.engine.networkfetch.coordinators.DeleteMessageAndAttachmentsCoordinator;
import io.olvid.engine.networkfetch.coordinators.DownloadAttachmentCoordinator;
import io.olvid.engine.networkfetch.coordinators.DownloadMessageExtendedPayloadCoordinator;
import io.olvid.engine.networkfetch.coordinators.DownloadMessagesAndListAttachmentsCoordinator;
import io.olvid.engine.networkfetch.coordinators.FreeTrialCoordinator;
import io.olvid.engine.networkfetch.coordinators.GetTurnCredentialsCoordinator;
import io.olvid.engine.networkfetch.coordinators.RefreshInboxAttachmentSignedUrlCoordinator;
import io.olvid.engine.networkfetch.coordinators.RegisterServerPushNotificationsCoordinator;
import io.olvid.engine.networkfetch.coordinators.ServerQueryCoordinator;
import io.olvid.engine.networkfetch.coordinators.ServerUserDataCoordinator;
import io.olvid.engine.networkfetch.coordinators.VerifyReceiptCoordinator;
import io.olvid.engine.networkfetch.coordinators.WebsocketCoordinator;
import io.olvid.engine.networkfetch.coordinators.WellKnownCoordinator;
import io.olvid.engine.networkfetch.databases.CachedWellKnown;
import io.olvid.engine.networkfetch.databases.InboxAttachment;
import io.olvid.engine.networkfetch.databases.InboxMessage;
import io.olvid.engine.networkfetch.databases.PendingServerQuery;
import io.olvid.engine.networkfetch.databases.PushNotificationConfiguration;
import io.olvid.engine.networkfetch.databases.ServerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSessionFactory;
import io.olvid.engine.protocol.datatypes.ProtocolStarterDelegate;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class FetchManager
implements FetchManagerSessionFactory,
NetworkFetchDelegate,
PushNotificationDelegate,
ObvManager {
    private final String engineBaseDirectory;
    private final PRNGService prng;
    private final CreateServerSessionCoordinator createServerSessionCoordinator;
    private final RefreshInboxAttachmentSignedUrlCoordinator refreshInboxAttachmentSignedUrlCoordinator;
    private final DownloadAttachmentCoordinator downloadAttachmentCoordinator;
    private final DownloadMessagesAndListAttachmentsCoordinator downloadMessagesAndListAttachmentsCoordinator;
    private final DownloadMessageExtendedPayloadCoordinator downloadMessageExtendedPayloadCoordinator;
    private final DeleteMessageAndAttachmentsCoordinator deleteMessageAndAttachmentsCoordinator;
    private final RegisterServerPushNotificationsCoordinator registerServerPushNotificationsCoordinator;
    private final WebsocketCoordinator websocketCoordinator;
    private final ServerQueryCoordinator serverQueryCoordinator;
    private final ServerUserDataCoordinator serverUserDataCoordinator;
    private final GetTurnCredentialsCoordinator getTurnCredentialsCoordinator;
    private final FreeTrialCoordinator freeTrialCoordinator;
    private final VerifyReceiptCoordinator verifyReceiptCoordinator;
    private final WellKnownCoordinator wellKnownCoordinator;
    private NotificationPostingDelegate notificationPostingDelegate;
    private IdentityDelegate identityDelegate;
    private ProcessDownloadedMessageDelegate processDownloadedMessageDelegate;
    private CreateSessionDelegate createSessionDelegate;
    private final HashSet<Identity> ownedIdentitiesUpToDateRegardingServerListing;

    public FetchManager(MetaManager metaManager, SSLSocketFactory sslSocketFactory, String userAgentOverride, String engineBaseDirectory, PRNGService prng, ObjectMapper jsonObjectMapper) {
        this.engineBaseDirectory = engineBaseDirectory;
        this.prng = prng;
        this.createServerSessionCoordinator = new CreateServerSessionCoordinator(this, sslSocketFactory, userAgentOverride);
        this.refreshInboxAttachmentSignedUrlCoordinator = new RefreshInboxAttachmentSignedUrlCoordinator(this, sslSocketFactory, userAgentOverride);
        this.downloadAttachmentCoordinator = new DownloadAttachmentCoordinator(this, sslSocketFactory, userAgentOverride, this.refreshInboxAttachmentSignedUrlCoordinator);
        this.downloadMessagesAndListAttachmentsCoordinator = new DownloadMessagesAndListAttachmentsCoordinator(this, sslSocketFactory, userAgentOverride, this.createServerSessionCoordinator);
        this.downloadMessageExtendedPayloadCoordinator = new DownloadMessageExtendedPayloadCoordinator(this, sslSocketFactory, userAgentOverride, this.createServerSessionCoordinator);
        this.deleteMessageAndAttachmentsCoordinator = new DeleteMessageAndAttachmentsCoordinator(this, sslSocketFactory, userAgentOverride, this.createServerSessionCoordinator);
        this.registerServerPushNotificationsCoordinator = new RegisterServerPushNotificationsCoordinator(this, sslSocketFactory, userAgentOverride, this.createServerSessionCoordinator, this.downloadMessagesAndListAttachmentsCoordinator);
        this.downloadMessagesAndListAttachmentsCoordinator.setRegisterServerPushNotificationDelegate(this.registerServerPushNotificationsCoordinator);
        this.serverUserDataCoordinator = new ServerUserDataCoordinator(this, sslSocketFactory, userAgentOverride, this.createServerSessionCoordinator, jsonObjectMapper, prng);
        this.serverQueryCoordinator = new ServerQueryCoordinator(this, sslSocketFactory, userAgentOverride, prng, this.createServerSessionCoordinator, this.serverUserDataCoordinator, jsonObjectMapper);
        this.freeTrialCoordinator = new FreeTrialCoordinator(this, sslSocketFactory, userAgentOverride);
        this.verifyReceiptCoordinator = new VerifyReceiptCoordinator(this, sslSocketFactory, userAgentOverride, this.createServerSessionCoordinator);
        this.wellKnownCoordinator = new WellKnownCoordinator(this, sslSocketFactory, userAgentOverride, jsonObjectMapper);
        this.websocketCoordinator = new WebsocketCoordinator(this, sslSocketFactory, userAgentOverride, this.createServerSessionCoordinator, this.downloadMessagesAndListAttachmentsCoordinator, this.wellKnownCoordinator, jsonObjectMapper);
        this.getTurnCredentialsCoordinator = new GetTurnCredentialsCoordinator(this, sslSocketFactory, userAgentOverride, this.createServerSessionCoordinator, this.wellKnownCoordinator);
        this.ownedIdentitiesUpToDateRegardingServerListing = new HashSet();
        metaManager.requestDelegate(this, CreateSessionDelegate.class);
        metaManager.requestDelegate(this, SolveChallengeDelegate.class);
        metaManager.requestDelegate(this, ProcessDownloadedMessageDelegate.class);
        metaManager.requestDelegate(this, NotificationListeningDelegate.class);
        metaManager.requestDelegate(this, NotificationPostingDelegate.class);
        metaManager.requestDelegate(this, ChannelDelegate.class);
        metaManager.requestDelegate(this, IdentityDelegate.class);
        metaManager.requestDelegate(this, ProtocolStarterDelegate.class);
        metaManager.registerImplementedDelegates(this);
    }

    @Override
    public int initialQueueingPriority() {
        return 0;
    }

    @Override
    public void initialisationComplete() {
        this.wellKnownCoordinator.initialQueueing();
        this.websocketCoordinator.initialQueueing();
        this.downloadMessagesAndListAttachmentsCoordinator.initialQueueing();
        this.registerServerPushNotificationsCoordinator.initialQueueing();
        this.downloadAttachmentCoordinator.initialQueueing();
        this.serverQueryCoordinator.initialQueueing();
        this.downloadMessageExtendedPayloadCoordinator.initialQueueing();
        this.serverUserDataCoordinator.initialQueueing();
        this.createServerSessionCoordinator.initialQueueing();
    }

    public void startProcessing() {
        this.createServerSessionCoordinator.startProcessing();
        this.deleteMessageAndAttachmentsCoordinator.startProcessing();
        this.downloadAttachmentCoordinator.startProcessing();
        this.downloadMessageExtendedPayloadCoordinator.startProcessing();
        this.downloadMessagesAndListAttachmentsCoordinator.startProcessing();
        this.freeTrialCoordinator.startProcessing();
        this.getTurnCredentialsCoordinator.startProcessing();
        this.refreshInboxAttachmentSignedUrlCoordinator.startProcessing();
        this.registerServerPushNotificationsCoordinator.startProcessing();
        this.serverQueryCoordinator.startProcessing();
        this.serverUserDataCoordinator.startProcessing();
        this.verifyReceiptCoordinator.startProcessing();
        this.websocketCoordinator.startProcessing();
        this.wellKnownCoordinator.startProcessing();
    }

    public void setDelegate(CreateSessionDelegate createSessionDelegate) {
        this.createSessionDelegate = createSessionDelegate;
        try (FetchManagerSession fetchManagerSession = this.getSession();){
            CachedWellKnown.createTable(fetchManagerSession.session);
            ServerSession.createTable(fetchManagerSession.session);
            PushNotificationConfiguration.createTable(fetchManagerSession.session);
            InboxMessage.createTable(fetchManagerSession.session);
            InboxAttachment.createTable(fetchManagerSession.session);
            PendingServerQuery.createTable(fetchManagerSession.session);
            fetchManagerSession.session.commit();
        }
        catch (SQLException e) {
            Logger.x(e);
            throw new RuntimeException("Unable to createCurrentDevice network fetch databases");
        }
    }

    public static void upgradeTables(Session session, int oldVersion, int newVersion) throws SQLException {
        CachedWellKnown.upgradeTable(session, oldVersion, newVersion);
        ServerSession.upgradeTable(session, oldVersion, newVersion);
        PushNotificationConfiguration.upgradeTable(session, oldVersion, newVersion);
        InboxMessage.upgradeTable(session, oldVersion, newVersion);
        InboxAttachment.upgradeTable(session, oldVersion, newVersion);
        PendingServerQuery.upgradeTable(session, oldVersion, newVersion);
        if (oldVersion < 40 && newVersion >= 40) {
            Logger.d("DROPPING `pending_delete_from_server` DATABASE FOR VERSION 40");
            try (Statement statement = session.createStatement();){
                statement.execute("DROP TABLE `pending_delete_from_server`");
            }
        }
    }

    public void setDelegate(SolveChallengeDelegate solveChallengeDelegate) {
        this.createServerSessionCoordinator.setSolveChallengeDelegate(solveChallengeDelegate);
    }

    public void setDelegate(ProcessDownloadedMessageDelegate processDownloadedMessageDelegate) {
        this.processDownloadedMessageDelegate = processDownloadedMessageDelegate;
        this.downloadMessagesAndListAttachmentsCoordinator.setProcessDownloadedMessageDelegate(processDownloadedMessageDelegate);
    }

    public void setDelegate(NotificationListeningDelegate notificationListeningDelegate) {
        this.registerServerPushNotificationsCoordinator.setNotificationListeningDelegate(notificationListeningDelegate);
        this.websocketCoordinator.setNotificationListeningDelegate(notificationListeningDelegate);
        this.downloadMessagesAndListAttachmentsCoordinator.setNotificationListeningDelegate(notificationListeningDelegate);
        this.downloadMessageExtendedPayloadCoordinator.setNotificationListeningDelegate(notificationListeningDelegate);
        this.downloadAttachmentCoordinator.setNotificationListeningDelegate(notificationListeningDelegate);
        this.deleteMessageAndAttachmentsCoordinator.setNotificationListeningDelegate(notificationListeningDelegate);
        this.serverQueryCoordinator.setNotificationListeningDelegate(notificationListeningDelegate);
        this.refreshInboxAttachmentSignedUrlCoordinator.setNotificationListeningDelegate(notificationListeningDelegate);
        this.serverUserDataCoordinator.setNotificationListeningDelegate(notificationListeningDelegate);
        this.verifyReceiptCoordinator.setNotificationListeningDelegate(notificationListeningDelegate);
    }

    public void setDelegate(NotificationPostingDelegate notificationPostingDelegate) {
        this.notificationPostingDelegate = notificationPostingDelegate;
        this.registerServerPushNotificationsCoordinator.setNotificationPostingDelegate(notificationPostingDelegate);
        this.downloadAttachmentCoordinator.setNotificationPostingDelegate(notificationPostingDelegate);
        this.createServerSessionCoordinator.setNotificationPostingDelegate(notificationPostingDelegate);
        this.refreshInboxAttachmentSignedUrlCoordinator.setNotificationPostingDelegate(notificationPostingDelegate);
        this.downloadMessagesAndListAttachmentsCoordinator.setNotificationPostingDelegate(notificationPostingDelegate);
        this.downloadMessageExtendedPayloadCoordinator.setNotificationPostingDelegate(notificationPostingDelegate);
        this.websocketCoordinator.setNotificationPostingDelegate(notificationPostingDelegate);
        this.wellKnownCoordinator.setNotificationPostingDelegate(notificationPostingDelegate);
        this.getTurnCredentialsCoordinator.setNotificationPostingDelegate(notificationPostingDelegate);
    }

    public void setDelegate(ChannelDelegate channelDelegate) {
        this.serverQueryCoordinator.setChannelDelegate(channelDelegate);
    }

    public void setDelegate(IdentityDelegate identityDelegate) {
        this.identityDelegate = identityDelegate;
    }

    public void setDelegate(ProtocolStarterDelegate protocolStarterDelegate) {
        this.websocketCoordinator.setProtocolStarterDelegate(protocolStarterDelegate);
        this.registerServerPushNotificationsCoordinator.setProtocolStarterDelegate(protocolStarterDelegate);
    }

    public void deleteOwnedIdentity(Session session, Identity ownedIdentity, boolean doNotDeleteServerSession) throws SQLException {
        InboxMessage[] inboxMessages = InboxMessage.getAllForOwnedIdentity(this.wrapSession(session), ownedIdentity);
        for (InboxMessage inboxMessage : inboxMessages) {
            inboxMessage.delete();
        }
        for (ObvDatabase obvDatabase : PendingServerQuery.getAll(this.wrapSession(session))) {
            try {
                ServerQuery serverQuery = ServerQuery.of(((PendingServerQuery)obvDatabase).getEncodedQuery());
                if (!ownedIdentity.equals(serverQuery.getOwnedIdentity())) continue;
                ((PendingServerQuery)obvDatabase).delete();
            }
            catch (DecodingException e) {
                ((PendingServerQuery)obvDatabase).delete();
            }
        }
        PushNotificationConfiguration.deleteForOwnedIdentity(this.wrapSession(session), ownedIdentity);
        if (doNotDeleteServerSession) {
            ServerSession.deleteForIdentity(this.wrapSession(session), ownedIdentity);
        }
    }

    @Override
    public FetchManagerSession getSession() throws SQLException {
        if (this.createSessionDelegate == null) {
            throw new SQLException("No CreateSessionDelegate was set in FetchManager.");
        }
        return new FetchManagerSession(this.createSessionDelegate.getSession(), this.downloadMessagesAndListAttachmentsCoordinator, this.downloadMessageExtendedPayloadCoordinator, this.deleteMessageAndAttachmentsCoordinator, this.downloadAttachmentCoordinator, this.registerServerPushNotificationsCoordinator, this.serverQueryCoordinator, this.identityDelegate, this.engineBaseDirectory, this.notificationPostingDelegate, this.createServerSessionCoordinator);
    }

    private FetchManagerSession wrapSession(Session session) {
        return new FetchManagerSession(session, this.downloadMessagesAndListAttachmentsCoordinator, this.downloadMessageExtendedPayloadCoordinator, this.deleteMessageAndAttachmentsCoordinator, this.downloadAttachmentCoordinator, this.registerServerPushNotificationsCoordinator, this.serverQueryCoordinator, this.identityDelegate, this.engineBaseDirectory, this.notificationPostingDelegate, this.createServerSessionCoordinator);
    }

    @Override
    public void downloadMessages(Identity ownedIdentity, UID deviceUid) {
        this.markOwnedIdentityAsNotUpToDate(ownedIdentity, OwnedIdentitySynchronizationStatus.MANUAL_SYNC_IN_PROGRESS);
        this.downloadMessagesAndListAttachmentsCoordinator.downloadMessagesAndListAttachments(ownedIdentity, deviceUid);
        HashMap<String, Object> userInfo = new HashMap<String, Object>();
        userInfo.put("owned_identity", ownedIdentity);
        userInfo.put("user_initiated", true);
        this.notificationPostingDelegate.postNotification("network_fetch_notification_server_poll_requested", userInfo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DecryptedApplicationMessage getMessage(Identity ownedIdentity, UID messageUid) {
        try (FetchManagerSession fetchManagerSession = this.getSession();){
            InboxMessage inboxMessage = InboxMessage.get(fetchManagerSession, ownedIdentity, messageUid);
            if (inboxMessage == null) {
                DecryptedApplicationMessage decryptedApplicationMessage2 = null;
                return decryptedApplicationMessage2;
            }
            DecryptedApplicationMessage decryptedApplicationMessage = inboxMessage.getDecryptedApplicationMessage();
            return decryptedApplicationMessage;
        }
        catch (SQLException e) {
            return null;
        }
    }

    @Override
    public void setAttachmentKeyAndMetadataAndMessagePayload(Session session, Identity ownedIdentity, UID messageUid, Identity remoteIdentity, UID remoteDeviceUid, AttachmentKeyAndMetadata[] attachmentKeyAndMetadata, byte[] messagePayload, AuthEncKey extendedPayloadKey) throws Exception {
        if (attachmentKeyAndMetadata == null) {
            Logger.e("FetchManager is trying to setAttachmentKeyAndMetadataAndMessagePayload with a null attachmentKeyAndMetadata.");
            throw new Exception();
        }
        FetchManagerSession fetchManagerSession = this.wrapSession(session);
        InboxMessage inboxMessage = InboxMessage.get(fetchManagerSession, ownedIdentity, messageUid);
        if (inboxMessage == null) {
            Logger.e("FetchManager is trying to setAttachmentKeyAndMetadataAndMessagePayload for an non-existing messageUid.");
            throw new Exception();
        }
        InboxAttachment[] attachments = inboxMessage.getAttachments();
        if (attachments.length != attachmentKeyAndMetadata.length) {
            Logger.e("Attachment count mismatch between message and attachmentKeyAndMetadata in setAttachmentKeyAndMetadataAndMessagePayload.");
            throw new Exception();
        }
        Logger.d("Setting attachmentKeyAndMetadata for " + attachments.length + " attachments.");
        for (int i = 0; i < attachments.length; ++i) {
            attachments[i].setKeyAndMetadata(attachmentKeyAndMetadata[i].getKey(), attachmentKeyAndMetadata[i].getMetadata());
        }
        inboxMessage.setPayloadAndFromIdentity(messagePayload, remoteIdentity, remoteDeviceUid, extendedPayloadKey, attachments);
        this.identityDelegate.setContactRecentlyOnline(session, ownedIdentity, remoteIdentity, true);
    }

    @Override
    public void setInboxMessageFromIdentityForMissingPreKeyContact(Session session, Identity ownedIdentity, UID messageUid, Identity contactIdentity) throws Exception {
        FetchManagerSession fetchManagerSession = this.wrapSession(session);
        InboxMessage inboxMessage = InboxMessage.get(fetchManagerSession, ownedIdentity, messageUid);
        if (inboxMessage == null) {
            Logger.e("FetchManager is trying to setInboxMessageFromIdentityForMissingPreKeyContact for an non-existing messageUid.");
            throw new Exception();
        }
        inboxMessage.setFromIdentityForMissingPreKeyContact(contactIdentity);
    }

    @Override
    public void downloadAttachment(Identity ownedIdentity, UID messageUid, int attachmentNumber, int priorityCategory) {
        try (FetchManagerSession fetchManagerSession = this.getSession();){
            InboxAttachment inboxAttachment = InboxAttachment.get(fetchManagerSession, ownedIdentity, messageUid, attachmentNumber);
            if (inboxAttachment == null) {
                Logger.e("FetchManager received a downloadAttachment request for an unknown attachment " + String.valueOf(messageUid) + "-" + attachmentNumber);
                return;
            }
            if (inboxAttachment.cannotBeFetched()) {
                Logger.e("FetchManager received a downloadAttachment request for an attachment that cannot be fetched " + String.valueOf(messageUid) + "-" + attachmentNumber);
                return;
            }
            inboxAttachment.requestDownload(priorityCategory);
            fetchManagerSession.session.commit();
        }
        catch (SQLException e) {
            Logger.e("FetchManager was unable to downloadAttachment " + String.valueOf(messageUid) + "-" + attachmentNumber);
        }
    }

    @Override
    public void pauseDownloadAttachment(Identity ownedIdentity, UID messageUid, int attachmentNumber) {
        try (FetchManagerSession fetchManagerSession = this.getSession();){
            InboxAttachment inboxAttachment = InboxAttachment.get(fetchManagerSession, ownedIdentity, messageUid, attachmentNumber);
            if (inboxAttachment == null) {
                Logger.e("FetchManager received a pauseDownloadAttachment request for an unknown attachment " + String.valueOf(messageUid) + "-" + attachmentNumber);
                return;
            }
            inboxAttachment.pauseDownload();
            fetchManagerSession.session.commit();
        }
        catch (SQLException e) {
            Logger.e("FetchManager was unable to pauseDownloadAttachment " + String.valueOf(messageUid) + "-" + attachmentNumber);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ReceivedAttachment getAttachment(Identity ownedIdentity, UID messageUid, int attachmentNumber) {
        try (FetchManagerSession fetchManagerSession = this.getSession();){
            InboxAttachment inboxAttachment = InboxAttachment.get(fetchManagerSession, ownedIdentity, messageUid, attachmentNumber);
            if (inboxAttachment == null) {
                Logger.e("FetchManager received a getAttachment request for an unknown attachment " + String.valueOf(messageUid) + "-" + attachmentNumber);
                ReceivedAttachment receivedAttachment = null;
                return receivedAttachment;
            }
            if (inboxAttachment.cannotBeFetched()) {
                Logger.e("FetchManager received a getAttachment request for an attachment not yet ready " + String.valueOf(messageUid) + "-" + attachmentNumber);
                ReceivedAttachment receivedAttachment = null;
                return receivedAttachment;
            }
            ReceivedAttachment receivedAttachment = new ReceivedAttachment(inboxAttachment.getOwnedIdentity(), inboxAttachment.getMessageUid(), inboxAttachment.getAttachmentNumber(), inboxAttachment.getMetadata(), inboxAttachment.getUrl(), inboxAttachment.getPlaintextExpectedLength(), inboxAttachment.getPlaintextReceivedLength(), inboxAttachment.isDownloadRequested());
            return receivedAttachment;
        }
        catch (SQLException e) {
            Logger.e("FetchManager was unable to getAttachment " + String.valueOf(messageUid) + "-" + attachmentNumber);
            return null;
        }
    }

    @Override
    public boolean isInboxAttachmentReceived(Session session, Identity ownedIdentity, UID messageUid, int attachmentNumber) throws Exception {
        InboxAttachment inboxAttachment = InboxAttachment.get(this.wrapSession(session), ownedIdentity, messageUid, attachmentNumber);
        return inboxAttachment == null || inboxAttachment.getExpectedLength() == inboxAttachment.getReceivedLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageCannotBeDecrypted(Session session, Identity ownedIdentity, UID messageUid) {
        HashSet<Identity> hashSet = this.ownedIdentitiesUpToDateRegardingServerListing;
        synchronized (hashSet) {
            if (this.ownedIdentitiesUpToDateRegardingServerListing.contains(ownedIdentity)) {
                this.deleteMessageAndAttachments(session, ownedIdentity, messageUid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markOwnedIdentityAsUpToDate(Identity ownedIdentity) {
        HashSet<Identity> hashSet = this.ownedIdentitiesUpToDateRegardingServerListing;
        synchronized (hashSet) {
            this.ownedIdentitiesUpToDateRegardingServerListing.add(ownedIdentity);
            if (this.notificationPostingDelegate != null) {
                HashMap<String, Object> userInfo = new HashMap<String, Object>();
                userInfo.put("owned_identity", ownedIdentity);
                userInfo.put("status", (Object)OwnedIdentitySynchronizationStatus.SYNCHRONIZED);
                this.notificationPostingDelegate.postNotification("network_fetch_notification_owned_identity_synchronizing_with_server", userInfo);
            }
            try (FetchManagerSession fetchManagerSession = this.getSession();){
                InboxMessage[] unprocessedMessages;
                for (InboxMessage inboxMessage : unprocessedMessages = InboxMessage.getUnprocessedMessagesForOwnedIdentity(fetchManagerSession, ownedIdentity)) {
                    this.processDownloadedMessageDelegate.processDownloadedMessage(inboxMessage.getNetworkReceivedMessage());
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markOwnedIdentityAsNotUpToDate(Identity ownedIdentity, OwnedIdentitySynchronizationStatus synchronizationStatus) {
        HashSet<Identity> hashSet = this.ownedIdentitiesUpToDateRegardingServerListing;
        synchronized (hashSet) {
            this.ownedIdentitiesUpToDateRegardingServerListing.remove(ownedIdentity);
            if (this.notificationPostingDelegate != null && synchronizationStatus != OwnedIdentitySynchronizationStatus.SYNCHRONIZED) {
                HashMap<String, Object> userInfo = new HashMap<String, Object>();
                userInfo.put("owned_identity", ownedIdentity);
                userInfo.put("status", (Object)synchronizationStatus);
                this.notificationPostingDelegate.postNotification("network_fetch_notification_owned_identity_synchronizing_with_server", userInfo);
            }
        }
    }

    @Override
    public void deleteMessageAndAttachments(Session session, Identity ownedIdentity, UID messageUid) {
        FetchManagerSession fetchManagerSession = this.wrapSession(session);
        InboxMessage inboxMessage = InboxMessage.get(fetchManagerSession, ownedIdentity, messageUid);
        if (inboxMessage == null) {
            return;
        }
        inboxMessage.markForDeletion();
        for (InboxAttachment inboxAttachment : inboxMessage.getAttachments()) {
            inboxAttachment.markForDeletion();
        }
        session.addSessionCommitListener(() -> fetchManagerSession.markAsListedAndDeleteOnServerListener.messageCanBeDeletedFromServer(ownedIdentity, messageUid));
    }

    @Override
    public void deleteMessage(Session session, Identity ownedIdentity, UID messageUid) {
        FetchManagerSession fetchManagerSession = this.wrapSession(session);
        InboxMessage inboxMessage = InboxMessage.get(fetchManagerSession, ownedIdentity, messageUid);
        if (inboxMessage == null) {
            return;
        }
        inboxMessage.markForDeletion();
        if (inboxMessage.canBeDeleted()) {
            session.addSessionCommitListener(() -> fetchManagerSession.markAsListedAndDeleteOnServerListener.messageCanBeDeletedFromServer(ownedIdentity, messageUid));
        }
    }

    @Override
    public void deleteAttachment(Session session, Identity ownedIdentity, UID messageUid, int attachmentNumber) throws SQLException {
        FetchManagerSession fetchManagerSession = this.wrapSession(session);
        InboxAttachment inboxAttachment = InboxAttachment.get(fetchManagerSession, ownedIdentity, messageUid, attachmentNumber);
        if (inboxAttachment == null) {
            return;
        }
        inboxAttachment.markForDeletion();
        if (inboxAttachment.getMessage().canBeDeleted()) {
            fetchManagerSession.markAsListedAndDeleteOnServerListener.messageCanBeDeletedFromServer(ownedIdentity, messageUid);
        }
    }

    @Override
    public void markMessageAsOnHold(Session session, Identity ownedIdentity, UID messageUid) throws SQLException {
        FetchManagerSession fetchManagerSession = this.wrapSession(session);
        InboxMessage inboxMessage = InboxMessage.get(fetchManagerSession, ownedIdentity, messageUid);
        if (inboxMessage == null) {
            return;
        }
        inboxMessage.markAsOnHold();
    }

    @Override
    public void resendAllDownloadedAttachmentNotifications() throws Exception {
        try (FetchManagerSession fetchManagerSession = this.getSession();){
            InboxAttachment[] inboxAttachments;
            for (InboxAttachment inboxAttachment : inboxAttachments = InboxAttachment.getAllDownloaded(fetchManagerSession)) {
                this.downloadAttachmentCoordinator.attachmentDownloadFinished(inboxAttachment.getOwnedIdentity(), inboxAttachment.getMessageUid(), inboxAttachment.getAttachmentNumber());
            }
        }
    }

    @Override
    public ObvMessage getOnHoldMessage(Session session, Identity ownedIdentity, UID messageUid) throws Exception {
        FetchManagerSession fetchManagerSession = this.wrapSession(session);
        InboxMessage inboxMessage = InboxMessage.get(fetchManagerSession, ownedIdentity, messageUid);
        if (inboxMessage == null) {
            throw new Exception("Message not found in Inbox");
        }
        InboxAttachment[] attachments = inboxMessage.getAttachments();
        ReceivedAttachment[] receivedAttachments = new ReceivedAttachment[attachments.length];
        for (int i = 0; i < attachments.length; ++i) {
            receivedAttachments[i] = new ReceivedAttachment(attachments[i].getOwnedIdentity(), attachments[i].getMessageUid(), attachments[i].getAttachmentNumber(), attachments[i].getMetadata(), attachments[i].getUrl(), attachments[i].getPlaintextExpectedLength(), attachments[i].getPlaintextReceivedLength(), attachments[i].isDownloadRequested());
        }
        return new ObvMessage(inboxMessage.getDecryptedApplicationMessage(), receivedAttachments);
    }

    @Override
    public void createPendingServerQuery(Session session, ServerQuery serverQuery) throws Exception {
        PendingServerQuery pendingServerQuery = PendingServerQuery.create(this.wrapSession(session), serverQuery, this.prng);
        if (pendingServerQuery == null) {
            throw new Exception();
        }
    }

    @Override
    public void deleteExistingServerSession(Session session, Identity ownedIdentity, boolean createNewSession) {
        ServerSession.deleteForIdentity(this.wrapSession(session), ownedIdentity);
        if (createNewSession) {
            this.createServerSessionCoordinator.createServerSession(ownedIdentity);
        }
    }

    public void createServerSession(Identity ownedIdentity) {
        this.createServerSessionCoordinator.createServerSession(ownedIdentity);
    }

    @Override
    public void connectWebsockets(boolean relyOnWebsocketForNetworkDetection, String os, String osVersion, int appBuild, String appVersion) {
        if ("javax.net.ssl.HttpsURLConnection.DefaultHostnameVerifier".equals(HttpsURLConnection.getDefaultHostnameVerifier().getClass().getCanonicalName())) {
            Logger.w("WARNING: default HostnameVerifier not set. Websocket connection will most probably fail.\n\tYou may want to consider using OkHttp's HostnameVerifier as the default with:\n\t\tHttpsURLConnection.setDefaultHostnameVerifier(OkHostnameVerifier.INSTANCE);");
        }
        this.websocketCoordinator.connectWebsockets(relyOnWebsocketForNetworkDetection, os, osVersion, appBuild, appVersion);
    }

    @Override
    public void disconnectWebsockets() {
        this.websocketCoordinator.disconnectWebsockets();
    }

    @Override
    public void pingWebsocket(Identity ownedIdentity) {
        this.websocketCoordinator.pingWebsocket(ownedIdentity);
    }

    @Override
    public byte[] getServerAuthenticationToken(Identity ownedIdentity) {
        byte[] byArray;
        block8: {
            FetchManagerSession fetchManagerSession = this.getSession();
            try {
                byArray = ServerSession.getToken(fetchManagerSession, ownedIdentity);
                if (fetchManagerSession == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fetchManagerSession != null) {
                        try {
                            fetchManagerSession.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    Logger.x(e);
                    return null;
                }
            }
            fetchManagerSession.close();
        }
        return byArray;
    }

    @Override
    public void retryScheduledNetworkTasks() {
        this.createServerSessionCoordinator.retryScheduledNetworkTasks();
        this.deleteMessageAndAttachmentsCoordinator.retryScheduledNetworkTasks();
        this.downloadAttachmentCoordinator.retryScheduledNetworkTasks();
        this.downloadMessagesAndListAttachmentsCoordinator.retryScheduledNetworkTasks();
        this.downloadMessageExtendedPayloadCoordinator.retryScheduledNetworkTasks();
        this.refreshInboxAttachmentSignedUrlCoordinator.retryScheduledNetworkTasks();
        this.registerServerPushNotificationsCoordinator.retryScheduledNetworkTasks();
        this.serverQueryCoordinator.retryScheduledNetworkTasks();
        this.websocketCoordinator.retryScheduledNetworkTasks();
    }

    @Override
    public void getTurnCredentials(Identity ownedIdentity, UUID callUuid, String username1, String username2) {
        this.getTurnCredentialsCoordinator.getTurnCredentials(ownedIdentity, callUuid, username1, username2);
    }

    @Override
    public List<String> getWellKnownTurnServers(Identity ownedIdentity) {
        try {
            return this.wellKnownCoordinator.getTurnUrls(ownedIdentity.getServer());
        }
        catch (WellKnownCoordinator.NotCachedException notCachedException) {
            return null;
        }
    }

    @Override
    public void queryApiKeyStatus(Identity ownedIdentity, UUID apiKey) {
        this.createServerSessionCoordinator.queueNewQueryApiKeyStatusOperation(ownedIdentity, apiKey);
    }

    @Override
    public void queryFreeTrial(Identity ownedIdentity) {
        this.freeTrialCoordinator.queryFreeTrial(ownedIdentity);
    }

    @Override
    public void startFreeTrial(Identity ownedIdentity) {
        this.freeTrialCoordinator.startFreeTrial(ownedIdentity);
    }

    @Override
    public void verifyReceipt(Identity ownedIdentity, String storeToken) {
        this.verifyReceiptCoordinator.verifyReceipt(ownedIdentity, storeToken);
    }

    @Override
    public void queryServerWellKnown(String server) {
        this.wellKnownCoordinator.queueNewWellKnownDownloadOperation(server);
    }

    @Override
    public List<JsonOsmStyle> getOsmStyles(String server) {
        try {
            return this.wellKnownCoordinator.getOsmStyles(server);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @Override
    public String getAddressServerUrl(String server) {
        try {
            return this.wellKnownCoordinator.getAddressUrl(server);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void registerPushNotificationIfConfigurationChanged(Session session, Identity ownedIdentity, UID currentDeviceUid, PushNotificationTypeAndParameters newPushParameters) throws SQLException {
        FetchManagerSession fetchManagerSession = this.wrapSession(session);
        PushNotificationConfiguration pushNotificationConfiguration = PushNotificationConfiguration.get(fetchManagerSession, ownedIdentity);
        if (pushNotificationConfiguration != null) {
            if (pushNotificationConfiguration.getDeviceUid().equals(currentDeviceUid)) {
                PushNotificationTypeAndParameters oldPushParameters = pushNotificationConfiguration.getPushNotificationTypeAndParameters();
                if (oldPushParameters.sameTypeAndToken(newPushParameters)) {
                    if ((oldPushParameters.reactivateCurrentDevice || !newPushParameters.reactivateCurrentDevice) && (!oldPushParameters.reactivateCurrentDevice || !newPushParameters.reactivateCurrentDevice || Objects.equals(oldPushParameters.deviceUidToReplace, newPushParameters.deviceUidToReplace))) return;
                    newPushParameters.identityMaskingUid = oldPushParameters.identityMaskingUid;
                } else if (oldPushParameters.reactivateCurrentDevice && !newPushParameters.reactivateCurrentDevice) {
                    newPushParameters.reactivateCurrentDevice = true;
                    newPushParameters.deviceUidToReplace = oldPushParameters.deviceUidToReplace;
                }
            }
            pushNotificationConfiguration.delete();
        }
        if (PushNotificationConfiguration.create(fetchManagerSession, ownedIdentity, currentDeviceUid, newPushParameters) != null) return;
        throw new SQLException();
    }

    @Override
    public void processAndroidPushNotification(String maskingUidString) {
        this.registerServerPushNotificationsCoordinator.processAndroidPushNotification(maskingUidString);
    }

    @Override
    public void forceRegisterPushNotification(Identity ownedIdentity, boolean triggerAnOwnedDeviceDiscoveryWhenFinished) {
        this.registerServerPushNotificationsCoordinator.registerServerPushNotification(ownedIdentity, triggerAnOwnedDeviceDiscoveryWhenFinished);
    }

    @Override
    public Identity getOwnedIdentityFromMaskingUid(String maskingUidString) {
        return this.registerServerPushNotificationsCoordinator.getOwnedIdentityFromMaskingUid(maskingUidString);
    }

    public void deleteReturnReceipt(Identity ownedIdentity, byte[] serverUid) {
        this.websocketCoordinator.deleteReturnReceipt(ownedIdentity, serverUid);
    }
}

