/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity.databases.sync;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.BackupSeed;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationPrivateKey;
import io.olvid.engine.datatypes.key.symmetric.MACKey;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.ObvBytesKey;
import io.olvid.engine.engine.types.ObvCapability;
import io.olvid.engine.engine.types.ObvGroupOwnerAndUidKey;
import io.olvid.engine.engine.types.identities.ObvIdentity;
import io.olvid.engine.engine.types.sync.ObvSyncDiff;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshotNode;
import io.olvid.engine.identity.databases.ContactGroup;
import io.olvid.engine.identity.databases.ContactGroupV2;
import io.olvid.engine.identity.databases.ContactIdentity;
import io.olvid.engine.identity.databases.KeycloakServer;
import io.olvid.engine.identity.databases.OwnedDevice;
import io.olvid.engine.identity.databases.OwnedIdentity;
import io.olvid.engine.identity.databases.OwnedIdentityDetails;
import io.olvid.engine.identity.databases.sync.ContactSyncSnapshot;
import io.olvid.engine.identity.databases.sync.GroupV1SyncSnapshot;
import io.olvid.engine.identity.databases.sync.GroupV2SyncSnapshot;
import io.olvid.engine.identity.databases.sync.IdentityDetailsSyncSnapshot;
import io.olvid.engine.identity.databases.sync.KeycloakSyncSnapshot;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import io.olvid.engine.protocol.datatypes.ProtocolStarterDelegate;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OwnedIdentitySyncSnapshot
implements ObvSyncSnapshotNode {
    public static final String PRIVATE_IDENTITY = "private_identity";
    public static final String PUBLISHED_DETAILS = "published_details";
    public static final String KEYCLOAK = "keycloak";
    public static final String BACKUP_SEED = "backup_seed";
    public static final String CONTACTS = "contacts";
    public static final String GROUPS = "groups";
    public static final String GROUPS2 = "groups2";
    static HashSet<String> DEFAULT_DOMAIN = new HashSet<String>(Arrays.asList("private_identity", "published_details", "keycloak", "backup_seed", "contacts", "groups", "groups2"));
    public PrivateIdentity private_identity;
    public IdentityDetailsSyncSnapshot published_details;
    public KeycloakSyncSnapshot keycloak;
    public byte[] backup_seed;
    @JsonSerialize(keyUsing=ObvBytesKey.KeySerializer.class)
    @JsonDeserialize(keyUsing=ObvBytesKey.KeyDeserializer.class)
    public HashMap<ObvBytesKey, ContactSyncSnapshot> contacts;
    @JsonSerialize(keyUsing=ObvGroupOwnerAndUidKey.Serializer.class)
    @JsonDeserialize(keyUsing=ObvGroupOwnerAndUidKey.Deserializer.class)
    public HashMap<ObvGroupOwnerAndUidKey, GroupV1SyncSnapshot> groups;
    @JsonSerialize(keyUsing=ObvBytesKey.KeySerializer.class)
    @JsonDeserialize(keyUsing=ObvBytesKey.KeyDeserializer.class)
    public HashMap<ObvBytesKey, GroupV2SyncSnapshot> groups2;
    public HashSet<String> domain;

    public static OwnedIdentitySyncSnapshot of(IdentityManagerSession identityManagerSession, OwnedIdentity ownedIdentity) throws SQLException {
        KeycloakServer keycloakServer;
        OwnedIdentitySyncSnapshot ownedIdentitySyncSnapshot = new OwnedIdentitySyncSnapshot();
        ownedIdentitySyncSnapshot.private_identity = PrivateIdentity.of(ownedIdentity.getPrivateIdentity());
        OwnedIdentityDetails publishedDetails = OwnedIdentityDetails.get(identityManagerSession, ownedIdentity.getOwnedIdentity(), ownedIdentity.getPublishedDetailsVersion());
        if (publishedDetails != null) {
            ownedIdentitySyncSnapshot.published_details = IdentityDetailsSyncSnapshot.of(identityManagerSession, publishedDetails);
        }
        if (ownedIdentity.isKeycloakManaged() && (keycloakServer = KeycloakServer.get(identityManagerSession, ownedIdentity.getKeycloakServerUrl(), ownedIdentity.getOwnedIdentity())) != null) {
            ownedIdentitySyncSnapshot.keycloak = KeycloakSyncSnapshot.of(identityManagerSession, keycloakServer);
        }
        ownedIdentitySyncSnapshot.backup_seed = ownedIdentity.getBackupSeed().getBackupSeedBytes();
        ownedIdentitySyncSnapshot.contacts = new HashMap();
        for (ContactIdentity contactIdentity : ContactIdentity.getAll(identityManagerSession, ownedIdentity.getOwnedIdentity())) {
            ownedIdentitySyncSnapshot.contacts.put(new ObvBytesKey(contactIdentity.getContactIdentity().getBytes()), ContactSyncSnapshot.of(identityManagerSession, contactIdentity));
        }
        ownedIdentitySyncSnapshot.groups = new HashMap();
        for (ObvDatabase obvDatabase : ContactGroup.getAllForIdentity(identityManagerSession, ownedIdentity.getOwnedIdentity())) {
            ownedIdentitySyncSnapshot.groups.put(new ObvGroupOwnerAndUidKey(((ContactGroup)obvDatabase).getGroupOwnerAndUid()), GroupV1SyncSnapshot.of(identityManagerSession, (ContactGroup)obvDatabase));
        }
        ownedIdentitySyncSnapshot.groups2 = new HashMap();
        for (ContactGroupV2 group2 : ContactGroupV2.getAllForIdentity(identityManagerSession, ownedIdentity.getOwnedIdentity())) {
            ownedIdentitySyncSnapshot.groups2.put(new ObvBytesKey(group2.getGroupIdentifier().getBytes()), GroupV2SyncSnapshot.of(identityManagerSession, group2));
        }
        ownedIdentitySyncSnapshot.domain = DEFAULT_DOMAIN;
        return ownedIdentitySyncSnapshot;
    }

    @JsonIgnore
    public ObvIdentity restoreOwnedIdentity(IdentityManagerSession identityManagerSession, String deviceName, Identity ownedIdentity) throws Exception {
        KeycloakServer keycloakServer;
        BackupSeed backupSeed;
        if (!this.domain.contains(PRIVATE_IDENTITY) || !this.domain.contains(PUBLISHED_DETAILS)) {
            Logger.e("Trying to restore an incomplete OwnedIdentitySyncSnapshot. Domain: " + String.valueOf(this.domain));
            throw new Exception();
        }
        ServerAuthenticationPrivateKey serverAuthenticationPrivateKey = (ServerAuthenticationPrivateKey)new Encoded(this.private_identity.server_authentication_private_key).decodePrivateKey();
        EncryptionPrivateKey encryptionPrivateKey = (EncryptionPrivateKey)new Encoded(this.private_identity.encryption_private_key).decodePrivateKey();
        MACKey macKey = (MACKey)new Encoded(this.private_identity.mac_key).decodeSymmetricKey();
        io.olvid.engine.datatypes.PrivateIdentity privateIdentity = new io.olvid.engine.datatypes.PrivateIdentity(ownedIdentity, serverAuthenticationPrivateKey, encryptionPrivateKey, macKey);
        OwnedIdentityDetails ownedIdentityDetails = this.published_details.restoreOwned(identityManagerSession, ownedIdentity);
        if (this.domain.contains(BACKUP_SEED) && this.backup_seed != null) {
            try {
                backupSeed = new BackupSeed(this.backup_seed);
            }
            catch (Exception e) {
                backupSeed = privateIdentity.getDeterministicBackupSeedForLegacyIdentity();
            }
        } else {
            backupSeed = privateIdentity.getDeterministicBackupSeedForLegacyIdentity();
        }
        OwnedIdentity ownedIdentityObject = new OwnedIdentity(identityManagerSession, privateIdentity, backupSeed, ownedIdentityDetails.getVersion());
        ownedIdentityObject.insert();
        if (this.domain.contains(KEYCLOAK) && this.keycloak != null && (keycloakServer = this.keycloak.restore(identityManagerSession, ownedIdentity, this.keycloak)) != null) {
            ownedIdentityObject.setKeycloakServerUrl(keycloakServer.getServerUrl());
        }
        OwnedDevice currentOwnedDevice = OwnedDevice.createCurrentDevice(identityManagerSession, ownedIdentity, deviceName, identityManagerSession.prng);
        currentOwnedDevice.setRawDeviceCapabilities(ObvCapability.capabilityListToStringArray(ObvCapability.currentCapabilities));
        return new ObvIdentity(ownedIdentity, ownedIdentityDetails.getJsonIdentityDetails(), ownedIdentityObject.isKeycloakManaged(), true);
    }

    @JsonIgnore
    public void restore(IdentityManagerSession identityManagerSession, ProtocolStarterDelegate protocolStarterDelegate, Identity ownedIdentity) throws Exception {
        if (!this.domain.contains(PRIVATE_IDENTITY) || !this.domain.contains(PUBLISHED_DETAILS)) {
            Logger.e("Trying to restore an incomplete OwnedIdentitySyncSnapshot. Domain: " + String.valueOf(this.domain));
            throw new Exception();
        }
        if (this.domain.contains(CONTACTS) && this.contacts != null) {
            for (Map.Entry<ObvBytesKey, ContactSyncSnapshot> entry : this.contacts.entrySet()) {
                Identity contactIdentity = Identity.of(entry.getKey().getBytes());
                entry.getValue().restore(identityManagerSession, ownedIdentity, contactIdentity);
            }
        }
        if (this.domain.contains(GROUPS) && this.groups != null) {
            for (Map.Entry<Object, ObvSyncSnapshotNode> entry : this.groups.entrySet()) {
                Identity groupOwnerIdentity = Identity.of(((ObvGroupOwnerAndUidKey)entry.getKey()).groupOwner);
                ((GroupV1SyncSnapshot)entry.getValue()).restore(identityManagerSession, ownedIdentity, groupOwnerIdentity, ((ObvGroupOwnerAndUidKey)entry.getKey()).getGroupOwnerAndUid());
            }
        }
        if (this.domain.contains(GROUPS2) && this.groups2 != null) {
            for (Map.Entry<Object, ObvSyncSnapshotNode> entry : this.groups2.entrySet()) {
                GroupV2.Identifier groupIdentifier = GroupV2.Identifier.of(new Encoded(((ObvBytesKey)entry.getKey()).getBytes()));
                ((GroupV2SyncSnapshot)entry.getValue()).restore(identityManagerSession, protocolStarterDelegate, ownedIdentity, groupIdentifier);
            }
        }
    }

    @Override
    public boolean areContentsTheSame(ObvSyncSnapshotNode otherSnapshotNode) {
        return false;
    }

    @Override
    public List<ObvSyncDiff> computeDiff(ObvSyncSnapshotNode otherSnapshotNode) throws Exception {
        return null;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PrivateIdentity {
        public byte[] server_authentication_private_key;
        public byte[] encryption_private_key;
        public byte[] mac_key;

        private static PrivateIdentity of(io.olvid.engine.datatypes.PrivateIdentity privateIdentity) {
            PrivateIdentity pi = new PrivateIdentity();
            pi.server_authentication_private_key = Encoded.of(privateIdentity.getServerAuthenticationPrivateKey()).getBytes();
            pi.encryption_private_key = Encoded.of(privateIdentity.getEncryptionPrivateKey()).getBytes();
            pi.mac_key = Encoded.of(privateIdentity.getMacKey()).getBytes();
            return pi;
        }
    }
}

