/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity.databases.sync;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.sync.ObvSyncDiff;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshotNode;
import io.olvid.engine.identity.databases.ContactGroupDetails;
import io.olvid.engine.identity.databases.ContactGroupV2Details;
import io.olvid.engine.identity.databases.ServerUserData;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GroupDetailsSyncSnapshot
implements ObvSyncSnapshotNode {
    public static final String VERSION = "version";
    public static final String SERIALIZED_DETAILS = "serialized_details";
    public static final String PHOTO_SERVER_IDENTITY = "photo_server_identity";
    public static final String PHOTO_SERVER_LABEL = "photo_server_label";
    public static final String PHOTO_SERVER_KEY = "photo_server_key";
    static HashSet<String> DEFAULT_V1_DOMAIN = new HashSet<String>(Arrays.asList("version", "serialized_details", "photo_server_label", "photo_server_key"));
    static HashSet<String> DEFAULT_V2_DOMAIN = new HashSet<String>(Arrays.asList("serialized_details", "photo_server_identity", "photo_server_label", "photo_server_key"));
    public Integer version;
    public String serialized_details;
    public byte[] photo_server_identity;
    public byte[] photo_server_label;
    public byte[] photo_server_key;
    public HashSet<String> domain;

    public static GroupDetailsSyncSnapshot of(IdentityManagerSession identityManagerSession, ContactGroupDetails contactGroupDetails) {
        GroupDetailsSyncSnapshot groupDetailsSyncSnapshot = new GroupDetailsSyncSnapshot();
        groupDetailsSyncSnapshot.version = contactGroupDetails.getVersion();
        groupDetailsSyncSnapshot.serialized_details = contactGroupDetails.getSerializedJsonDetails();
        if (contactGroupDetails.getPhotoServerLabel() != null && contactGroupDetails.getPhotoServerKey() != null) {
            groupDetailsSyncSnapshot.photo_server_label = contactGroupDetails.getPhotoServerLabel().getBytes();
            groupDetailsSyncSnapshot.photo_server_key = Encoded.of(contactGroupDetails.getPhotoServerKey()).getBytes();
        }
        groupDetailsSyncSnapshot.domain = DEFAULT_V1_DOMAIN;
        return groupDetailsSyncSnapshot;
    }

    public static GroupDetailsSyncSnapshot of(IdentityManagerSession identityManagerSession, ContactGroupV2Details contactGroupV2Details) {
        GroupDetailsSyncSnapshot groupDetailsSyncSnapshot = new GroupDetailsSyncSnapshot();
        groupDetailsSyncSnapshot.serialized_details = contactGroupV2Details.getSerializedJsonDetails();
        if (contactGroupV2Details.getPhotoServerLabel() != null && contactGroupV2Details.getPhotoServerKey() != null) {
            groupDetailsSyncSnapshot.photo_server_identity = contactGroupV2Details.getPhotoServerIdentity() == null ? null : contactGroupV2Details.getPhotoServerIdentity().getBytes();
            groupDetailsSyncSnapshot.photo_server_label = contactGroupV2Details.getPhotoServerLabel().getBytes();
            groupDetailsSyncSnapshot.photo_server_key = Encoded.of(contactGroupV2Details.getPhotoServerKey()).getBytes();
        }
        groupDetailsSyncSnapshot.domain = DEFAULT_V2_DOMAIN;
        return groupDetailsSyncSnapshot;
    }

    @JsonIgnore
    public ContactGroupDetails restoreGroup(IdentityManagerSession identityManagerSession, Identity ownedIdentity, Identity groupOwnerIdentity, byte[] groupOwnerAndUid) throws Exception {
        AuthEncKey photoServerKey;
        UID photoServerLabel;
        if (!this.domain.contains(VERSION) || !this.domain.contains(SERIALIZED_DETAILS)) {
            Logger.e("Trying to restoreGroup an incomplete GroupDetailsSyncSnapshot. Domain: " + String.valueOf(this.domain));
            throw new Exception();
        }
        if (this.domain.contains(PHOTO_SERVER_LABEL) && this.domain.contains(PHOTO_SERVER_KEY) && this.photo_server_key != null && this.photo_server_label != null) {
            try {
                photoServerLabel = new UID(this.photo_server_label);
                photoServerKey = (AuthEncKey)new Encoded(this.photo_server_key).decodeSymmetricKey();
            }
            catch (Exception e) {
                Logger.x(e);
                photoServerLabel = null;
                photoServerKey = null;
            }
        } else {
            photoServerLabel = null;
            photoServerKey = null;
        }
        ContactGroupDetails contactGroupDetails = new ContactGroupDetails(identityManagerSession, groupOwnerAndUid, ownedIdentity, this.version, this.serialized_details, null, photoServerLabel, photoServerKey);
        contactGroupDetails.insert();
        if (groupOwnerIdentity.equals(ownedIdentity) && photoServerLabel != null && photoServerKey != null) {
            ServerUserData.createForOwnedGroupDetails(identityManagerSession, ownedIdentity, photoServerLabel, groupOwnerAndUid);
        }
        return contactGroupDetails;
    }

    @JsonIgnore
    public ContactGroupV2Details restoreGroupV2(IdentityManagerSession identityManagerSession, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, int version) throws Exception {
        AuthEncKey photoServerKey;
        UID photoServerLabel;
        Identity photoServerIdentity;
        if (!this.domain.contains(SERIALIZED_DETAILS)) {
            Logger.e("Trying to restoreGroupV2 an incomplete GroupDetailsSyncSnapshot. Domain: " + String.valueOf(this.domain));
            throw new Exception();
        }
        if (this.domain.contains(PHOTO_SERVER_IDENTITY) && this.domain.contains(PHOTO_SERVER_LABEL) && this.domain.contains(PHOTO_SERVER_KEY) && this.photo_server_key != null && this.photo_server_label != null) {
            try {
                photoServerIdentity = this.photo_server_identity == null ? null : Identity.of(this.photo_server_identity);
                photoServerLabel = new UID(this.photo_server_label);
                photoServerKey = (AuthEncKey)new Encoded(this.photo_server_key).decodeSymmetricKey();
            }
            catch (Exception e) {
                Logger.x(e);
                photoServerIdentity = null;
                photoServerLabel = null;
                photoServerKey = null;
            }
        } else {
            photoServerIdentity = null;
            photoServerLabel = null;
            photoServerKey = null;
        }
        ContactGroupV2Details contactGroupV2Details = new ContactGroupV2Details(identityManagerSession, groupIdentifier.groupUid, groupIdentifier.serverUrl, groupIdentifier.category, ownedIdentity, version, this.serialized_details, null, photoServerIdentity, photoServerLabel, photoServerKey);
        contactGroupV2Details.insert();
        if (ownedIdentity.equals(photoServerIdentity)) {
            ServerUserData.createForGroupV2(identityManagerSession, ownedIdentity, photoServerLabel, groupIdentifier.getBytes());
        }
        return contactGroupV2Details;
    }

    @Override
    public boolean areContentsTheSame(ObvSyncSnapshotNode otherSnapshotNode) {
        if (!(otherSnapshotNode instanceof GroupDetailsSyncSnapshot)) {
            return false;
        }
        GroupDetailsSyncSnapshot other = (GroupDetailsSyncSnapshot)otherSnapshotNode;
        HashSet<String> domainIntersection = new HashSet<String>(this.domain);
        domainIntersection.retainAll(other.domain);
        Iterator<String> iterator = domainIntersection.iterator();
        block16: while (iterator.hasNext()) {
            String item;
            switch (item = iterator.next()) {
                case "version": {
                    if (Objects.equals(this.version, other.version)) break;
                    return false;
                }
                case "serialized_details": {
                    if (Objects.equals(this.serialized_details, other.serialized_details)) break;
                    return false;
                }
                case "photo_server_identity": {
                    if (Arrays.equals(this.photo_server_identity, other.photo_server_identity)) break;
                    return false;
                }
                case "photo_server_label": {
                    if (Arrays.equals(this.photo_server_label, other.photo_server_label)) break;
                    return false;
                }
                case "photo_server_key": {
                    try {
                        if (!(this.photo_server_key == null && other.photo_server_key != null || this.photo_server_key != null && other.photo_server_key == null) && (this.photo_server_key == null || Objects.equals(new Encoded(this.photo_server_key).decodeSymmetricKey(), new Encoded(other.photo_server_key).decodeSymmetricKey()))) continue block16;
                        return false;
                    }
                    catch (DecodingException e) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public List<ObvSyncDiff> computeDiff(ObvSyncSnapshotNode otherSnapshotNode) throws Exception {
        return null;
    }
}

