/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity.databases.backups;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.olvid.engine.engine.types.sync.ObvSyncDiff;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshotNode;
import io.olvid.engine.identity.databases.OwnedIdentity;
import io.olvid.engine.identity.databases.OwnedIdentityDetails;
import io.olvid.engine.identity.databases.sync.IdentityDetailsSyncSnapshot;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OwnedIdentityDeviceSnapshot
implements ObvSyncSnapshotNode {
    public static final String PUBLISHED_DETAILS = "published_details";
    public static final String KEYCLOAK_MANAGED = "keycloak_managed";
    public static final String BACKUP_SEED = "backup_seed";
    static HashSet<String> DEFAULT_DOMAIN = new HashSet<String>(Arrays.asList("published_details", "keycloak_managed", "backup_seed"));
    public IdentityDetailsSyncSnapshot published_details;
    public Boolean keycloak_managed;
    public byte[] backup_seed;
    public HashSet<String> domain;

    public static OwnedIdentityDeviceSnapshot of(IdentityManagerSession identityManagerSession, OwnedIdentity ownedIdentity) throws SQLException {
        OwnedIdentityDeviceSnapshot ownedIdentityDeviceSnapshot = new OwnedIdentityDeviceSnapshot();
        OwnedIdentityDetails publishedDetails = OwnedIdentityDetails.get(identityManagerSession, ownedIdentity.getOwnedIdentity(), ownedIdentity.getPublishedDetailsVersion());
        if (publishedDetails != null) {
            ownedIdentityDeviceSnapshot.published_details = IdentityDetailsSyncSnapshot.of(identityManagerSession, publishedDetails);
        }
        ownedIdentityDeviceSnapshot.keycloak_managed = ownedIdentity.isKeycloakManaged();
        ownedIdentityDeviceSnapshot.backup_seed = ownedIdentity.getBackupSeed().getBackupSeedBytes();
        ownedIdentityDeviceSnapshot.domain = DEFAULT_DOMAIN;
        return ownedIdentityDeviceSnapshot;
    }

    public boolean validate() {
        return this.domain.containsAll(DEFAULT_DOMAIN) && this.backup_seed != null && this.keycloak_managed != null && this.published_details != null;
    }

    @Override
    public boolean areContentsTheSame(ObvSyncSnapshotNode otherSnapshotNode) {
        return false;
    }

    @Override
    public List<ObvSyncDiff> computeDiff(ObvSyncSnapshotNode otherSnapshotNode) throws Exception {
        return null;
    }
}

