/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.Signature;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.Constants;
import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.KeyId;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.PrivateIdentity;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPublicKey;
import io.olvid.engine.datatypes.key.asymmetric.KeyPair;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.ObvCapability;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

public class OwnedPreKey
implements ObvDatabase {
    static final String TABLE_NAME = "owned_pre_key";
    private final IdentityManagerSession identityManagerSession;
    private KeyId keyId;
    static final String KEY_ID = "key_id";
    private Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private Long expirationTimestamp;
    static final String EXPIRATION_TIMESTAMP = "expiration_timestamp";
    private EncryptionPrivateKey encryptionPrivateKey;
    static final String ENCRYPTION_PRIVATE_KEY = "encryption_private_key";
    private Encoded encodedSignedPreKey;
    static final String ENCODED_SIGNED_PRE_KEY = "encoded_signed_pre_key";

    public KeyId getKeyId() {
        return this.keyId;
    }

    public Long getExpirationTimestamp() {
        return this.expirationTimestamp;
    }

    public Encoded getEncodedSignedPreKey() {
        return this.encodedSignedPreKey;
    }

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public EncryptionPrivateKey getEncryptionPrivateKey() {
        return this.encryptionPrivateKey;
    }

    public static OwnedPreKey create(IdentityManagerSession identityManagerSession, Identity ownedIdentity, PrivateIdentity privateIdentity, UID currentDeviceUid, long expirationTimestamp, PRNGService prng) {
        byte[] signature;
        if (ownedIdentity == null || privateIdentity == null || currentDeviceUid == null) {
            return null;
        }
        KeyId keyId = new KeyId(prng.bytes(32));
        KeyPair encryptionKeyPair = Suite.generateEncryptionKeyPair(null, prng);
        if (encryptionKeyPair == null) {
            return null;
        }
        String[] rawDeviceCapabilities = ObvCapability.capabilityListToStringArray(ObvCapability.currentCapabilities);
        Encoded encodedPreKey = Encoded.of(new Encoded[]{Encoded.of(keyId.getBytes()), Encoded.of(((EncryptionPublicKey)encryptionKeyPair.getPublicKey()).getCompactKey()), Encoded.of(currentDeviceUid), Encoded.of(expirationTimestamp)});
        HashMap<DictionaryKey, Encoded> dict = new HashMap<DictionaryKey, Encoded>();
        dict.put(new DictionaryKey("prk"), encodedPreKey);
        dict.put(new DictionaryKey("cap"), Encoded.of(rawDeviceCapabilities));
        Encoded encodedDict = Encoded.of(dict);
        try {
            signature = Signature.sign(Constants.SignatureContext.DEVICE_PRE_KEY, encodedDict.getBytes(), privateIdentity.getServerAuthenticationPrivateKey().getSignaturePrivateKey(), prng);
            if (signature == null) {
                return null;
            }
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
        try {
            OwnedPreKey ownedPreKey = new OwnedPreKey(identityManagerSession, keyId, ownedIdentity, expirationTimestamp, (EncryptionPrivateKey)encryptionKeyPair.getPrivateKey(), Encoded.of(new Encoded[]{encodedDict, Encoded.of(signature)}));
            ownedPreKey.insert();
            return ownedPreKey;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public OwnedPreKey(IdentityManagerSession identityManagerSession, KeyId keyId, Identity ownedIdentity, Long expirationTimestamp, EncryptionPrivateKey encryptionPrivateKey, Encoded encodedSignedPreKey) {
        this.identityManagerSession = identityManagerSession;
        this.keyId = keyId;
        this.ownedIdentity = ownedIdentity;
        this.expirationTimestamp = expirationTimestamp;
        this.encryptionPrivateKey = encryptionPrivateKey;
        this.encodedSignedPreKey = encodedSignedPreKey;
    }

    private OwnedPreKey(IdentityManagerSession identityManagerSession, ResultSet res) throws SQLException {
        this.identityManagerSession = identityManagerSession;
        this.keyId = new KeyId(res.getBytes(KEY_ID));
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        this.expirationTimestamp = res.getLong(EXPIRATION_TIMESTAMP);
        byte[] encryptionPrivateKeyBytes = res.getBytes(ENCRYPTION_PRIVATE_KEY);
        try {
            this.encryptionPrivateKey = (EncryptionPrivateKey)new Encoded(encryptionPrivateKeyBytes).decodePrivateKey();
        }
        catch (DecodingException decodingException) {
            // empty catch block
        }
        this.encodedSignedPreKey = new Encoded(res.getBytes(ENCODED_SIGNED_PRE_KEY));
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS owned_pre_key (key_id BLOB PRIMARY KEY, owned_identity BLOB NOT NULL, expiration_timestamp INTEGER NOT NULL, encryption_private_key BLOB NOT NULL, encoded_signed_pre_key BLOB NOT NULL, FOREIGN KEY (owned_identity) REFERENCES owned_identity (identity) ON DELETE CASCADE);");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        if (oldVersion < 41 && newVersion >= 41) {
            Logger.d("CREATING `owned_pre_key` DATABASE FOR VERSION 41");
            try (Statement statement = session.createStatement();){
                statement.execute("CREATE TABLE `owned_pre_key` ( key_id BLOB PRIMARY KEY,  owned_identity BLOB NOT NULL,  expiration_timestamp INTEGER NOT NULL,  encryption_private_key BLOB NOT NULL,  encoded_signed_pre_key BLOB NOT NULL,  FOREIGN KEY (owned_identity) REFERENCES owned_identity(identity) ON DELETE CASCADE);");
            }
            oldVersion = 41;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("OwnedPreKey.insert", "INSERT INTO owned_pre_key VALUES (?,?,?,?,?);");){
            statement.setBytes(1, this.keyId.getBytes());
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.setLong(3, this.expirationTimestamp);
            statement.setBytes(4, Encoded.of(this.encryptionPrivateKey).getBytes());
            statement.setBytes(5, this.encodedSignedPreKey.getBytes());
            statement.executeUpdate();
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("OwnedPreKey.delete", "DELETE FROM owned_pre_key WHERE key_id = ?;");){
            statement.setBytes(1, this.keyId.getBytes());
            statement.executeUpdate();
        }
    }

    public static OwnedPreKey get(IdentityManagerSession identityManagerSession, Identity ownedIdentity, KeyId keyId) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("OwnedPreKey.get", "SELECT * FROM owned_pre_key WHERE key_id = ?  AND owned_identity = ?;");){
            OwnedPreKey ownedPreKey;
            block16: {
                ResultSet res;
                block14: {
                    OwnedPreKey ownedPreKey2;
                    block15: {
                        statement.setBytes(1, keyId.getBytes());
                        statement.setBytes(2, ownedIdentity.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block14;
                            ownedPreKey2 = new OwnedPreKey(identityManagerSession, res);
                            if (res == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return ownedPreKey2;
                }
                ownedPreKey = null;
                if (res == null) break block16;
                res.close();
            }
            return ownedPreKey;
        }
    }

    public static OwnedPreKey getLatest(IdentityManagerSession identityManagerSession, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("OwnedPreKey.getLatest", "SELECT * FROM owned_pre_key WHERE owned_identity = ?  ORDER BY expiration_timestamp DESC LIMIT 1;");){
            OwnedPreKey ownedPreKey;
            block16: {
                ResultSet res;
                block14: {
                    OwnedPreKey ownedPreKey2;
                    block15: {
                        statement.setBytes(1, ownedIdentity.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block14;
                            ownedPreKey2 = new OwnedPreKey(identityManagerSession, res);
                            if (res == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return ownedPreKey2;
                }
                ownedPreKey = null;
                if (res == null) break block16;
                res.close();
            }
            return ownedPreKey;
        }
    }

    public static void deleteExpired(IdentityManagerSession identityManagerSession, Identity ownedIdentity, long timestamp) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("OwnedPreKey.deleteExpired", "DELETE FROM owned_pre_key WHERE owned_identity = ?  AND expiration_timestamp < ?;");){
            statement.setBytes(1, ownedIdentity.getBytes());
            statement.setLong(2, timestamp);
            statement.executeUpdate();
        }
    }

    @Override
    public void wasCommitted() {
    }
}

