/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity.databases;

import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class KeycloakRevokedIdentity
implements ObvDatabase {
    static final String TABLE_NAME = "keycloak_revoked_identity";
    private final IdentityManagerSession identityManagerSession;
    private long rowId;
    static final String ROW_ID = "row_id";
    private Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private String keycloakServerUrl;
    static final String KEYCLOAK_SERVER_URL = "keycloak_server_url";
    private Identity revokedIdentity;
    static final String REVOKED_IDENTITY = "revoked_identity";
    private int revocationType;
    static final String REVOCATION_TYPE = "revocation_type";
    private long revocationTimestamp;
    static final String REVOCATION_TIMESTAMP = "revocation_timestamp";
    public static final int TYPE_COMPROMISED = 0;
    public static final int TYPE_LEFT_COMPANY = 1;

    public int getRevocationType() {
        return this.revocationType;
    }

    public long getRevocationTimestamp() {
        return this.revocationTimestamp;
    }

    public String getKeycloakServerUrl() {
        return this.keycloakServerUrl;
    }

    public static KeycloakRevokedIdentity create(IdentityManagerSession identityManagerSession, Identity ownedIdentity, String keycloakServerUrl, Identity revokedIdentity, int revocationType, long revocationTimestamp) {
        if (ownedIdentity == null || keycloakServerUrl == null || revokedIdentity == null) {
            return null;
        }
        try {
            KeycloakRevokedIdentity keycloakRevokedIdentity = new KeycloakRevokedIdentity(identityManagerSession, ownedIdentity, keycloakServerUrl, revokedIdentity, revocationType, revocationTimestamp);
            keycloakRevokedIdentity.insert();
            return keycloakRevokedIdentity;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public KeycloakRevokedIdentity(IdentityManagerSession identityManagerSession, Identity ownedIdentity, String keycloakServerUrl, Identity revokedIdentity, int revocationType, long revocationTimestamp) {
        this.identityManagerSession = identityManagerSession;
        this.ownedIdentity = ownedIdentity;
        this.keycloakServerUrl = keycloakServerUrl;
        this.revokedIdentity = revokedIdentity;
        this.revocationType = revocationType;
        this.revocationTimestamp = revocationTimestamp;
    }

    public KeycloakRevokedIdentity(IdentityManagerSession identityManagerSession, ResultSet res) throws SQLException {
        this.identityManagerSession = identityManagerSession;
        this.rowId = res.getLong(ROW_ID);
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        this.keycloakServerUrl = res.getString(KEYCLOAK_SERVER_URL);
        try {
            this.revokedIdentity = Identity.of(res.getBytes(REVOKED_IDENTITY));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        this.revocationType = res.getInt(REVOCATION_TYPE);
        this.revocationTimestamp = res.getLong(REVOCATION_TIMESTAMP);
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS keycloak_revoked_identity (row_id INTEGER PRIMARY KEY AUTOINCREMENT, owned_identity BLOB NOT NULL, keycloak_server_url TEXT NOT NULL, revoked_identity BLOB NOT NULL, revocation_type INT NOT NULL, revocation_timestamp BIGINT NOT NULL,  FOREIGN KEY (owned_identity, keycloak_server_url) REFERENCES keycloak_server(owned_identity, server_url) ON DELETE CASCADE);");
            statement.execute("CREATE INDEX IF NOT EXISTS `index_keycloak_revoked_identity_revoked_identity` ON keycloak_revoked_identity (revoked_identity)");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        if (oldVersion < 25 && newVersion >= 25) {
            try (Statement statement = session.createStatement();){
                statement.execute("CREATE TABLE keycloak_revoked_identity ( row_id INTEGER PRIMARY KEY AUTOINCREMENT,  owned_identity BLOB NOT NULL,  keycloak_server_url TEXT NOT NULL,  revoked_identity BLOB NOT NULL,  revocation_type INT NOT NULL,  revocation_timestamp BIGINT NOT NULL,  FOREIGN KEY (owned_identity, keycloak_server_url) REFERENCES keycloak_server (owned_identity, server_url) ON DELETE CASCADE);");
                statement.execute("CREATE INDEX `index_keycloak_revoked_identity_revoked_identity` ON keycloak_revoked_identity (revoked_identity)");
            }
            oldVersion = 25;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("KeycloakRevokedIdentity.insert", "INSERT INTO keycloak_revoked_identity(owned_identity, keycloak_server_url, revoked_identity, revocation_type, revocation_timestamp)  VALUES (?,?,?,?,?);", true);){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setString(2, this.keycloakServerUrl);
            statement.setBytes(3, this.revokedIdentity.getBytes());
            statement.setInt(4, this.revocationType);
            statement.setLong(5, this.revocationTimestamp);
            statement.executeUpdate();
            try (ResultSet res = statement.getGeneratedKeys();){
                if (res.next()) {
                    this.rowId = res.getLong(1);
                }
            }
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("KeycloakRevokedIdentity.delete", "DELETE FROM keycloak_revoked_identity WHERE row_id = ?;");){
            statement.setLong(1, this.rowId);
            statement.executeUpdate();
        }
    }

    public static List<KeycloakRevokedIdentity> get(IdentityManagerSession identityManagerSession, Identity ownedIdentity, Identity identityToVerify) throws SQLException {
        if (ownedIdentity == null || identityToVerify == null) {
            return null;
        }
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("KeycloakRevokedIdentity.get", "SELECT kr.* FROM keycloak_revoked_identity AS kr  INNER JOIN owned_identity AS oi  ON kr.owned_identity = oi.identity AND kr.keycloak_server_url = oi.keycloak_server_url WHERE oi.identity = ?  AND kr.revoked_identity = ?;");){
            ArrayList<KeycloakRevokedIdentity> arrayList;
            block14: {
                statement.setBytes(1, ownedIdentity.getBytes());
                statement.setBytes(2, identityToVerify.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<KeycloakRevokedIdentity> list = new ArrayList<KeycloakRevokedIdentity>();
                    while (res.next()) {
                        list.add(new KeycloakRevokedIdentity(identityManagerSession, res));
                    }
                    arrayList = list;
                    if (res == null) break block14;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
    }

    public static void prune(IdentityManagerSession identityManagerSession, Identity ownedIdentity, String keycloakServerUrl, long timestamp) throws SQLException {
        if (ownedIdentity == null || keycloakServerUrl == null) {
            return;
        }
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("KeycloakRevokedIdentity.prune", "DELETE FROM keycloak_revoked_identity WHERE owned_identity = ?  AND keycloak_server_url = ?  AND revocation_timestamp < ?;");){
            statement.setBytes(1, ownedIdentity.getBytes());
            statement.setString(2, keycloakServerUrl);
            statement.setLong(3, timestamp);
            statement.executeUpdate();
        }
    }

    @Override
    public void wasCommitted() {
    }
}

