/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity.databases;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.TrustLevel;
import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.engine.datatypes.containers.TrustOrigin;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.identity.databases.ContactIdentity;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class ContactTrustOrigin
implements ObvDatabase {
    static final String TABLE_NAME = "contact_trust_origin";
    private final IdentityManagerSession identityManagerSession;
    private long rowId;
    static final String ROW_ID = "row_id";
    private Identity contactIdentity;
    static final String CONTACT_IDENTITY = "contact_identity";
    private Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private long timestamp;
    static final String TIMESTAMP = "timestamp";
    private int trustType;
    static final String TRUST_TYPE = "trust_type";
    private Identity mediatorOrGroupOwnerIdentity;
    static final String MEDIATOR_OR_GROUP_OWNER_IDENTITY = "mediator_or_group_owner_identity";
    private Integer mediatorOrGroupOwnerTrustLevelMajor;
    static final String MEDIATOR_OR_GROUP_OWNER_TRUST_LEVEL_MAJOR = "mediator_or_group_owner_trust_level_major";
    private String identityServer;
    static final String IDENTITY_SERVER = "identity_server";
    private byte[] serializedGroupIdentifier;
    static final String SERIALIZED_GROUP_IDENTIFIER = "serialized_group_identifier";
    public static final int TRUST_TYPE_DIRECT = 1;
    public static final int TRUST_TYPE_INTRODUCTION = 2;
    public static final int TRUST_TYPE_GROUP = 3;
    public static final int TRUST_TYPE_IDENTITY_SERVER = 4;
    public static final int TRUST_TYPE_SERVER_GROUP_V2 = 5;

    TrustLevel getTrustLevel() {
        switch (this.trustType) {
            case 1: {
                return TrustLevel.createDirect();
            }
            case 2: 
            case 3: {
                return TrustLevel.createIndirect(this.mediatorOrGroupOwnerTrustLevelMajor);
            }
            case 4: {
                return TrustLevel.createServer();
            }
            case 5: {
                return TrustLevel.createServerGroupV2();
            }
        }
        return null;
    }

    public TrustOrigin getTrustOrigin() {
        switch (this.trustType) {
            case 1: {
                return TrustOrigin.createDirectTrustOrigin(this.timestamp);
            }
            case 3: {
                return TrustOrigin.createGroupTrustOrigin(this.timestamp, this.mediatorOrGroupOwnerIdentity);
            }
            case 2: {
                return TrustOrigin.createIntroductionTrustOrigin(this.timestamp, this.mediatorOrGroupOwnerIdentity);
            }
            case 4: {
                return TrustOrigin.createKeycloakTrustOrigin(this.timestamp, this.identityServer);
            }
            case 5: {
                try {
                    return TrustOrigin.createServerGroupV2TrustOrigin(this.timestamp, GroupV2.Identifier.of(this.serializedGroupIdentifier));
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return null;
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS contact_trust_origin (row_id INTEGER PRIMARY KEY AUTOINCREMENT, contact_identity BLOB NOT NULL, owned_identity BLOB NOT NULL, timestamp INTEGER NOT NULL, trust_type INTEGER NOT NULL, mediator_or_group_owner_identity BLOB, mediator_or_group_owner_trust_level_major INTEGER, identity_server TEXT, serialized_group_identifier BLOB,  FOREIGN KEY (contact_identity, owned_identity) REFERENCES contact_identity (identity, owned_identity) ON DELETE CASCADE);");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        Statement statement;
        if (oldVersion < 12 && newVersion >= 12) {
            statement = session.createStatement();
            try {
                statement.execute("DELETE FROM contact_trust_origin AS p  WHERE NOT EXISTS ( SELECT 1 FROM contact_identity  WHERE identity = p.contact_identity AND owned_identity = p.owned_identity )");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 12;
        }
        if (oldVersion < 32 && newVersion >= 32) {
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE contact_trust_origin  ADD COLUMN serialized_group_identifier BLOB DEFAULT NULL");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 32;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactTrustOrigin.insert", "INSERT INTO contact_trust_origin(contact_identity, owned_identity, timestamp, trust_type, mediator_or_group_owner_identity, mediator_or_group_owner_trust_level_major, identity_server, serialized_group_identifier)  VALUES (?,?,?,?,?, ?,?,?);", true);){
            statement.setBytes(1, this.contactIdentity.getBytes());
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.setLong(3, this.timestamp);
            statement.setInt(4, this.trustType);
            if (this.mediatorOrGroupOwnerIdentity == null) {
                statement.setBytes(5, null);
            } else {
                statement.setBytes(5, this.mediatorOrGroupOwnerIdentity.getBytes());
            }
            if (this.mediatorOrGroupOwnerTrustLevelMajor == null) {
                statement.setNull(6, 4);
            } else {
                statement.setInt(6, this.mediatorOrGroupOwnerTrustLevelMajor);
            }
            statement.setString(7, this.identityServer);
            statement.setBytes(8, this.serializedGroupIdentifier);
            statement.executeUpdate();
            ResultSet res = statement.getGeneratedKeys();
            if (res.next()) {
                this.rowId = res.getLong(1);
            }
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactTrustOrigin.delete", "DELETE FROM contact_trust_origin WHERE row_id = ?;");){
            statement.setLong(1, this.rowId);
            statement.executeUpdate();
        }
    }

    public static ContactTrustOrigin create(IdentityManagerSession identityManagerSession, Identity contactIdentity, Identity ownedIdentity, TrustOrigin trustOrigin) {
        if (ownedIdentity == null || contactIdentity == null || trustOrigin == null) {
            return null;
        }
        try {
            byte[] serializedGroupIdentifier;
            String identityServer;
            Identity mediatorOrGroupOwnerIdentity;
            int trustType;
            switch (trustOrigin.getType()) {
                case DIRECT: {
                    trustType = 1;
                    mediatorOrGroupOwnerIdentity = null;
                    identityServer = null;
                    serializedGroupIdentifier = null;
                    break;
                }
                case GROUP: {
                    trustType = 3;
                    mediatorOrGroupOwnerIdentity = trustOrigin.getMediatorOrGroupOwnerIdentity();
                    identityServer = null;
                    serializedGroupIdentifier = null;
                    break;
                }
                case INTRODUCTION: {
                    trustType = 2;
                    mediatorOrGroupOwnerIdentity = trustOrigin.getMediatorOrGroupOwnerIdentity();
                    identityServer = null;
                    serializedGroupIdentifier = null;
                    break;
                }
                case KEYCLOAK: {
                    trustType = 4;
                    mediatorOrGroupOwnerIdentity = null;
                    identityServer = trustOrigin.getKeycloakServer();
                    serializedGroupIdentifier = null;
                    break;
                }
                case SERVER_GROUP_V2: {
                    trustType = 5;
                    mediatorOrGroupOwnerIdentity = null;
                    identityServer = null;
                    serializedGroupIdentifier = trustOrigin.getGroupIdentifier().getBytes();
                    break;
                }
                default: {
                    return null;
                }
            }
            Integer mediatorOrGroupOwnerTrustLevelMajor = null;
            if (mediatorOrGroupOwnerIdentity != null) {
                ContactIdentity mediatorOrGroupOwner = ContactIdentity.get(identityManagerSession, ownedIdentity, mediatorOrGroupOwnerIdentity);
                if (mediatorOrGroupOwner == null) {
                    return null;
                }
                mediatorOrGroupOwnerTrustLevelMajor = mediatorOrGroupOwner.getTrustLevel().major;
            }
            ContactTrustOrigin contactTrustOrigin = new ContactTrustOrigin(identityManagerSession, contactIdentity, ownedIdentity, trustOrigin.getTimestamp(), trustType, mediatorOrGroupOwnerIdentity, mediatorOrGroupOwnerTrustLevelMajor, identityServer, serializedGroupIdentifier);
            contactTrustOrigin.insert();
            return contactTrustOrigin;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    public ContactTrustOrigin(IdentityManagerSession identityManagerSession, Identity contactIdentity, Identity ownedIdentity, long timestamp, int trustType, Identity mediatorOrGroupOwnerIdentity, Integer mediatorOrGroupOwnerTrustLevelMajor, String identityServer, byte[] serializedGroupIdentifier) {
        this.identityManagerSession = identityManagerSession;
        this.contactIdentity = contactIdentity;
        this.ownedIdentity = ownedIdentity;
        this.timestamp = timestamp;
        this.trustType = trustType;
        this.mediatorOrGroupOwnerIdentity = mediatorOrGroupOwnerIdentity;
        this.mediatorOrGroupOwnerTrustLevelMajor = mediatorOrGroupOwnerTrustLevelMajor;
        this.identityServer = identityServer;
        this.serializedGroupIdentifier = serializedGroupIdentifier;
    }

    private ContactTrustOrigin(IdentityManagerSession identityManagerSession, ResultSet res) throws SQLException {
        this.rowId = res.getLong(ROW_ID);
        this.identityManagerSession = identityManagerSession;
        try {
            this.contactIdentity = Identity.of(res.getBytes(CONTACT_IDENTITY));
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
            byte[] mediatorBytes = res.getBytes(MEDIATOR_OR_GROUP_OWNER_IDENTITY);
            this.mediatorOrGroupOwnerIdentity = mediatorBytes == null ? null : Identity.of(mediatorBytes);
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        this.timestamp = res.getLong(TIMESTAMP);
        this.trustType = res.getInt(TRUST_TYPE);
        this.mediatorOrGroupOwnerTrustLevelMajor = res.getInt(MEDIATOR_OR_GROUP_OWNER_TRUST_LEVEL_MAJOR);
        if (res.wasNull()) {
            this.mediatorOrGroupOwnerTrustLevelMajor = null;
        }
        this.identityServer = res.getString(IDENTITY_SERVER);
        this.serializedGroupIdentifier = res.getBytes(SERIALIZED_GROUP_IDENTIFIER);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ContactTrustOrigin[] getAll(IdentityManagerSession identityManagerSession, Identity contactIdentity, Identity ownedIdentity) {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactTrustOrigin.getAll", "SELECT * FROM contact_trust_origin WHERE contact_identity = ?  AND owned_identity = ? ORDER BY timestamp DESC;");){
            ContactTrustOrigin[] contactTrustOriginArray;
            block15: {
                statement.setBytes(1, contactIdentity.getBytes());
                statement.setBytes(2, ownedIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ContactTrustOrigin> list = new ArrayList<ContactTrustOrigin>();
                    while (res.next()) {
                        list.add(new ContactTrustOrigin(identityManagerSession, res));
                    }
                    contactTrustOriginArray = list.toArray(new ContactTrustOrigin[0]);
                    if (res == null) break block15;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return contactTrustOriginArray;
        }
        catch (SQLException e) {
            return new ContactTrustOrigin[0];
        }
    }

    @Override
    public void wasCommitted() {
    }

    public static Pojo_0[] backupAll(IdentityManagerSession identityManagerSession, Identity ownedIdentity, Identity contactIdentity) {
        ContactTrustOrigin[] contactTrustOrigins = ContactTrustOrigin.getAll(identityManagerSession, contactIdentity, ownedIdentity);
        Pojo_0[] pojos = new Pojo_0[contactTrustOrigins.length];
        for (int i = 0; i < contactTrustOrigins.length; ++i) {
            pojos[i] = contactTrustOrigins[i].backup();
        }
        return pojos;
    }

    public static void restoreAll(IdentityManagerSession identityManagerSession, Identity ownedIdentity, Identity contactIdentity, Pojo_0[] pojos) throws SQLException {
        if (pojos == null) {
            return;
        }
        for (Pojo_0 pojo : pojos) {
            ContactTrustOrigin.restore(identityManagerSession, ownedIdentity, contactIdentity, pojo);
        }
    }

    private Pojo_0 backup() {
        Pojo_0 pojo = new Pojo_0();
        pojo.timestamp = this.timestamp;
        pojo.writeTrust_type(this.trustType);
        if (this.mediatorOrGroupOwnerIdentity != null) {
            pojo.mediator_or_group_owner_identity = this.mediatorOrGroupOwnerIdentity.getBytes();
        }
        if (this.mediatorOrGroupOwnerTrustLevelMajor != null) {
            pojo.mediator_or_group_owner_trust_level_major = this.mediatorOrGroupOwnerTrustLevelMajor;
        }
        pojo.identity_server = this.identityServer;
        pojo.raw_obv_group_v2_identifier = this.serializedGroupIdentifier;
        return pojo;
    }

    private static void restore(IdentityManagerSession identityManagerSession, Identity ownedIdentity, Identity contactIdentity, Pojo_0 pojo) throws SQLException {
        Identity mediatorOrGroupOwnerIdentity = null;
        try {
            if (pojo.mediator_or_group_owner_identity != null) {
                mediatorOrGroupOwnerIdentity = Identity.of(pojo.mediator_or_group_owner_identity);
            }
        }
        catch (DecodingException e) {
            Logger.x(e);
        }
        ContactTrustOrigin contactTrustOrigin = new ContactTrustOrigin(identityManagerSession, contactIdentity, ownedIdentity, pojo.timestamp, pojo.readTrust_type(), mediatorOrGroupOwnerIdentity, pojo.mediator_or_group_owner_trust_level_major, pojo.identity_server, pojo.raw_obv_group_v2_identifier);
        contactTrustOrigin.insert();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Pojo_0 {
        private static final int TYPE_DIRECT = 0;
        private static final int TYPE_GROUP = 1;
        private static final int TYPE_INTRODUCTION = 2;
        private static final int TYPE_IDENTITY_SERVER = 3;
        private static final int TYPE_SERVER_GROUP_V2 = 4;
        public long timestamp;
        private int trust_type;
        public byte[] mediator_or_group_owner_identity;
        public Integer mediator_or_group_owner_trust_level_major;
        public String identity_server;
        public byte[] raw_obv_group_v2_identifier;

        public int getTrust_type() {
            return this.trust_type;
        }

        public void setTrust_type(int trust_type) {
            this.trust_type = trust_type;
        }

        @JsonIgnore
        public int readTrust_type() {
            switch (this.trust_type) {
                case 1: {
                    return 3;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 4;
                }
                case 4: {
                    return 5;
                }
            }
            return 1;
        }

        @JsonIgnore
        public void writeTrust_type(int trust_type) {
            switch (trust_type) {
                case 3: {
                    this.trust_type = 1;
                    break;
                }
                case 2: {
                    this.trust_type = 2;
                    break;
                }
                case 4: {
                    this.trust_type = 3;
                    break;
                }
                case 5: {
                    this.trust_type = 4;
                    break;
                }
                default: {
                    this.trust_type = 0;
                }
            }
        }
    }
}

