/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity.databases;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.TrustLevel;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.TrustOrigin;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.JsonIdentityDetails;
import io.olvid.engine.engine.types.JsonIdentityDetailsWithVersionAndPhoto;
import io.olvid.engine.engine.types.JsonKeycloakUserDetails;
import io.olvid.engine.identity.databases.ContactGroup;
import io.olvid.engine.identity.databases.ContactIdentityDetails;
import io.olvid.engine.identity.databases.ContactTrustOrigin;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import io.olvid.engine.secure_io.SecureFile;
import io.olvid.engine.secure_io.SecureFileOutputStream;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Random;

public class ContactIdentity
implements ObvDatabase {
    static final String TABLE_NAME = "contact_identity";
    private final IdentityManagerSession identityManagerSession;
    private Identity contactIdentity;
    static final String CONTACT_IDENTITY = "identity";
    private Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private int trustedDetailsVersion;
    static final String TRUSTED_DETAILS_VERSION = "trusted_details_version";
    public int publishedDetailsVersion;
    static final String PUBLISHED_DETAILS_VERSION = "published_details_version";
    private TrustLevel trustLevel;
    static final String TRUST_LEVEL = "trust_level";
    private boolean certifiedByOwnKeycloak;
    static final String CERTIFIED_BY_OWN_KEYCLOAK = "keycloak_managed";
    public boolean revokedAsCompromised;
    static final String REVOKED_AS_COMPROMISED = "revoked_as_compromised";
    public boolean forcefullyTrustedByUser;
    static final String FORCEFULLY_TRUSTED_BY_USER = "forcefully_trusted_by_user";
    private int oneToOne;
    static final String ONE_TO_ONE = "one_to_one";
    private long lastNoDeviceContactDeviceDiscovery;
    static final String LAST_CONTACT_DEVICE_DISCOVERY = "last_no_device_contact_device_discovery";
    private boolean recentlyOnline;
    static final String RECENTLY_ONLINE = "recently_online";
    public static final int ONE_TO_ONE_STATUS_FALSE = 0;
    public static final int ONE_TO_ONE_STATUS_TRUE = 1;
    public static final int ONE_TO_ONE_STATUS_UNKNOWN = 2;
    private long commitHookBits = 0L;
    private static final long HOOK_BIT_INSERTED = 1L;
    private static final long HOOK_BIT_DELETED = 2L;
    private static final long HOOK_BIT_PUBLISHED_DETAILS_TRUSTED = 4L;
    private JsonIdentityDetailsWithVersionAndPhoto hookTrustedDetails;
    private static final long HOOK_BIT_NEW_PUBLISHED_DETAILS = 8L;
    private int hookPhotoSetVersion;
    private static final long HOOK_BIT_PHOTO_SET = 16L;
    private static final long HOOK_BIT_TRUST_LEVEL_INCREASED = 32L;
    private static final long HOOK_BIT_KEYCLOAK_MANAGED_CHANGED = 64L;
    private static final long HOOK_BIT_ACTIVE_CHANGED = 128L;
    private static final long HOOK_BIT_REVOKED = 256L;
    private static final long HOOK_BIT_ONE_TO_ONE_CHANGED = 512L;
    private static final long HOOK_BIT_RECENTLY_ONLINE_CHANGED = 1024L;

    public Identity getContactIdentity() {
        return this.contactIdentity;
    }

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public int getTrustedDetailsVersion() {
        return this.trustedDetailsVersion;
    }

    public int getPublishedDetailsVersion() {
        return this.publishedDetailsVersion;
    }

    public TrustLevel getTrustLevel() {
        return this.trustLevel;
    }

    public boolean isCertifiedByOwnKeycloak() {
        return this.certifiedByOwnKeycloak;
    }

    public boolean isRevokedAsCompromised() {
        return this.revokedAsCompromised;
    }

    public boolean isForcefullyTrustedByUser() {
        return this.forcefullyTrustedByUser;
    }

    public boolean isActive() {
        return this.forcefullyTrustedByUser || !this.revokedAsCompromised;
    }

    public boolean isOneToOne() {
        return this.oneToOne == 1;
    }

    public boolean isNotOneToOne() {
        return this.oneToOne == 0;
    }

    public long getLastContactDeviceDiscoveryTimestamp() {
        return this.lastNoDeviceContactDeviceDiscovery;
    }

    public boolean isRecentlyOnline() {
        return this.recentlyOnline;
    }

    public ContactIdentityDetails getPublishedDetails() throws SQLException {
        return ContactIdentityDetails.get(this.identityManagerSession, this.contactIdentity, this.ownedIdentity, this.publishedDetailsVersion);
    }

    public ContactIdentityDetails getTrustedDetails() throws SQLException {
        return ContactIdentityDetails.get(this.identityManagerSession, this.contactIdentity, this.ownedIdentity, this.trustedDetailsVersion);
    }

    public void updatePublishedDetails(JsonIdentityDetailsWithVersionAndPhoto jsonIdentityDetailsWithVersionAndPhoto, boolean allowDowngrade) throws Exception {
        JsonKeycloakUserDetails jsonKeycloakUserDetails;
        PreparedStatement statement;
        String lastKnownSerializedCertifiedDetails;
        if (jsonIdentityDetailsWithVersionAndPhoto == null) {
            return;
        }
        int newDetailsVersion = jsonIdentityDetailsWithVersionAndPhoto.getVersion();
        if (!allowDowngrade && jsonIdentityDetailsWithVersionAndPhoto.getVersion() <= this.publishedDetailsVersion) {
            return;
        }
        boolean notifyNewDetails = true;
        if (allowDowngrade && newDetailsVersion <= this.publishedDetailsVersion) {
            ContactIdentityDetails newPublishedDetails2;
            ContactIdentityDetails publishedDetails = this.getPublishedDetails();
            lastKnownSerializedCertifiedDetails = publishedDetails.getSerializedJsonDetails();
            if (newDetailsVersion == this.publishedDetailsVersion && publishedDetails.getJsonIdentityDetails().equals(jsonIdentityDetailsWithVersionAndPhoto.getIdentityDetails())) {
                UID newPhotoServerLabel;
                UID uID = newPhotoServerLabel = jsonIdentityDetailsWithVersionAndPhoto.getPhotoServerLabel() == null ? null : new UID(jsonIdentityDetailsWithVersionAndPhoto.getPhotoServerLabel());
                if (Objects.equals(newPhotoServerLabel, publishedDetails.getPhotoServerLabel())) {
                    AuthEncKey newPhotoServerKey;
                    AuthEncKey authEncKey = newPhotoServerKey = jsonIdentityDetailsWithVersionAndPhoto.getPhotoServerKey() == null ? null : (AuthEncKey)new Encoded(jsonIdentityDetailsWithVersionAndPhoto.getPhotoServerKey()).decodeSymmetricKey();
                    if (Objects.equals(newPhotoServerKey, publishedDetails.getPhotoServerKey())) {
                        return;
                    }
                }
            }
            ContactIdentityDetails.cleanup(this.identityManagerSession, this.ownedIdentity, this.contactIdentity, this.publishedDetailsVersion, this.trustedDetailsVersion);
            ContactIdentityDetails trustedDetails = this.getTrustedDetails();
            if (this.trustedDetailsVersion != -1) {
                ContactIdentityDetails.copy(this.identityManagerSession, this.ownedIdentity, this.contactIdentity, this.trustedDetailsVersion, -1);
                statement = this.identityManagerSession.session.prepareStatement("ContactIdentity.updatePublishedDetails", "UPDATE contact_identity SET trusted_details_version = ?, published_details_version = ?  WHERE identity = ?  AND owned_identity = ?;");
                try {
                    statement.setInt(1, -1);
                    statement.setInt(2, -1);
                    statement.setBytes(3, this.contactIdentity.getBytes());
                    statement.setBytes(4, this.ownedIdentity.getBytes());
                    statement.executeUpdate();
                    this.trustedDetailsVersion = -1;
                    this.publishedDetailsVersion = -1;
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
                trustedDetails.delete();
            } else {
                statement = this.identityManagerSession.session.prepareStatement("ContactIdentity.updatePublishedDetails", "UPDATE contact_identity SET trusted_details_version = ?, published_details_version = ?  WHERE identity = ?  AND owned_identity = ?;");
                try {
                    statement.setInt(1, -1);
                    statement.setInt(2, -1);
                    statement.setBytes(3, this.contactIdentity.getBytes());
                    statement.setBytes(4, this.ownedIdentity.getBytes());
                    statement.executeUpdate();
                    this.trustedDetailsVersion = -1;
                    this.publishedDetailsVersion = -1;
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            if (publishedDetails.getVersion() != trustedDetails.getVersion()) {
                publishedDetails.delete();
            }
            if ((newPublishedDetails2 = ContactIdentityDetails.create(this.identityManagerSession, this.contactIdentity, this.ownedIdentity, jsonIdentityDetailsWithVersionAndPhoto)).getPhotoServerLabel() != null && newPublishedDetails2.getPhotoServerKey() != null && newPublishedDetails2.getPhotoServerLabel().equals(publishedDetails.getPhotoServerLabel()) && newPublishedDetails2.getPhotoServerKey().equals(publishedDetails.getPhotoServerKey()) && publishedDetails.getPhotoUrl() != null) {
                newPublishedDetails2.setPhotoUrl(publishedDetails.getPhotoUrl());
            }
            try (PreparedStatement statement2 = this.identityManagerSession.session.prepareStatement("ContactIdentity.updatePublishedDetails", "UPDATE contact_identity SET published_details_version = ?  WHERE identity = ?  AND owned_identity = ?;");){
                statement2.setInt(1, newPublishedDetails2.getVersion());
                statement2.setBytes(2, this.contactIdentity.getBytes());
                statement2.setBytes(3, this.ownedIdentity.getBytes());
                statement2.executeUpdate();
                this.publishedDetailsVersion = newPublishedDetails2.getVersion();
            }
        }
        ContactIdentityDetails newPublishedDetails = ContactIdentityDetails.create(this.identityManagerSession, this.contactIdentity, this.ownedIdentity, jsonIdentityDetailsWithVersionAndPhoto);
        ContactIdentityDetails publishedDetails = this.getPublishedDetails();
        lastKnownSerializedCertifiedDetails = publishedDetails.getSerializedJsonDetails();
        if (newPublishedDetails.getPhotoServerLabel() != null && newPublishedDetails.getPhotoServerKey() != null && newPublishedDetails.getPhotoServerLabel().equals(publishedDetails.getPhotoServerLabel()) && newPublishedDetails.getPhotoServerKey().equals(publishedDetails.getPhotoServerKey()) && publishedDetails.getPhotoUrl() != null) {
            newPublishedDetails.setPhotoUrl(publishedDetails.getPhotoUrl());
        }
        try {
            if (publishedDetails.getJsonIdentityDetails().fieldsAreTheSame(newPublishedDetails.getJsonIdentityDetails()) && Objects.equals(publishedDetails.getPhotoServerKey(), newPublishedDetails.getPhotoServerKey()) && Objects.equals(publishedDetails.getPhotoServerLabel(), newPublishedDetails.getPhotoServerLabel())) {
                notifyNewDetails = false;
            }
        }
        catch (Exception newPublishedDetails2) {
            // empty catch block
        }
        statement = this.identityManagerSession.session.prepareStatement("ContactIdentity.updatePublishedDetails", "UPDATE contact_identity SET published_details_version = ?  WHERE identity = ?  AND owned_identity = ?;");
        try {
            statement.setInt(1, newPublishedDetails.getVersion());
            statement.setBytes(2, this.contactIdentity.getBytes());
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.publishedDetailsVersion = newPublishedDetails.getVersion();
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        if (notifyNewDetails) {
            this.commitHookBits |= 8L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
        if (jsonIdentityDetailsWithVersionAndPhoto.getIdentityDetails().getSignedUserDetails() != null && (jsonKeycloakUserDetails = this.identityManagerSession.identityDelegate.verifyKeycloakIdentitySignature(this.identityManagerSession.session, this.ownedIdentity, jsonIdentityDetailsWithVersionAndPhoto.getIdentityDetails().getSignedUserDetails())) != null) {
            JsonIdentityDetails certifiedJsonIdentityDetails = jsonKeycloakUserDetails.getIdentityDetails(jsonIdentityDetailsWithVersionAndPhoto.getIdentityDetails().getSignedUserDetails());
            this.markContactAsCertifiedByOwnKeycloak(certifiedJsonIdentityDetails);
            return;
        }
        if (this.certifiedByOwnKeycloak) {
            this.setCertifiedByOwnKeycloak(false, lastKnownSerializedCertifiedDetails);
        }
        if (this.trustedDetailsVersion != this.publishedDetailsVersion) {
            ContactIdentityDetails trustedDetails = this.getTrustedDetails();
            publishedDetails = this.getPublishedDetails();
            boolean same = publishedDetails.getJsonIdentityDetails().firstAndLastNamesAreTheSame(trustedDetails.getJsonIdentityDetails());
            if (same && this.trustedDetailsVersion != -1) {
                boolean bl = same = Objects.equals(trustedDetails.getPhotoServerLabel(), publishedDetails.getPhotoServerLabel()) && Objects.equals(trustedDetails.getPhotoServerKey(), publishedDetails.getPhotoServerKey());
            }
            if (same) {
                this.trustPublishedDetails();
            }
        }
    }

    public void setCertifiedByOwnKeycloak(boolean certifiedByOwnKeycloak, String lastKnownSerializedCertifiedDetails) throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactIdentity.setCertifiedByOwnKeycloak", "UPDATE contact_identity SET keycloak_managed = ?  WHERE identity = ?  AND owned_identity = ?;");){
            statement.setBoolean(1, certifiedByOwnKeycloak);
            statement.setBytes(2, this.contactIdentity.getBytes());
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.certifiedByOwnKeycloak = certifiedByOwnKeycloak;
            this.commitHookBits |= 0x40L;
            this.identityManagerSession.session.addSessionCommitListener(this);
            this.identityManagerSession.identityDelegate.rePingOrDemoteContactFromAllKeycloakGroups(this.identityManagerSession.session, this.ownedIdentity, this.contactIdentity, certifiedByOwnKeycloak, lastKnownSerializedCertifiedDetails);
        }
    }

    public void setOneToOne(boolean oneToOne) throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactIdentity.setOneToOne", "UPDATE contact_identity SET one_to_one = ?  WHERE identity = ?  AND owned_identity = ?;");){
            statement.setInt(1, oneToOne ? 1 : 0);
            statement.setBytes(2, this.contactIdentity.getBytes());
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            if (this.isOneToOne() != oneToOne) {
                this.commitHookBits |= 0x200L;
                this.identityManagerSession.session.addSessionCommitListener(this);
            }
            this.oneToOne = oneToOne ? 1 : 0;
        }
    }

    public void setRecentlyOnline(boolean recentlyOnline) throws SQLException {
        if (this.recentlyOnline != recentlyOnline) {
            try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactIdentity.setRecentlyOnline", "UPDATE contact_identity SET recently_online = ?  WHERE identity = ?  AND owned_identity = ?;");){
                statement.setBoolean(1, recentlyOnline);
                statement.setBytes(2, this.contactIdentity.getBytes());
                statement.setBytes(3, this.ownedIdentity.getBytes());
                statement.executeUpdate();
                this.recentlyOnline = recentlyOnline;
                this.commitHookBits |= 0x400L;
                this.identityManagerSession.session.addSessionCommitListener(this);
            }
        }
    }

    public void setRevokedAsCompromised(boolean revokedAsCompromised) throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactIdentity.setRevokedAsCompromised", "UPDATE contact_identity SET revoked_as_compromised = ?  WHERE identity = ?  AND owned_identity = ?;");){
            statement.setBoolean(1, revokedAsCompromised);
            statement.setBytes(2, this.contactIdentity.getBytes());
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            if (!this.revokedAsCompromised && revokedAsCompromised) {
                this.commitHookBits |= 0x100L;
            }
            this.revokedAsCompromised = revokedAsCompromised;
            this.commitHookBits |= 0x80L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
    }

    public void setForcefullyTrustedByUser(boolean forcefullyTrustedByUser) throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactIdentity.setForcefullyTrustedByUser", "UPDATE contact_identity SET forcefully_trusted_by_user = ?  WHERE identity = ?  AND owned_identity = ?;");){
            statement.setBoolean(1, forcefullyTrustedByUser);
            statement.setBytes(2, this.contactIdentity.getBytes());
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.forcefullyTrustedByUser = forcefullyTrustedByUser;
            this.commitHookBits |= 0x80L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
    }

    public void markContactAsCertifiedByOwnKeycloak(JsonIdentityDetails certifiedJsonIdentityDetails) throws SQLException {
        String keycloakServerUrl;
        ContactIdentityDetails publishedDetails;
        JsonIdentityDetails contactIdentityDetails;
        if (!this.identityManagerSession.session.isInTransaction()) {
            throw new SQLException("markContactAsCertifiedByOwnKeycloak can only be called from within a transaction");
        }
        if (!this.isCertifiedByOwnKeycloak()) {
            this.setCertifiedByOwnKeycloak(true, null);
        }
        if (this.trustedDetailsVersion != this.publishedDetailsVersion) {
            try {
                this.trustPublishedDetails();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!certifiedJsonIdentityDetails.equals(contactIdentityDetails = (publishedDetails = this.getPublishedDetails()).getJsonIdentityDetails())) {
            try {
                String serializedCertifiedIdentityDetails = this.identityManagerSession.jsonObjectMapper.writeValueAsString((Object)certifiedJsonIdentityDetails);
                publishedDetails.setSerializedJsonDetails(serializedCertifiedIdentityDetails);
                this.hookTrustedDetails = publishedDetails.getJsonIdentityDetailsWithVersionAndPhoto();
                this.commitHookBits |= 4L;
                this.identityManagerSession.session.addSessionCommitListener(this);
            }
            catch (JsonProcessingException serializedCertifiedIdentityDetails) {
                // empty catch block
            }
        }
        if ((keycloakServerUrl = this.identityManagerSession.identityDelegate.getOwnedIdentityKeycloakServerUrl(this.identityManagerSession.session, this.ownedIdentity)) != null) {
            this.addTrustOrigin(TrustOrigin.createKeycloakTrustOrigin(System.currentTimeMillis(), keycloakServerUrl));
        }
    }

    public static void unmarkAllCertifiedByOwnKeycloakContacts(IdentityManagerSession identityManagerSession, Identity ownedIdentity) throws SQLException {
        LinkedList<ContactIdentity> certifiedContacts = new LinkedList<ContactIdentity>();
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactIdentity.unmarkAllCertifiedByOwnKeycloakContacts", "SELECT * FROM  contact_identity WHERE keycloak_managed = ?  AND owned_identity = ?;");){
            statement.setBoolean(1, true);
            statement.setBytes(2, ownedIdentity.getBytes());
            try (ResultSet res = statement.executeQuery();){
                while (res.next()) {
                    certifiedContacts.add(new ContactIdentity(identityManagerSession, res));
                }
            }
        }
        for (ContactIdentity contactIdentity : certifiedContacts) {
            contactIdentity.setCertifiedByOwnKeycloak(false, null);
        }
    }

    public JsonIdentityDetailsWithVersionAndPhoto trustPublishedDetails() throws SQLException {
        if (this.trustedDetailsVersion == this.publishedDetailsVersion) {
            return null;
        }
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactIdentity.trustPublishedDetails", "UPDATE contact_identity SET trusted_details_version = ?  WHERE identity = ?  AND owned_identity = ?;");){
            statement.setInt(1, this.publishedDetailsVersion);
            statement.setBytes(2, this.contactIdentity.getBytes());
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.trustedDetailsVersion = this.publishedDetailsVersion;
        }
        this.hookTrustedDetails = this.getTrustedDetails().getJsonIdentityDetailsWithVersionAndPhoto();
        this.commitHookBits |= 4L;
        this.identityManagerSession.session.addSessionCommitListener(this);
        return this.hookTrustedDetails;
    }

    public void setDetailsDownloadedPhotoUrl(int version, byte[] photo) throws Exception {
        String randFileName;
        SecureFile dstPhotoFile;
        ContactIdentityDetails contactIdentityDetails = ContactIdentityDetails.get(this.identityManagerSession, this.contactIdentity, this.ownedIdentity, version);
        if (contactIdentityDetails == null) {
            return;
        }
        String fileName = "identity_photos" + File.separator + Logger.toHexString(Arrays.copyOfRange(this.contactIdentity.getBytes(), this.contactIdentity.getBytes().length - 32, this.contactIdentity.getBytes().length));
        Random random = new Random();
        while ((dstPhotoFile = new SecureFile(this.identityManagerSession.engineBaseDirectory, randFileName = fileName + "_" + random.nextInt(65536))).exists()) {
        }
        try (SecureFileOutputStream os = new SecureFileOutputStream(dstPhotoFile);){
            os.write(photo, 0, photo.length);
        }
        contactIdentityDetails.setPhotoUrl(randFileName);
        this.hookPhotoSetVersion = version;
        this.commitHookBits |= 0x10L;
        this.identityManagerSession.session.addSessionCommitListener(this);
    }

    public void addTrustOrigin(TrustOrigin newTrustOrigin) throws SQLException {
        ContactTrustOrigin contactTrustOrigin;
        if (!this.identityManagerSession.session.isInTransaction()) {
            Logger.e("Calling ContactIdentity.addTrustOrigin() outside a transaction");
            throw new SQLException();
        }
        if (newTrustOrigin.getType() != TrustOrigin.TYPE.DIRECT) {
            ContactTrustOrigin[] contactTrustOrigins;
            for (ContactTrustOrigin contactTrustOrigin2 : contactTrustOrigins = ContactTrustOrigin.getAll(this.identityManagerSession, this.contactIdentity, this.ownedIdentity)) {
                TrustOrigin other = contactTrustOrigin2.getTrustOrigin();
                if (!newTrustOrigin.equals(other)) continue;
                return;
            }
        }
        if ((contactTrustOrigin = ContactTrustOrigin.create(this.identityManagerSession, this.contactIdentity, this.ownedIdentity, newTrustOrigin)) == null) {
            Logger.e("Error create contactTrustOrigin in ContactIdentity.addTrustOrigin()");
            throw new SQLException();
        }
        TrustLevel newTrustLevel = contactTrustOrigin.getTrustLevel();
        if (newTrustLevel.compareTo(this.trustLevel) > 0) {
            this.setTrustLevel(newTrustLevel);
        }
    }

    private void setTrustLevel(TrustLevel trustLevel) throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactIdentity.setTrustLevel", "UPDATE contact_identity SET trust_level = ?  WHERE identity = ?  AND owned_identity = ?;");){
            statement.setString(1, trustLevel.toString());
            statement.setBytes(2, this.contactIdentity.getBytes());
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.trustLevel = trustLevel;
            this.commitHookBits |= 0x20L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
    }

    public void setLastContactDeviceDiscoveryTimestamp(long lastNoDeviceContactDeviceDiscovery) throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactIdentity.setLastContactDeviceDiscoveryTimestamp", "UPDATE contact_identity SET last_no_device_contact_device_discovery = ?  WHERE identity = ?  AND owned_identity = ?;");){
            statement.setLong(1, lastNoDeviceContactDeviceDiscovery);
            statement.setBytes(2, this.contactIdentity.getBytes());
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.lastNoDeviceContactDeviceDiscovery = lastNoDeviceContactDeviceDiscovery;
        }
    }

    public static ContactIdentity create(IdentityManagerSession identityManagerSession, Identity contactIdentity, Identity ownedIdentity, JsonIdentityDetailsWithVersionAndPhoto jsonIdentityDetailsWithVersionAndPhoto, TrustOrigin trustOrigin, boolean revokedAsCompromised, boolean oneToOne) {
        if (contactIdentity == null || ownedIdentity == null || jsonIdentityDetailsWithVersionAndPhoto == null) {
            return null;
        }
        try {
            if (!identityManagerSession.session.isInTransaction()) {
                Logger.e("Calling ContactIdentity.create() outside a transaction");
                throw new SQLException();
            }
            ContactIdentityDetails contactIdentityDetails = ContactIdentityDetails.create(identityManagerSession, contactIdentity, ownedIdentity, jsonIdentityDetailsWithVersionAndPhoto);
            if (contactIdentityDetails == null) {
                Logger.e("Error create contactIdentityDetails in ContactIdentity.create()");
                throw new SQLException();
            }
            ContactIdentity contactIdentityObject = new ContactIdentity(identityManagerSession, contactIdentity, ownedIdentity, contactIdentityDetails.getVersion(), new TrustLevel(0, 0), oneToOne ? 1 : 2);
            contactIdentityObject.revokedAsCompromised = revokedAsCompromised;
            contactIdentityObject.insert();
            JsonKeycloakUserDetails jsonKeycloakUserDetails = identityManagerSession.identityDelegate.verifyKeycloakIdentitySignature(identityManagerSession.session, ownedIdentity, jsonIdentityDetailsWithVersionAndPhoto.getIdentityDetails().getSignedUserDetails());
            if (jsonKeycloakUserDetails != null) {
                try {
                    JsonIdentityDetails certifiedJsonIdentityDetails = jsonKeycloakUserDetails.getIdentityDetails(jsonIdentityDetailsWithVersionAndPhoto.getIdentityDetails().getSignedUserDetails());
                    contactIdentityObject.markContactAsCertifiedByOwnKeycloak(certifiedJsonIdentityDetails);
                }
                catch (Exception e) {
                    Logger.x(e);
                }
            }
            if (trustOrigin != null) {
                ContactTrustOrigin contactTrustOrigin = ContactTrustOrigin.create(identityManagerSession, contactIdentity, ownedIdentity, trustOrigin);
                if (contactTrustOrigin == null) {
                    Logger.e("Error create contactTrustOrigin in ContactIdentity.create()");
                    throw new SQLException();
                }
                contactIdentityObject.setTrustLevel(contactTrustOrigin.getTrustLevel());
            } else {
                contactIdentityObject.setTrustLevel(new TrustLevel(0, 0));
            }
            return contactIdentityObject;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public ContactIdentity(IdentityManagerSession identityManagerSession, Identity contactIdentity, Identity ownedIdentity, int version, TrustLevel trustLevel, int oneToOne) {
        this.identityManagerSession = identityManagerSession;
        this.contactIdentity = contactIdentity;
        this.ownedIdentity = ownedIdentity;
        this.trustedDetailsVersion = version;
        this.publishedDetailsVersion = version;
        this.trustLevel = trustLevel;
        this.certifiedByOwnKeycloak = false;
        this.revokedAsCompromised = false;
        this.forcefullyTrustedByUser = false;
        this.oneToOne = oneToOne;
        this.lastNoDeviceContactDeviceDiscovery = 0L;
        this.recentlyOnline = true;
    }

    private ContactIdentity(IdentityManagerSession identityManagerSession, ResultSet res) throws SQLException {
        this.identityManagerSession = identityManagerSession;
        try {
            this.contactIdentity = Identity.of(res.getBytes(CONTACT_IDENTITY));
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        this.trustedDetailsVersion = res.getInt(TRUSTED_DETAILS_VERSION);
        this.publishedDetailsVersion = res.getInt(PUBLISHED_DETAILS_VERSION);
        this.trustLevel = TrustLevel.of(res.getString(TRUST_LEVEL));
        this.certifiedByOwnKeycloak = res.getBoolean(CERTIFIED_BY_OWN_KEYCLOAK);
        this.revokedAsCompromised = res.getBoolean(REVOKED_AS_COMPROMISED);
        this.forcefullyTrustedByUser = res.getBoolean(FORCEFULLY_TRUSTED_BY_USER);
        this.oneToOne = res.getInt(ONE_TO_ONE);
        this.lastNoDeviceContactDeviceDiscovery = res.getLong(LAST_CONTACT_DEVICE_DISCOVERY);
        this.recentlyOnline = res.getBoolean(RECENTLY_ONLINE);
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS contact_identity (identity BLOB NOT NULL, owned_identity BLOB NOT NULL, trusted_details_version INT NOT NULL, published_details_version INT NOT NULL, trust_level TEXT NOT NULL, keycloak_managed BIT NOT NULL, revoked_as_compromised BIT NOT NULL, forcefully_trusted_by_user BIT NOT NULL, one_to_one BIT NOT NULL, last_no_device_contact_device_discovery INTEGER NOT NULL, recently_online BIT NOT NULL DEFAULT 1,  CONSTRAINT PK_contact_identity PRIMARY KEY(identity, owned_identity),  FOREIGN KEY (owned_identity) REFERENCES owned_identity(identity) ON DELETE CASCADE,  FOREIGN KEY (identity, owned_identity, trusted_details_version) REFERENCES contact_identity_details(contact_identity, owned_identity, version),  FOREIGN KEY (identity, owned_identity, published_details_version) REFERENCES contact_identity_details(contact_identity, owned_identity, version));");
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        block128: {
            block127: {
                if (oldVersion >= 6 || newVersion < 6) break block127;
                statement = session.createStatement();
                try {
                    statement.execute("ALTER TABLE contact_identity RENAME TO old_contact_identity");
                    statement.execute("CREATE TABLE IF NOT EXISTS contact_identity_details ( contact_identity BLOB NOT NULL,  owned_identity BLOB NOT NULL,  version INT NOT NULL,  serialized_json_details TEXT NOT NULL,  photo_url TEXT,  photo_server_label BLOB,  photo_server_key BLOB,  CONSTRAINT PK_contact_identity_details PRIMARY KEY(contact_identity, owned_identity, version));");
                    statement.execute("CREATE TABLE IF NOT EXISTS contact_identity ( identity BLOB NOT NULL,  owned_identity BLOB NOT NULL,  trusted_details_version INT NOT NULL,  published_details_version INT NOT NULL,  encoded_trust_origins BLOB NOT NULL,  CONSTRAINT PK_contact_identity PRIMARY KEY(identity, owned_identity),  FOREIGN KEY (owned_identity) REFERENCES owned_identity(identity), FOREIGN KEY (identity, owned_identity, trusted_details_version) REFERENCES contact_identity_details(contact_identity, owned_identity, version), FOREIGN KEY (identity, owned_identity, published_details_version) REFERENCES contact_identity_details(contact_identity, owned_identity, version));");
                    objectMapper = new ObjectMapper();
                    res = statement.executeQuery("SELECT * FROM old_contact_identity");
lbl12:
                    // 2 sources

                    try {
                        while (res.next()) {
                            preparedStatement = session.prepareStatement("INSERT INTO contact_identity VALUES (?,?,?,?,?);");
                            try {
                                preparedStatement.setBytes(1, res.getBytes(1));
                                preparedStatement.setBytes(2, res.getBytes(2));
                                preparedStatement.setInt(3, 0);
                                preparedStatement.setInt(4, 0);
                                preparedStatement.setBytes(5, res.getBytes(5));
                                preparedStatement.executeUpdate();
                            }
                            finally {
                                if (preparedStatement != null) {
                                    preparedStatement.close();
                                }
                            }
                            preparedStatement = session.prepareStatement("INSERT INTO contact_identity_details VALUES (?,?,?,?,?, ?,?);");
                            preparedStatement.setBytes(1, res.getBytes(1));
                            preparedStatement.setBytes(2, res.getBytes(2));
                            preparedStatement.setInt(3, 0);
                            map = new HashMap<K, V>();
                            map.put("first_name", res.getString(3));
                            try {
                                preparedStatement.setString(4, objectMapper.writeValueAsString((Object)map));
                            }
                            catch (Exception e) {
                                Logger.x(e);
                                if (preparedStatement == null) continue;
                                preparedStatement.close();
                                continue;
                            }
                            try {
                                preparedStatement.setString(5, null);
                                preparedStatement.setBytes(6, null);
                                preparedStatement.setBytes(7, null);
                                preparedStatement.executeUpdate();
                            }
                            finally {
                                if (preparedStatement == null) ** GOTO lbl12
                                preparedStatement.close();
                            }
                        }
                    }
                    finally {
                        if (res != null) {
                            res.close();
                        }
                    }
                    statement.execute("DROP TABLE old_contact_identity");
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
                oldVersion = 6;
            }
            if (oldVersion >= 9 || newVersion < 9) break block128;
            statement = session.createStatement();
            try {
                block120: {
                    statement.execute("ALTER TABLE contact_identity RENAME TO old_contact_identity");
                    statement.execute("CREATE TABLE IF NOT EXISTS contact_identity ( identity BLOB NOT NULL,  owned_identity BLOB NOT NULL,  trusted_details_version INT NOT NULL,  published_details_version INT NOT NULL,  trust_level TEXT NOT NULL,  CONSTRAINT PK_contact_identity PRIMARY KEY(identity, owned_identity),  FOREIGN KEY (owned_identity) REFERENCES owned_identity(identity), FOREIGN KEY (identity, owned_identity, trusted_details_version) REFERENCES contact_identity_details(contact_identity, owned_identity, version), FOREIGN KEY (identity, owned_identity, published_details_version) REFERENCES contact_identity_details(contact_identity, owned_identity, version));");
                    statement.execute("CREATE TABLE IF NOT EXISTS contact_trust_origin (row_id INTEGER PRIMARY KEY AUTOINCREMENT, contact_identity BLOB NOT NULL, owned_identity BLOB NOT NULL, timestamp INTEGER NOT NULL, trust_type INTEGER NOT NULL, mediator_or_group_owner_identity BLOB, mediator_or_group_owner_trust_level_major INTEGER, identity_server TEXT,  FOREIGN KEY (contact_identity, owned_identity ) REFERENCES contact_identity(identity, owned_identity) ON DELETE CASCADE);");
                    res = statement.executeQuery("SELECT * FROM old_contact_identity");
                    block88: while (true) {
                        while (res.next()) {
                            try {
                                encodeds = new Encoded(res.getBytes(5));
                                maxTL = 0;
lbl90:
                                // 6 sources

                                for (Encoded encoded : encodeds.decodeList()) {
                                    try {
                                        listOfEncoded = encoded.decodeList();
                                        if (listOfEncoded.length == 0) continue;
                                        type = (int)listOfEncoded[0].decodeLong();
                                        switch (type) {
                                            case 0: {
                                                if (listOfEncoded.length != 2) break;
                                                preparedStatement = session.prepareStatement("INSERT INTO contact_trust_origin(contact_identity,owned_identity,timestamp,trust_type,mediator_or_group_owner_identity,mediator_or_group_owner_trust_level_major,identity_server) VALUES (?,?,?,?,?,?,?);");
                                                try {
                                                    preparedStatement.setBytes(1, res.getBytes(1));
                                                    preparedStatement.setBytes(2, res.getBytes(2));
                                                    preparedStatement.setLong(3, listOfEncoded[1].decodeLong());
                                                    preparedStatement.setInt(4, 1);
                                                    preparedStatement.setBytes(5, null);
                                                    preparedStatement.setNull(6, 4);
                                                    preparedStatement.setString(7, null);
                                                    preparedStatement.executeUpdate();
                                                }
                                                finally {
                                                    if (preparedStatement != null) {
                                                        preparedStatement.close();
                                                    }
                                                }
                                                if (maxTL < 4) {
                                                    maxTL = 4;
                                                    break;
                                                }
                                                ** GOTO lbl90
                                            }
                                            case 1: {
                                                if (listOfEncoded.length != 3) break;
                                                preparedStatement = session.prepareStatement("INSERT INTO contact_trust_origin(contact_identity,owned_identity,timestamp,trust_type,mediator_or_group_owner_identity,mediator_or_group_owner_trust_level_major,identity_server) VALUES (?,?,?,?,?,?,?);");
                                                try {
                                                    preparedStatement.setBytes(1, res.getBytes(1));
                                                    preparedStatement.setBytes(2, res.getBytes(2));
                                                    preparedStatement.setLong(3, listOfEncoded[1].decodeLong());
                                                    preparedStatement.setInt(4, 2);
                                                    preparedStatement.setBytes(5, listOfEncoded[2].decodeBytes());
                                                    preparedStatement.setInt(6, 4);
                                                    preparedStatement.setString(7, null);
                                                    preparedStatement.executeUpdate();
                                                }
                                                finally {
                                                    if (preparedStatement != null) {
                                                        preparedStatement.close();
                                                    }
                                                }
                                                if (maxTL < 2) {
                                                    maxTL = 2;
                                                    break;
                                                }
                                                ** GOTO lbl90
                                            }
                                            case 2: {
                                                if (listOfEncoded.length != 4) break;
                                                preparedStatement = session.prepareStatement("INSERT INTO contact_trust_origin(contact_identity,owned_identity,timestamp,trust_type,mediator_or_group_owner_identity,mediator_or_group_owner_trust_level_major,identity_server) VALUES (?,?,?,?,?,?,?);");
                                                try {
                                                    preparedStatement.setBytes(1, res.getBytes(1));
                                                    preparedStatement.setBytes(2, res.getBytes(2));
                                                    preparedStatement.setLong(3, listOfEncoded[1].decodeLong());
                                                    preparedStatement.setInt(4, 3);
                                                    preparedStatement.setBytes(5, listOfEncoded[2].decodeBytes());
                                                    preparedStatement.setInt(6, 4);
                                                    preparedStatement.setString(7, null);
                                                    preparedStatement.executeUpdate();
                                                }
                                                finally {
                                                    if (preparedStatement != null) {
                                                        preparedStatement.close();
                                                    }
                                                }
                                                if (maxTL < 2) {
                                                    maxTL = 2;
                                                } else {
                                                    break;
                                                }
                                            }
                                        }
                                    }
                                    catch (DecodingException var11_40) {
                                        // empty catch block
                                    }
                                }
                                preparedStatement = session.prepareStatement("INSERT INTO contact_identity VALUES (?,?,?,?,?);");
                                try {
                                    preparedStatement.setBytes(1, res.getBytes(1));
                                    preparedStatement.setBytes(2, res.getBytes(2));
                                    preparedStatement.setInt(3, res.getInt(3));
                                    preparedStatement.setInt(4, res.getInt(4));
                                    if (maxTL == 4) {
                                        preparedStatement.setString(5, "4.0");
                                    } else if (maxTL == 2) {
                                        preparedStatement.setString(5, "2.4");
                                    } else {
                                        preparedStatement.setString(5, "0.0");
                                    }
                                    preparedStatement.executeUpdate();
                                    continue block88;
                                }
                                finally {
                                    if (preparedStatement != null) {
                                        preparedStatement.close();
                                    }
                                    continue block88;
                                }
                            }
                            catch (DecodingException var5_14) {
                            }
                        }
                        break block120;
                        {
                            continue block88;
                            break;
                        }
                        break;
                    }
                    finally {
                        if (res != null) {
                            res.close();
                        }
                    }
                }
                statement.execute("DROP TABLE old_contact_identity");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 9;
        }
        if (oldVersion < 20 && newVersion >= 20) {
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE contact_identity ADD COLUMN keycloak_managed BIT NOT NULL DEFAULT 0");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 20;
        }
        if (oldVersion < 25 && newVersion >= 25) {
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE contact_identity ADD COLUMN revoked_as_compromised BIT NOT NULL DEFAULT 0");
                statement.execute("ALTER TABLE contact_identity ADD COLUMN forcefully_trusted_by_user BIT NOT NULL DEFAULT 0");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 25;
        }
        if (oldVersion < 28 && newVersion >= 28) {
            statement = session.createStatement();
            try {
                Logger.d("MIGRATING `contact_identity` TABLE FROM VERSION " + oldVersion + " TO 28");
                statement.execute("ALTER TABLE contact_identity ADD COLUMN one_to_one BIT NOT NULL DEFAULT 1");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 28;
        }
        if (oldVersion < 35 && newVersion >= 35) {
            statement = session.createStatement();
            try {
                Logger.d("MIGRATING `contact_identity` TABLE FROM VERSION " + oldVersion + " TO 35");
                statement.execute("ALTER TABLE contact_identity ADD COLUMN last_no_device_contact_device_discovery INTEGER NOT NULL DEFAULT 0");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 35;
        }
        if (oldVersion < 41 && newVersion >= 41) {
            Logger.d("MIGRATING `contact_identity` DATABASE FROM VERSION " + oldVersion + " TO 41");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE contact_identity ADD COLUMN `recently_online` BIT NOT NULL DEFAULT 1");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 41;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactIdentity.insert", "INSERT INTO contact_identity VALUES (?,?,?,?,?, ?,?,?,?,?, ?);");){
            statement.setBytes(1, this.contactIdentity.getBytes());
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.setInt(3, this.trustedDetailsVersion);
            statement.setInt(4, this.publishedDetailsVersion);
            statement.setString(5, this.trustLevel.toString());
            statement.setBoolean(6, this.certifiedByOwnKeycloak);
            statement.setBoolean(7, this.revokedAsCompromised);
            statement.setBoolean(8, this.forcefullyTrustedByUser);
            statement.setInt(9, this.oneToOne);
            statement.setLong(10, this.lastNoDeviceContactDeviceDiscovery);
            statement.setBoolean(11, this.recentlyOnline);
            statement.executeUpdate();
            this.commitHookBits |= 1L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
    }

    @Override
    public void delete() throws SQLException {
        if (!this.identityManagerSession.session.isInTransaction()) {
            Logger.e("Running ContactIdentity delete outside a transaction");
            throw new SQLException();
        }
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactIdentity.delete", "DELETE FROM contact_identity WHERE identity = ?  AND owned_identity = ?;");){
            statement.setBytes(1, this.contactIdentity.getBytes());
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.commitHookBits |= 2L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
        statement = this.identityManagerSession.session.prepareStatement("ContactIdentity.delete", "DELETE FROM contact_identity_details WHERE contact_identity = ?  AND owned_identity = ?;");
        try {
            statement.setBytes(1, this.contactIdentity.getBytes());
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.executeUpdate();
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    public static ContactIdentity get(IdentityManagerSession identityManagerSession, Identity ownedIdentity, Identity contactIdentity) throws SQLException {
        if (contactIdentity == null || ownedIdentity == null) {
            return null;
        }
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactIdentity.get", "SELECT * FROM contact_identity WHERE identity = ? AND owned_identity = ?;");){
            ContactIdentity contactIdentity2;
            block17: {
                ResultSet res;
                block15: {
                    ContactIdentity contactIdentity3;
                    block16: {
                        statement.setBytes(1, contactIdentity.getBytes());
                        statement.setBytes(2, ownedIdentity.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block15;
                            contactIdentity3 = new ContactIdentity(identityManagerSession, res);
                            if (res == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return contactIdentity3;
                }
                contactIdentity2 = null;
                if (res == null) break block17;
                res.close();
            }
            return contactIdentity2;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ContactIdentity[] getAll(IdentityManagerSession identityManagerSession, Identity ownedIdentity) {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactIdentity.getAll", "SELECT * FROM contact_identity WHERE owned_identity = ?;");){
            ContactIdentity[] contactIdentityArray;
            block15: {
                statement.setBytes(1, ownedIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ContactIdentity> list = new ArrayList<ContactIdentity>();
                    while (res.next()) {
                        list.add(new ContactIdentity(identityManagerSession, res));
                    }
                    contactIdentityArray = list.toArray(new ContactIdentity[0]);
                    if (res == null) break block15;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return contactIdentityArray;
        }
        catch (SQLException e) {
            return new ContactIdentity[0];
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<ContactIdentity> getAllCertifiedByKeycloak(IdentityManagerSession identityManagerSession, Identity ownedIdentity) {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactIdentity.getAllCertifiedByKeycloak", "SELECT * FROM contact_identity WHERE owned_identity = ?  AND keycloak_managed = 1;");){
            ArrayList<ContactIdentity> arrayList;
            block15: {
                statement.setBytes(1, ownedIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ContactIdentity> list = new ArrayList<ContactIdentity>();
                    while (res.next()) {
                        list.add(new ContactIdentity(identityManagerSession, res));
                    }
                    arrayList = list;
                    if (res == null) break block15;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            return new ArrayList<ContactIdentity>();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ContactIdentity[] getAllForAllOwnedIdentities(IdentityManagerSession identityManagerSession) {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactIdentity.getAllForAllOwnedIdentities", "SELECT * FROM contact_identity");){
            ContactIdentity[] contactIdentityArray;
            block15: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ContactIdentity> list = new ArrayList<ContactIdentity>();
                    while (res.next()) {
                        list.add(new ContactIdentity(identityManagerSession, res));
                    }
                    contactIdentityArray = list.toArray(new ContactIdentity[0]);
                    if (res == null) break block15;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return contactIdentityArray;
        }
        catch (SQLException e) {
            return new ContactIdentity[0];
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ContactIdentity[] getAllActiveWithoutDevices(IdentityManagerSession identityManagerSession, long timestamp) {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactIdentity.getAllActiveWithoutDevices", "SELECT * FROM contact_identity AS c WHERE  (c.revoked_as_compromised = 0 OR c.forcefully_trusted_by_user = 1)  AND c.last_no_device_contact_device_discovery < ?  AND NOT EXISTS ( SELECT 1 FROM contact_device WHERE contact_identity = c.identity AND owned_identity = c.owned_identity)");){
            ContactIdentity[] contactIdentityArray;
            block15: {
                statement.setLong(1, timestamp);
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ContactIdentity> list = new ArrayList<ContactIdentity>();
                    while (res.next()) {
                        list.add(new ContactIdentity(identityManagerSession, res));
                    }
                    contactIdentityArray = list.toArray(new ContactIdentity[0]);
                    if (res == null) break block15;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return contactIdentityArray;
        }
        catch (SQLException e) {
            return new ContactIdentity[0];
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ContactIdentity[] getAllInactiveWithDevices(IdentityManagerSession identityManagerSession) {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactIdentity.getAllInactiveWithDevices", "SELECT * FROM contact_identity AS c WHERE  (c.revoked_as_compromised = 1 AND c.forcefully_trusted_by_user = 0)  AND EXISTS ( SELECT 1 FROM contact_device WHERE contact_identity = c.identity AND owned_identity = c.owned_identity)");){
            ContactIdentity[] contactIdentityArray;
            block15: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ContactIdentity> list = new ArrayList<ContactIdentity>();
                    while (res.next()) {
                        list.add(new ContactIdentity(identityManagerSession, res));
                    }
                    contactIdentityArray = list.toArray(new ContactIdentity[0]);
                    if (res == null) break block15;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return contactIdentityArray;
        }
        catch (SQLException e) {
            return new ContactIdentity[0];
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ContactIdentity[] getAllActiveWithDevicesAndOldDiscovery(IdentityManagerSession identityManagerSession, long timestamp) {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactIdentity.getAllActiveWithDevicesAndOldDiscovery", "SELECT * FROM contact_identity AS c WHERE  (c.revoked_as_compromised = 0 OR c.forcefully_trusted_by_user = 1)  AND c.last_no_device_contact_device_discovery < ?  AND EXISTS ( SELECT 1 FROM contact_device WHERE contact_identity = c.identity AND owned_identity = c.owned_identity)");){
            ContactIdentity[] contactIdentityArray;
            block15: {
                statement.setLong(1, timestamp);
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ContactIdentity> list = new ArrayList<ContactIdentity>();
                    while (res.next()) {
                        list.add(new ContactIdentity(identityManagerSession, res));
                    }
                    contactIdentityArray = list.toArray(new ContactIdentity[0]);
                    if (res == null) break block15;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return contactIdentityArray;
        }
        catch (SQLException e) {
            return new ContactIdentity[0];
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getSerializedPublishedDetails(IdentityManagerSession identityManagerSession, Identity ownedIdentity, Identity contactIdentity) {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactIdentity.getSerializedPublishedDetails", "SELECT details.serialized_json_details FROM contact_identity AS contact  INNER JOIN contact_identity_details AS details  ON contact.owned_identity = details.owned_identity AND contact.identity = details.contact_identity AND contact.published_details_version = details.version WHERE contact.owned_identity = ?  AND contact.identity = ?;");){
            String string;
            block18: {
                ResultSet res;
                block16: {
                    String string2;
                    block17: {
                        statement.setBytes(1, ownedIdentity.getBytes());
                        statement.setBytes(2, contactIdentity.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block16;
                            string2 = res.getString(1);
                            if (res == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return string2;
                }
                string = null;
                if (res == null) break block18;
                res.close();
            }
            return string;
        }
        catch (SQLException e) {
            return null;
        }
    }

    @Override
    public void wasCommitted() {
        HashMap<String, Object> userInfo;
        if ((this.commitHookBits & 1L) != 0L) {
            userInfo = new HashMap<String, Object>();
            userInfo.put(TABLE_NAME, this.contactIdentity);
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            userInfo.put(CERTIFIED_BY_OWN_KEYCLOAK, this.certifiedByOwnKeycloak);
            userInfo.put("active", this.isActive());
            userInfo.put(ONE_TO_ONE, this.isOneToOne());
            userInfo.put(TRUST_LEVEL, this.trustLevel.major);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_new_contact_identity", userInfo);
        }
        if ((this.commitHookBits & 2L) != 0L) {
            userInfo = new HashMap();
            userInfo.put(TABLE_NAME, this.contactIdentity);
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_contact_identity_deleted", userInfo);
        }
        if ((this.commitHookBits & 8L) != 0L && (this.commitHookBits & 4L) == 0L) {
            userInfo = new HashMap();
            userInfo.put(TABLE_NAME, this.contactIdentity);
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_new_contact_published_details", userInfo);
        }
        if ((this.commitHookBits & 4L) != 0L) {
            userInfo = new HashMap();
            userInfo.put(TABLE_NAME, this.contactIdentity);
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            userInfo.put("identity_details", this.hookTrustedDetails);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_contact_trusted_details_updated", userInfo);
        }
        if ((this.commitHookBits & 0x10L) != 0L) {
            userInfo = new HashMap();
            userInfo.put(TABLE_NAME, this.contactIdentity);
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            userInfo.put("version", this.hookPhotoSetVersion);
            userInfo.put("is_trusted", this.hookPhotoSetVersion == this.trustedDetailsVersion);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_contact_photo_set", userInfo);
        }
        if ((this.commitHookBits & 0x20L) != 0L) {
            userInfo = new HashMap();
            userInfo.put(TABLE_NAME, this.contactIdentity);
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            userInfo.put(TRUST_LEVEL, this.trustLevel);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_contact_trust_level_increased", userInfo);
        }
        if ((this.commitHookBits & 0x40L) != 0L) {
            userInfo = new HashMap();
            userInfo.put(TABLE_NAME, this.contactIdentity);
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            userInfo.put(CERTIFIED_BY_OWN_KEYCLOAK, this.certifiedByOwnKeycloak);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_contact_keycloak_managed_changed", userInfo);
        }
        if ((this.commitHookBits & 0x80L) != 0L) {
            userInfo = new HashMap();
            userInfo.put(TABLE_NAME, this.contactIdentity);
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            userInfo.put("active", this.isActive());
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_contact_active_changed", userInfo);
        }
        if ((this.commitHookBits & 0x100L) != 0L) {
            userInfo = new HashMap();
            userInfo.put(TABLE_NAME, this.contactIdentity);
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_contact_revoked", userInfo);
        }
        if ((this.commitHookBits & 0x200L) != 0L) {
            userInfo = new HashMap();
            userInfo.put(TABLE_NAME, this.contactIdentity);
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            userInfo.put(ONE_TO_ONE, this.isOneToOne());
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_contact_one_to_one_changed", userInfo);
        }
        if ((this.commitHookBits & 0x400L) != 0L) {
            userInfo = new HashMap();
            userInfo.put(TABLE_NAME, this.contactIdentity);
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            userInfo.put(RECENTLY_ONLINE, this.recentlyOnline);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_contact_recently_online_changed", userInfo);
        }
        this.commitHookBits = 0L;
    }

    public static Pojo_0[] backupAll(IdentityManagerSession identityManagerSession, Identity ownedIdentity) throws SQLException {
        ContactIdentity[] contactIdentities = ContactIdentity.getAll(identityManagerSession, ownedIdentity);
        Pojo_0[] pojos = new Pojo_0[contactIdentities.length];
        for (int i = 0; i < contactIdentities.length; ++i) {
            pojos[i] = contactIdentities[i].backup();
        }
        return pojos;
    }

    public static void restoreAll(IdentityManagerSession identityManagerSession, Identity ownedIdentity, Pojo_0[] pojos, long backupTimestamp) throws SQLException {
        if (pojos == null) {
            return;
        }
        for (Pojo_0 pojo : pojos) {
            ContactIdentity.restoreContact(identityManagerSession, ownedIdentity, pojo);
        }
        for (Pojo_0 pojo : pojos) {
            ContactIdentity.restoreContactGroups(identityManagerSession, ownedIdentity, pojo, backupTimestamp);
        }
    }

    Pojo_0 backup() throws SQLException {
        Pojo_0 pojo = new Pojo_0();
        pojo.contact_identity = this.contactIdentity.getBytes();
        pojo.trusted_details = this.getTrustedDetails().backup();
        if (this.publishedDetailsVersion != this.trustedDetailsVersion) {
            pojo.published_details = this.getPublishedDetails().backup();
        }
        pojo.trust_level = this.trustLevel.toString();
        pojo.revoked = this.revokedAsCompromised;
        pojo.forcefully_trusted = this.forcefullyTrustedByUser;
        switch (this.oneToOne) {
            case 1: {
                pojo.one_to_one = true;
                break;
            }
            case 0: {
                pojo.one_to_one = false;
                break;
            }
            default: {
                pojo.one_to_one = null;
            }
        }
        pojo.trust_origins = ContactTrustOrigin.backupAll(this.identityManagerSession, this.ownedIdentity, this.contactIdentity);
        pojo.contact_groups = ContactGroup.backupAllForOwner(this.identityManagerSession, this.ownedIdentity, this.contactIdentity);
        return pojo;
    }

    private static void restoreContact(IdentityManagerSession identityManagerSession, Identity ownedIdentity, Pojo_0 pojo) throws SQLException {
        Identity contactIdentity = null;
        try {
            contactIdentity = Identity.of(pojo.contact_identity);
        }
        catch (DecodingException e) {
            Logger.e("Error recreating ContactIdentity from backup!");
            Logger.x(e);
        }
        if (contactIdentity == null) {
            return;
        }
        identityManagerSession.session.startTransaction();
        ContactIdentityDetails trusted_details = ContactIdentityDetails.restore(identityManagerSession, ownedIdentity, contactIdentity, pojo.trusted_details);
        ContactIdentityDetails published_details = null;
        if (pojo.published_details != null && pojo.published_details.version != pojo.trusted_details.version) {
            published_details = ContactIdentityDetails.restore(identityManagerSession, ownedIdentity, contactIdentity, pojo.published_details);
        }
        ContactIdentity contactIdentityObject = new ContactIdentity(identityManagerSession, contactIdentity, ownedIdentity, trusted_details.getVersion(), TrustLevel.of(pojo.trust_level), pojo.one_to_one == null ? 2 : (pojo.one_to_one != false ? 1 : 0));
        if (published_details != null) {
            contactIdentityObject.publishedDetailsVersion = published_details.getVersion();
        }
        contactIdentityObject.revokedAsCompromised = pojo.revoked;
        contactIdentityObject.forcefullyTrustedByUser = pojo.forcefully_trusted;
        contactIdentityObject.insert();
        JsonKeycloakUserDetails jsonKeycloakUserDetails = identityManagerSession.identityDelegate.verifyKeycloakIdentitySignature(identityManagerSession.session, ownedIdentity, trusted_details.getJsonIdentityDetailsWithVersionAndPhoto().getIdentityDetails().getSignedUserDetails());
        if (jsonKeycloakUserDetails != null) {
            contactIdentityObject.setCertifiedByOwnKeycloak(true, null);
        }
        ContactTrustOrigin.restoreAll(identityManagerSession, ownedIdentity, contactIdentity, pojo.trust_origins);
        identityManagerSession.session.commit();
    }

    private static void restoreContactGroups(IdentityManagerSession identityManagerSession, Identity ownedIdentity, Pojo_0 pojo, long backupTimestamp) throws SQLException {
        Identity contactIdentity = null;
        try {
            contactIdentity = Identity.of(pojo.contact_identity);
        }
        catch (DecodingException e) {
            Logger.e("Error recreating ContactIdentityGroups from backup!");
            Logger.x(e);
        }
        if (contactIdentity == null) {
            return;
        }
        ContactGroup.restoreAllForOwner(identityManagerSession, ownedIdentity, contactIdentity, pojo.contact_groups, backupTimestamp);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Pojo_0 {
        public byte[] contact_identity;
        public ContactIdentityDetails.Pojo_0 trusted_details;
        public ContactIdentityDetails.Pojo_0 published_details;
        public String trust_level;
        public boolean revoked;
        public boolean forcefully_trusted;
        public Boolean one_to_one;
        public ContactTrustOrigin.Pojo_0[] trust_origins;
        public ContactGroup.Pojo_0[] contact_groups;
    }
}

