/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity.databases;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.JsonGroupDetails;
import io.olvid.engine.engine.types.JsonGroupDetailsWithVersionAndPhoto;
import io.olvid.engine.identity.databases.ServerUserData;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ContactGroupDetails
implements ObvDatabase {
    static final String TABLE_NAME = "contact_group_details";
    private final IdentityManagerSession identityManagerSession;
    private byte[] groupOwnerAndUid;
    static final String GROUP_OWNER_AND_UID = "group_owner_and_uid";
    private Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private int version;
    static final String VERSION = "version";
    private String serializedJsonDetails;
    static final String SERIALIZED_JSON_DETAILS = "serialized_json_details";
    private String photoUrl;
    static final String PHOTO_URL = "photo_url";
    private UID photoServerLabel;
    static final String PHOTO_SERVER_LABEL = "photo_server_label";
    private AuthEncKey photoServerKey;
    static final String PHOTO_SERVER_KEY = "photo_server_key";

    public byte[] getGroupOwnerAndUid() {
        return this.groupOwnerAndUid;
    }

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public int getVersion() {
        return this.version;
    }

    public String getSerializedJsonDetails() {
        return this.serializedJsonDetails;
    }

    public JsonGroupDetails getJsonGroupDetails() {
        try {
            return (JsonGroupDetails)this.identityManagerSession.jsonObjectMapper.readValue(this.serializedJsonDetails, JsonGroupDetails.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public JsonGroupDetailsWithVersionAndPhoto getJsonGroupDetailsWithVersionAndPhoto() {
        try {
            JsonGroupDetailsWithVersionAndPhoto json = new JsonGroupDetailsWithVersionAndPhoto();
            json.setGroupDetails((JsonGroupDetails)this.identityManagerSession.jsonObjectMapper.readValue(this.serializedJsonDetails, JsonGroupDetails.class));
            json.setVersion(this.version);
            json.setPhotoUrl(this.photoUrl);
            if (this.photoServerLabel != null && this.photoServerKey != null) {
                json.setPhotoServerLabel(this.photoServerLabel.getBytes());
                json.setPhotoServerKey(Encoded.of(this.photoServerKey).getBytes());
            }
            return json;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getPhotoUrl() {
        return this.photoUrl;
    }

    public UID getPhotoServerLabel() {
        return this.photoServerLabel;
    }

    public AuthEncKey getPhotoServerKey() {
        return this.photoServerKey;
    }

    public static void cleanup(IdentityManagerSession identityManagerSession, Identity ownedIdentity, byte[] groupOwnerAndUid, int publishedVersion, int latestOrTrustedVersion) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupDetails.cleanup", "DELETE FROM contact_group_details WHERE owned_identity = ?  AND group_owner_and_uid = ?  AND version NOT IN (?,?);");){
            statement.setBytes(1, ownedIdentity.getBytes());
            statement.setBytes(2, groupOwnerAndUid);
            statement.setInt(3, publishedVersion);
            statement.setInt(4, latestOrTrustedVersion);
            statement.executeUpdate();
        }
    }

    public void setJsonDetails(JsonGroupDetails jsonGroupDetails) throws Exception {
        if (jsonGroupDetails == null) {
            throw new Exception();
        }
        String serializedJsonDetails = this.identityManagerSession.jsonObjectMapper.writeValueAsString((Object)jsonGroupDetails);
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroupDetails.setJsonDetails", "UPDATE contact_group_details SET serialized_json_details = ?  WHERE group_owner_and_uid = ?  AND owned_identity = ?  AND version = ?;");){
            statement.setString(1, serializedJsonDetails);
            statement.setBytes(2, this.groupOwnerAndUid);
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.setInt(4, this.version);
            statement.executeUpdate();
            this.serializedJsonDetails = serializedJsonDetails;
        }
    }

    public void setPhotoUrl(String photoUrl, boolean clearLabelAndKey) throws SQLException {
        if (clearLabelAndKey) {
            try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroupDetails.setPhotoUrl", "UPDATE contact_group_details SET photo_url = ?, photo_server_label = NULL, photo_server_key = NULL  WHERE group_owner_and_uid = ?  AND owned_identity = ?  AND version = ?;");){
                statement.setString(1, photoUrl);
                statement.setBytes(2, this.groupOwnerAndUid);
                statement.setBytes(3, this.ownedIdentity.getBytes());
                statement.setInt(4, this.version);
                statement.executeUpdate();
                this.photoUrl = photoUrl;
                this.photoServerKey = null;
                this.photoServerLabel = null;
            }
        }
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroupDetails.setPhotoUrl", "UPDATE contact_group_details SET photo_url = ?  WHERE group_owner_and_uid = ?  AND owned_identity = ?  AND version = ?;");){
            statement.setString(1, photoUrl);
            statement.setBytes(2, this.groupOwnerAndUid);
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.setInt(4, this.version);
            statement.executeUpdate();
            this.photoUrl = photoUrl;
        }
    }

    public void setPhotoServerLabelAndKey(UID photoServerLabel, AuthEncKey photoServerKey) throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroupDetails.setPhotoServerLabelAndKey", "UPDATE contact_group_details SET photo_server_label = ?, photo_server_key = ?  WHERE group_owner_and_uid = ?  AND owned_identity = ?  AND version = ?;");){
            statement.setBytes(1, photoServerLabel.getBytes());
            statement.setBytes(2, Encoded.of(photoServerKey).getBytes());
            statement.setBytes(3, this.groupOwnerAndUid);
            statement.setBytes(4, this.ownedIdentity.getBytes());
            statement.setInt(5, this.version);
            statement.executeUpdate();
            this.photoServerLabel = photoServerLabel;
            this.photoServerKey = photoServerKey;
        }
    }

    public static ContactGroupDetails create(IdentityManagerSession identityManagerSession, byte[] groupUid, Identity ownedIdentity, JsonGroupDetailsWithVersionAndPhoto jsonGroupDetailsWithVersionAndPhoto) {
        if (groupUid == null || ownedIdentity == null || jsonGroupDetailsWithVersionAndPhoto == null || jsonGroupDetailsWithVersionAndPhoto.getGroupDetails() == null) {
            return null;
        }
        try {
            int version = jsonGroupDetailsWithVersionAndPhoto.getVersion();
            String serializedJsonDetails = identityManagerSession.jsonObjectMapper.writeValueAsString((Object)jsonGroupDetailsWithVersionAndPhoto.getGroupDetails());
            UID photoServerLabel = jsonGroupDetailsWithVersionAndPhoto.getPhotoServerLabel() == null ? null : new UID(jsonGroupDetailsWithVersionAndPhoto.getPhotoServerLabel());
            AuthEncKey photoServerKey = jsonGroupDetailsWithVersionAndPhoto.getPhotoServerKey() == null ? null : (AuthEncKey)new Encoded(jsonGroupDetailsWithVersionAndPhoto.getPhotoServerKey()).decodeSymmetricKey();
            ContactGroupDetails contactGroupDetails = new ContactGroupDetails(identityManagerSession, groupUid, ownedIdentity, version, serializedJsonDetails, null, photoServerLabel, photoServerKey);
            contactGroupDetails.insert();
            return contactGroupDetails;
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    public static ContactGroupDetails copy(IdentityManagerSession identityManagerSession, Identity ownedIdentity, byte[] groupUid, int version, Integer newVersion) {
        if (groupUid == null || ownedIdentity == null) {
            return null;
        }
        try {
            ContactGroupDetails oldDetails;
            if (newVersion == null) {
                newVersion = version + 1;
                try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupDetails.copy", "SELECT * FROM contact_group_details WHERE group_owner_and_uid = ?  AND owned_identity = ?  ORDER BY version DESC LIMIT 1;");){
                    statement.setBytes(1, groupUid);
                    statement.setBytes(2, ownedIdentity.getBytes());
                    try (ResultSet res = statement.executeQuery();){
                        if (res.next()) {
                            newVersion = res.getInt(VERSION) + 1;
                        }
                    }
                }
            }
            if ((oldDetails = ContactGroupDetails.get(identityManagerSession, groupUid, ownedIdentity, version)) == null) {
                return null;
            }
            ContactGroupDetails contactGroupDetails = new ContactGroupDetails(identityManagerSession, groupUid, ownedIdentity, newVersion, oldDetails.serializedJsonDetails, oldDetails.photoUrl, oldDetails.photoServerLabel, oldDetails.photoServerKey);
            contactGroupDetails.insert();
            return contactGroupDetails;
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    public ContactGroupDetails(IdentityManagerSession identityManagerSession, byte[] groupOwnerAndUid, Identity ownedIdentity, int version, String serializedJsonDetails, String photoUrl, UID photoServerLabel, AuthEncKey photoServerKey) {
        this.identityManagerSession = identityManagerSession;
        this.groupOwnerAndUid = groupOwnerAndUid;
        this.ownedIdentity = ownedIdentity;
        this.version = version;
        this.serializedJsonDetails = serializedJsonDetails;
        this.photoUrl = photoUrl;
        this.photoServerLabel = photoServerLabel;
        this.photoServerKey = photoServerKey;
    }

    private ContactGroupDetails(IdentityManagerSession identityManagerSession, ResultSet res) throws SQLException {
        this.identityManagerSession = identityManagerSession;
        this.groupOwnerAndUid = res.getBytes(GROUP_OWNER_AND_UID);
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        this.version = res.getInt(VERSION);
        this.serializedJsonDetails = res.getString(SERIALIZED_JSON_DETAILS);
        this.photoUrl = res.getString(PHOTO_URL);
        byte[] bytes = res.getBytes(PHOTO_SERVER_LABEL);
        this.photoServerLabel = bytes == null ? null : new UID(bytes);
        bytes = res.getBytes(PHOTO_SERVER_KEY);
        if (bytes == null) {
            this.photoServerKey = null;
        } else {
            try {
                this.photoServerKey = (AuthEncKey)new Encoded(bytes).decodeSymmetricKey();
            }
            catch (DecodingException e) {
                Logger.x(e);
                this.photoServerKey = null;
            }
        }
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS contact_group_details (group_owner_and_uid BLOB NOT NULL, owned_identity BLOB NOT NULL, version INT NOT NULL, serialized_json_details TEXT NOT NULL, photo_url TEXT, photo_server_label BLOB, photo_server_key BLOB,  CONSTRAINT PK_contact_group_details PRIMARY KEY(group_owner_and_uid, owned_identity, version));");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroupDetails.insert", "INSERT INTO contact_group_details VALUES (?,?,?,?,?, ?,?);");){
            statement.setBytes(1, this.groupOwnerAndUid);
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.setInt(3, this.version);
            statement.setString(4, this.serializedJsonDetails);
            statement.setString(5, this.photoUrl);
            statement.setBytes(6, this.photoServerLabel == null ? null : this.photoServerLabel.getBytes());
            statement.setBytes(7, this.photoServerKey == null ? null : Encoded.of(this.photoServerKey).getBytes());
            statement.executeUpdate();
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroupDetails.delete", "DELETE FROM contact_group_details WHERE group_owner_and_uid = ?  AND owned_identity = ?  AND version = ?;");){
            statement.setBytes(1, this.groupOwnerAndUid);
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.setInt(3, this.version);
            statement.executeUpdate();
        }
    }

    public static ContactGroupDetails get(IdentityManagerSession identityManagerSession, byte[] groupUid, Identity ownedIdentity, int version) throws SQLException {
        if (ownedIdentity == null) {
            return null;
        }
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupDetails.get", "SELECT * FROM contact_group_details WHERE group_owner_and_uid = ? AND owned_identity = ? AND version = ?;");){
            ContactGroupDetails contactGroupDetails;
            block17: {
                ResultSet res;
                block15: {
                    ContactGroupDetails contactGroupDetails2;
                    block16: {
                        statement.setBytes(1, groupUid);
                        statement.setBytes(2, ownedIdentity.getBytes());
                        statement.setInt(3, version);
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block15;
                            contactGroupDetails2 = new ContactGroupDetails(identityManagerSession, res);
                            if (res == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return contactGroupDetails2;
                }
                contactGroupDetails = null;
                if (res == null) break block17;
                res.close();
            }
            return contactGroupDetails;
        }
    }

    public static List<String> getAllPhotoUrl(IdentityManagerSession identityManagerSession) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupDetails.getAllPhotoUrl", "SELECT photo_url FROM contact_group_details WHERE photo_url IS NOT NULL;");){
            ArrayList<String> arrayList;
            block13: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<String> list = new ArrayList<String>();
                    while (res.next()) {
                        list.add(res.getString(PHOTO_URL));
                    }
                    arrayList = list;
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
    }

    public static List<ContactGroupDetails> getAllWithMissingPhotoUrl(IdentityManagerSession identityManagerSession) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupDetails.getAllWithMissingPhotoUrl", "SELECT * FROM contact_group_details WHERE photo_url IS NULL  AND photo_server_key IS NOT NULL  AND photo_server_label IS NOT NULL;");){
            ArrayList<ContactGroupDetails> arrayList;
            block13: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ContactGroupDetails> list = new ArrayList<ContactGroupDetails>();
                    while (res.next()) {
                        list.add(new ContactGroupDetails(identityManagerSession, res));
                    }
                    arrayList = list;
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
    }

    @Override
    public void wasCommitted() {
    }

    Pojo_0 backup() {
        Pojo_0 pojo = new Pojo_0();
        pojo.version = this.version;
        pojo.serialized_details = this.serializedJsonDetails;
        if (this.photoServerLabel != null && this.photoServerKey != null) {
            pojo.photo_server_label = this.photoServerLabel.getBytes();
            pojo.photo_server_key = Encoded.of(this.photoServerKey).getBytes();
        }
        return pojo;
    }

    public static ContactGroupDetails restore(IdentityManagerSession identityManagerSession, Identity ownedIdentity, byte[] groupOwnerAndUid, Pojo_0 pojo, boolean ownedGroup) throws SQLException {
        UID photoServerLabel = null;
        if (pojo.photo_server_label != null) {
            photoServerLabel = new UID(pojo.photo_server_label);
        }
        AuthEncKey photoServerKey = null;
        try {
            if (pojo.photo_server_key != null) {
                photoServerKey = (AuthEncKey)new Encoded(pojo.photo_server_key).decodeSymmetricKey();
            }
        }
        catch (DecodingException | ClassCastException e) {
            Logger.x(e);
        }
        ContactGroupDetails contactGroupDetails = new ContactGroupDetails(identityManagerSession, groupOwnerAndUid, ownedIdentity, pojo.version, pojo.serialized_details, null, photoServerLabel, photoServerKey);
        contactGroupDetails.insert();
        if (ownedGroup && photoServerLabel != null && photoServerKey != null) {
            ServerUserData.createForOwnedGroupDetails(identityManagerSession, ownedIdentity, photoServerLabel, groupOwnerAndUid);
        }
        return contactGroupDetails;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Pojo_0 {
        public int version;
        public String serialized_details;
        public byte[] photo_server_label;
        public byte[] photo_server_key;
    }
}

