/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity.databases;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.GroupInformation;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.JsonGroupDetails;
import io.olvid.engine.engine.types.JsonGroupDetailsWithVersionAndPhoto;
import io.olvid.engine.identity.databases.ContactGroupDetails;
import io.olvid.engine.identity.databases.ContactGroupMembersJoin;
import io.olvid.engine.identity.databases.PendingGroupMember;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import io.olvid.engine.secure_io.SecureFile;
import io.olvid.engine.secure_io.SecureFileInputStream;
import io.olvid.engine.secure_io.SecureFileOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;

public class ContactGroup
implements ObvDatabase {
    static final String TABLE_NAME = "contact_group";
    private final IdentityManagerSession identityManagerSession;
    private byte[] groupOwnerAndUid;
    static final String GROUP_OWNER_AND_UID = "group_owner_and_uid";
    private Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private Identity groupOwner;
    static final String GROUP_OWNER = "group_owner";
    private int publishedDetailsVersion;
    static final String PUBLISHED_DETAILS_VERSION = "published_details_version";
    public int latestOrTrustedDetailsVersion;
    static final String LATEST_OR_TRUSTED_DETAILS_VERSION = "latest_or_trusted_details_version";
    public long groupMembersVersion;
    static final String GROUP_MEMBERS_VERSION = "group_members_version";
    private UID labelToDelete;
    private JsonGroupDetailsWithVersionAndPhoto hookDetails;
    private int hookPhotoSetVersion;
    private long commitHookBits = 0L;
    private static final long HOOK_BIT_INSERTED = 1L;
    private static final long HOOK_BIT_DELETED = 2L;
    private static final long HOOK_BIT_PUBLISHED_DETAILS_TRUSTED = 4L;
    private static final long HOOK_BIT_NEW_PUBLISHED_DETAILS = 8L;
    private static final long HOOK_BIT_PHOTO_SET = 16L;
    private static final long HOOK_BIT_DETAILS_PUBLISHED = 32L;
    private static final long HOOK_BIT_SERVER_USER_DATA_CAN_BE_DELETED = 64L;
    private static final long HOOK_BIT_CREATED_ON_OTHER_DEVICE = 128L;

    public byte[] getGroupOwnerAndUid() {
        return this.groupOwnerAndUid;
    }

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public Identity getGroupOwner() {
        return this.groupOwner;
    }

    public long getGroupMembersVersion() {
        return this.groupMembersVersion;
    }

    public int getPublishedDetailsVersion() {
        return this.publishedDetailsVersion;
    }

    public ContactGroupDetails getPublishedDetails() throws SQLException {
        return ContactGroupDetails.get(this.identityManagerSession, this.groupOwnerAndUid, this.ownedIdentity, this.publishedDetailsVersion);
    }

    public ContactGroupDetails getLatestOrTrustedDetails() throws SQLException {
        return ContactGroupDetails.get(this.identityManagerSession, this.groupOwnerAndUid, this.ownedIdentity, this.latestOrTrustedDetailsVersion);
    }

    public int getLatestOrTrustedDetailsVersion() {
        return this.latestOrTrustedDetailsVersion;
    }

    public GroupInformation getGroupInformation() {
        String serializedGroupDetailsWithVersionAndPhoto;
        try {
            JsonGroupDetailsWithVersionAndPhoto jsonGroupDetailsWithVersionAndPhoto = this.getPublishedDetails().getJsonGroupDetailsWithVersionAndPhoto();
            serializedGroupDetailsWithVersionAndPhoto = this.identityManagerSession.jsonObjectMapper.writeValueAsString((Object)jsonGroupDetailsWithVersionAndPhoto);
        }
        catch (Exception e) {
            return null;
        }
        UID groupUid = new UID(Arrays.copyOfRange(this.groupOwnerAndUid, this.groupOwnerAndUid.length - 32, this.groupOwnerAndUid.length));
        return new GroupInformation(this.groupOwner == null ? this.ownedIdentity : this.groupOwner, groupUid, serializedGroupDetailsWithVersionAndPhoto);
    }

    public boolean updatePublishedDetails(JsonGroupDetailsWithVersionAndPhoto jsonGroupDetailsWithVersionAndPhoto, boolean allowDowngrade) throws Exception {
        if (jsonGroupDetailsWithVersionAndPhoto == null) {
            return false;
        }
        int newDetailsVersion = jsonGroupDetailsWithVersionAndPhoto.getVersion();
        if (!allowDowngrade && newDetailsVersion <= this.publishedDetailsVersion) {
            return false;
        }
        if (allowDowngrade && newDetailsVersion <= this.publishedDetailsVersion) {
            ContactGroupDetails newPublishedDetails;
            PreparedStatement statement;
            ContactGroupDetails publishedDetails = this.getPublishedDetails();
            if (newDetailsVersion == this.publishedDetailsVersion && publishedDetails.getJsonGroupDetails().equals(jsonGroupDetailsWithVersionAndPhoto.getGroupDetails())) {
                UID newPhotoServerLabel;
                UID uID = newPhotoServerLabel = jsonGroupDetailsWithVersionAndPhoto.getPhotoServerLabel() == null ? null : new UID(jsonGroupDetailsWithVersionAndPhoto.getPhotoServerLabel());
                if (newPhotoServerLabel == null && publishedDetails.getPhotoServerLabel() == null || newPhotoServerLabel != null && newPhotoServerLabel.equals(publishedDetails.getPhotoServerLabel())) {
                    AuthEncKey newPhotoServerKey;
                    AuthEncKey authEncKey = newPhotoServerKey = jsonGroupDetailsWithVersionAndPhoto.getPhotoServerKey() == null ? null : (AuthEncKey)new Encoded(jsonGroupDetailsWithVersionAndPhoto.getPhotoServerKey()).decodeSymmetricKey();
                    if (newPhotoServerKey == null && publishedDetails.getPhotoServerKey() == null || newPhotoServerKey != null && newPhotoServerKey.equals(publishedDetails.getPhotoServerKey())) {
                        return false;
                    }
                }
            }
            ContactGroupDetails.cleanup(this.identityManagerSession, this.ownedIdentity, this.groupOwnerAndUid, this.publishedDetailsVersion, this.latestOrTrustedDetailsVersion);
            ContactGroupDetails trustedDetails = this.getLatestOrTrustedDetails();
            if (this.latestOrTrustedDetailsVersion != -1) {
                ContactGroupDetails zeroedDetails = ContactGroupDetails.copy(this.identityManagerSession, this.ownedIdentity, this.groupOwnerAndUid, this.latestOrTrustedDetailsVersion, -1);
                if (zeroedDetails == null) {
                    throw new Exception("Failed to copy contact groupd details to version 0");
                }
                statement = this.identityManagerSession.session.prepareStatement("ContactGroup.updatePublishedDetails", "UPDATE contact_group SET latest_or_trusted_details_version = ?, published_details_version = ?  WHERE group_owner_and_uid = ?  AND owned_identity = ?;");
                try {
                    statement.setInt(1, -1);
                    statement.setInt(2, -1);
                    statement.setBytes(3, this.groupOwnerAndUid);
                    statement.setBytes(4, this.ownedIdentity.getBytes());
                    statement.executeUpdate();
                    this.latestOrTrustedDetailsVersion = -1;
                    this.publishedDetailsVersion = -1;
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
                trustedDetails.delete();
            } else {
                try (PreparedStatement statement2 = this.identityManagerSession.session.prepareStatement("ContactGroup.updatePublishedDetails", "UPDATE contact_group SET latest_or_trusted_details_version = ?, published_details_version = ?  WHERE group_owner_and_uid = ?  AND owned_identity = ?;");){
                    statement2.setInt(1, -1);
                    statement2.setInt(2, -1);
                    statement2.setBytes(3, this.groupOwnerAndUid);
                    statement2.setBytes(4, this.ownedIdentity.getBytes());
                    statement2.executeUpdate();
                    this.latestOrTrustedDetailsVersion = -1;
                    this.publishedDetailsVersion = -1;
                }
            }
            if (publishedDetails.getVersion() != trustedDetails.getVersion()) {
                publishedDetails.delete();
            }
            if ((newPublishedDetails = ContactGroupDetails.create(this.identityManagerSession, this.groupOwnerAndUid, this.ownedIdentity, jsonGroupDetailsWithVersionAndPhoto)).getPhotoServerLabel() != null && newPublishedDetails.getPhotoServerKey() != null && newPublishedDetails.getPhotoServerLabel().equals(publishedDetails.getPhotoServerLabel()) && newPublishedDetails.getPhotoServerKey().equals(publishedDetails.getPhotoServerKey()) && publishedDetails.getPhotoUrl() != null) {
                newPublishedDetails.setPhotoUrl(publishedDetails.getPhotoUrl(), false);
            }
            statement = this.identityManagerSession.session.prepareStatement("ContactGroup.updatePublishedDetails", "UPDATE contact_group SET published_details_version = ?  WHERE group_owner_and_uid = ?  AND owned_identity = ?;");
            try {
                statement.setInt(1, newPublishedDetails.getVersion());
                statement.setBytes(2, this.groupOwnerAndUid);
                statement.setBytes(3, this.ownedIdentity.getBytes());
                statement.executeUpdate();
                this.publishedDetailsVersion = newPublishedDetails.getVersion();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        ContactGroupDetails newPublishedDetails = ContactGroupDetails.create(this.identityManagerSession, this.groupOwnerAndUid, this.ownedIdentity, jsonGroupDetailsWithVersionAndPhoto);
        ContactGroupDetails publishedDetails = this.getPublishedDetails();
        if (newPublishedDetails.getPhotoServerLabel() != null && newPublishedDetails.getPhotoServerKey() != null && newPublishedDetails.getPhotoServerLabel().equals(publishedDetails.getPhotoServerLabel()) && newPublishedDetails.getPhotoServerKey().equals(publishedDetails.getPhotoServerKey()) && publishedDetails.getPhotoUrl() != null) {
            newPublishedDetails.setPhotoUrl(publishedDetails.getPhotoUrl(), false);
        }
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroup.updatePublishedDetails", "UPDATE contact_group SET published_details_version = ?  WHERE group_owner_and_uid = ?  AND owned_identity = ?;");){
            statement.setInt(1, newPublishedDetails.getVersion());
            statement.setBytes(2, this.groupOwnerAndUid);
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.publishedDetailsVersion = newPublishedDetails.getVersion();
        }
        if (this.groupOwner != null) {
            this.commitHookBits |= 8L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
        return true;
    }

    public JsonGroupDetailsWithVersionAndPhoto trustPublishedDetails() throws SQLException {
        if (this.latestOrTrustedDetailsVersion == this.publishedDetailsVersion) {
            return null;
        }
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroup.trustPublishedDetails", "UPDATE contact_group SET latest_or_trusted_details_version = ?  WHERE group_owner_and_uid = ?  AND owned_identity = ?;");){
            statement.setInt(1, this.publishedDetailsVersion);
            statement.setBytes(2, this.groupOwnerAndUid);
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.latestOrTrustedDetailsVersion = this.publishedDetailsVersion;
        }
        this.hookDetails = this.getLatestOrTrustedDetails().getJsonGroupDetailsWithVersionAndPhoto();
        this.commitHookBits |= 4L;
        this.identityManagerSession.session.addSessionCommitListener(this);
        return this.hookDetails;
    }

    public void setLatestDetails(JsonGroupDetails groupDetails) throws Exception {
        ContactGroupDetails contactGroupDetails;
        JsonGroupDetails publishedDetails;
        if (this.groupOwner != null || groupDetails == null || groupDetails.isEmpty()) {
            return;
        }
        JsonGroupDetails latestDetails = this.getLatestOrTrustedDetails().getJsonGroupDetails();
        if (latestDetails.equals(groupDetails)) {
            return;
        }
        if (this.publishedDetailsVersion != this.latestOrTrustedDetailsVersion && (publishedDetails = this.getPublishedDetails().getJsonGroupDetails()).equals(groupDetails)) {
            this.discardLatestDetails();
            return;
        }
        if (this.publishedDetailsVersion == this.latestOrTrustedDetailsVersion) {
            contactGroupDetails = ContactGroupDetails.copy(this.identityManagerSession, this.ownedIdentity, this.groupOwnerAndUid, this.publishedDetailsVersion, null);
            try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroup.setLatestDetails", "UPDATE contact_group SET latest_or_trusted_details_version = ?  WHERE group_owner_and_uid = ? AND owned_identity = ?;");){
                statement.setInt(1, contactGroupDetails.getVersion());
                statement.setBytes(2, this.groupOwnerAndUid);
                statement.setBytes(3, this.ownedIdentity.getBytes());
                statement.executeUpdate();
                this.latestOrTrustedDetailsVersion = contactGroupDetails.getVersion();
            }
        } else {
            contactGroupDetails = ContactGroupDetails.get(this.identityManagerSession, this.groupOwnerAndUid, this.ownedIdentity, this.latestOrTrustedDetailsVersion);
        }
        contactGroupDetails.setJsonDetails(groupDetails);
    }

    public void setOwnedGroupPhoto(String srcAbsolutePhotoUrl, boolean partOfGroupCreation) throws Exception {
        if (this.groupOwner != null) {
            return;
        }
        if (srcAbsolutePhotoUrl == null) {
            ContactGroupDetails contactGroupDetails;
            if (this.publishedDetailsVersion == this.latestOrTrustedDetailsVersion) {
                contactGroupDetails = ContactGroupDetails.copy(this.identityManagerSession, this.ownedIdentity, this.groupOwnerAndUid, this.publishedDetailsVersion, null);
                try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroup.setOwnedGroupPhoto", "UPDATE contact_group SET latest_or_trusted_details_version = ?  WHERE group_owner_and_uid = ? AND owned_identity = ?;");){
                    statement.setInt(1, contactGroupDetails.getVersion());
                    statement.setBytes(2, this.groupOwnerAndUid);
                    statement.setBytes(3, this.ownedIdentity.getBytes());
                    statement.executeUpdate();
                    this.latestOrTrustedDetailsVersion = contactGroupDetails.getVersion();
                }
            } else {
                contactGroupDetails = ContactGroupDetails.get(this.identityManagerSession, this.groupOwnerAndUid, this.ownedIdentity, this.latestOrTrustedDetailsVersion);
            }
            contactGroupDetails.setPhotoUrl(null, true);
        } else {
            String randFileName;
            SecureFile dstPhotoFile;
            ContactGroupDetails contactGroupDetails;
            SecureFile srcPhotoFile = new SecureFile(srcAbsolutePhotoUrl);
            if (!srcPhotoFile.canRead()) {
                return;
            }
            if (partOfGroupCreation) {
                contactGroupDetails = ContactGroupDetails.get(this.identityManagerSession, this.groupOwnerAndUid, this.ownedIdentity, this.publishedDetailsVersion);
            } else if (this.publishedDetailsVersion == this.latestOrTrustedDetailsVersion) {
                contactGroupDetails = ContactGroupDetails.copy(this.identityManagerSession, this.ownedIdentity, this.groupOwnerAndUid, this.publishedDetailsVersion, null);
                try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroup.setOwnedGroupPhoto", "UPDATE contact_group SET latest_or_trusted_details_version = ?  WHERE group_owner_and_uid = ? AND owned_identity = ?;");){
                    statement.setInt(1, contactGroupDetails.getVersion());
                    statement.setBytes(2, this.groupOwnerAndUid);
                    statement.setBytes(3, this.ownedIdentity.getBytes());
                    statement.executeUpdate();
                    this.latestOrTrustedDetailsVersion = contactGroupDetails.getVersion();
                }
            } else {
                contactGroupDetails = ContactGroupDetails.get(this.identityManagerSession, this.groupOwnerAndUid, this.ownedIdentity, this.latestOrTrustedDetailsVersion);
            }
            String fileName = "identity_photos" + File.separator + Logger.toHexString(Arrays.copyOfRange(this.groupOwnerAndUid, this.groupOwnerAndUid.length - 32, this.groupOwnerAndUid.length));
            Random random = new Random();
            while ((dstPhotoFile = new SecureFile(this.identityManagerSession.engineBaseDirectory, randFileName = fileName + "_" + random.nextInt(65536))).exists()) {
            }
            try (SecureFileInputStream is = new SecureFileInputStream(srcPhotoFile);
                 SecureFileOutputStream os = new SecureFileOutputStream(dstPhotoFile);){
                int length;
                byte[] buffer = new byte[4096];
                while ((length = is.read(buffer)) > 0) {
                    ((OutputStream)os).write(buffer, 0, length);
                }
            }
            contactGroupDetails.setPhotoUrl(randFileName, true);
        }
    }

    public void setPhotoLabelAndKey(int version, UID photoServerLabel, AuthEncKey photoServerKey) throws SQLException {
        ContactGroupDetails contactGroupDetails = ContactGroupDetails.get(this.identityManagerSession, this.groupOwnerAndUid, this.ownedIdentity, version);
        if (contactGroupDetails != null) {
            contactGroupDetails.setPhotoServerLabelAndKey(photoServerLabel, photoServerKey);
        }
    }

    public int publishLatestDetails() throws SQLException {
        if (this.latestOrTrustedDetailsVersion == this.publishedDetailsVersion) {
            return -1;
        }
        ContactGroupDetails publishedDetails = this.getPublishedDetails();
        ContactGroupDetails latestDetails = this.getLatestOrTrustedDetails();
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroup.publishLatestDetails", "UPDATE contact_group SET published_details_version = ?  WHERE group_owner_and_uid = ?  AND owned_identity = ?;");){
            statement.setInt(1, this.latestOrTrustedDetailsVersion);
            statement.setBytes(2, this.groupOwnerAndUid);
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.publishedDetailsVersion = this.latestOrTrustedDetailsVersion;
        }
        if (!(publishedDetails.getPhotoUrl() == null || latestDetails.getPhotoUrl() != null && latestDetails.getPhotoUrl().equals(publishedDetails.getPhotoUrl()) || publishedDetails.getPhotoServerLabel() == null)) {
            this.labelToDelete = publishedDetails.getPhotoServerLabel();
            this.commitHookBits |= 0x40L;
        }
        this.commitHookBits |= 0x20L;
        this.hookDetails = latestDetails.getJsonGroupDetailsWithVersionAndPhoto();
        this.identityManagerSession.session.addSessionCommitListener(this);
        return this.latestOrTrustedDetailsVersion;
    }

    public void discardLatestDetails() throws SQLException {
        if (this.latestOrTrustedDetailsVersion == this.publishedDetailsVersion) {
            return;
        }
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroup.discardLatestDetails", "UPDATE contact_group SET latest_or_trusted_details_version = ?  WHERE group_owner_and_uid = ?  AND owned_identity = ?;");){
            statement.setInt(1, this.publishedDetailsVersion);
            statement.setBytes(2, this.groupOwnerAndUid);
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.latestOrTrustedDetailsVersion = this.publishedDetailsVersion;
        }
    }

    public void setDetailsDownloadedPhotoUrl(int version, byte[] photo) throws Exception {
        String randFileName;
        SecureFile dstPhotoFile;
        ContactGroupDetails contactGroupDetails = ContactGroupDetails.get(this.identityManagerSession, this.groupOwnerAndUid, this.ownedIdentity, version);
        if (contactGroupDetails == null) {
            return;
        }
        String fileName = "identity_photos" + File.separator + Logger.toHexString(Arrays.copyOfRange(this.groupOwnerAndUid, this.groupOwnerAndUid.length - 32, this.groupOwnerAndUid.length));
        Random random = new Random();
        while ((dstPhotoFile = new SecureFile(this.identityManagerSession.engineBaseDirectory, randFileName = fileName + "_" + random.nextInt(65536))).exists()) {
        }
        try (SecureFileOutputStream os = new SecureFileOutputStream(dstPhotoFile);){
            os.write(photo, 0, photo.length);
        }
        contactGroupDetails.setPhotoUrl(randFileName, false);
        if (this.groupOwner == null) {
            this.hookDetails = contactGroupDetails.getJsonGroupDetailsWithVersionAndPhoto();
            this.commitHookBits |= 4L;
        } else {
            this.hookPhotoSetVersion = version;
            this.commitHookBits |= 0x10L;
        }
        this.identityManagerSession.session.addSessionCommitListener(this);
    }

    public void incrementGroupMembersVersion() throws Exception {
        if (!this.identityManagerSession.session.isInTransaction()) {
            Logger.e("Called incrementGroupMembersVersion outside a transaction");
            throw new Exception();
        }
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroup.incrementGroupMembersVersion", "UPDATE contact_group SET group_members_version = ?  WHERE group_owner_and_uid = ?  AND owned_identity = ?;");){
            statement.setLong(1, this.groupMembersVersion + 1L);
            statement.setBytes(2, this.groupOwnerAndUid);
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            ++this.groupMembersVersion;
        }
    }

    public void setGroupMembersVersion(long groupMembersVersion) throws Exception {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroup.setGroupMembersVersion", "UPDATE contact_group SET group_members_version = ?  WHERE group_owner_and_uid = ?  AND owned_identity = ?;");){
            statement.setLong(1, groupMembersVersion);
            statement.setBytes(2, this.groupOwnerAndUid);
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.groupMembersVersion = groupMembersVersion;
        }
    }

    public static ContactGroup create(IdentityManagerSession identityManagerSession, byte[] groupUid, Identity ownedIdentity, String serializedGroupDetailsWithVersionAndPhoto, Identity groupOwner, boolean createdByMeOnOtherDevice) {
        JsonGroupDetailsWithVersionAndPhoto jsonGroupDetailsWithVersionAndPhoto;
        if (groupUid == null || serializedGroupDetailsWithVersionAndPhoto == null || ownedIdentity == null) {
            return null;
        }
        try {
            jsonGroupDetailsWithVersionAndPhoto = (JsonGroupDetailsWithVersionAndPhoto)identityManagerSession.jsonObjectMapper.readValue(serializedGroupDetailsWithVersionAndPhoto, JsonGroupDetailsWithVersionAndPhoto.class);
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
        try {
            if (!identityManagerSession.session.isInTransaction()) {
                Logger.e("Calling ContactGroup.create() outside a transaction");
                throw new SQLException();
            }
            ContactGroupDetails contactGroupDetails = ContactGroupDetails.create(identityManagerSession, groupUid, ownedIdentity, jsonGroupDetailsWithVersionAndPhoto);
            if (contactGroupDetails == null) {
                Logger.e("Error create contactGroupDetails in ContactGroup.create()");
                throw new SQLException();
            }
            ContactGroup contactGroup = new ContactGroup(identityManagerSession, groupUid, ownedIdentity, groupOwner, contactGroupDetails.getVersion());
            contactGroup.insert();
            if (createdByMeOnOtherDevice) {
                contactGroup.commitHookBits |= 0x80L;
            }
            return contactGroup;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    public ContactGroup(IdentityManagerSession identityManagerSession, byte[] groupOwnerAndUid, Identity ownedIdentity, Identity groupOwner, int version) {
        this.identityManagerSession = identityManagerSession;
        this.groupOwnerAndUid = groupOwnerAndUid;
        this.ownedIdentity = ownedIdentity;
        this.groupOwner = groupOwner;
        this.publishedDetailsVersion = version;
        this.latestOrTrustedDetailsVersion = version;
        this.groupMembersVersion = 0L;
    }

    private ContactGroup(IdentityManagerSession identityManagerSession, ResultSet res) throws SQLException {
        this.identityManagerSession = identityManagerSession;
        this.groupOwnerAndUid = res.getBytes(GROUP_OWNER_AND_UID);
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
            byte[] bytes = res.getBytes(GROUP_OWNER);
            this.groupOwner = bytes == null ? null : Identity.of(bytes);
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        this.publishedDetailsVersion = res.getInt(PUBLISHED_DETAILS_VERSION);
        this.latestOrTrustedDetailsVersion = res.getInt(LATEST_OR_TRUSTED_DETAILS_VERSION);
        this.groupMembersVersion = res.getLong(GROUP_MEMBERS_VERSION);
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS contact_group (group_owner_and_uid BLOB NOT NULL, owned_identity BLOB NOT NULL, group_owner BLOB, published_details_version INT NOT NULL, latest_or_trusted_details_version INT NOT NULL, group_members_version BIGINT NOT NULL,  CONSTRAINT PK_contact_group PRIMARY KEY(group_owner_and_uid, owned_identity),  FOREIGN KEY (group_owner,owned_identity) REFERENCES contact_identity(identity,owned_identity),  FOREIGN KEY (owned_identity) REFERENCES owned_identity(identity), FOREIGN KEY (owned_identity, group_owner_and_uid, published_details_version) REFERENCES contact_group_details(owned_identity, group_owner_and_uid, version), FOREIGN KEY (owned_identity, group_owner_and_uid, latest_or_trusted_details_version) REFERENCES contact_group_details(owned_identity, group_owner_and_uid, version));");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        if (oldVersion >= 11) return;
        if (newVersion < 11) return;
        try (Statement statement = session.createStatement();){
            Logger.d("MIGRATING contact_group DATABASE FROM VERSION " + oldVersion + " TO 11");
            statement.execute("ALTER TABLE contact_group RENAME TO old_contact_group");
            statement.execute("CREATE TABLE contact_group_details ( group_owner_and_uid BLOB NOT NULL,  owned_identity BLOB NOT NULL,  version INT NOT NULL,  serialized_json_details TEXT NOT NULL,  photo_url TEXT,  photo_server_label BLOB,  photo_server_key BLOB,  CONSTRAINT PK_contact_group_details PRIMARY KEY(group_owner_and_uid, owned_identity, version));");
            statement.execute("CREATE TABLE contact_group ( group_owner_and_uid BLOB NOT NULL,  owned_identity BLOB NOT NULL,  group_owner BLOB,  published_details_version INT NOT NULL,  latest_or_trusted_details_version INT NOT NULL,  group_members_version BIGINT NOT NULL,  CONSTRAINT PK_contact_group PRIMARY KEY(group_owner_and_uid, owned_identity),  FOREIGN KEY (group_owner,owned_identity) REFERENCES contact_identity(identity,owned_identity),  FOREIGN KEY (owned_identity) REFERENCES owned_identity(identity),  FOREIGN KEY (owned_identity, group_owner_and_uid, published_details_version) REFERENCES contact_group_details(owned_identity, group_owner_and_uid, version),  FOREIGN KEY (owned_identity, group_owner_and_uid, latest_or_trusted_details_version) REFERENCES contact_group_details(owned_identity, group_owner_and_uid, version));");
            ObjectMapper objectMapper = new ObjectMapper();
            try (ResultSet res = statement.executeQuery("SELECT * FROM old_contact_group");){
                while (res.next()) {
                    try (PreparedStatement preparedStatement = session.prepareStatement("INSERT INTO contact_group VALUES (?,?,?,?,?, ?);");){
                        preparedStatement.setBytes(1, res.getBytes(1));
                        preparedStatement.setBytes(2, res.getBytes(2));
                        preparedStatement.setBytes(3, res.getBytes(4));
                        preparedStatement.setInt(4, 0);
                        preparedStatement.setInt(5, 0);
                        preparedStatement.setInt(6, 0);
                        preparedStatement.executeUpdate();
                    }
                    preparedStatement = session.prepareStatement("INSERT INTO contact_group_details VALUES (?,?,?,?,?, ?,?);");
                    try {
                        preparedStatement.setBytes(1, res.getBytes(1));
                        preparedStatement.setBytes(2, res.getBytes(2));
                        preparedStatement.setInt(3, 0);
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("name", res.getString(3));
                        try {
                            preparedStatement.setString(4, objectMapper.writeValueAsString(map));
                        }
                        catch (Exception e) {
                            Logger.e("\n\n\n\nMIGRATION ERROR!!!\n\n\n");
                            throw new SQLException();
                        }
                        preparedStatement.setString(5, null);
                        preparedStatement.setBytes(6, null);
                        preparedStatement.setBytes(7, null);
                        preparedStatement.executeUpdate();
                    }
                    finally {
                        if (preparedStatement == null) continue;
                        preparedStatement.close();
                    }
                }
            }
            statement.execute("DROP TABLE old_contact_group");
            return;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroup.insert", "INSERT INTO contact_group VALUES (?,?,?,?,?, ?);");){
            statement.setBytes(1, this.groupOwnerAndUid);
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.setBytes(3, this.groupOwner == null ? null : this.groupOwner.getBytes());
            statement.setInt(4, this.publishedDetailsVersion);
            statement.setInt(5, this.latestOrTrustedDetailsVersion);
            statement.setLong(6, this.groupMembersVersion);
            statement.executeUpdate();
            this.commitHookBits |= 1L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
    }

    @Override
    public void delete() throws SQLException {
        if (!this.identityManagerSession.session.isInTransaction()) {
            Logger.e("Running ContactGroup.delete() outside a transaction");
            throw new SQLException();
        }
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroup.delete", "DELETE FROM contact_group WHERE group_owner_and_uid = ? AND owned_identity = ?;");){
            statement.setBytes(1, this.groupOwnerAndUid);
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.commitHookBits |= 2L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
        statement = this.identityManagerSession.session.prepareStatement("ContactGroup.delete", "DELETE FROM contact_group_details WHERE group_owner_and_uid = ?  AND owned_identity = ?;");
        try {
            statement.setBytes(1, this.groupOwnerAndUid);
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.executeUpdate();
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    public static ContactGroup get(IdentityManagerSession identityManagerSession, byte[] groupOwnerAndUid, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroup.get", "SELECT * FROM contact_group WHERE group_owner_and_uid = ? AND owned_identity = ?;");){
            ContactGroup contactGroup;
            block16: {
                ResultSet res;
                block14: {
                    ContactGroup contactGroup2;
                    block15: {
                        statement.setBytes(1, groupOwnerAndUid);
                        statement.setBytes(2, ownedIdentity.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block14;
                            contactGroup2 = new ContactGroup(identityManagerSession, res);
                            if (res == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return contactGroup2;
                }
                contactGroup = null;
                if (res == null) break block16;
                res.close();
            }
            return contactGroup;
        }
    }

    public static ContactGroup[] getAll(IdentityManagerSession identityManagerSession) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroup.getAll", "SELECT * FROM contact_group;");){
            ContactGroup[] contactGroupArray;
            block13: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ContactGroup> list = new ArrayList<ContactGroup>();
                    while (res.next()) {
                        ContactGroup contactGroup = new ContactGroup(identityManagerSession, res);
                        list.add(contactGroup);
                    }
                    contactGroupArray = list.toArray(new ContactGroup[0]);
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return contactGroupArray;
        }
    }

    public static ContactGroup[] getAllForIdentity(IdentityManagerSession identityManagerSession, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroup.getAllForIdentity", "SELECT * FROM contact_group WHERE owned_identity = ?;");){
            ContactGroup[] contactGroupArray;
            block13: {
                statement.setBytes(1, ownedIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ContactGroup> list = new ArrayList<ContactGroup>();
                    while (res.next()) {
                        ContactGroup contactGroup = new ContactGroup(identityManagerSession, res);
                        list.add(contactGroup);
                    }
                    contactGroupArray = list.toArray(new ContactGroup[0]);
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return contactGroupArray;
        }
    }

    public static ContactGroup[] getAllForOwnedIdentityAndOwner(IdentityManagerSession identityManagerSession, Identity ownedIdentity, Identity groupOwner) throws SQLException {
        if (ownedIdentity.equals(groupOwner)) {
            try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroup.getAllForOwnedIdentityAndOwner", "SELECT * FROM contact_group WHERE owned_identity = ?  AND group_owner IS NULL;");){
                ContactGroup[] contactGroup2;
                block27: {
                    statement.setBytes(1, ownedIdentity.getBytes());
                    ResultSet res = statement.executeQuery();
                    try {
                        ArrayList<ContactGroup[]> list = new ArrayList<ContactGroup[]>();
                        while (res.next()) {
                            contactGroup2 = new ContactGroup(identityManagerSession, res);
                            list.add(contactGroup2);
                        }
                        contactGroup2 = list.toArray(new ContactGroup[0]);
                        if (res == null) break block27;
                    }
                    catch (Throwable list) {
                        if (res != null) {
                            try {
                                res.close();
                            }
                            catch (Throwable contactGroup2) {
                                list.addSuppressed(contactGroup2);
                            }
                        }
                        throw list;
                    }
                    res.close();
                }
                return contactGroup2;
            }
        }
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroup.getAllForOwnedIdentityAndOwner", "SELECT * FROM contact_group WHERE owned_identity = ?  AND group_owner = ?;");){
            ContactGroup[] contactGroupArray;
            block28: {
                statement.setBytes(1, ownedIdentity.getBytes());
                statement.setBytes(2, groupOwner.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ContactGroup> list = new ArrayList<ContactGroup>();
                    while (res.next()) {
                        ContactGroup contactGroup = new ContactGroup(identityManagerSession, res);
                        list.add(contactGroup);
                    }
                    contactGroupArray = list.toArray(new ContactGroup[0]);
                    if (res == null) break block28;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return contactGroupArray;
        }
    }

    public static byte[][] getGroupOwnerAndUidsOfGroupsOwnedByContact(IdentityManagerSession identityManagerSession, Identity ownedIdentity, Identity contactIdentity) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroup.getGroupOwnerAndUidsOfOwnedGroupsWithContact", "SELECT group_owner_and_uid FROM contact_group WHERE owned_identity = ? AND group_owner = ?;");){
            byte[][] byArray;
            block13: {
                statement.setBytes(1, ownedIdentity.getBytes());
                statement.setBytes(2, contactIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<byte[]> list = new ArrayList<byte[]>();
                    while (res.next()) {
                        list.add(res.getBytes(GROUP_OWNER_AND_UID));
                    }
                    byArray = (byte[][])list.toArray((T[])new byte[0][]);
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return byArray;
        }
    }

    public static byte[][] getGroupOwnerAndUidsOfOwnedGroupsWithContact(IdentityManagerSession identityManagerSession, Identity ownedIdentity, Identity contactIdentity) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroup.getGroupOwnerAndUidsOfOwnedGroupsWithContact", "SELECT g.group_owner_and_uid FROM contact_group AS g  INNER JOIN contact_group_members_join AS j  ON g.group_owner_and_uid = j.group_owner_and_uid AND g.owned_identity = j.owned_identity WHERE g.owned_identity = ?  AND g.group_owner IS NULL  AND j.contact_identity = ?;");){
            byte[][] byArray;
            block13: {
                statement.setBytes(1, ownedIdentity.getBytes());
                statement.setBytes(2, contactIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<byte[]> list = new ArrayList<byte[]>();
                    while (res.next()) {
                        list.add(res.getBytes(GROUP_OWNER_AND_UID));
                    }
                    byArray = (byte[][])list.toArray((T[])new byte[0][]);
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return byArray;
        }
    }

    @Override
    public void wasCommitted() {
        HashMap<String, Object> userInfo;
        if ((this.commitHookBits & 1L) != 0L) {
            userInfo = new HashMap<String, Object>();
            userInfo.put("group_uid", this.groupOwnerAndUid);
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            userInfo.put("on_other_device", (this.commitHookBits & 0x80L) != 0L);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_group_created", userInfo);
        }
        if ((this.commitHookBits & 2L) != 0L) {
            userInfo = new HashMap();
            userInfo.put("group_uid", this.groupOwnerAndUid);
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_group_deleted", userInfo);
        }
        if ((this.commitHookBits & 0x20L) != 0L) {
            userInfo = new HashMap();
            userInfo.put("group_uid", this.groupOwnerAndUid);
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            userInfo.put("group_name", this.hookDetails);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_group_published_details_updated", userInfo);
        }
        if ((this.commitHookBits & 8L) != 0L) {
            userInfo = new HashMap();
            userInfo.put("group_uid", this.groupOwnerAndUid);
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_new_group_published_details", userInfo);
        }
        if ((this.commitHookBits & 4L) != 0L) {
            userInfo = new HashMap();
            userInfo.put("group_uid", this.groupOwnerAndUid);
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            userInfo.put("group_details", this.hookDetails);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_group_trusted_details_updated", userInfo);
        }
        if ((this.commitHookBits & 0x10L) != 0L) {
            userInfo = new HashMap();
            userInfo.put("group_uid", this.groupOwnerAndUid);
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            userInfo.put("version", this.hookPhotoSetVersion);
            userInfo.put("is_trusted", this.hookPhotoSetVersion == this.latestOrTrustedDetailsVersion);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_group_photo_set", userInfo);
        }
        if ((this.commitHookBits & 0x40L) != 0L) {
            userInfo = new HashMap();
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            userInfo.put("label", this.labelToDelete);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_server_user_data_can_be_deleted", userInfo);
        }
        this.commitHookBits = 0L;
    }

    public static Pojo_0[] backupAllForOwner(IdentityManagerSession identityManagerSession, Identity ownedIdentity, Identity groupOwnerIdentity) throws SQLException {
        ContactGroup[] contactGroups = ContactGroup.getAllForOwnedIdentityAndOwner(identityManagerSession, ownedIdentity, groupOwnerIdentity);
        Pojo_0[] pojos = new Pojo_0[contactGroups.length];
        for (int i = 0; i < contactGroups.length; ++i) {
            pojos[i] = contactGroups[i].backup();
        }
        return pojos;
    }

    public static void restoreAllForOwner(IdentityManagerSession identityManagerSession, Identity ownedIdentity, Identity groupOwner, Pojo_0[] pojos, long backupTimestamp) throws SQLException {
        if (pojos == null) {
            return;
        }
        for (Pojo_0 pojo : pojos) {
            ContactGroup.restoreForOwner(identityManagerSession, ownedIdentity, groupOwner, pojo, backupTimestamp);
        }
    }

    Pojo_0 backup() throws SQLException {
        Pojo_0 pojo = new Pojo_0();
        pojo.group_uid = Arrays.copyOfRange(this.groupOwnerAndUid, this.groupOwnerAndUid.length - 32, this.groupOwnerAndUid.length);
        if (this.groupOwner == null) {
            pojo.published_details = this.getPublishedDetails().backup();
            if (this.latestOrTrustedDetailsVersion != this.publishedDetailsVersion) {
                pojo.latest_details = this.getLatestOrTrustedDetails().backup();
            }
        } else {
            pojo.trusted_details = this.getLatestOrTrustedDetails().backup();
            if (this.publishedDetailsVersion != this.latestOrTrustedDetailsVersion) {
                pojo.published_details = this.getPublishedDetails().backup();
            }
        }
        pojo.group_members_version = this.groupMembersVersion;
        pojo.members = ContactGroupMembersJoin.backupAll(this.identityManagerSession, this.ownedIdentity, this.groupOwnerAndUid);
        pojo.pending_members = PendingGroupMember.backupAll(this.identityManagerSession, this.ownedIdentity, this.groupOwnerAndUid);
        return pojo;
    }

    public static void restoreForOwner(IdentityManagerSession identityManagerSession, Identity ownedIdentity, Identity groupOwner, Pojo_0 pojo, long backupTimestamp) throws SQLException {
        byte[] groupOwnerAndUid = new byte[groupOwner.getBytes().length + 32];
        System.arraycopy(groupOwner.getBytes(), 0, groupOwnerAndUid, 0, groupOwner.getBytes().length);
        System.arraycopy(pojo.group_uid, 0, groupOwnerAndUid, groupOwner.getBytes().length, 32);
        identityManagerSession.session.startTransaction();
        if (groupOwner.equals(ownedIdentity)) {
            ContactGroupDetails publishedDetails = ContactGroupDetails.restore(identityManagerSession, ownedIdentity, groupOwnerAndUid, pojo.published_details, true);
            ContactGroupDetails latestDetails = null;
            if (pojo.latest_details != null && pojo.latest_details.version != pojo.published_details.version) {
                latestDetails = ContactGroupDetails.restore(identityManagerSession, ownedIdentity, groupOwnerAndUid, pojo.latest_details, true);
            }
            ContactGroup contactGroup = new ContactGroup(identityManagerSession, groupOwnerAndUid, ownedIdentity, null, publishedDetails.getVersion());
            if (latestDetails != null) {
                contactGroup.latestOrTrustedDetailsVersion = latestDetails.getVersion();
            }
            contactGroup.insert();
        } else {
            ContactGroupDetails trustedDetails = ContactGroupDetails.restore(identityManagerSession, ownedIdentity, groupOwnerAndUid, pojo.trusted_details, false);
            ContactGroupDetails publishDetails = null;
            if (pojo.published_details != null && pojo.trusted_details.version != pojo.published_details.version) {
                publishDetails = ContactGroupDetails.restore(identityManagerSession, ownedIdentity, groupOwnerAndUid, pojo.published_details, false);
            }
            ContactGroup contactGroup = new ContactGroup(identityManagerSession, groupOwnerAndUid, ownedIdentity, groupOwner, trustedDetails.getVersion());
            if (publishDetails != null) {
                contactGroup.publishedDetailsVersion = publishDetails.getVersion();
            }
            contactGroup.groupMembersVersion = pojo.group_members_version;
            contactGroup.insert();
        }
        ContactGroupMembersJoin.restoreAll(identityManagerSession, ownedIdentity, groupOwnerAndUid, pojo.members);
        PendingGroupMember.restoreAll(identityManagerSession, ownedIdentity, groupOwnerAndUid, pojo.pending_members);
        identityManagerSession.session.commit();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Pojo_0 {
        public byte[] group_uid;
        public ContactGroupDetails.Pojo_0 published_details;
        public ContactGroupDetails.Pojo_0 latest_details;
        public ContactGroupDetails.Pojo_0 trusted_details;
        public long group_members_version;
        public ContactGroupMembersJoin.Pojo_0[] members;
        public PendingGroupMember.Pojo_0[] pending_members;
    }
}

