/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.KeyId;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.PreKeyBlobOnServer;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.PreKey;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPublicKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.ObvCapability;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ContactDevice
implements ObvDatabase {
    static final String TABLE_NAME = "contact_device";
    private final IdentityManagerSession identityManagerSession;
    private UID uid;
    static final String UID_ = "uid";
    private Identity contactIdentity;
    static final String CONTACT_IDENTITY = "contact_identity";
    private Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private byte[] serializedDeviceCapabilities;
    static final String SERIALIZED_DEVICE_CAPABILITIES = "serialized_device_capabilities";
    private long latestChannelCreationPingTimestamp;
    static final String LATEST_CHANNEL_CREATION_PING_TIMESTAMP = "latest_channel_creation_ping_timestamp";
    private KeyId preKeyId;
    static final String PRE_KEY_ID = "pre_key_id";
    private EncryptionPublicKey preKeyEncryptionPublicKey;
    static final String PRE_KEY_ENCRYPTION_PUBLIC_KEY = "pre_key_encryption_public_key";
    private Long preKeyExpirationTimestamp;
    static final String PRE_KEY_EXPIRATION_TIMESTAMP = "pre_key_expiration_timestamp";
    boolean channelCreationAlreadyInProgress = false;
    private long commitHookBits = 0L;
    private static final long HOOK_BIT_INSERTED = 1L;
    private static final long HOOK_BIT_CAPABILITIES_UPDATED = 2L;
    private static final long HOOK_BIT_DEVICE_CHANGED = 4L;

    public UID getUid() {
        return this.uid;
    }

    public Identity getContactIdentity() {
        return this.contactIdentity;
    }

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public String[] getRawDeviceCapabilities() {
        return ObvCapability.deserializeRawDeviceCapabilities(this.serializedDeviceCapabilities);
    }

    public List<ObvCapability> getDeviceCapabilities() {
        return ObvCapability.deserializeDeviceCapabilities(this.serializedDeviceCapabilities);
    }

    public boolean hasPreKey() {
        return this.preKeyId != null;
    }

    public long getLatestChannelCreationPingTimestamp() {
        return this.latestChannelCreationPingTimestamp;
    }

    public PreKey getPreKey() {
        if (this.hasPreKey()) {
            return new PreKey(this.uid, this.preKeyId, this.preKeyEncryptionPublicKey, this.preKeyExpirationTimestamp);
        }
        return null;
    }

    public static ContactDevice create(IdentityManagerSession identityManagerSession, UID uid, Identity contactIdentity, Identity ownedIdentity, PreKeyBlobOnServer preKeyBlob, boolean channelCreationAlreadyInProgress) {
        if (uid == null || contactIdentity == null || ownedIdentity == null) {
            return null;
        }
        try {
            ContactDevice contactDevice = new ContactDevice(identityManagerSession, uid, contactIdentity, ownedIdentity, preKeyBlob == null ? null : ObvCapability.serializeRawDeviceCapabilities(preKeyBlob.rawDeviceCapabilities), preKeyBlob == null ? null : preKeyBlob.preKey);
            contactDevice.insert();
            contactDevice.channelCreationAlreadyInProgress = channelCreationAlreadyInProgress;
            return contactDevice;
        }
        catch (SQLException e) {
            return null;
        }
    }

    private ContactDevice(IdentityManagerSession identityManagerSession, UID uid, Identity contactIdentity, Identity ownedIdentity, byte[] serializedDeviceCapabilities, PreKey preKey) {
        this.identityManagerSession = identityManagerSession;
        this.uid = uid;
        this.contactIdentity = contactIdentity;
        this.ownedIdentity = ownedIdentity;
        this.serializedDeviceCapabilities = serializedDeviceCapabilities;
        this.latestChannelCreationPingTimestamp = 0L;
        if (preKey != null) {
            this.preKeyId = preKey.keyId;
            this.preKeyEncryptionPublicKey = preKey.encryptionPublicKey;
            this.preKeyExpirationTimestamp = preKey.expirationTimestamp;
        }
    }

    private ContactDevice(IdentityManagerSession identityManagerSession, ResultSet res) throws SQLException {
        this.identityManagerSession = identityManagerSession;
        this.uid = new UID(res.getBytes(UID_));
        try {
            this.contactIdentity = Identity.of(res.getBytes(CONTACT_IDENTITY));
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        this.serializedDeviceCapabilities = res.getBytes(SERIALIZED_DEVICE_CAPABILITIES);
        this.latestChannelCreationPingTimestamp = res.getLong(LATEST_CHANNEL_CREATION_PING_TIMESTAMP);
        byte[] preKeyIdBytes = res.getBytes(PRE_KEY_ID);
        this.preKeyId = preKeyIdBytes == null ? null : new KeyId(preKeyIdBytes);
        byte[] preKeyEncodedPublicKeyBytes = res.getBytes(PRE_KEY_ENCRYPTION_PUBLIC_KEY);
        if (preKeyEncodedPublicKeyBytes != null) {
            try {
                this.preKeyEncryptionPublicKey = (EncryptionPublicKey)new Encoded(preKeyEncodedPublicKeyBytes).decodePublicKey();
            }
            catch (DecodingException decodingException) {
                // empty catch block
            }
        }
        this.preKeyExpirationTimestamp = res.getLong(PRE_KEY_EXPIRATION_TIMESTAMP);
        if (res.wasNull()) {
            this.preKeyExpirationTimestamp = null;
        }
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS contact_device (uid BLOB NOT NULL, contact_identity BLOB NOT NULL, owned_identity BLOB NOT NULL, serialized_device_capabilities BLOB DEFAULT NULL, latest_channel_creation_ping_timestamp BIGINT NOT NULL DEFAULT 0, pre_key_id BLOB DEFAULT NULL, pre_key_encryption_public_key BLOB DEFAULT NULL, pre_key_expiration_timestamp BIGINT DEFAULT NULL, CONSTRAINT PK_contact_device PRIMARY KEY(uid, contact_identity, owned_identity), FOREIGN KEY (contact_identity, owned_identity) REFERENCES contact_identity (identity, owned_identity) ON DELETE CASCADE);");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        Statement statement;
        if (oldVersion < 12 && newVersion >= 12) {
            statement = session.createStatement();
            try {
                statement.execute("DELETE FROM contact_device AS p  WHERE NOT EXISTS ( SELECT 1 FROM contact_identity  WHERE identity = p.contact_identity AND owned_identity = p.owned_identity )");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 12;
        }
        if (oldVersion < 27 && newVersion >= 27) {
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE contact_device ADD COLUMN `serialized_device_capabilities` BLOB DEFAULT NULL");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 27;
        }
        if (oldVersion < 41 && newVersion >= 41) {
            Logger.d("MIGRATING `contact_device` DATABASE FROM VERSION " + oldVersion + " TO 41");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE contact_device ADD COLUMN `latest_channel_creation_ping_timestamp` BIGINT NOT NULL DEFAULT 0");
                statement.execute("ALTER TABLE contact_device ADD COLUMN `pre_key_id` BLOB DEFAULT NULL");
                statement.execute("ALTER TABLE contact_device ADD COLUMN `pre_key_encryption_public_key` BLOB DEFAULT NULL");
                statement.execute("ALTER TABLE contact_device ADD COLUMN `pre_key_expiration_timestamp` BIGINT DEFAULT NULL");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 41;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactDevice.insert", "INSERT INTO contact_device VALUES (?,?,?,?,?, ?,?,?);");){
            statement.setBytes(1, this.uid.getBytes());
            statement.setBytes(2, this.contactIdentity.getBytes());
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.setBytes(4, this.serializedDeviceCapabilities);
            statement.setLong(5, this.latestChannelCreationPingTimestamp);
            if (this.preKeyId != null && this.preKeyEncryptionPublicKey != null && this.preKeyExpirationTimestamp != null) {
                statement.setBytes(6, this.preKeyId.getBytes());
                statement.setBytes(7, Encoded.of(this.preKeyEncryptionPublicKey).getBytes());
                statement.setLong(8, this.preKeyExpirationTimestamp);
            } else {
                statement.setBytes(6, null);
                statement.setBytes(7, null);
                statement.setNull(8, -5);
            }
            statement.executeUpdate();
            if (this.serializedDeviceCapabilities != null) {
                this.commitHookBits |= 2L;
            }
            this.commitHookBits |= 1L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactDevice.delete", "DELETE FROM contact_device WHERE uid = ?  AND contact_identity = ?  AND owned_identity = ?;");){
            statement.setBytes(1, this.uid.getBytes());
            statement.setBytes(2, this.contactIdentity.getBytes());
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            if (this.serializedDeviceCapabilities != null) {
                this.commitHookBits |= 2L;
            }
            this.commitHookBits |= 4L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
    }

    public static ContactDevice get(IdentityManagerSession identityManagerSession, UID contactDeviceUid, Identity contactIdentity, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactDevice.get", "SELECT * FROM contact_device WHERE uid = ? AND contact_identity = ? AND owned_identity = ?;");){
            ContactDevice contactDevice;
            block16: {
                ResultSet res;
                block14: {
                    ContactDevice contactDevice2;
                    block15: {
                        statement.setBytes(1, contactDeviceUid.getBytes());
                        statement.setBytes(2, contactIdentity.getBytes());
                        statement.setBytes(3, ownedIdentity.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block14;
                            contactDevice2 = new ContactDevice(identityManagerSession, res);
                            if (res == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return contactDevice2;
                }
                contactDevice = null;
                if (res == null) break block16;
                res.close();
            }
            return contactDevice;
        }
    }

    public static boolean exists(IdentityManagerSession identityManagerSession, UID contactDeviceUid, Identity contactIdentity, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactDevice.exists", "SELECT * FROM contact_device WHERE uid = ?  AND contact_identity = ?  AND owned_identity = ?;");){
            boolean bl;
            block12: {
                statement.setBytes(1, contactDeviceUid.getBytes());
                statement.setBytes(2, contactIdentity.getBytes());
                statement.setBytes(3, ownedIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    bl = res.next();
                    if (res == null) break block12;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return bl;
        }
    }

    public static ContactDevice[] getAll(IdentityManagerSession identityManagerSession, Identity contactIdentity, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactDevice.getAllForContact", "SELECT * FROM contact_device WHERE contact_identity = ? AND owned_identity = ?;");){
            ContactDevice[] contactDeviceArray;
            block13: {
                statement.setBytes(1, contactIdentity.getBytes());
                statement.setBytes(2, ownedIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ContactDevice> list = new ArrayList<ContactDevice>();
                    while (res.next()) {
                        list.add(new ContactDevice(identityManagerSession, res));
                    }
                    contactDeviceArray = list.toArray(new ContactDevice[0]);
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return contactDeviceArray;
        }
    }

    public static ContactDevice[] getAll(IdentityManagerSession identityManagerSession) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactDevice.getAll", "SELECT * FROM contact_device;");){
            ContactDevice[] contactDeviceArray;
            block13: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ContactDevice> list = new ArrayList<ContactDevice>();
                    while (res.next()) {
                        list.add(new ContactDevice(identityManagerSession, res));
                    }
                    contactDeviceArray = list.toArray(new ContactDevice[0]);
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return contactDeviceArray;
        }
    }

    public static List<ContactDevice> getAllWithExpiredPreKey(IdentityManagerSession identityManagerSession, Identity ownedIdentity, long expirationTimestamp) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactDevice.getAllWithExpiredPreKey", "SELECT * FROM contact_device WHERE owned_identity = ?  AND pre_key_expiration_timestamp < ?;");){
            ArrayList<ContactDevice> arrayList;
            block13: {
                statement.setBytes(1, ownedIdentity.getBytes());
                statement.setLong(2, expirationTimestamp);
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ContactDevice> list = new ArrayList<ContactDevice>();
                    while (res.next()) {
                        list.add(new ContactDevice(identityManagerSession, res));
                    }
                    arrayList = list;
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
    }

    public static void deleteAll(IdentityManagerSession identityManagerSession, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactDevice.deleteAll", "DELETE FROM contact_device WHERE owned_identity = ?;");){
            statement.setBytes(1, ownedIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    public boolean setRawDeviceCapabilities(String[] rawDeviceCapabilities) throws SQLException {
        byte[] serializedDeviceCapabilities = ObvCapability.serializeRawDeviceCapabilities(rawDeviceCapabilities);
        if (Arrays.equals(serializedDeviceCapabilities, this.serializedDeviceCapabilities)) {
            return false;
        }
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactDevice.setRawDeviceCapabilities", "UPDATE contact_device SET serialized_device_capabilities = ?  WHERE uid = ?  AND contact_identity = ?  AND owned_identity = ?;");){
            statement.setBytes(1, serializedDeviceCapabilities);
            statement.setBytes(2, this.uid.getBytes());
            statement.setBytes(3, this.contactIdentity.getBytes());
            statement.setBytes(4, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.serializedDeviceCapabilities = serializedDeviceCapabilities;
            this.commitHookBits |= 2L;
            this.identityManagerSession.session.addSessionCommitListener(this);
            boolean bl = true;
            return bl;
        }
    }

    public void setLatestChannelCreationPingTimestamp(long timestamp) throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactDevice.setLatestChannelCreationPingTimestamp", "UPDATE contact_device SET latest_channel_creation_ping_timestamp = ?  WHERE uid = ?  AND contact_identity = ?  AND owned_identity = ?;");){
            statement.setLong(1, timestamp);
            statement.setBytes(2, this.uid.getBytes());
            statement.setBytes(3, this.contactIdentity.getBytes());
            statement.setBytes(4, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.latestChannelCreationPingTimestamp = timestamp;
        }
    }

    public void setPreKey(PreKeyBlobOnServer preKeyBlob) throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactDevice.setPreKey", "UPDATE contact_device SET pre_key_id = ?, pre_key_encryption_public_key = ?, pre_key_expiration_timestamp = ?  WHERE uid = ?  AND owned_identity = ?;");){
            boolean preKeyAddedOrRemoved;
            if (preKeyBlob == null) {
                statement.setNull(1, 2004);
                statement.setNull(2, 2004);
                statement.setNull(3, -5);
                preKeyAddedOrRemoved = this.preKeyId != null;
                this.preKeyId = null;
                this.preKeyEncryptionPublicKey = null;
                this.preKeyExpirationTimestamp = null;
            } else {
                statement.setBytes(1, preKeyBlob.preKey.keyId.getBytes());
                statement.setBytes(2, Encoded.of(preKeyBlob.preKey.encryptionPublicKey).getBytes());
                statement.setLong(3, preKeyBlob.preKey.expirationTimestamp);
                preKeyAddedOrRemoved = this.preKeyId == null;
                this.preKeyId = preKeyBlob.preKey.keyId;
                this.preKeyEncryptionPublicKey = preKeyBlob.preKey.encryptionPublicKey;
                this.preKeyExpirationTimestamp = preKeyBlob.preKey.expirationTimestamp;
                if (this.serializedDeviceCapabilities == null && preKeyBlob.rawDeviceCapabilities != null) {
                    this.setRawDeviceCapabilities(preKeyBlob.rawDeviceCapabilities);
                }
            }
            statement.setBytes(4, this.uid.getBytes());
            statement.setBytes(5, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            if (preKeyAddedOrRemoved) {
                this.commitHookBits |= 4L;
                this.identityManagerSession.session.addSessionCommitListener(this);
            }
        }
    }

    @Override
    public void wasCommitted() {
        HashMap<String, Object> userInfo;
        if ((this.commitHookBits & 1L) != 0L) {
            userInfo = new HashMap<String, Object>();
            userInfo.put("contact_device_uid", this.uid);
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            userInfo.put(CONTACT_IDENTITY, this.contactIdentity);
            userInfo.put("channel_creation_already_in_progress", this.channelCreationAlreadyInProgress);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_new_contact_device", userInfo);
        }
        if ((this.commitHookBits & 2L) != 0L) {
            userInfo = new HashMap();
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            userInfo.put(CONTACT_IDENTITY, this.contactIdentity);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_contact_capabilities_updated", userInfo);
        }
        if ((this.commitHookBits & 4L) != 0L) {
            userInfo = new HashMap();
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            userInfo.put(CONTACT_IDENTITY, this.contactIdentity);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_contact_devices_changed", userInfo);
        }
        this.commitHookBits = 0L;
    }
}

