/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine.types.sync;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.identities.ObvIdentity;
import io.olvid.engine.engine.types.sync.ObvBackupAndSyncDelegate;
import io.olvid.engine.engine.types.sync.ObvSyncDiff;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshotNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ObvSyncSnapshot {
    private final HashMap<String, ObvSyncSnapshotNode> snapshotMap;

    private ObvSyncSnapshot(HashMap<String, ObvSyncSnapshotNode> snapshotMap) {
        this.snapshotMap = snapshotMap;
    }

    public static ObvSyncSnapshot get(Identity ownedIdentity, ObvBackupAndSyncDelegate ... delegates) {
        HashMap<String, ObvSyncSnapshotNode> snapshotMap = new HashMap<String, ObvSyncSnapshotNode>();
        for (ObvBackupAndSyncDelegate delegate : delegates) {
            snapshotMap.put(delegate.getTag(), delegate.getSyncSnapshot(ownedIdentity));
        }
        return new ObvSyncSnapshot(snapshotMap);
    }

    public List<ObvBackupAndSyncDelegate.RestoreFinishedCallback> restoreOwnedIdentity(ObvIdentity obvOwnedIdentity, ObvBackupAndSyncDelegate ... delegates) throws Exception {
        ArrayList<ObvBackupAndSyncDelegate.RestoreFinishedCallback> callbacks = new ArrayList<ObvBackupAndSyncDelegate.RestoreFinishedCallback>();
        try {
            for (ObvBackupAndSyncDelegate delegate : delegates) {
                ObvSyncSnapshotNode node = this.snapshotMap.get(delegate.getTag());
                if (node == null) {
                    throw new Exception();
                }
                ObvBackupAndSyncDelegate.RestoreFinishedCallback callback = delegate.restoreOwnedIdentity(obvOwnedIdentity, node);
                if (callback == null) continue;
                callbacks.add(callback);
            }
            return callbacks;
        }
        catch (Exception e) {
            for (ObvBackupAndSyncDelegate.RestoreFinishedCallback callback : callbacks) {
                try {
                    callback.onRestoreFailure();
                }
                catch (Exception exception) {}
            }
            throw e;
        }
    }

    public List<ObvBackupAndSyncDelegate.RestoreFinishedCallback> restore(ObvBackupAndSyncDelegate ... delegates) throws Exception {
        ArrayList<ObvBackupAndSyncDelegate.RestoreFinishedCallback> callbacks = new ArrayList<ObvBackupAndSyncDelegate.RestoreFinishedCallback>();
        try {
            for (ObvBackupAndSyncDelegate delegate : delegates) {
                ObvSyncSnapshotNode node = this.snapshotMap.get(delegate.getTag());
                if (node == null) {
                    throw new Exception();
                }
                ObvBackupAndSyncDelegate.RestoreFinishedCallback callback = delegate.restoreSyncSnapshot(node);
                if (callback == null) continue;
                callbacks.add(callback);
            }
            return callbacks;
        }
        catch (Exception e) {
            for (ObvBackupAndSyncDelegate.RestoreFinishedCallback callback : callbacks) {
                try {
                    callback.onRestoreFailure();
                }
                catch (Exception exception) {}
            }
            throw e;
        }
    }

    public HashMap<DictionaryKey, Encoded> toEncodedDictionary(ObvBackupAndSyncDelegate ... delegates) {
        try {
            HashMap<DictionaryKey, Encoded> map = new HashMap<DictionaryKey, Encoded>();
            for (ObvBackupAndSyncDelegate delegate : delegates) {
                ObvSyncSnapshotNode node = this.snapshotMap.get(delegate.getTag());
                if (node == null) {
                    return null;
                }
                map.put(new DictionaryKey(delegate.getTag()), Encoded.of(delegate.serialize(ObvBackupAndSyncDelegate.SerializationContext.PROFILE, node)));
            }
            return map;
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    public static ObvSyncSnapshot fromEncodedDictionary(HashMap<DictionaryKey, Encoded> map, ObvBackupAndSyncDelegate ... delegates) {
        try {
            HashMap<String, ObvSyncSnapshotNode> snapshotMap = new HashMap<String, ObvSyncSnapshotNode>();
            for (ObvBackupAndSyncDelegate delegate : delegates) {
                Encoded encodedNode = map.get(new DictionaryKey(delegate.getTag()));
                if (encodedNode == null) {
                    return null;
                }
                snapshotMap.put(delegate.getTag(), delegate.deserialize(ObvBackupAndSyncDelegate.SerializationContext.PROFILE, encodedNode.decodeBytes()));
            }
            return new ObvSyncSnapshot(snapshotMap);
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    public boolean areContentsTheSame(ObvSyncSnapshot otherSnapshot) {
        if (otherSnapshot == null) {
            return false;
        }
        if (!Objects.equals(this.snapshotMap.keySet(), otherSnapshot.snapshotMap.keySet())) {
            return false;
        }
        for (Map.Entry<String, ObvSyncSnapshotNode> entry : this.snapshotMap.entrySet()) {
            if (entry.getValue().areContentsTheSame(otherSnapshot.snapshotMap.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public List<ObvSyncDiff> computeDiff(ObvSyncSnapshot otherSnapshot) throws Exception {
        if (otherSnapshot == null || !Objects.equals(this.snapshotMap.keySet(), otherSnapshot.snapshotMap.keySet())) {
            throw new Exception();
        }
        ArrayList<ObvSyncDiff> diffs = new ArrayList<ObvSyncDiff>();
        for (Map.Entry<String, ObvSyncSnapshotNode> entry : this.snapshotMap.entrySet()) {
            diffs.addAll(entry.getValue().computeDiff(otherSnapshot.snapshotMap.get(entry.getKey())));
        }
        return diffs;
    }

    public ObvSyncSnapshotNode getSnapshotNode(String tag) {
        return this.snapshotMap.get(tag);
    }
}

