/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine.types.identities;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvBase64;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ObvUrlIdentity {
    public static final String URL_PROTOCOL = "https";
    public static final String URL_PROTOCOL_OLVID = "olvid";
    public static final String URL_INVITATION_HOST = "invitation.olvid.io";
    public static final Pattern INVITATION_PATTERN = Pattern.compile("(https|olvid)" + Pattern.quote("://invitation.olvid.io") + "/([-_a-zA-Z0-9]*)?#([-_a-zA-Z0-9]+)");
    public final Identity identity;
    public final String displayName;

    public ObvUrlIdentity(Identity identity, String displayName) {
        this.identity = identity;
        this.displayName = displayName;
    }

    public ObvUrlIdentity(byte[] bytesIdentity, String displayName) {
        Identity identity;
        try {
            identity = Identity.of(bytesIdentity);
        }
        catch (DecodingException e) {
            identity = null;
        }
        this.identity = identity;
        this.displayName = displayName;
    }

    public byte[] getBytesIdentity() {
        return this.identity.getBytes();
    }

    public String getUrlRepresentation(boolean forMutualScan) {
        return "https://invitation.olvid.io" + (forMutualScan ? "/1#" : "/#") + ObvBase64.encode(Encoded.of(new Encoded[]{Encoded.of(this.identity), Encoded.of(this.displayName)}).getBytes());
    }

    public static ObvUrlIdentity fromUrlRepresentation(String urlRepresentation) {
        Matcher matcher = INVITATION_PATTERN.matcher(urlRepresentation);
        if (matcher.find()) {
            try {
                Encoded[] list = new Encoded(ObvBase64.decode(matcher.group(3))).decodeList();
                Identity identity = list[0].decodeIdentity();
                String displayName = list[1].decodeString();
                return new ObvUrlIdentity(identity, displayName);
            }
            catch (Exception e) {
                Logger.x(e);
                return null;
            }
        }
        return null;
    }
}

