/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine.types.identities;

import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import java.util.HashMap;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.lang.JoseException;

public class ObvKeycloakState {
    public final String keycloakServer;
    public final String clientId;
    public final String clientSecret;
    public final JsonWebKeySet jwks;
    public final JsonWebKey signatureKey;
    public final String serializedAuthState;
    public final boolean transferRestricted;
    public final String ownApiKey;
    public final long latestRevocationListTimestamp;
    public final long latestGroupUpdateTimestamp;

    public ObvKeycloakState(String keycloakServer, String clientId, String clientSecret, JsonWebKeySet jwks, JsonWebKey signatureKey, String serializedAuthState, boolean transferRestricted, String ownApiKey, long latestRevocationListTimestamp, long latestGroupUpdateTimestamp) {
        this.keycloakServer = keycloakServer;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.jwks = jwks;
        this.signatureKey = signatureKey;
        this.serializedAuthState = serializedAuthState;
        this.transferRestricted = transferRestricted;
        this.ownApiKey = ownApiKey;
        this.latestRevocationListTimestamp = latestRevocationListTimestamp;
        this.latestGroupUpdateTimestamp = latestGroupUpdateTimestamp;
    }

    public Encoded encode() {
        HashMap<DictionaryKey, Encoded> dict = new HashMap<DictionaryKey, Encoded>();
        if (this.keycloakServer != null) {
            dict.put(new DictionaryKey("ks"), Encoded.of(this.keycloakServer));
        }
        if (this.clientId != null) {
            dict.put(new DictionaryKey("ci"), Encoded.of(this.clientId));
        }
        if (this.clientSecret != null) {
            dict.put(new DictionaryKey("cs"), Encoded.of(this.clientSecret));
        }
        if (this.jwks != null) {
            dict.put(new DictionaryKey("jwks"), Encoded.of(this.jwks.toJson()));
        }
        if (this.signatureKey != null) {
            dict.put(new DictionaryKey("sk"), Encoded.of(this.signatureKey.toJson()));
        }
        if (this.serializedAuthState != null) {
            dict.put(new DictionaryKey("sas"), Encoded.of(this.serializedAuthState));
        }
        if (this.transferRestricted) {
            dict.put(new DictionaryKey("tr"), Encoded.of(this.transferRestricted));
        }
        return Encoded.of(dict);
    }

    public static ObvKeycloakState of(Encoded encoded) throws DecodingException {
        JsonWebKey signatureKey;
        JsonWebKeySet jwks;
        DictionaryKey key;
        HashMap<DictionaryKey, Encoded> dict = encoded.decodeDictionary();
        Encoded encodedValue = dict.get(key = new DictionaryKey("ks"));
        String keycloakServer = encodedValue != null ? encodedValue.decodeString() : null;
        key = new DictionaryKey("ci");
        encodedValue = dict.get(key);
        String clientId = encodedValue != null ? encodedValue.decodeString() : null;
        key = new DictionaryKey("cs");
        encodedValue = dict.get(key);
        String clientSecret = encodedValue != null ? encodedValue.decodeString() : null;
        key = new DictionaryKey("jwks");
        encodedValue = dict.get(key);
        if (encodedValue != null) {
            try {
                jwks = new JsonWebKeySet(encodedValue.decodeString());
            }
            catch (JoseException e) {
                jwks = null;
            }
        } else {
            jwks = null;
        }
        if ((encodedValue = dict.get(key = new DictionaryKey("sk"))) != null) {
            try {
                signatureKey = JsonWebKey.Factory.newJwk((String)encodedValue.decodeString());
            }
            catch (JoseException e) {
                signatureKey = null;
            }
        } else {
            signatureKey = null;
        }
        String serializedAuthState = (encodedValue = dict.get(key = new DictionaryKey("sas"))) != null ? encodedValue.decodeString() : null;
        key = new DictionaryKey("tr");
        encodedValue = dict.get(key);
        boolean transferRestricted = encodedValue != null ? encodedValue.decodeBoolean() : false;
        return new ObvKeycloakState(keycloakServer, clientId, clientSecret, jwks, signatureKey, serializedAuthState, transferRestricted, null, 0L, 0L);
    }
}

