/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine.types.identities;

import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.ObvBytesKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ObvGroupV2 {
    public final byte[] bytesOwnedIdentity;
    public final GroupV2.Identifier groupIdentifier;
    public final HashSet<GroupV2.Permission> ownPermissions;
    public final HashSet<ObvGroupV2Member> otherGroupMembers;
    public final HashSet<ObvGroupV2PendingMember> pendingGroupMembers;
    public final ObvGroupV2DetailsAndPhotos detailsAndPhotos;
    public final long lastModificationTimestamp;

    public ObvGroupV2(byte[] bytesOwnedIdentity, GroupV2.Identifier groupIdentifier, HashSet<GroupV2.Permission> ownPermissions, HashSet<ObvGroupV2Member> otherGroupMembers, HashSet<ObvGroupV2PendingMember> pendingGroupMembers, String serializedGroupDetails, String photoUrl, String serializedPublishedDetails, String publishedPhotoUrl, long lastModificationTimestamp) {
        this.bytesOwnedIdentity = bytesOwnedIdentity;
        this.groupIdentifier = groupIdentifier;
        this.ownPermissions = ownPermissions;
        this.otherGroupMembers = otherGroupMembers;
        this.pendingGroupMembers = pendingGroupMembers;
        this.detailsAndPhotos = new ObvGroupV2DetailsAndPhotos(serializedGroupDetails, photoUrl, serializedPublishedDetails, publishedPhotoUrl);
        this.lastModificationTimestamp = lastModificationTimestamp;
    }

    private ObvGroupV2(byte[] bytesOwnedIdentity, GroupV2.Identifier groupIdentifier, HashSet<GroupV2.Permission> ownPermissions, HashSet<ObvGroupV2Member> otherGroupMembers, HashSet<ObvGroupV2PendingMember> pendingGroupMembers, ObvGroupV2DetailsAndPhotos detailsAndPhotos) {
        this.bytesOwnedIdentity = bytesOwnedIdentity;
        this.groupIdentifier = groupIdentifier;
        this.ownPermissions = ownPermissions;
        this.otherGroupMembers = otherGroupMembers;
        this.pendingGroupMembers = pendingGroupMembers;
        this.detailsAndPhotos = detailsAndPhotos;
        this.lastModificationTimestamp = 0L;
    }

    public Encoded encode() {
        ArrayList<Encoded> encodedMembers = new ArrayList<Encoded>();
        ArrayList<Encoded> encodedPendingMembers = new ArrayList<Encoded>();
        if (this.otherGroupMembers != null) {
            for (ObvGroupV2Member obvGroupV2Member : this.otherGroupMembers) {
                encodedMembers.add(obvGroupV2Member.encode());
            }
        }
        if (this.pendingGroupMembers != null) {
            for (ObvGroupV2PendingMember obvGroupV2PendingMember : this.pendingGroupMembers) {
                encodedPendingMembers.add(obvGroupV2PendingMember.encode());
            }
        }
        return Encoded.of(new Encoded[]{Encoded.of(this.bytesOwnedIdentity), this.groupIdentifier.encode(), Encoded.of(GroupV2.Permission.serializePermissions(this.ownPermissions)), Encoded.of(encodedMembers.toArray(new Encoded[0])), Encoded.of(encodedPendingMembers.toArray(new Encoded[0])), this.detailsAndPhotos.encode()});
    }

    public static ObvGroupV2 of(Encoded encoded) throws DecodingException {
        Encoded[] list = encoded.decodeList();
        if (list.length != 6) {
            throw new DecodingException();
        }
        HashSet<ObvGroupV2Member> otherGroupMembers = new HashSet<ObvGroupV2Member>();
        HashSet<ObvGroupV2PendingMember> pendingGroupMembers = new HashSet<ObvGroupV2PendingMember>();
        for (Encoded encodedMember : list[3].decodeList()) {
            otherGroupMembers.add(ObvGroupV2Member.of(encodedMember));
        }
        for (Encoded encodedMember : list[4].decodeList()) {
            pendingGroupMembers.add(ObvGroupV2PendingMember.of(encodedMember));
        }
        return new ObvGroupV2(list[0].decodeBytes(), GroupV2.Identifier.of(list[1]), GroupV2.Permission.deserializeKnownPermissions(list[2].decodeBytes()), otherGroupMembers, pendingGroupMembers, ObvGroupV2DetailsAndPhotos.of(list[5]));
    }

    public static class ObvGroupV2DetailsAndPhotos {
        public final String serializedGroupDetails;
        public final String photoUrl;
        public final String serializedPublishedDetails;
        public final String publishedPhotoUrl;
        private static final String SERIALIZED_GROUP_DETAILS_KEY = "sgd";
        private static final String PHOTO_URL_KEY = "pu";
        private static final String SERIALIZED_PUBLISHED_DETAILS_KEY = "spd";
        private static final String PUBLISHED_PHOTO_URL_KEY = "ppu";

        public ObvGroupV2DetailsAndPhotos(String serializedGroupDetails, String photoUrl, String serializedPublishedDetails, String publishedPhotoUrl) {
            this.serializedGroupDetails = serializedGroupDetails;
            this.photoUrl = photoUrl;
            this.serializedPublishedDetails = serializedPublishedDetails;
            this.publishedPhotoUrl = publishedPhotoUrl;
        }

        public String getNullIfEmptyPhotoUrl() {
            if (this.photoUrl == null || this.photoUrl.isEmpty()) {
                return null;
            }
            return this.photoUrl;
        }

        public String getNullIfEmptyPublishedPhotoUrl() {
            if (this.publishedPhotoUrl == null || this.publishedPhotoUrl.isEmpty()) {
                return null;
            }
            return this.publishedPhotoUrl;
        }

        Encoded encode() {
            HashMap<DictionaryKey, Encoded> map = new HashMap<DictionaryKey, Encoded>();
            map.put(new DictionaryKey(SERIALIZED_GROUP_DETAILS_KEY), Encoded.of(this.serializedGroupDetails));
            if (this.photoUrl != null) {
                map.put(new DictionaryKey(PHOTO_URL_KEY), Encoded.of(this.photoUrl));
            }
            if (this.serializedPublishedDetails != null) {
                map.put(new DictionaryKey(SERIALIZED_PUBLISHED_DETAILS_KEY), Encoded.of(this.serializedPublishedDetails));
            }
            if (this.publishedPhotoUrl != null) {
                map.put(new DictionaryKey(PUBLISHED_PHOTO_URL_KEY), Encoded.of(this.publishedPhotoUrl));
            }
            return Encoded.of(map);
        }

        static ObvGroupV2DetailsAndPhotos of(Encoded encoded) throws DecodingException {
            HashMap<DictionaryKey, Encoded> detailsMap = encoded.decodeDictionary();
            Encoded enc = detailsMap.get(new DictionaryKey(SERIALIZED_GROUP_DETAILS_KEY));
            String serializedGroupDetails = enc.decodeString();
            enc = detailsMap.get(new DictionaryKey(PHOTO_URL_KEY));
            String photoUrl = enc == null ? null : enc.decodeString();
            enc = detailsMap.get(new DictionaryKey(PHOTO_URL_KEY));
            String serializedPublishedDetails = enc == null ? null : enc.decodeString();
            enc = detailsMap.get(new DictionaryKey(PHOTO_URL_KEY));
            String publishedPhotoUrl = enc == null ? null : enc.decodeString();
            return new ObvGroupV2DetailsAndPhotos(serializedGroupDetails, photoUrl, serializedPublishedDetails, publishedPhotoUrl);
        }
    }

    public static class ObvGroupV2Member {
        public final byte[] bytesIdentity;
        public final HashSet<GroupV2.Permission> permissions;

        public ObvGroupV2Member(byte[] bytesIdentity, HashSet<GroupV2.Permission> permissions) {
            this.bytesIdentity = bytesIdentity;
            this.permissions = permissions;
        }

        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.bytesIdentity), Encoded.of(GroupV2.Permission.serializePermissions(this.permissions))});
        }

        public static ObvGroupV2Member of(Encoded encoded) throws DecodingException {
            Encoded[] list = encoded.decodeList();
            if (list.length != 2) {
                throw new DecodingException();
            }
            return new ObvGroupV2Member(list[0].decodeBytes(), GroupV2.Permission.deserializeKnownPermissions(list[1].decodeBytes()));
        }
    }

    public static class ObvGroupV2PendingMember {
        public final byte[] bytesIdentity;
        public final HashSet<GroupV2.Permission> permissions;
        public final String serializedDetails;

        public ObvGroupV2PendingMember(byte[] bytesIdentity, HashSet<GroupV2.Permission> permissions, String serializedDetails) {
            this.bytesIdentity = bytesIdentity;
            this.permissions = permissions;
            this.serializedDetails = serializedDetails;
        }

        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.bytesIdentity), Encoded.of(GroupV2.Permission.serializePermissions(this.permissions)), Encoded.of(this.serializedDetails)});
        }

        public static ObvGroupV2PendingMember of(Encoded encoded) throws DecodingException {
            Encoded[] list = encoded.decodeList();
            if (list.length != 3) {
                throw new DecodingException();
            }
            return new ObvGroupV2PendingMember(list[0].decodeBytes(), GroupV2.Permission.deserializeKnownPermissions(list[1].decodeBytes()), list[2].decodeString());
        }
    }

    public static class ObvGroupV2ChangeSet {
        public final List<byte[]> removedMembers = new ArrayList<byte[]>();
        public final HashMap<ObvBytesKey, HashSet<GroupV2.Permission>> addedMembersWithPermissions = new HashMap();
        public final HashMap<ObvBytesKey, HashSet<GroupV2.Permission>> permissionChanges = new HashMap();
        public String updatedSerializedGroupDetails = null;
        public String updatedJsonGroupType = null;
        public String updatedPhotoUrl = null;

        public boolean isEmpty() {
            return this.removedMembers.isEmpty() && this.addedMembersWithPermissions.isEmpty() && this.permissionChanges.isEmpty() && this.updatedPhotoUrl == null && this.updatedSerializedGroupDetails == null && this.updatedJsonGroupType == null;
        }

        public Encoded encode() {
            byte[] serializedPermissions;
            ArrayList<Encoded> encodeds;
            HashMap<DictionaryKey, Encoded> dic = new HashMap<DictionaryKey, Encoded>();
            if (!this.removedMembers.isEmpty()) {
                encodeds = new ArrayList<Encoded>();
                for (byte[] byArray : this.removedMembers) {
                    encodeds.add(Encoded.of(byArray));
                }
                dic.put(new DictionaryKey("rm"), Encoded.of(encodeds.toArray(new Encoded[0])));
            }
            if (!this.addedMembersWithPermissions.isEmpty()) {
                encodeds = new ArrayList();
                for (Map.Entry entry : this.addedMembersWithPermissions.entrySet()) {
                    serializedPermissions = GroupV2.Permission.serializePermissions((Collection)entry.getValue());
                    if (serializedPermissions == null) continue;
                    encodeds.add(Encoded.of(((ObvBytesKey)entry.getKey()).getBytes()));
                    encodeds.add(Encoded.of(serializedPermissions));
                }
                dic.put(new DictionaryKey("am"), Encoded.of(encodeds.toArray(new Encoded[0])));
            }
            if (!this.permissionChanges.isEmpty()) {
                encodeds = new ArrayList();
                for (Map.Entry entry : this.permissionChanges.entrySet()) {
                    serializedPermissions = GroupV2.Permission.serializePermissions((Collection)entry.getValue());
                    if (serializedPermissions == null) continue;
                    encodeds.add(Encoded.of(((ObvBytesKey)entry.getKey()).getBytes()));
                    encodeds.add(Encoded.of(serializedPermissions));
                }
                dic.put(new DictionaryKey("pc"), Encoded.of(encodeds.toArray(new Encoded[0])));
            }
            if (this.updatedSerializedGroupDetails != null) {
                dic.put(new DictionaryKey("gd"), Encoded.of(this.updatedSerializedGroupDetails));
            }
            if (this.updatedJsonGroupType != null) {
                dic.put(new DictionaryKey("gt"), Encoded.of(this.updatedJsonGroupType));
            }
            if (this.updatedPhotoUrl != null) {
                dic.put(new DictionaryKey("pu"), Encoded.of(this.updatedPhotoUrl));
            }
            return Encoded.of(dic);
        }

        public static ObvGroupV2ChangeSet of(Encoded encoded) throws DecodingException {
            int i;
            Encoded[] encodeds;
            HashMap<DictionaryKey, Encoded> dic = encoded.decodeDictionary();
            ObvGroupV2ChangeSet changeSet = new ObvGroupV2ChangeSet();
            Encoded enc = dic.get(new DictionaryKey("rm"));
            if (enc != null) {
                for (Encoded encodedGroupMember : enc.decodeList()) {
                    changeSet.removedMembers.add(encodedGroupMember.decodeBytes());
                }
            }
            if ((enc = dic.get(new DictionaryKey("am"))) != null) {
                encodeds = enc.decodeList();
                for (i = 0; i < encodeds.length; i += 2) {
                    changeSet.addedMembersWithPermissions.put(new ObvBytesKey(encodeds[i].decodeBytes()), GroupV2.Permission.deserializeKnownPermissions(encodeds[i + 1].decodeBytes()));
                }
            }
            if ((enc = dic.get(new DictionaryKey("pc"))) != null) {
                encodeds = enc.decodeList();
                for (i = 0; i < encodeds.length; i += 2) {
                    changeSet.permissionChanges.put(new ObvBytesKey(encodeds[i].decodeBytes()), GroupV2.Permission.deserializeKnownPermissions(encodeds[i + 1].decodeBytes()));
                }
            }
            if ((enc = dic.get(new DictionaryKey("gd"))) != null) {
                changeSet.updatedSerializedGroupDetails = enc.decodeString();
            }
            if ((enc = dic.get(new DictionaryKey("gt"))) != null) {
                changeSet.updatedJsonGroupType = enc.decodeString();
            }
            if ((enc = dic.get(new DictionaryKey("pu"))) != null) {
                changeSet.updatedPhotoUrl = enc.decodeString();
            }
            return changeSet;
        }
    }
}

