/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine.types;

import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import java.util.HashMap;
import java.util.Map;

public abstract class ObvTransferStep {
    public abstract Step getStep();

    public abstract Encoded[] getEncodedParts();

    public static ObvTransferStep of(Encoded encoded) throws DecodingException {
        Encoded[] list = encoded.decodeList();
        if (list.length != 2) {
            throw new DecodingException();
        }
        int id = (int)list[0].decodeLong();
        Encoded[] encodedParts = list[1].decodeList();
        Step step = Step.fromIntValue(id);
        if (step == null) {
            throw new DecodingException();
        }
        switch (step.ordinal()) {
            case 0: {
                return new Fail(encodedParts);
            }
            case 1: {
                return new SourceWaitForSessionNumberStep(encodedParts);
            }
            case 2: {
                return new SourceDisplaySessionNumber(encodedParts);
            }
            case 3: {
                return new TargetSessionNumberInput(encodedParts);
            }
            case 4: {
                return new OngoingProtocol(encodedParts);
            }
            case 5: {
                return new SourceSasInput(encodedParts);
            }
            case 6: {
                return new TargetShowSas(encodedParts);
            }
            case 7: {
                return new SourceSnapshotSent(encodedParts);
            }
            case 8: {
                return new TargetSnapshotReceived(encodedParts);
            }
            case 9: {
                return new TargetRequestsKeycloakAuthenticationProof(encodedParts);
            }
        }
        throw new DecodingException();
    }

    Encoded encode() {
        return Encoded.of(new Encoded[]{Encoded.of(this.getStep().value), Encoded.of(this.getEncodedParts())});
    }

    public static enum Step {
        FAIL(1000),
        SOURCE_WAIT_FOR_SESSION_NUMBER(0),
        SOURCE_DISPLAY_SESSION_NUMBER(1),
        TARGET_SESSION_NUMBER_INPUT(2),
        ONGOING_PROTOCOL(3),
        SOURCE_SAS_INPUT(4),
        TARGET_SHOW_SAS(5),
        SOURCE_SNAPSHOT_SENT(6),
        TARGET_SNAPSHOT_RECEIVED(7),
        TARGET_REQUESTS_KEYCLOAK_AUTHENTICATION_PROOF(8);

        private static final Map<Integer, Step> valueMap;
        final int value;

        private Step(int value) {
            this.value = value;
        }

        static Step fromIntValue(int value) {
            return valueMap.get(value);
        }

        static {
            valueMap = new HashMap<Integer, Step>();
            for (Step step : Step.values()) {
                valueMap.put(step.value, step);
            }
        }
    }

    public static class Fail
    extends ObvTransferStep {
        public static final int FAIL_REASON_NETWORK_ERROR = 1;
        public static final int FAIL_REASON_TRANSFERRED_IDENTITY_ALREADY_EXISTS = 2;
        public static final int FAIL_REASON_INVALID_RESPONSE = 3;
        public final int failReason;

        public Fail(int failReason) {
            this.failReason = failReason;
        }

        public Fail(Encoded[] encodedParts) throws DecodingException {
            if (encodedParts.length != 1) {
                throw new DecodingException();
            }
            this.failReason = (int)encodedParts[0].decodeLong();
        }

        @Override
        public Step getStep() {
            return Step.FAIL;
        }

        @Override
        public Encoded[] getEncodedParts() {
            return new Encoded[]{Encoded.of(this.failReason)};
        }
    }

    public static class SourceWaitForSessionNumberStep
    extends ObvTransferStep {
        public SourceWaitForSessionNumberStep() {
        }

        public SourceWaitForSessionNumberStep(Encoded[] encodedParts) throws DecodingException {
            if (encodedParts.length != 0) {
                throw new DecodingException();
            }
        }

        @Override
        public Step getStep() {
            return Step.SOURCE_WAIT_FOR_SESSION_NUMBER;
        }

        @Override
        public Encoded[] getEncodedParts() {
            return new Encoded[0];
        }
    }

    public static class SourceDisplaySessionNumber
    extends ObvTransferStep {
        public final long sessionNumber;

        public SourceDisplaySessionNumber(long sessionNumber) {
            this.sessionNumber = sessionNumber;
        }

        public SourceDisplaySessionNumber(Encoded[] encodedParts) throws DecodingException {
            if (encodedParts.length != 1) {
                throw new DecodingException();
            }
            this.sessionNumber = encodedParts[0].decodeLong();
        }

        @Override
        public Step getStep() {
            return Step.SOURCE_DISPLAY_SESSION_NUMBER;
        }

        @Override
        public Encoded[] getEncodedParts() {
            return new Encoded[]{Encoded.of(this.sessionNumber)};
        }
    }

    public static class TargetSessionNumberInput
    extends ObvTransferStep {
        public TargetSessionNumberInput() {
        }

        public TargetSessionNumberInput(Encoded[] encodedParts) throws DecodingException {
            if (encodedParts.length != 0) {
                throw new DecodingException();
            }
        }

        @Override
        public Step getStep() {
            return Step.TARGET_SESSION_NUMBER_INPUT;
        }

        @Override
        public Encoded[] getEncodedParts() {
            return new Encoded[0];
        }
    }

    public static class OngoingProtocol
    extends ObvTransferStep {
        public OngoingProtocol() {
        }

        public OngoingProtocol(Encoded[] encodedParts) throws DecodingException {
            if (encodedParts.length != 0) {
                throw new DecodingException();
            }
        }

        @Override
        public Step getStep() {
            return Step.ONGOING_PROTOCOL;
        }

        @Override
        public Encoded[] getEncodedParts() {
            return new Encoded[0];
        }
    }

    public static class SourceSasInput
    extends ObvTransferStep {
        public final String correctSas;
        public final String targetDeviceName;

        public SourceSasInput(String correctSas, String targetDeviceName) {
            this.correctSas = correctSas;
            this.targetDeviceName = targetDeviceName;
        }

        public SourceSasInput(Encoded[] encodedParts) throws DecodingException {
            if (encodedParts.length != 2) {
                throw new DecodingException();
            }
            this.correctSas = encodedParts[0].decodeString();
            this.targetDeviceName = encodedParts[1].decodeString();
        }

        @Override
        public Step getStep() {
            return Step.SOURCE_SAS_INPUT;
        }

        @Override
        public Encoded[] getEncodedParts() {
            return new Encoded[]{Encoded.of(this.correctSas), Encoded.of(this.targetDeviceName)};
        }
    }

    public static class TargetShowSas
    extends ObvTransferStep {
        public final String sas;

        public TargetShowSas(String sas) {
            this.sas = sas;
        }

        public TargetShowSas(Encoded[] encodedParts) throws DecodingException {
            if (encodedParts.length != 1) {
                throw new DecodingException();
            }
            this.sas = encodedParts[0].decodeString();
        }

        @Override
        public Step getStep() {
            return Step.TARGET_SHOW_SAS;
        }

        @Override
        public Encoded[] getEncodedParts() {
            return new Encoded[]{Encoded.of(this.sas)};
        }
    }

    public static class SourceSnapshotSent
    extends ObvTransferStep {
        public SourceSnapshotSent() {
        }

        public SourceSnapshotSent(Encoded[] encodedParts) throws DecodingException {
            if (encodedParts.length != 0) {
                throw new DecodingException();
            }
        }

        @Override
        public Step getStep() {
            return Step.SOURCE_SNAPSHOT_SENT;
        }

        @Override
        public Encoded[] getEncodedParts() {
            return new Encoded[0];
        }
    }

    public static class TargetSnapshotReceived
    extends ObvTransferStep {
        public TargetSnapshotReceived() {
        }

        public TargetSnapshotReceived(Encoded[] encodedParts) throws DecodingException {
            if (encodedParts.length != 0) {
                throw new DecodingException();
            }
        }

        @Override
        public Step getStep() {
            return Step.TARGET_SNAPSHOT_RECEIVED;
        }

        @Override
        public Encoded[] getEncodedParts() {
            return new Encoded[0];
        }
    }

    public static class TargetRequestsKeycloakAuthenticationProof
    extends ObvTransferStep {
        public final String keycloakServerUrl;
        public final String clientId;
        public final String fullSas;
        public final long sessionNumber;
        public final String clientSecret;

        public TargetRequestsKeycloakAuthenticationProof(String keycloakServerUrl, String clientId, String clientSecret, String fullSas, long sessionNumber) {
            this.keycloakServerUrl = keycloakServerUrl;
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            this.fullSas = fullSas;
            this.sessionNumber = sessionNumber;
        }

        public TargetRequestsKeycloakAuthenticationProof(Encoded[] encodedParts) throws DecodingException {
            if (encodedParts.length != 5 && encodedParts.length != 4) {
                throw new DecodingException();
            }
            this.keycloakServerUrl = encodedParts[0].decodeString();
            this.clientId = encodedParts[1].decodeString();
            this.fullSas = encodedParts[2].decodeString();
            this.sessionNumber = encodedParts[3].decodeLong();
            this.clientSecret = encodedParts.length == 5 ? encodedParts[4].decodeString() : null;
        }

        @Override
        public Step getStep() {
            return Step.TARGET_REQUESTS_KEYCLOAK_AUTHENTICATION_PROOF;
        }

        @Override
        public Encoded[] getEncodedParts() {
            if (this.clientSecret == null) {
                return new Encoded[]{Encoded.of(this.keycloakServerUrl), Encoded.of(this.clientId), Encoded.of(this.fullSas), Encoded.of(this.sessionNumber)};
            }
            return new Encoded[]{Encoded.of(this.keycloakServerUrl), Encoded.of(this.clientId), Encoded.of(this.fullSas), Encoded.of(this.sessionNumber), Encoded.of(this.clientSecret)};
        }
    }
}

