/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine.types;

import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.DecryptedApplicationMessage;
import io.olvid.engine.datatypes.containers.ReceivedAttachment;
import io.olvid.engine.engine.types.ObvAttachment;

public class ObvMessage {
    private final UID messageUid;
    private final long serverTimestamp;
    private final long downloadTimestamp;
    private final long localDownloadTimestamp;
    private final byte[] messagePayload;
    private final byte[] bytesFromIdentity;
    private final byte[] bytesFromDeviceUid;
    private final byte[] bytesToIdentity;
    private final ObvAttachment[] attachments;

    public byte[] getIdentifier() {
        return this.messageUid.getBytes();
    }

    public long getServerTimestamp() {
        return this.serverTimestamp;
    }

    public long getDownloadTimestamp() {
        return this.downloadTimestamp;
    }

    public long getLocalDownloadTimestamp() {
        return this.localDownloadTimestamp;
    }

    public byte[] getMessagePayload() {
        return this.messagePayload;
    }

    public byte[] getBytesFromIdentity() {
        return this.bytesFromIdentity;
    }

    public byte[] getBytesFromDeviceUid() {
        return this.bytesFromDeviceUid;
    }

    public byte[] getBytesToIdentity() {
        return this.bytesToIdentity;
    }

    public ObvAttachment[] getAttachments() {
        return this.attachments;
    }

    public ObvMessage(DecryptedApplicationMessage receivedMessage, ReceivedAttachment[] receivedAttachments) {
        this.messageUid = receivedMessage.getMessageUid();
        this.messagePayload = receivedMessage.getMessagePayload();
        this.serverTimestamp = receivedMessage.getServerTimestamp();
        this.downloadTimestamp = receivedMessage.getDownloadTimestamp();
        this.localDownloadTimestamp = receivedMessage.getLocalDownloadTimestamp();
        this.bytesFromIdentity = receivedMessage.getFromIdentity() != null ? receivedMessage.getFromIdentity().getBytes() : null;
        this.bytesFromDeviceUid = receivedMessage.getFromDeviceUid() != null ? receivedMessage.getFromDeviceUid().getBytes() : null;
        this.bytesToIdentity = receivedMessage.getToIdentity() != null ? receivedMessage.getToIdentity().getBytes() : null;
        this.attachments = new ObvAttachment[receivedAttachments.length];
        for (int i = 0; i < this.attachments.length; ++i) {
            ReceivedAttachment receivedAttachment = receivedAttachments[i];
            this.attachments[i] = new ObvAttachment(receivedAttachment.getMetadata(), receivedAttachment.getUrl(), receivedAttachment.isDownloadRequested(), receivedAttachment.getOwnedIdentity(), receivedAttachment.getMessageUid(), receivedMessage.getServerTimestamp(), receivedAttachment.getAttachmentNumber(), receivedAttachment.getExpectedLength(), receivedAttachment.getReceivedLength());
        }
    }
}

