/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine.types;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Arrays;

public class ObvGroupOwnerAndUidKey {
    public final byte[] groupOwner;
    public final byte[] groupUid;

    public ObvGroupOwnerAndUidKey(byte[] groupOwnerAndUid) {
        this.groupOwner = Arrays.copyOfRange(groupOwnerAndUid, 0, groupOwnerAndUid.length - 32);
        this.groupUid = Arrays.copyOfRange(groupOwnerAndUid, groupOwnerAndUid.length - 32, groupOwnerAndUid.length);
    }

    public ObvGroupOwnerAndUidKey(byte[] groupOwner, byte[] groupUid) {
        this.groupOwner = groupOwner;
        this.groupUid = groupUid;
    }

    public byte[] getGroupOwnerAndUid() {
        byte[] out = new byte[this.groupOwner.length + this.groupUid.length];
        System.arraycopy(this.groupOwner, 0, out, 0, this.groupOwner.length);
        System.arraycopy(this.groupUid, 0, out, this.groupOwner.length, this.groupUid.length);
        return out;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ObvGroupOwnerAndUidKey)) {
            return false;
        }
        return Arrays.equals(this.groupOwner, ((ObvGroupOwnerAndUidKey)other).groupOwner) && Arrays.equals(this.groupUid, ((ObvGroupOwnerAndUidKey)other).groupUid);
    }

    public int hashCode() {
        return Arrays.hashCode(this.groupOwner) * 31 + Arrays.hashCode(this.groupUid);
    }

    public static class Deserializer
    extends KeyDeserializer {
        public Object deserializeKey(String key, DeserializationContext context) throws IOException {
            String[] parts = key.split("-");
            if (parts.length != 2) {
                throw new IOException();
            }
            return new ObvGroupOwnerAndUidKey(context.getConfig().getBase64Variant().decode(parts[0]), context.getConfig().getBase64Variant().decode(parts[1]));
        }
    }

    public static class Serializer
    extends JsonSerializer<ObvGroupOwnerAndUidKey> {
        public void serialize(ObvGroupOwnerAndUidKey value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeFieldName(serializers.getConfig().getBase64Variant().encode(value.groupOwner) + "-" + serializers.getConfig().getBase64Variant().encode(value.groupUid));
        }
    }
}

