/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine.types;

import io.olvid.engine.datatypes.UID;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;

public class ObvDeviceManagementRequest {
    public static final int ACTION_SET_NICKNAME = 0;
    public static final int ACTION_DEACTIVATE_DEVICE = 1;
    public static final int ACTION_SET_UNEXPIRING_DEVICE = 2;
    public final int action;
    public final byte[] bytesDeviceUid;
    public final String nickname;

    public static ObvDeviceManagementRequest createSetNicknameRequest(byte[] bytesDeviceUid, String nickname) {
        if (nickname == null) {
            nickname = "";
        }
        return new ObvDeviceManagementRequest(0, bytesDeviceUid, nickname);
    }

    public static ObvDeviceManagementRequest createDeactivateDeviceRequest(byte[] bytesDeviceUid) {
        return new ObvDeviceManagementRequest(1, bytesDeviceUid, null);
    }

    public static ObvDeviceManagementRequest createSetUnexpiringDeviceRequest(byte[] bytesDeviceUid) {
        return new ObvDeviceManagementRequest(2, bytesDeviceUid, null);
    }

    private ObvDeviceManagementRequest(int action, byte[] bytesDeviceUid, String nickname) {
        this.action = action;
        this.bytesDeviceUid = bytesDeviceUid;
        this.nickname = nickname;
    }

    public UID getDeviceUid() {
        if (this.bytesDeviceUid == null) {
            return null;
        }
        return new UID(this.bytesDeviceUid);
    }

    public Encoded encode() {
        switch (this.action) {
            case 0: {
                return Encoded.of(new Encoded[]{Encoded.of(0L), Encoded.of(this.bytesDeviceUid), Encoded.of(this.nickname)});
            }
            case 1: {
                return Encoded.of(new Encoded[]{Encoded.of(1L), Encoded.of(this.bytesDeviceUid)});
            }
            case 2: {
                return Encoded.of(new Encoded[]{Encoded.of(2L), Encoded.of(this.bytesDeviceUid)});
            }
        }
        return null;
    }

    public static ObvDeviceManagementRequest of(Encoded encoded) throws DecodingException {
        Encoded[] encodeds = encoded.decodeList();
        int action = (int)encodeds[0].decodeLong();
        switch (action) {
            case 0: {
                if (encodeds.length != 3) {
                    throw new DecodingException();
                }
                UID deviceUid = encodeds[1].decodeUid();
                String nickname = encodeds[2].decodeString();
                return new ObvDeviceManagementRequest(0, deviceUid.getBytes(), nickname);
            }
            case 1: {
                if (encodeds.length != 2) {
                    throw new DecodingException();
                }
                UID deviceUid = encodeds[1].decodeUid();
                return new ObvDeviceManagementRequest(1, deviceUid.getBytes(), null);
            }
            case 2: {
                if (encodeds.length != 2) {
                    throw new DecodingException();
                }
                UID deviceUid = encodeds[1].decodeUid();
                return new ObvDeviceManagementRequest(2, deviceUid.getBytes(), null);
            }
        }
        throw new DecodingException();
    }
}

