/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine.types;

import io.olvid.engine.crypto.PublicKeyEncryption;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPrivateKey;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.ObvBytesKey;
import io.olvid.engine.engine.types.identities.ObvOwnedDevice;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;

public class ObvDeviceList {
    public final Boolean multiDevice;
    public final HashMap<ObvBytesKey, ObvOwnedDevice.ServerDeviceInfo> deviceUidsAndServerInfo;

    public ObvDeviceList(Boolean multiDevice, HashMap<ObvBytesKey, ObvOwnedDevice.ServerDeviceInfo> deviceUidsAndServerInfo) {
        this.deviceUidsAndServerInfo = deviceUidsAndServerInfo;
        this.multiDevice = multiDevice;
    }

    public static ObvDeviceList of(EncryptedBytes encryptedPayload, EncryptionPrivateKey privateKey) throws Exception {
        Encoded[] encodedDevices;
        PublicKeyEncryption publicKeyEncryption = Suite.getPublicKeyEncryption(privateKey);
        byte[] decryptedPayload = publicKeyEncryption.decrypt(privateKey, encryptedPayload);
        HashMap<DictionaryKey, Encoded> map = new Encoded(decryptedPayload).decodeDictionary();
        Encoded encodedMulti = map.get(new DictionaryKey("multi"));
        Boolean multiDevice = encodedMulti != null ? Boolean.valueOf(encodedMulti.decodeBoolean()) : null;
        HashMap<ObvBytesKey, ObvOwnedDevice.ServerDeviceInfo> deviceUidsAndServerInfo = new HashMap<ObvBytesKey, ObvOwnedDevice.ServerDeviceInfo>();
        for (Encoded encodedDevice : encodedDevices = map.get(new DictionaryKey("dev")).decodeList()) {
            HashMap<DictionaryKey, Encoded> deviceMap = encodedDevice.decodeDictionary();
            UID deviceUid = deviceMap.get(new DictionaryKey("uid")).decodeUid();
            Encoded encodedExpiration = deviceMap.get(new DictionaryKey("exp"));
            Long expirationTimestamp = encodedExpiration == null ? null : Long.valueOf(encodedExpiration.decodeLong());
            Encoded encodedRegistration = deviceMap.get(new DictionaryKey("reg"));
            Long lastRegistrationTimestamp = encodedRegistration == null ? null : Long.valueOf(encodedRegistration.decodeLong());
            Encoded encodedName = deviceMap.get(new DictionaryKey("name"));
            String deviceName = null;
            if (encodedName != null) {
                try {
                    byte[] plaintext = publicKeyEncryption.decrypt(privateKey, encodedName.decodeEncryptedData());
                    byte[] bytesDeviceName = new Encoded(plaintext).decodeListWithPadding()[0].decodeBytes();
                    if (bytesDeviceName.length != 0) {
                        deviceName = new String(bytesDeviceName, StandardCharsets.UTF_8);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            deviceUidsAndServerInfo.put(new ObvBytesKey(deviceUid.getBytes()), new ObvOwnedDevice.ServerDeviceInfo(deviceName, expirationTimestamp, lastRegistrationTimestamp));
        }
        return new ObvDeviceList(multiDevice, deviceUidsAndServerInfo);
    }
}

