/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine.types;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum ObvCapability {
    WEBRTC_CONTINUOUS_ICE,
    ONE_TO_ONE_CONTACTS,
    GROUPS_V2;

    public static final List<ObvCapability> currentCapabilities;

    public static ObvCapability fromString(String stringRepresentation) {
        switch (stringRepresentation) {
            case "webrtc_continuous_ice": {
                return WEBRTC_CONTINUOUS_ICE;
            }
            case "groups_v2": {
                return GROUPS_V2;
            }
            case "one_to_one_contacts": {
                return ONE_TO_ONE_CONTACTS;
            }
        }
        return null;
    }

    public String toString() {
        switch (this.ordinal()) {
            case 0: {
                return "webrtc_continuous_ice";
            }
            case 1: {
                return "one_to_one_contacts";
            }
            case 2: {
                return "groups_v2";
            }
        }
        return null;
    }

    public static List<ObvCapability> getAll() {
        return Arrays.asList(ObvCapability.values());
    }

    public static String[] capabilityListToStringArray(List<ObvCapability> capabilities) {
        String[] capabilityStrings = new String[capabilities.size()];
        int i = 0;
        for (ObvCapability capability : capabilities) {
            capabilityStrings[i] = capability.toString();
            ++i;
        }
        return capabilityStrings;
    }

    public static byte[] serializeRawDeviceCapabilities(String[] rawDeviceCapabilities) {
        byte[] serializedDeviceCapabilities;
        if (rawDeviceCapabilities == null) {
            serializedDeviceCapabilities = null;
        } else if (rawDeviceCapabilities.length == 0) {
            serializedDeviceCapabilities = new byte[]{};
        } else {
            Arrays.sort(rawDeviceCapabilities);
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                boolean first = true;
                for (String capabilityString : rawDeviceCapabilities) {
                    if (!first) {
                        baos.write(new byte[]{0});
                    }
                    first = false;
                    baos.write(capabilityString.getBytes(StandardCharsets.UTF_8));
                }
                serializedDeviceCapabilities = baos.toByteArray();
            }
            catch (IOException e) {
                serializedDeviceCapabilities = null;
            }
        }
        return serializedDeviceCapabilities;
    }

    public static List<ObvCapability> deserializeDeviceCapabilities(byte[] serializedDeviceCapabilities) {
        String capabilityString;
        ObvCapability capability;
        if (serializedDeviceCapabilities == null) {
            return null;
        }
        ArrayList<ObvCapability> capabilities = new ArrayList<ObvCapability>();
        int startPos = 0;
        for (int i = 0; i < serializedDeviceCapabilities.length; ++i) {
            if (serializedDeviceCapabilities[i] != 0) continue;
            String capabilityString2 = new String(Arrays.copyOfRange(serializedDeviceCapabilities, startPos, i), StandardCharsets.UTF_8);
            startPos = i + 1;
            ObvCapability capability2 = ObvCapability.fromString(capabilityString2);
            if (capability2 == null) continue;
            capabilities.add(capability2);
        }
        if (startPos != serializedDeviceCapabilities.length && (capability = ObvCapability.fromString(capabilityString = new String(Arrays.copyOfRange(serializedDeviceCapabilities, startPos, serializedDeviceCapabilities.length), StandardCharsets.UTF_8))) != null) {
            capabilities.add(capability);
        }
        return capabilities;
    }

    public static String[] deserializeRawDeviceCapabilities(byte[] serializedDeviceCapabilities) {
        if (serializedDeviceCapabilities == null) {
            return new String[0];
        }
        ArrayList<String> rawCapabilities = new ArrayList<String>();
        int startPos = 0;
        for (int i = 0; i < serializedDeviceCapabilities.length; ++i) {
            if (serializedDeviceCapabilities[i] != 0) continue;
            rawCapabilities.add(new String(Arrays.copyOfRange(serializedDeviceCapabilities, startPos, i), StandardCharsets.UTF_8));
            startPos = i + 1;
        }
        if (startPos != serializedDeviceCapabilities.length) {
            rawCapabilities.add(new String(Arrays.copyOfRange(serializedDeviceCapabilities, startPos, serializedDeviceCapabilities.length), StandardCharsets.UTF_8));
        }
        return rawCapabilities.toArray(new String[0]);
    }

    static {
        currentCapabilities = new ArrayList<ObvCapability>(Arrays.asList(ONE_TO_ONE_CONTACTS, GROUPS_V2));
    }
}

