/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.datatypes.EngineSession;
import io.olvid.engine.engine.types.ObvDialog;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.UUID;

public class UserInterfaceDialog
implements ObvDatabase {
    static final String TABLE_NAME = "user_interface_dialog";
    private final EngineSession engineSession;
    private UUID uuid;
    static final String UUID_ = "uuid";
    private Encoded encodedDialog;
    static final String ENCODED_DIALOG = "encoded_dialog";
    private long creationTimestamp;
    static final String CREATION_TIMESTAMP = "creation_timestamp";
    private long commitHookBits = 0L;
    private static final long HOOK_BIT_SHOULD_SEND_NOTIFICATION = 1L;
    private static final long HOOK_BIT_DELETED = 2L;

    public UUID getUuid() {
        return this.uuid;
    }

    public void resend() {
        try {
            this.sendNotification();
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    public void update(Encoded encodedDialog) {
        try (PreparedStatement statement = this.engineSession.session.prepareStatement("UserInterfaceDialog.update", "UPDATE user_interface_dialog SET encoded_dialog = ?, creation_timestamp = ?  WHERE uuid = ?;");){
            long timestamp = System.currentTimeMillis();
            statement.setBytes(1, encodedDialog.getBytes());
            statement.setLong(2, timestamp);
            statement.setString(3, Logger.getUuidString(this.uuid));
            statement.executeUpdate();
            this.encodedDialog = encodedDialog;
            this.creationTimestamp = timestamp;
            this.commitHookBits |= 1L;
            this.engineSession.session.addSessionCommitListener(this);
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    public static UserInterfaceDialog createOrReplace(EngineSession engineSession, ObvDialog dialog) {
        if (dialog == null) {
            return null;
        }
        try {
            UserInterfaceDialog previousUserInterfaceDialog = UserInterfaceDialog.get(engineSession, dialog.getUuid());
            if (previousUserInterfaceDialog != null) {
                previousUserInterfaceDialog.update(dialog.encode(engineSession.jsonObjectMapper));
                return previousUserInterfaceDialog;
            }
            UserInterfaceDialog userInterfaceDialog = new UserInterfaceDialog(engineSession, dialog.getUuid(), dialog.encode(engineSession.jsonObjectMapper));
            userInterfaceDialog.insert();
            return userInterfaceDialog;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    private UserInterfaceDialog(EngineSession engineSession, UUID uuid, Encoded encodedDialog) {
        this.engineSession = engineSession;
        this.uuid = uuid;
        this.encodedDialog = encodedDialog;
        this.creationTimestamp = System.currentTimeMillis();
    }

    private UserInterfaceDialog(EngineSession engineSession, ResultSet res) throws SQLException {
        this.engineSession = engineSession;
        this.uuid = UUID.fromString(res.getString(UUID_));
        this.encodedDialog = new Encoded(res.getBytes(ENCODED_DIALOG));
        this.creationTimestamp = res.getLong(CREATION_TIMESTAMP);
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS user_interface_dialog (uuid VARCHAR PRIMARY KEY, encoded_dialog BLOB NOT NULL, creation_timestamp BIGINT NOT NULL);");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        Statement statement;
        if (oldVersion < 8 && newVersion >= 8) {
            statement = session.createStatement();
            try {
                statement.execute("DELETE FROM user_interface_dialog");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 8;
        }
        if (oldVersion < 11 && newVersion >= 11) {
            statement = session.createStatement();
            try {
                statement.execute("DELETE FROM user_interface_dialog");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 11;
        }
        if (oldVersion < 28 && newVersion >= 28) {
            Logger.d("MIGRATING `user_interface_dialog` TABLE FROM VERSION " + oldVersion + " TO 28");
            statement = session.createStatement();
            try {
                ArrayList<String> dialogUuids;
                block34: {
                    dialogUuids = new ArrayList<String>();
                    ResultSet res = statement.executeQuery("SELECT * FROM user_interface_dialog");
                    block22: while (true) {
                        while (res.next()) {
                            Encoded encodedDialog = new Encoded(res.getBytes(ENCODED_DIALOG));
                            try {
                                Encoded encodedCategory = encodedDialog.decodeList()[3];
                                int id = (int)encodedCategory.decodeList()[0].decodeLong();
                                if (id != 9 && id != 10 && id != 11 && id != 12) continue block22;
                                dialogUuids.add(res.getString(UUID_));
                                continue block22;
                            }
                            catch (Exception exception) {
                            }
                        }
                        break block34;
                        {
                            continue block22;
                            break;
                        }
                        break;
                    }
                    finally {
                        if (res != null) {
                            res.close();
                        }
                    }
                }
                for (String uuid : dialogUuids) {
                    statement.execute("DELETE FROM user_interface_dialog WHERE uuid = '" + uuid + "'");
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 28;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.engineSession.session.prepareStatement("UserInterfaceDialog.insert", "INSERT INTO user_interface_dialog VALUES (?,?,?);");){
            statement.setString(1, Logger.getUuidString(this.uuid));
            statement.setBytes(2, this.encodedDialog.getBytes());
            statement.setLong(3, this.creationTimestamp);
            statement.executeUpdate();
            this.commitHookBits |= 1L;
            this.engineSession.session.addSessionCommitListener(this);
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.engineSession.session.prepareStatement("UserInterfaceDialog.delete", "DELETE FROM user_interface_dialog WHERE uuid = ?;");){
            statement.setString(1, Logger.getUuidString(this.uuid));
            statement.executeUpdate();
            this.commitHookBits |= 2L;
            this.engineSession.session.addSessionCommitListener(this);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static UserInterfaceDialog get(EngineSession engineSession, UUID uuid) {
        if (uuid == null) {
            return null;
        }
        try (PreparedStatement statement = engineSession.session.prepareStatement("UserInterfaceDialog.get", "SELECT * FROM user_interface_dialog WHERE uuid = ?;");){
            UserInterfaceDialog userInterfaceDialog;
            block19: {
                ResultSet res;
                block17: {
                    UserInterfaceDialog userInterfaceDialog2;
                    block18: {
                        statement.setString(1, Logger.getUuidString(uuid));
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block17;
                            userInterfaceDialog2 = new UserInterfaceDialog(engineSession, res);
                            if (res == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return userInterfaceDialog2;
                }
                userInterfaceDialog = null;
                if (res == null) break block19;
                res.close();
            }
            return userInterfaceDialog;
        }
        catch (SQLException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static UserInterfaceDialog[] getAll(EngineSession engineSession) {
        try (PreparedStatement statement = engineSession.session.prepareStatement("UserInterfaceDialog.getAll", "SELECT * FROM user_interface_dialog;");){
            UserInterfaceDialog[] userInterfaceDialogArray;
            block15: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<UserInterfaceDialog> list = new ArrayList<UserInterfaceDialog>();
                    while (res.next()) {
                        list.add(new UserInterfaceDialog(engineSession, res));
                    }
                    userInterfaceDialogArray = list.toArray(new UserInterfaceDialog[0]);
                    if (res == null) break block15;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return userInterfaceDialogArray;
        }
        catch (SQLException e) {
            Logger.x(e);
            return new UserInterfaceDialog[0];
        }
    }

    public void sendNotification() throws Exception {
        this.engineSession.userInterfaceDialogListener.sendUserInterfaceDialogNotification(this.uuid, this.getObvDialog(), this.creationTimestamp);
    }

    public ObvDialog getObvDialog() throws Exception {
        return ObvDialog.of(this.encodedDialog, this.engineSession.jsonObjectMapper);
    }

    @Override
    public void wasCommitted() {
        if ((this.commitHookBits & 1L) != 0L && this.engineSession.userInterfaceDialogListener != null) {
            try {
                this.sendNotification();
            }
            catch (Exception e) {
                Logger.x(e);
            }
        }
        if ((this.commitHookBits & 2L) != 0L && this.engineSession.userInterfaceDialogListener != null) {
            try {
                this.engineSession.userInterfaceDialogListener.sendUserInterfaceDialogDeletionNotification(this.uuid);
            }
            catch (Exception e) {
                Logger.x(e);
            }
        }
        this.commitHookBits = 0L;
    }
}

