/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NotificationListener;
import io.olvid.engine.datatypes.TrustLevel;
import io.olvid.engine.engine.Engine;
import io.olvid.engine.engine.datatypes.EngineSession;
import io.olvid.engine.engine.types.JsonIdentityDetails;
import io.olvid.engine.engine.types.JsonIdentityDetailsWithVersionAndPhoto;
import io.olvid.engine.engine.types.ObvCapability;
import io.olvid.engine.engine.types.identities.ObvIdentity;
import io.olvid.engine.notification.NotificationManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NotificationListenerIdentity
implements NotificationListener {
    private final Engine engine;

    public NotificationListenerIdentity(Engine engine) {
        this.engine = engine;
    }

    void registerToNotifications(NotificationManager notificationManager) {
        for (String notificationName : new String[]{"identity_manager_notification_owned_identity_list_updated", "identity_manager_notification_owned_identity_published_details_updated", "identity_manager_notification_new_contact_identity", "identity_manager_notification_contact_trust_level_increased", "identity_manager_notification_contact_identity_deleted", "identity_manager_notification_new_contact_device", "identity_manager_notification_contact_devices_changed", "identity_manager_notification_new_contact_published_details", "identity_manager_notification_contact_photo_set", "identity_manager_notification_contact_trusted_details_updated", "identity_manager_notification_contact_keycloak_managed_changed", "identity_manager_notification_contact_active_changed", "identity_manager_notification_contact_revoked", "identity_manager_notification_latest_owned_identity_details_updated", "identity_manager_notification_owned_identity_changed_active_status", "identity_manager_notification_contact_capabilities_updated", "identity_manager_notification_own_capabilities_updated", "identity_manager_notification_contact_one_to_one_changed", "identity_manager_notification_contact_recently_online_changed", "identity_manager_notification_owned_device_list_changed"}) {
            notificationManager.addListener(notificationName, this);
        }
    }

    @Override
    public void callback(String notificationName, Map<String, Object> userInfo) {
        switch (notificationName) {
            case "identity_manager_notification_new_contact_identity": {
                try (EngineSession engineSession = this.engine.getSession();){
                    Identity contactIdentity = (Identity)userInfo.get("contact_identity");
                    Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                    boolean keycloakManaged = (Boolean)userInfo.get("keycloak_managed");
                    boolean active = (Boolean)userInfo.get("active");
                    boolean oneToOne = (Boolean)userInfo.get("one_to_one");
                    int trustLevel = (Integer)userInfo.get("trust_level");
                    if (contactIdentity != null && ownedIdentity != null) {
                        this.engine.protocolManager.startDeviceDiscoveryProtocol(ownedIdentity, contactIdentity);
                        HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                        JsonIdentityDetails contactDetails = this.engine.identityManager.getContactIdentityTrustedDetails(engineSession.session, ownedIdentity, contactIdentity);
                        engineInfo.put("owned_identity", ownedIdentity.getBytes());
                        engineInfo.put("contact_identity", new ObvIdentity(contactIdentity, contactDetails, keycloakManaged, active));
                        engineInfo.put("one_to_one", oneToOne);
                        engineInfo.put("trust_level", trustLevel);
                        engineInfo.put("has_untrusted_published_details", this.engine.identityManager.contactHasUntrustedPublishedDetails(engineSession.session, ownedIdentity, contactIdentity));
                        this.engine.postEngineNotification("engine_notification_new_contact", engineInfo);
                    }
                }
                catch (Exception e) {
                    Logger.x(e);
                }
                break;
            }
            case "identity_manager_notification_contact_trust_level_increased": {
                Identity contactIdentity = (Identity)userInfo.get("contact_identity");
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                TrustLevel trustLevel = (TrustLevel)userInfo.get("trust_level");
                if (contactIdentity == null || ownedIdentity == null || trustLevel == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("bytes_contact_identity", contactIdentity.getBytes());
                engineInfo.put("trust_level", trustLevel.major);
                this.engine.postEngineNotification("engine_notification_contact_trust_level_increased", engineInfo);
                break;
            }
            case "identity_manager_notification_contact_identity_deleted": {
                Identity contactIdentity = (Identity)userInfo.get("contact_identity");
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                if (contactIdentity == null || ownedIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("bytes_contact_identity", contactIdentity.getBytes());
                this.engine.postEngineNotification("engine_notification_contact_deleted", engineInfo);
                break;
            }
            case "identity_manager_notification_new_contact_device": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                Identity contactIdentity = (Identity)userInfo.get("contact_identity");
                if (contactIdentity == null || ownedIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("owned_identity", ownedIdentity.getBytes());
                engineInfo.put("contact_identity", contactIdentity.getBytes());
                this.engine.postEngineNotification("engine_notification_contact_devices_updated", engineInfo);
                break;
            }
            case "identity_manager_notification_contact_devices_changed": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                Identity contactIdentity = (Identity)userInfo.get("contact_identity");
                if (contactIdentity == null || ownedIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("owned_identity", ownedIdentity.getBytes());
                engineInfo.put("contact_identity", contactIdentity.getBytes());
                this.engine.postEngineNotification("engine_notification_contact_devices_updated", engineInfo);
                break;
            }
            case "identity_manager_notification_new_contact_published_details": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                Identity contactIdentity = (Identity)userInfo.get("contact_identity");
                if (ownedIdentity == null || contactIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("bytes_contact_identity", contactIdentity.getBytes());
                this.engine.postEngineNotification("engine_notification_new_contact_published_details", engineInfo);
                break;
            }
            case "identity_manager_notification_owned_identity_list_updated": {
                this.engine.postEngineNotification("engine_notification_owned_identity_list_updated", new HashMap<String, Object>());
                break;
            }
            case "identity_manager_notification_owned_identity_published_details_updated": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                JsonIdentityDetailsWithVersionAndPhoto identityDetails = (JsonIdentityDetailsWithVersionAndPhoto)userInfo.get("identity_details");
                if (ownedIdentity == null || identityDetails == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("display_name", identityDetails.getIdentityDetails());
                engineInfo.put("photo_url", identityDetails.getPhotoUrl());
                this.engine.postEngineNotification("engine_notification_owned_identity_display_name_changed", engineInfo);
                break;
            }
            case "identity_manager_notification_contact_photo_set": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                Identity contactIdentity = (Identity)userInfo.get("contact_identity");
                int version = (Integer)userInfo.get("version");
                boolean isTrusted = (Boolean)userInfo.get("is_trusted");
                if (ownedIdentity == null || contactIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("bytes_contact_identity", contactIdentity.getBytes());
                engineInfo.put("version", version);
                engineInfo.put("is_trusted", isTrusted);
                this.engine.postEngineNotification("engine_notification_new_contact_photo", engineInfo);
                break;
            }
            case "identity_manager_notification_contact_trusted_details_updated": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                Identity contactIdentity = (Identity)userInfo.get("contact_identity");
                JsonIdentityDetailsWithVersionAndPhoto identityDetails = (JsonIdentityDetailsWithVersionAndPhoto)userInfo.get("identity_details");
                if (ownedIdentity == null || contactIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("bytes_contact_identity", contactIdentity.getBytes());
                engineInfo.put("identity_details", identityDetails);
                this.engine.postEngineNotification("engine_notification_contact_published_details_trusted", engineInfo);
                break;
            }
            case "identity_manager_notification_contact_keycloak_managed_changed": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                Identity contactIdentity = (Identity)userInfo.get("contact_identity");
                boolean keycloakManaged = (Boolean)userInfo.get("keycloak_managed");
                if (ownedIdentity == null || contactIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("bytes_contact_identity", contactIdentity.getBytes());
                engineInfo.put("keycloak_managed", keycloakManaged);
                this.engine.postEngineNotification("engine_notification_contact_keycloak_managed_changed", engineInfo);
                break;
            }
            case "identity_manager_notification_contact_active_changed": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                Identity contactIdentity = (Identity)userInfo.get("contact_identity");
                boolean active = (Boolean)userInfo.get("active");
                if (ownedIdentity == null || contactIdentity == null) break;
                if (active) {
                    try {
                        this.engine.protocolManager.startDeviceDiscoveryProtocol(ownedIdentity, contactIdentity);
                    }
                    catch (Exception engineInfo) {
                        // empty catch block
                    }
                }
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("bytes_contact_identity", contactIdentity.getBytes());
                engineInfo.put("active", active);
                this.engine.postEngineNotification("engine_notification_contact_active_changed", engineInfo);
                break;
            }
            case "identity_manager_notification_contact_revoked": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                Identity contactIdentity = (Identity)userInfo.get("contact_identity");
                if (ownedIdentity == null || contactIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("bytes_contact_identity", contactIdentity.getBytes());
                this.engine.postEngineNotification("engine_notification_contact_revoked", engineInfo);
                break;
            }
            case "identity_manager_notification_latest_owned_identity_details_updated": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                boolean hasUnpublished = (Boolean)userInfo.get("has_unpublished");
                if (ownedIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("has_unpublished", hasUnpublished);
                this.engine.postEngineNotification("engine_notification_owned_identity_latest_details_updated", engineInfo);
                break;
            }
            case "identity_manager_notification_owned_identity_changed_active_status": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                boolean active = (Boolean)userInfo.get("active");
                if (ownedIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("active", active);
                this.engine.postEngineNotification("engine_notification_owned_identity_changed_active_status", engineInfo);
                break;
            }
            case "identity_manager_notification_contact_capabilities_updated": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                Identity contactIdentity = (Identity)userInfo.get("contact_identity");
                if (ownedIdentity == null || contactIdentity == null) break;
                try {
                    List<ObvCapability> capabilities = this.engine.identityManager.getContactCapabilities(ownedIdentity, contactIdentity);
                    HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                    engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                    engineInfo.put("bytes_contact_identity", contactIdentity.getBytes());
                    engineInfo.put("capabilities", capabilities);
                    this.engine.postEngineNotification("engine_notification_contact_capabilities_updated", engineInfo);
                }
                catch (Exception e) {
                    Logger.x(e);
                }
                break;
            }
            case "identity_manager_notification_own_capabilities_updated": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                if (ownedIdentity == null) break;
                try {
                    List<ObvCapability> capabilities = this.engine.identityManager.getOwnCapabilities(ownedIdentity);
                    HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                    engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                    engineInfo.put("capabilities", capabilities);
                    this.engine.postEngineNotification("engine_notification_own_capabilities_updated", engineInfo);
                }
                catch (Exception e) {
                    Logger.x(e);
                }
                break;
            }
            case "identity_manager_notification_contact_one_to_one_changed": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                Identity contactIdentity = (Identity)userInfo.get("contact_identity");
                boolean oneToOne = (Boolean)userInfo.get("one_to_one");
                if (ownedIdentity == null || contactIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("bytes_contact_identity", contactIdentity.getBytes());
                engineInfo.put("one_to_one", oneToOne);
                this.engine.postEngineNotification("engine_notification_contact_one_to_one_changed", engineInfo);
                break;
            }
            case "identity_manager_notification_contact_recently_online_changed": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                Identity contactIdentity = (Identity)userInfo.get("contact_identity");
                boolean recentlyOnline = (Boolean)userInfo.get("recently_online");
                if (ownedIdentity == null || contactIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("bytes_contact_identity", contactIdentity.getBytes());
                engineInfo.put("recently_online", recentlyOnline);
                this.engine.postEngineNotification("engine_notification_contact_recently_online_changed", engineInfo);
                break;
            }
            case "identity_manager_notification_owned_device_list_changed": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                if (ownedIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                this.engine.postEngineNotification("engine_notification_owned_identity_device_list_changed", engineInfo);
                break;
            }
            default: {
                Logger.w("Received notification " + notificationName + " but no handler is set.");
            }
        }
    }
}

