/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NotificationListener;
import io.olvid.engine.datatypes.containers.GroupWithDetails;
import io.olvid.engine.engine.Engine;
import io.olvid.engine.engine.datatypes.EngineSession;
import io.olvid.engine.engine.types.JsonGroupDetailsWithVersionAndPhoto;
import io.olvid.engine.engine.types.JsonIdentityDetails;
import io.olvid.engine.engine.types.identities.ObvGroup;
import io.olvid.engine.engine.types.identities.ObvIdentity;
import io.olvid.engine.notification.NotificationManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class NotificationListenerGroups
implements NotificationListener {
    private final Engine engine;

    public NotificationListenerGroups(Engine engine) {
        this.engine = engine;
    }

    void registerToNotifications(NotificationManager notificationManager) {
        for (String notificationName : new String[]{"identity_manager_notification_group_created", "identity_manager_notification_group_deleted", "identity_manager_notification_group_trusted_details_updated", "identity_manager_notification_group_published_details_updated", "identity_manager_notification_new_group_published_details", "identity_manager_notification_group_member_added", "identity_manager_notification_group_member_removed", "identity_manager_notification_group_photo_set", "identity_manager_notification_pending_group_member_added", "identity_manager_notification_pending_group_member_removed", "identity_manager_notification_pending_group_member_declined_toggled"}) {
            notificationManager.addListener(notificationName, this);
        }
    }

    @Override
    public void callback(String notificationName, Map<String, Object> userInfo) {
        switch (notificationName) {
            case "identity_manager_notification_group_created": {
                try (EngineSession engineSession = this.engine.getSession();){
                    byte[] groupOwnerAndUid = (byte[])userInfo.get("group_uid");
                    Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                    Boolean createdOnOtherDevice = (Boolean)userInfo.get("on_other_device");
                    if (groupOwnerAndUid != null && ownedIdentity != null && createdOnOtherDevice != null) {
                        HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                        GroupWithDetails group = this.engine.identityManager.getGroupWithDetails(engineSession.session, ownedIdentity, groupOwnerAndUid);
                        if (group != null) {
                            byte[][] bytesContactIdentities = new byte[group.getGroupMembers().length][];
                            for (int j = 0; j < bytesContactIdentities.length; ++j) {
                                bytesContactIdentities[j] = group.getGroupMembers()[j].getBytes();
                            }
                            ObvIdentity[] pendingMembers = new ObvIdentity[group.getPendingGroupMembers().length];
                            for (int j = 0; j < pendingMembers.length; ++j) {
                                try {
                                    JsonIdentityDetails identityDetails = (JsonIdentityDetails)this.engine.identityManager.getJsonObjectMapper().readValue(group.getPendingGroupMembers()[j].serializedDetails, JsonIdentityDetails.class);
                                    pendingMembers[j] = new ObvIdentity(group.getPendingGroupMembers()[j].identity, identityDetails, false, true);
                                    continue;
                                }
                                catch (IOException e) {
                                    pendingMembers[j] = new ObvIdentity(group.getPendingGroupMembers()[j].identity, null, false, true);
                                }
                            }
                            byte[][] bytesDeclinesPendingMembers = new byte[group.getDeclinedPendingMembers().length][];
                            for (int j = 0; j < bytesDeclinesPendingMembers.length; ++j) {
                                bytesDeclinesPendingMembers[j] = group.getDeclinedPendingMembers()[j].getBytes();
                            }
                            ObvGroup obvGroup = group.getGroupOwner() == null ? new ObvGroup(group.getGroupOwnerAndUid(), group.getPublishedGroupDetails(), ownedIdentity.getBytes(), bytesContactIdentities, pendingMembers, bytesDeclinesPendingMembers, null) : new ObvGroup(group.getGroupOwnerAndUid(), group.getLatestOrTrustedGroupDetails(), ownedIdentity.getBytes(), bytesContactIdentities, pendingMembers, bytesDeclinesPendingMembers, group.getGroupOwner().getBytes());
                            String photoUrl = this.engine.identityManager.getGroupPhotoUrl(engineSession.session, ownedIdentity, groupOwnerAndUid);
                            engineInfo.put("group", obvGroup);
                            engineInfo.put("has_multiple_details", group.hasMultipleDetails());
                            engineInfo.put("photo_url", photoUrl);
                            engineInfo.put("on_other_device", createdOnOtherDevice);
                            this.engine.postEngineNotification("engine_notification_group_created", engineInfo);
                        }
                    }
                }
                catch (Exception e) {
                    Logger.x(e);
                }
                break;
            }
            case "identity_manager_notification_group_deleted": {
                byte[] groupUid = (byte[])userInfo.get("group_uid");
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                if (groupUid == null || ownedIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_group_owner_and_uid", groupUid);
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                this.engine.postEngineNotification("engine_notification_group_deleted", engineInfo);
                break;
            }
            case "identity_manager_notification_group_trusted_details_updated": {
                byte[] groupUid = (byte[])userInfo.get("group_uid");
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                JsonGroupDetailsWithVersionAndPhoto groupDetailsWithVersionAndPhoto = (JsonGroupDetailsWithVersionAndPhoto)userInfo.get("group_details");
                if (groupUid == null || ownedIdentity == null || groupDetailsWithVersionAndPhoto == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_group_uid", groupUid);
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("group_details", groupDetailsWithVersionAndPhoto);
                this.engine.postEngineNotification("engine_notification_group_published_details_trusted", engineInfo);
                break;
            }
            case "identity_manager_notification_group_member_added": {
                byte[] groupOwnerAndUid = (byte[])userInfo.get("group_owner_and_uid");
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                Identity contactIdentity = (Identity)userInfo.get("contact_identity");
                if (groupOwnerAndUid == null || ownedIdentity == null || contactIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("group_uid", groupOwnerAndUid);
                engineInfo.put("owned_identity", ownedIdentity.getBytes());
                engineInfo.put("contact_identity", contactIdentity.getBytes());
                this.engine.postEngineNotification("engine_notification_group_member_added", engineInfo);
                break;
            }
            case "identity_manager_notification_group_member_removed": {
                byte[] groupUid = (byte[])userInfo.get("group_uid");
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                Identity contactIdentity = (Identity)userInfo.get("contact_identity");
                if (groupUid == null || ownedIdentity == null || contactIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_group_uid", groupUid);
                engineInfo.put("owned_identity", ownedIdentity.getBytes());
                engineInfo.put("contact_identity", contactIdentity.getBytes());
                this.engine.postEngineNotification("engine_notification_group_member_removed", engineInfo);
                break;
            }
            case "identity_manager_notification_group_published_details_updated": {
                byte[] groupUid = (byte[])userInfo.get("group_uid");
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                JsonGroupDetailsWithVersionAndPhoto groupDetails = (JsonGroupDetailsWithVersionAndPhoto)userInfo.get("group_name");
                if (groupUid == null || ownedIdentity == null || groupDetails == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_group_uid", groupUid);
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("group_details", groupDetails);
                this.engine.postEngineNotification("engine_notification_group_published_details_updated", engineInfo);
                break;
            }
            case "identity_manager_notification_pending_group_member_added": {
                JsonIdentityDetails identityDetails;
                byte[] groupUid = (byte[])userInfo.get("group_uid");
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                Identity contactIdentity = (Identity)userInfo.get("contact_identity");
                String contactSerializedDetails = (String)userInfo.get("contact_serialized_details");
                if (groupUid == null || ownedIdentity == null || contactIdentity == null || contactSerializedDetails == null) break;
                try {
                    identityDetails = (JsonIdentityDetails)this.engine.jsonObjectMapper.readValue(contactSerializedDetails, JsonIdentityDetails.class);
                }
                catch (Exception e) {
                    break;
                }
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_group_uid", groupUid);
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("contact_identity", new ObvIdentity(contactIdentity, identityDetails, false, true));
                this.engine.postEngineNotification("engine_notification_pending_group_member_added", engineInfo);
                break;
            }
            case "identity_manager_notification_pending_group_member_removed": {
                JsonIdentityDetails identityDetails;
                byte[] groupUid = (byte[])userInfo.get("group_uid");
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                Identity contactIdentity = (Identity)userInfo.get("contact_identity");
                String contactSerializedDetails = (String)userInfo.get("contact_serialized_details");
                if (groupUid == null || ownedIdentity == null || contactIdentity == null || contactSerializedDetails == null) break;
                try {
                    identityDetails = (JsonIdentityDetails)this.engine.jsonObjectMapper.readValue(contactSerializedDetails, JsonIdentityDetails.class);
                }
                catch (Exception e) {
                    break;
                }
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_group_uid", groupUid);
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("contact_identity", new ObvIdentity(contactIdentity, identityDetails, false, true));
                this.engine.postEngineNotification("engine_notification_pending_group_member_removed", engineInfo);
                break;
            }
            case "identity_manager_notification_pending_group_member_declined_toggled": {
                byte[] groupUid = (byte[])userInfo.get("group_uid");
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                Identity contactIdentity = (Identity)userInfo.get("contact_identity");
                boolean declined = (Boolean)userInfo.get("declined");
                if (groupUid == null || ownedIdentity == null || contactIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_group_uid", groupUid);
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("bytes_contact_identity", contactIdentity.getBytes());
                engineInfo.put("declined", declined);
                this.engine.postEngineNotification("engine_notification_pending_group_member_decline_toggled", engineInfo);
                break;
            }
            case "identity_manager_notification_group_photo_set": {
                byte[] groupOwnerAndUid = (byte[])userInfo.get("group_uid");
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                int version = (Integer)userInfo.get("version");
                boolean isTrusted = (Boolean)userInfo.get("is_trusted");
                if (ownedIdentity == null || groupOwnerAndUid == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("bytes_group_uid", groupOwnerAndUid);
                engineInfo.put("version", version);
                engineInfo.put("is_trusted", isTrusted);
                this.engine.postEngineNotification("engine_notification_new_group_photo", engineInfo);
                break;
            }
            case "identity_manager_notification_new_group_published_details": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                byte[] groupOwnerAndUid = (byte[])userInfo.get("group_uid");
                if (ownedIdentity == null || groupOwnerAndUid == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("bytes_group_uid", groupOwnerAndUid);
                this.engine.postEngineNotification("engine_notification_new_group_published_details", engineInfo);
                break;
            }
            default: {
                Logger.w("Received notification " + notificationName + " but no handler is set.");
            }
        }
    }
}

