/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NotificationListener;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelDialogMessageToSend;
import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.engine.engine.Engine;
import io.olvid.engine.engine.databases.UserInterfaceDialog;
import io.olvid.engine.engine.datatypes.EngineSession;
import io.olvid.engine.notification.NotificationManager;
import java.util.HashMap;
import java.util.Map;

public class NotificationListenerChannelsAndProtocols
implements NotificationListener {
    private final Engine engine;

    public NotificationListenerChannelsAndProtocols(Engine engine) {
        this.engine = engine;
    }

    void registerToNotifications(NotificationManager notificationManager) {
        for (String notificationName : new String[]{"channel_notification_new_ui_dialog", "channel_notification_channel_confirmed", "channel_notification_channel_deleted", "protocol_manager_notification_mutual_scan_contact_added", "protocol_manager_notification_group_v2_update_failed", "protocol_manager_notification_owned_identity_deleted_from_another_device", "protocol_manager_notification_keycloak_synchronization_required", "protocol_manager_notification_contact_introduction_invitation_sent", "protocol_manager_notification_contact_introduction_invitation_response", "protocol_manager_notification_snapshot_restoration_finished", "protocol_manager_notification_owned_device_discovery_done"}) {
            notificationManager.addListener(notificationName, this);
        }
    }

    @Override
    public void callback(String notificationName, Map<String, Object> userInfo) {
        switch (notificationName) {
            case "channel_notification_new_ui_dialog": {
                try {
                    Session session = (Session)userInfo.get("session_key");
                    ChannelDialogMessageToSend channelDialogMessageToSend = (ChannelDialogMessageToSend)userInfo.get("message_to_send_key");
                    if (channelDialogMessageToSend == null) break;
                    if (channelDialogMessageToSend.getSendChannelInfo().getDialogType().id == -1) {
                        UserInterfaceDialog userInterfaceDialog = UserInterfaceDialog.get(this.engine.wrapSession(session), channelDialogMessageToSend.getSendChannelInfo().getDialogUuid());
                        if (userInterfaceDialog == null) break;
                        userInterfaceDialog.delete();
                        break;
                    }
                    UserInterfaceDialog.createOrReplace(this.engine.wrapSession(session), this.engine.createDialog(channelDialogMessageToSend));
                }
                catch (Exception e) {
                    Logger.x(e);
                }
                break;
            }
            case "channel_notification_channel_confirmed": {
                try (EngineSession engineSession = this.engine.getSession();){
                    Identity contactIdentity = (Identity)userInfo.get("remote_identity_key");
                    UID currentDeviceUid = (UID)userInfo.get("current_device_uid_key");
                    if (contactIdentity != null && currentDeviceUid != null) {
                        HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                        Identity ownedIdentity = this.engine.identityManager.getOwnedIdentityForCurrentDeviceUid(engineSession.session, currentDeviceUid);
                        engineInfo.put("owned_identity", ownedIdentity.getBytes());
                        engineInfo.put("contact_identity", contactIdentity.getBytes());
                        this.engine.postEngineNotification("engine_notification_channel_confirmed_or_deleted", engineInfo);
                    }
                }
                catch (Exception e) {
                    Logger.x(e);
                }
                break;
            }
            case "channel_notification_channel_deleted": {
                try (EngineSession engineSession = this.engine.getSession();){
                    Identity contactIdentity = (Identity)userInfo.get("remote_identity_key");
                    UID currentDeviceUid = (UID)userInfo.get("current_device_uid_key");
                    if (contactIdentity != null && currentDeviceUid != null) {
                        HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                        Identity ownedIdentity = this.engine.identityManager.getOwnedIdentityForCurrentDeviceUid(engineSession.session, currentDeviceUid);
                        if (ownedIdentity != null) {
                            engineInfo.put("owned_identity", ownedIdentity.getBytes());
                            engineInfo.put("contact_identity", contactIdentity.getBytes());
                            this.engine.postEngineNotification("engine_notification_channel_confirmed_or_deleted", engineInfo);
                        }
                    }
                }
                catch (Exception e) {
                    Logger.x(e);
                }
                break;
            }
            case "protocol_manager_notification_mutual_scan_contact_added": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                Identity contactIdentity = (Identity)userInfo.get("contact_identity");
                byte[] signature = (byte[])userInfo.get("nonce");
                if (ownedIdentity == null || contactIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("bytes_contact_identity", contactIdentity.getBytes());
                if (signature != null) {
                    engineInfo.put("signature", signature);
                }
                this.engine.postEngineNotification("engine_notification_mutual_scan_contact_added", engineInfo);
                break;
            }
            case "protocol_manager_notification_group_v2_update_failed": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                GroupV2.Identifier groupIdentifier = (GroupV2.Identifier)userInfo.get("group_identifier");
                Boolean error = (Boolean)userInfo.get("error");
                if (ownedIdentity == null || groupIdentifier == null || error == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("bytes_group_identifier", groupIdentifier.getBytes());
                engineInfo.put("error", error);
                this.engine.postEngineNotification("engine_notification_group_v2_update_failed", engineInfo);
                break;
            }
            case "protocol_manager_notification_owned_identity_deleted_from_another_device": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                if (ownedIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                this.engine.postEngineNotification("engine_notification_owned_identity_deleted_from_another_device", engineInfo);
                break;
            }
            case "protocol_manager_notification_keycloak_synchronization_required": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                if (ownedIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                this.engine.postEngineNotification("engine_notification_keycloak_synchronization_required", engineInfo);
                break;
            }
            case "protocol_manager_notification_contact_introduction_invitation_sent": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                Identity contactIdentityA = (Identity)userInfo.get("contact_identity_a");
                Identity contactIdentityB = (Identity)userInfo.get("contact_identity_b");
                if (ownedIdentity == null || contactIdentityA == null || contactIdentityB == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("bytes_contact_identity_a", contactIdentityA.getBytes());
                engineInfo.put("bytes_contact_identity_b", contactIdentityB.getBytes());
                this.engine.postEngineNotification("engine_notification_contact_introduction_invitation_sent", engineInfo);
                break;
            }
            case "protocol_manager_notification_contact_introduction_invitation_response": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                Identity mediatorIdentity = (Identity)userInfo.get("mediator_identity");
                Identity contactIdentity = (Identity)userInfo.get("contact_identity");
                String contactSerializedDetails = (String)userInfo.get("contact_serialized_details");
                Boolean accepted = (Boolean)userInfo.get("accepted");
                if (ownedIdentity == null || mediatorIdentity == null || contactSerializedDetails == null || accepted == null || contactIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("bytes_mediator_identity", mediatorIdentity.getBytes());
                engineInfo.put("bytes_contact_identity", contactIdentity.getBytes());
                engineInfo.put("contact_serialized_Details", contactSerializedDetails);
                engineInfo.put("accepted", accepted);
                this.engine.postEngineNotification("engine_notification_contact_introduction_invitation_response", engineInfo);
                break;
            }
            case "protocol_manager_notification_snapshot_restoration_finished": {
                this.engine.postEngineNotification("engine_notification_engine_snapshot_restoration_finished", new HashMap<String, Object>());
                break;
            }
            case "protocol_manager_notification_owned_device_discovery_done": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                if (ownedIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                this.engine.postEngineNotification("engine_notification_owned_device_discovery_done", engineInfo);
                break;
            }
            default: {
                Logger.w("Received notification " + notificationName + " but no handler is set.");
            }
        }
    }
}

