/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.NotificationListener;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.engine.Engine;
import io.olvid.engine.notification.NotificationManager;
import java.util.HashMap;
import java.util.Map;

public class NotificationListenerBackups
implements NotificationListener {
    private final Engine engine;

    public NotificationListenerBackups(Engine engine) {
        this.engine = engine;
    }

    void registerToNotifications(NotificationManager notificationManager) {
        for (String notificationName : new String[]{"backup_notification_new_backup_seed_generated", "backup_notification_backup_seed_generation_failed", "backup_notification_backup_for_export_finished", "backup_notification_backup_finished", "backup_notification_backup_verification_successful", "backup_notification_backup_for_export_failed", "backup_notification_app_backup_initiation_request", "backup_notification_backup_restoration_finished"}) {
            notificationManager.addListener(notificationName, this);
        }
    }

    @Override
    public void callback(String notificationName, Map<String, Object> userInfo) {
        switch (notificationName) {
            case "backup_notification_new_backup_seed_generated": {
                String seed = (String)userInfo.get("seed");
                if (seed == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("seed", seed);
                this.engine.postEngineNotification("engine_notification_new_backup_seed_generated", engineInfo);
                break;
            }
            case "backup_notification_backup_seed_generation_failed": {
                this.engine.postEngineNotification("engine_notification_backup_seed_generation_failed", new HashMap<String, Object>());
                break;
            }
            case "backup_notification_backup_for_export_finished": {
                UID backupKeyUid = (UID)userInfo.get("backup_key_uid");
                int version = (Integer)userInfo.get("version");
                byte[] encryptedContent = (byte[])userInfo.get("encrypted_content");
                if (backupKeyUid == null || encryptedContent == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("backup_key_uid", backupKeyUid.getBytes());
                engineInfo.put("version", version);
                engineInfo.put("encrypted_content", encryptedContent);
                this.engine.postEngineNotification("engine_notification_backup_for_export_finished", engineInfo);
                break;
            }
            case "backup_notification_backup_finished": {
                UID backupKeyUid = (UID)userInfo.get("backup_key_uid");
                int version = (Integer)userInfo.get("version");
                byte[] encryptedContent = (byte[])userInfo.get("encrypted_content");
                if (backupKeyUid == null || encryptedContent == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("backup_key_uid", backupKeyUid.getBytes());
                engineInfo.put("version", version);
                engineInfo.put("encrypted_content", encryptedContent);
                this.engine.postEngineNotification("engine_notification_backup_finished", engineInfo);
                break;
            }
            case "backup_notification_backup_verification_successful": {
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                this.engine.postEngineNotification("engine_notification_backup_key_verification_successful", engineInfo);
                break;
            }
            case "backup_notification_backup_for_export_failed": {
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                this.engine.postEngineNotification("engine_notification_backup_for_export_failed", engineInfo);
                break;
            }
            case "backup_notification_app_backup_initiation_request": {
                UID backupKeyUid = (UID)userInfo.get("backup_uid");
                int version = (Integer)userInfo.get("version");
                if (backupKeyUid == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_backup_key_uid", backupKeyUid.getBytes());
                engineInfo.put("version", version);
                this.engine.postEngineNotification("engine_notification_app_backup_requested", engineInfo);
                break;
            }
            case "backup_notification_backup_restoration_finished": {
                this.engine.postEngineNotification("engine_notification_engine_backup_restoration_finished", new HashMap<String, Object>());
                break;
            }
            default: {
                Logger.w("Received notification " + notificationName + " but no handler is set.");
            }
        }
    }
}

