/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.key.asymmetric;

import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.key.asymmetric.PublicKey;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationECSdsaCurve25519PublicKey;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationECSdsaMDCPublicKey;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationECSdsaPublicKey;
import io.olvid.engine.datatypes.key.asymmetric.SignaturePublicKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import java.util.HashMap;

public abstract class ServerAuthenticationPublicKey
extends PublicKey {
    public static final byte ALGO_IMPL_SIGN_CHALLENGE_EC_SDSA_MDC = 0;
    public static final byte ALGO_IMPL_SIGN_CHALLENGE_EC_SDSA_CURVE25519 = 1;

    public ServerAuthenticationPublicKey(byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) {
        super((byte)20, algorithmImplementation, key);
    }

    public static ServerAuthenticationPublicKey of(byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) {
        switch (algorithmImplementation) {
            case 0: {
                return new ServerAuthenticationECSdsaMDCPublicKey(key);
            }
            case 1: {
                return new ServerAuthenticationECSdsaCurve25519PublicKey(key);
            }
        }
        return null;
    }

    public static int getCompactKeyLength(byte algorithmImplementation) {
        switch (algorithmImplementation) {
            case 0: {
                return ServerAuthenticationECSdsaMDCPublicKey.COMPACT_KEY_LENGTH;
            }
            case 1: {
                return ServerAuthenticationECSdsaCurve25519PublicKey.COMPACT_KEY_LENGTH;
            }
        }
        return -1;
    }

    public int getCompactKeyLength() {
        return ServerAuthenticationPublicKey.getCompactKeyLength(this.algorithmImplementation);
    }

    public static ServerAuthenticationPublicKey of(byte[] compactKeyBytes) throws DecodingException {
        switch (compactKeyBytes[0]) {
            case 0: {
                return ServerAuthenticationECSdsaMDCPublicKey.of(compactKeyBytes);
            }
            case 1: {
                return ServerAuthenticationECSdsaCurve25519PublicKey.of(compactKeyBytes);
            }
        }
        throw new DecodingException();
    }

    public abstract byte[] getCompactKey();

    public SignaturePublicKey getSignaturePublicKey() throws Exception {
        switch (this.algorithmImplementation) {
            case 0: 
            case 1: {
                return ((ServerAuthenticationECSdsaPublicKey)this).getSignaturePublicKey();
            }
        }
        throw new Exception("This server authentication public key does not implement signature");
    }
}

