/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.key.asymmetric;

import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationPublicKey;
import io.olvid.engine.datatypes.key.asymmetric.SignatureECSdsaPublicKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.encoder.EncodingException;
import java.util.HashMap;

public abstract class ServerAuthenticationECSdsaPublicKey
extends ServerAuthenticationPublicKey {
    public static final String PUBLIC_X_COORD_KEY_NAME = "x";
    public static final String PUBLIC_Y_COORD_KEY_NAME = "y";
    private final SignatureECSdsaPublicKey signaturePublicKey;

    public ServerAuthenticationECSdsaPublicKey(byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key, SignatureECSdsaPublicKey signaturePublicKey) {
        super(algorithmImplementation, key);
        this.signaturePublicKey = signaturePublicKey;
    }

    @Override
    public SignatureECSdsaPublicKey getSignaturePublicKey() {
        return this.signaturePublicKey;
    }

    @Override
    public byte[] getCompactKey() {
        byte[] compactKey = new byte[this.getCompactKeyLength()];
        compactKey[0] = this.algorithmImplementation;
        try {
            byte[] yBytes = Encoded.bytesFromBigUInt(((Encoded)this.key.get(new DictionaryKey(PUBLIC_Y_COORD_KEY_NAME))).decodeBigUInt(), compactKey.length - 1);
            System.arraycopy(yBytes, 0, compactKey, 1, yBytes.length);
        }
        catch (DecodingException | EncodingException exception) {
            // empty catch block
        }
        return compactKey;
    }
}

