/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.key.asymmetric;

import io.olvid.engine.crypto.EdwardCurve;
import io.olvid.engine.crypto.PRNG;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.EdwardCurvePoint;
import io.olvid.engine.datatypes.key.asymmetric.KeyPair;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationECSdsaCurve25519PrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationECSdsaCurve25519PublicKey;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.encoder.EncodingException;
import java.math.BigInteger;
import java.util.HashMap;

public class ServerAuthenticationECSdsaCurve25519KeyPair
extends KeyPair {
    @Override
    public ServerAuthenticationECSdsaCurve25519PublicKey getPublicKey() {
        return (ServerAuthenticationECSdsaCurve25519PublicKey)this.publicKey;
    }

    @Override
    public ServerAuthenticationECSdsaCurve25519PrivateKey getPrivateKey() {
        return (ServerAuthenticationECSdsaCurve25519PrivateKey)this.privateKey;
    }

    public ServerAuthenticationECSdsaCurve25519KeyPair(ServerAuthenticationECSdsaCurve25519PublicKey publicKey, ServerAuthenticationECSdsaCurve25519PrivateKey privateKey) {
        super(publicKey, privateKey);
    }

    public static ServerAuthenticationECSdsaCurve25519KeyPair generate(PRNG prng) {
        EdwardCurvePoint A;
        BigInteger a;
        EdwardCurve curve25519 = Suite.getCurve("Curve_25519");
        while ((a = prng.bigInt(curve25519.q)).equals(BigInteger.ZERO) || a.equals(BigInteger.ONE) || (A = curve25519.scalarMultiplicationWithX(a, curve25519.G)).isLowOrderPoint()) {
        }
        HashMap<DictionaryKey, Encoded> publicKeyDictionary = new HashMap<DictionaryKey, Encoded>();
        HashMap<DictionaryKey, Encoded> privateKeyDictionary = new HashMap<DictionaryKey, Encoded>();
        try {
            publicKeyDictionary.put(new DictionaryKey("x"), Encoded.of(A.getX(), curve25519.byteLength));
            publicKeyDictionary.put(new DictionaryKey("y"), Encoded.of(A.getY(), curve25519.byteLength));
            privateKeyDictionary.put(new DictionaryKey("n"), Encoded.of(a, curve25519.byteLength));
        }
        catch (EncodingException e) {
            return null;
        }
        return new ServerAuthenticationECSdsaCurve25519KeyPair(new ServerAuthenticationECSdsaCurve25519PublicKey(publicKeyDictionary), new ServerAuthenticationECSdsaCurve25519PrivateKey(privateKeyDictionary));
    }

    public static boolean areKeysMatching(ServerAuthenticationECSdsaCurve25519PublicKey publicKey, ServerAuthenticationECSdsaCurve25519PrivateKey privateKey) {
        EdwardCurve curve25519 = Suite.getCurve("Curve_25519");
        EdwardCurvePoint A = curve25519.scalarMultiplicationWithX(privateKey.getSignaturePrivateKey().getA(), curve25519.G);
        return A.getY().equals(publicKey.getSignaturePublicKey().getAy());
    }
}

